-- -------------------------------------------------------------------- 
-- >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<< 
-- -------------------------------------------------------------------- 
-- Copyright (c) 2005 by Lattice Semiconductor Corporation 
-- -------------------------------------------------------------------- 
-- 
-- 
--                     Lattice Semiconductor Corporation 
--                     5555 NE Moore Court 
--                     Hillsboro, OR 97214 
--                     U.S.A 
-- 
--                     TEL: 1-800-Lattice (USA and Canada) 
--                          408-826-6000 (other locations) 
-- 
--                     web: http://www.latticesemi.com/ 
--                     email: techsupport@latticesemi.com 
-- 
-- 
-- Revision History : 

--***************************************************************
--	This VHDL file contains the source code of the complete
--	library modules in a single file  including the lattice 
--	declaration package which contains the declaration and 
--  instantiation of the primitives
--***************************************************************

LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE STD.TEXTIO.ALL;

package VHD_PKG is

	component SHFE 
		port( REF : IN std_logic;
			  DATA : IN std_logic);
	end component;

	component PW 
		port( PULSE : IN std_logic);
	end component;

	component INV 
		port( A0 : IN std_logic;
			  ZN0 : OUT std_logic);
	end component;

	component BUF 
		port( A0 : IN std_logic;
			  Z0 : OUT std_logic);
	end component;

	component LXOR2
		port(A0 : IN std_logic;
			 A1 : IN std_logic;
			 Z0 : OUT std_logic);
	end component;

	component FD11
		port(D0 : IN std_logic;
			 CLK : IN std_logic;
			 Q0 : OUT std_logic);
	end component;

	component FD21
		port(D0 : IN std_logic;
			 CLK : IN std_logic;
			 CD : IN std_logic;
			 Q0 : OUT std_logic);
	end component;

	component XINV 
		port( A0 : IN std_logic;
			  ZN0 : OUT std_logic);
	end component;

	component XINPUT 
		port( XI0 : IN std_logic;
			  Z0 : OUT std_logic);
	end component;

	component XOUTPUT 
		port( A0 : IN std_logic;
			  XO0 : OUT std_logic);
	end component;

	component XBIDI1 
		port ( A0 : IN std_logic;
			   OE : IN std_logic;
			   Z0 : OUT std_logic;
			   XB0 : INOUT std_logic);
	 end component;

	component XTRI1 
		port( A0 : IN  std_logic;
			  OE : IN  std_logic;
			  XO0 : OUT  std_logic);
	end component;

	component XDFF1
		port( D0 : IN std_logic;
			  CLK : IN std_logic;
			  Q0 : OUT std_logic);
	end component;

	component XDL1
		port ( D0 : IN std_logic;
				G : IN std_logic;
			   Q0 : OUT std_logic);
	end component;

component XOR2 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component XOR3 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component XOR4 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component XOR8 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component XOR9 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component OR2 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component OR3 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component OR4 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component OR5 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component OR6 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component OR7 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component OR8 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component OR9 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component OR10 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component OR11 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component OR12 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component OR16 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 A12 : IN std_logic;
		 A13 : IN std_logic;
		 A14 : IN std_logic;
		 A15 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND2 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND3 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND4 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND5 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND6 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND7 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND8 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND9 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND10 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND11 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND12 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND13 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 A12 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND14 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 A12 : IN std_logic;
		 A13 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND15 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 A12 : IN std_logic;
		 A13 : IN std_logic;
		 A14 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND16 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 A12 : IN std_logic;
		 A13 : IN std_logic;
		 A14 : IN std_logic;
		 A15 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND17 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 A12 : IN std_logic;
		 A13 : IN std_logic;
		 A14 : IN std_logic;
		 A15 : IN std_logic;
		 A16 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND18 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 A12 : IN std_logic;
		 A13 : IN std_logic;
		 A14 : IN std_logic;
		 A15 : IN std_logic;
		 A16 : IN std_logic;
		 A17 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component NAND2 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NAND3 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NAND4 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NAND5 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NAND6 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NAND7 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NAND8 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NAND9 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NAND10 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NAND11 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NAND12 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NAND16 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 A12 : IN std_logic;
		 A13 : IN std_logic;
		 A14 : IN std_logic;
		 A15 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NOR2 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NOR3 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NOR4 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NOR5 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NOR6 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NOR7 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NOR8 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NOR9 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NOR10 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NOR11 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NOR12 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NOR16 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 A12 : IN std_logic;
		 A13 : IN std_logic;
		 A14 : IN std_logic;
		 A15 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component XNOR2 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component XNOR3 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component XNOR4 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component XNOR7 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component XNOR8 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component XNOR9 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component FD11E
  port (D0, CLK, EN : IN std_logic;
	       Q0 : OUT std_logic);
end component;

component FD21E
  port (D0, CLK, CD, EN : IN std_logic;
	           Q0 : OUT std_logic);
end component;

component FDC1
  port (D0, CLK, SD : IN std_logic;
	       Q0 : OUT std_logic);
end component;

component FDC1E
  port (D0, CLK, SD, EN : IN std_logic;
	           Q0 : OUT std_logic);
end component;

component FDE1
  port (D0, CLK, CD, SD : IN std_logic;
	           Q0 : OUT std_logic);
end component;

component FDE1E
  port (D0, CLK, CD, SD, EN : IN std_logic;
	               Q0 : OUT std_logic);
end component;

component FTI21
  port (T0, CLK, CD : IN std_logic;
                 Q0 : OUT std_logic);
end component;

component FTI21E
  port (T0, CLK, CD, EN : IN std_logic;
                     Q0 : OUT std_logic);
end component;

component FTI31
  port (T0, CLK, SD : IN std_logic;
	       Q0 : OUT std_logic);
end component;

component FTI31E
  port (T0, CLK, SD, EN : IN std_logic;
		 Q0 : OUT std_logic);
end component;

component FTI41
  port (T0, CLK, SD, CD : IN std_logic;
		 Q0 : OUT std_logic);
end component;

component FTI41E
  port (T0, CLK, CD, SD, EN : IN std_logic;
		     Q0 : OUT std_logic);
end component;

component IT11
  port(A0, OE : IN std_logic;
	 O0 : OUT  std_logic);
end component;
       
component LDI11
  port (D0, G : IN std_logic;
           Q0 : OUT std_logic);
end component;

component LDI21
  port (D0, G, CD : IN std_logic;
	     Q0 : OUT std_logic);
end component;

component LDI31
  port (D0, G, SD : IN std_logic;
	     Q0 : OUT std_logic);
end component;

component LDI41
  port (D0, G, CD, SD : IN std_logic;
	         Q0 : OUT std_logic);
end component;

component XDFF1E
  port (D0, CLK, EN : IN std_logic;
	       Q0 : OUT std_logic);
end component;

component XDFF2
  port (D0, CLK, CD : IN std_logic;
	       Q0 : OUT std_logic);
end component;

component XDFF2E
  port (D0, CLK, CD, EN : IN std_logic;
	           Q0 : OUT std_logic);
end component;

component XDFF3
  port (D0, CLK, SD : IN std_logic;
	       Q0 : OUT std_logic);
end component;

component XDFF3E
  port (D0, CLK, SD, EN : IN std_logic;
	           Q0 : OUT std_logic);
end component;

component XDFF4
  port (D0, CLK, CD, SD : IN std_logic;
	           Q0 : OUT std_logic);
end component;

component XDFF4E
  port (D0, CLK, CD, SD, EN : IN std_logic;
	               Q0 : OUT std_logic);
end component;

component XDL2
  port (D0, G, CD : IN std_logic;
	     Q0 : OUT std_logic);
end component;

component XDL3
  port (D0, G, SD : IN std_logic;
	     Q0 : OUT std_logic);
end component;

component XDL4
  port (D0, G, CD, SD : IN std_logic;
	         Q0 : OUT std_logic);
end component;

component ADDF1
  port (
    Z0 : out std_logic;
    CO : out std_logic;
    A0 : in std_logic;
    B0 : in std_logic;
    CI : in std_logic);
end component;
component ADDF16A
  port (
    CO : out std_logic;
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z10 : out std_logic;
    Z11 : out std_logic;
    Z12 : out std_logic;
    Z13 : out std_logic;
    Z14 : out std_logic;
    Z15 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    Z8 : out std_logic;
    Z9 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A10 : in std_logic;
    A11 : in std_logic;
    A12 : in std_logic;
    A13 : in std_logic;
    A14 : in std_logic;
    A15 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    A8 : in std_logic;
    A9 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B10 : in std_logic;
    B11 : in std_logic;
    B12 : in std_logic;
    B13 : in std_logic;
    B14 : in std_logic;
    B15 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    B4 : in std_logic;
    B5 : in std_logic;
    B6 : in std_logic;
    B7 : in std_logic;
    B8 : in std_logic;
    B9 : in std_logic;
    CI : in std_logic);
end component;
component ADDF2
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    CO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    CI : in std_logic);
end component;
component ADDF4
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    CO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    CI : in std_logic);
end component;
component ADDF8
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    CO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    B4 : in std_logic;
    B5 : in std_logic;
    B6 : in std_logic;
    B7 : in std_logic;
    CI : in std_logic);
end component;
component ADDF8A
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    CO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    B4 : in std_logic;
    B5 : in std_logic;
    B6 : in std_logic;
    B7 : in std_logic;
    CI : in std_logic);
end component;
component ADDH1
  port (
    Z0 : out std_logic;
    CO : out std_logic;
    A0 : in std_logic;
    B0 : in std_logic);
end component;
component ADDH16A
  port (
    CO : out std_logic;
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z10 : out std_logic;
    Z11 : out std_logic;
    Z12 : out std_logic;
    Z13 : out std_logic;
    Z14 : out std_logic;
    Z15 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    Z8 : out std_logic;
    Z9 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A10 : in std_logic;
    A11 : in std_logic;
    A12 : in std_logic;
    A13 : in std_logic;
    A14 : in std_logic;
    A15 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    A8 : in std_logic;
    A9 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B10 : in std_logic;
    B11 : in std_logic;
    B12 : in std_logic;
    B13 : in std_logic;
    B14 : in std_logic;
    B15 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    B4 : in std_logic;
    B5 : in std_logic;
    B6 : in std_logic;
    B7 : in std_logic;
    B8 : in std_logic;
    B9 : in std_logic);
end component;
component ADDH2
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    CO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic);
end component;
component ADDH3
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    CO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic);
end component;
component ADDH4
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    CO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic);
end component;
component ADDH8
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    CO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    B4 : in std_logic;
    B5 : in std_logic;
    B6 : in std_logic;
    B7 : in std_logic);
end component;
component ADDH8A
  port (
    CO : out std_logic;
    Z7 : out std_logic;
    Z6 : out std_logic;
    Z5 : out std_logic;
    Z4 : out std_logic;
    Z3 : out std_logic;
    Z2 : out std_logic;
    Z1 : out std_logic;
    Z0 : out std_logic;
    B7 : in std_logic;
    B6 : in std_logic;
    B5 : in std_logic;
    B4 : in std_logic;
    B3 : in std_logic;
    B2 : in std_logic;
    B1 : in std_logic;
    B0 : in std_logic;
    A7 : in std_logic;
    A6 : in std_logic;
    A5 : in std_logic;
    A4 : in std_logic;
    A3 : in std_logic;
    A2 : in std_logic;
    A1 : in std_logic;
    A0 : in std_logic);
end component;
component BI11
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    OE : in std_logic);
end component;
component BI14
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    OE : in std_logic);
end component;
component BI18
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    OE : in std_logic);
end component;
component BI21
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    OE : in std_logic);
end component;
component BI24
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    OE : in std_logic);
end component;
component BI28
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    OE : in std_logic);
end component;
component BI31
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    OE : in std_logic);
end component;
component BI34
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    OE : in std_logic);
end component;
component BI38
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    OE : in std_logic);
end component;
component BI41
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    OE : in std_logic);
end component;
component BI44
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    OE : in std_logic);
end component;
component BI48
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    OE : in std_logic);
end component;
component BIID11
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID11E
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    OE : in std_logic);
end component;
component BIID14
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID14E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    OE : in std_logic);
end component;
component BIID18
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID21
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID24
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID28
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID31
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID34
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID38
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID41
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID44
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID48
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID51
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID54
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID58
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID61
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID64
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID68
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID71
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID74
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID78
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID81
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID84
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID88
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID91
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID91E
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    OE : in std_logic);
end component;
component BIID94
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID94E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    OE : in std_logic);
end component;
component BIIDA1
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIIDA1E
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIIDA4
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIIDA4E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIIDB1
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIIDB1E
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIIDB4
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIIDB4E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIIL11
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL14
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL18
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL21
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL24
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL28
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL31
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL34
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL38
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL41
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL44
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL48
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL51
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL54
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL58
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL61
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL64
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL68
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL71
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL74
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL78
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL81
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL84
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL88
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL91
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CD : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL94
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CD : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIILA1
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    G : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIILA4
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    G : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIILB1
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CD : in std_logic;
    G : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIILB4
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CD : in std_logic;
    G : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIN27
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    EN : in std_logic);
end component;
component BIOD11
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    OE : in std_logic);
end component;
component BIOD11E
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    EN : in std_logic;
    OE : in std_logic);
end component;
component BIOD14
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    OE : in std_logic);
end component;
component BIOD14E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    OE : in std_logic);
end component;
component BIOD21
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    OE : in std_logic);
end component;
component BIOD21E
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    EN : in std_logic;
    OE : in std_logic);
end component;
component BIOD24
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    OE : in std_logic);
end component;
component BIOD24E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    OE : in std_logic);
end component;
component BIOD31
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIOD31E
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    EN : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIOD34
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIOD34E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIOD41
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIOD41E
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    EN : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIOD44
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIOD44E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIOL11
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    D0 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIOL14
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIOL21
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIOL24
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIOL31
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    D0 : in std_logic;
    G : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIOL34
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIOL41
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    G : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIOL44
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component CBD11
  port (
    Q0 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    CD : in std_logic);
end component;
component CBD12
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    CD : in std_logic);
end component;
component CBD14
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    CD : in std_logic);
end component;
component CBD18
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    CD : in std_logic);
end component;
component CBD21
  port (
    Q0 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBD22
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBD24
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBD28
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBD31
  port (
    Q0 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBD32
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBD34
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBD38
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBD41
  port (
    Q0 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CBD42
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CBD44
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CBD48
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CBD516
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    Q8 : out std_logic;
    Q9 : out std_logic;
    Q10 : out std_logic;
    Q11 : out std_logic;
    Q12 : out std_logic;
    Q13 : out std_logic;
    Q14 : out std_logic;
    Q15 : out std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBD616
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    Q8 : out std_logic;
    Q9 : out std_logic;
    Q10 : out std_logic;
    Q11 : out std_logic;
    Q12 : out std_logic;
    Q13 : out std_logic;
    Q14 : out std_logic;
    Q15 : out std_logic;
    CAO : out std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBD84
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component CBD88
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component CBD94
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component CBD98
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component CBDA16
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q10 : out std_logic;
    Q11 : out std_logic;
    Q12 : out std_logic;
    Q13 : out std_logic;
    Q14 : out std_logic;
    Q15 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    Q8 : out std_logic;
    Q9 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D10 : in std_logic;
    D11 : in std_logic;
    D12 : in std_logic;
    D13 : in std_logic;
    D14 : in std_logic;
    D15 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    D8 : in std_logic;
    D9 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component CBDA4
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component CBDA8
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component CBDB4
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    CS : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component CBDB8
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    CS : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component CBU11
  port (
    Q0 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    CD : in std_logic);
end component;
component CBU12
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    CD : in std_logic);
end component;
component CBU14
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    CD : in std_logic);
end component;
component CBU18
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    CD : in std_logic);
end component;
component CBU21
  port (
    Q0 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBU22
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBU24
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBU28
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBU31
  port (
    Q0 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBU32
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBU34
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBU38
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBU41
  port (
    Q0 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CBU42
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CBU44
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CBU48
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CBU516
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    Q8 : out std_logic;
    Q9 : out std_logic;
    Q10 : out std_logic;
    Q11 : out std_logic;
    Q12 : out std_logic;
    Q13 : out std_logic;
    Q14 : out std_logic;
    Q15 : out std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBU616
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    Q8 : out std_logic;
    Q9 : out std_logic;
    Q10 : out std_logic;
    Q11 : out std_logic;
    Q12 : out std_logic;
    Q13 : out std_logic;
    Q14 : out std_logic;
    Q15 : out std_logic;
    CAO : out std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBU716
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q10 : out std_logic;
    Q11 : out std_logic;
    Q12 : out std_logic;
    Q13 : out std_logic;
    Q14 : out std_logic;
    Q15 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    Q8 : out std_logic;
    Q9 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D10 : in std_logic;
    D11 : in std_logic;
    D12 : in std_logic;
    D13 : in std_logic;
    D14 : in std_logic;
    D15 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    D8 : in std_logic;
    D9 : in std_logic;
    EN : in std_logic;
    LD : in std_logic);
end component;
component CBU84
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component CBU88
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component CBU94
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component CBU98
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component CBUA16
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q10 : out std_logic;
    Q11 : out std_logic;
    Q12 : out std_logic;
    Q13 : out std_logic;
    Q14 : out std_logic;
    Q15 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    Q8 : out std_logic;
    Q9 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D10 : in std_logic;
    D11 : in std_logic;
    D12 : in std_logic;
    D13 : in std_logic;
    D14 : in std_logic;
    D15 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    D8 : in std_logic;
    D9 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component CBUA4
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component CBUA8
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component CBUB4
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    CS : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component CBUB8
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    CS : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component CBUD1
  port (
    Q0 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    DNUP : in std_logic;
    CD : in std_logic;
    CS : in std_logic);
end component;
component CBUD2
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    DNUP : in std_logic;
    CD : in std_logic;
    CS : in std_logic);
end component;
component CBUD4
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    DNUP : in std_logic;
    CD : in std_logic;
    CS : in std_logic);
end component;
component CBUD4S
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    CS : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    DNUP : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component CBUD8
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    DNUP : in std_logic;
    CD : in std_logic;
    CS : in std_logic);
end component;
component CBUD8S
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    CS : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    DNUP : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component CDD14
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CDD18
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CDD24
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CDD28
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CDD34
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CDD38
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CDD44
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CDD48
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CDU14
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CDU18
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CDU24
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CDU28
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CDU34
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CDU38
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CDU44
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CDU48
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CDUD4
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    DNUP : in std_logic;
    CD : in std_logic;
    CS : in std_logic);
end component;
component CDUD4C
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    DNUP : in std_logic;
    CD : in std_logic;
    CS : in std_logic);
end component;
component CDUD8
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    DNUP : in std_logic;
    CD : in std_logic;
    CS : in std_logic);
end component;
component CDUD8C
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    DNUP : in std_logic;
    CD : in std_logic;
    CS : in std_logic);
end component;
component CGD14
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CGD24
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CGD34
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component CGU14
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CGU24
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CGU34
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component CGUD4
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    DNUP : in std_logic;
    CD : in std_logic;
    CS : in std_logic);
end component;
component CGUD4S
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    CS : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    DNUP : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component CMP2
  port (
    EQ : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic);
end component;
component CMP4
  port (
    EQ : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic);
end component;
component CMP8
  port (
    EQ : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    B4 : in std_logic;
    B5 : in std_logic;
    B6 : in std_logic;
    B7 : in std_logic);
end component;
component DEC2
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    S0 : in std_logic);
end component;
component DEC2E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    EN : in std_logic;
    S0 : in std_logic);
end component;
component DEC3
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component DEC3E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    EN : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component DEC4
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component DEC4E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    EN : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component DMUX2
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    A0 : in std_logic;
    S0 : in std_logic);
end component;
component DMUX22
  port (
    Y0 : out std_logic;
    Y1 : out std_logic;
    Z0 : out std_logic;
    Z1 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    S0 : in std_logic);
end component;
component DMUX22E
  port (
    Y0 : out std_logic;
    Y1 : out std_logic;
    Z0 : out std_logic;
    Z1 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic);
end component;
component DMUX24
  port (
    W0 : out std_logic;
    W1 : out std_logic;
    X0 : out std_logic;
    X1 : out std_logic;
    Y0 : out std_logic;
    Y1 : out std_logic;
    Z0 : out std_logic;
    Z1 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component DMUX24E
  port (
    W0 : out std_logic;
    W1 : out std_logic;
    X0 : out std_logic;
    X1 : out std_logic;
    Y0 : out std_logic;
    Y1 : out std_logic;
    Z0 : out std_logic;
    Z1 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component DMUX2E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    A0 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic);
end component;
component DMUX4
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    A0 : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component DMUX42
  port (
    Y0 : out std_logic;
    Y1 : out std_logic;
    Y2 : out std_logic;
    Y3 : out std_logic;
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    S0 : in std_logic);
end component;
component DMUX42E
  port (
    Y0 : out std_logic;
    Y1 : out std_logic;
    Y2 : out std_logic;
    Y3 : out std_logic;
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic);
end component;
component DMUX44
  port (
    W0 : out std_logic;
    W1 : out std_logic;
    W2 : out std_logic;
    W3 : out std_logic;
    X0 : out std_logic;
    X1 : out std_logic;
    X2 : out std_logic;
    X3 : out std_logic;
    Y0 : out std_logic;
    Y1 : out std_logic;
    Y2 : out std_logic;
    Y3 : out std_logic;
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component DMUX44E
  port (
    W0 : out std_logic;
    W1 : out std_logic;
    W2 : out std_logic;
    W3 : out std_logic;
    X0 : out std_logic;
    X1 : out std_logic;
    X2 : out std_logic;
    X3 : out std_logic;
    Y0 : out std_logic;
    Y1 : out std_logic;
    Y2 : out std_logic;
    Y3 : out std_logic;
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component DMUX4E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    A0 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component DMUX82
  port (
    Y0 : out std_logic;
    Y1 : out std_logic;
    Y2 : out std_logic;
    Y3 : out std_logic;
    Y4 : out std_logic;
    Y5 : out std_logic;
    Y6 : out std_logic;
    Y7 : out std_logic;
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    S0 : in std_logic);
end component;
component DMUX82E
  port (
    Y0 : out std_logic;
    Y1 : out std_logic;
    Y2 : out std_logic;
    Y3 : out std_logic;
    Y4 : out std_logic;
    Y5 : out std_logic;
    Y6 : out std_logic;
    Y7 : out std_logic;
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic);
end component;
component F3ADD
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    G012 : out std_logic;
    P012 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    CI : in std_logic);
end component;
component F3SUB
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    G012 : out std_logic;
    P012 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    BI : in std_logic);
end component;
component FD14
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic);
end component;
component FD14E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic);
end component;
component FD18
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CLK : in std_logic);
end component;
component FD18E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    EN : in std_logic);
end component;
component FD24
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic;
    CD : in std_logic);
end component;
component FD24E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic);
end component;
component FD28
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CLK : in std_logic;
    CD : in std_logic);
end component;
component FD28E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    EN : in std_logic);
end component;
component FD31
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic);
end component;
component FD34
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic);
end component;
component FD38
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic);
end component;
component FD41
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    CD : in std_logic);
end component;
component FD44
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    CD : in std_logic);
end component;
component FD48
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    CD : in std_logic);
end component;
component FD51
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    CS : in std_logic);
end component;
component FD54
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    CS : in std_logic);
end component;
component FD58
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    CS : in std_logic);
end component;
component FD61
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    TI0 : in std_logic;
    CLK : in std_logic;
    TE : in std_logic);
end component;
component FD64
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    CLK : in std_logic;
    TE : in std_logic);
end component;
component FD68
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    TI4 : in std_logic;
    TI5 : in std_logic;
    TI6 : in std_logic;
    TI7 : in std_logic;
    CLK : in std_logic;
    TE : in std_logic);
end component;
component FD71
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    TI0 : in std_logic;
    CLK : in std_logic;
    CD : in std_logic;
    TE : in std_logic);
end component;
component FD74
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    CLK : in std_logic;
    CD : in std_logic;
    TE : in std_logic);
end component;
component FD78
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    TI4 : in std_logic;
    TI5 : in std_logic;
    TI6 : in std_logic;
    TI7 : in std_logic;
    CLK : in std_logic;
    CD : in std_logic;
    TE : in std_logic);
end component;
component FD81
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    TI0 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    TE : in std_logic);
end component;
component FD84
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    TE : in std_logic);
end component;
component FD88
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    TI4 : in std_logic;
    TI5 : in std_logic;
    TI6 : in std_logic;
    TI7 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    TE : in std_logic);
end component;
component FD91
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    TI0 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    CD : in std_logic;
    TE : in std_logic);
end component;
component FD94
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    CD : in std_logic;
    TE : in std_logic);
end component;
component FD98
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    TI4 : in std_logic;
    TI5 : in std_logic;
    TI6 : in std_logic;
    TI7 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    CD : in std_logic;
    TE : in std_logic);
end component;
component FDA1
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    TI0 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    CS : in std_logic;
    TE : in std_logic);
end component;
component FDA4
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    CS : in std_logic;
    TE : in std_logic);
end component;
component FDA8
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    TI4 : in std_logic;
    TI5 : in std_logic;
    TI6 : in std_logic;
    TI7 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    CS : in std_logic;
    TE : in std_logic);
end component;
component FDB1
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    CLK : in std_logic;
    SD : in std_logic);
end component;
component FDB4
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic;
    SD : in std_logic);
end component;
component FDB8
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CLK : in std_logic;
    SD : in std_logic);
end component;
component FDC4
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    SD : in std_logic);
end component;
component FDC4E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component FDC8
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    SD : in std_logic);
end component;
component FDC8E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component FDE4
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    SD : in std_logic);
end component;
component FDE4E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component FDE8
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    SD : in std_logic);
end component;
component FDE8E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component FJK11
  port (
    Q0 : out std_logic;
    J0 : in std_logic;
    K0 : in std_logic;
    CLK : in std_logic);
end component;
component FJK21
  port (
    Q0 : out std_logic;
    J0 : in std_logic;
    K0 : in std_logic;
    CLK : in std_logic;
    CD : in std_logic);
end component;
component FJK31
  port (
    Q0 : out std_logic;
    J0 : in std_logic;
    K0 : in std_logic;
    TI0 : in std_logic;
    CLK : in std_logic;
    TE : in std_logic);
end component;
component FJK41
  port (
    Q0 : out std_logic;
    J0 : in std_logic;
    K0 : in std_logic;
    TI0 : in std_logic;
    CLK : in std_logic;
    CD : in std_logic;
    TE : in std_logic);
end component;
component FJK51
  port (
    Q0 : out std_logic;
    J0 : in std_logic;
    K0 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    CD : in std_logic);
end component;
component FJK61
  port (
    Q0 : out std_logic;
    CLK : in std_logic;
    J0 : in std_logic;
    K0 : in std_logic;
    SD : in std_logic);
end component;
component FJK64
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CLK : in std_logic;
    J0 : in std_logic;
    J1 : in std_logic;
    J2 : in std_logic;
    J3 : in std_logic;
    K0 : in std_logic;
    K1 : in std_logic;
    K2 : in std_logic;
    K3 : in std_logic;
    SD : in std_logic);
end component;
component FJK68
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CLK : in std_logic;
    J0 : in std_logic;
    J1 : in std_logic;
    J2 : in std_logic;
    J3 : in std_logic;
    J4 : in std_logic;
    J5 : in std_logic;
    J6 : in std_logic;
    J7 : in std_logic;
    K0 : in std_logic;
    K1 : in std_logic;
    K2 : in std_logic;
    K3 : in std_logic;
    K4 : in std_logic;
    K5 : in std_logic;
    K6 : in std_logic;
    K7 : in std_logic;
    SD : in std_logic);
end component;
component FJK71
  port (
    Q0 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    J0 : in std_logic;
    K0 : in std_logic;
    SD : in std_logic);
end component;
component FJK71E
  port (
    Q0 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    J0 : in std_logic;
    K0 : in std_logic;
    SD : in std_logic);
end component;
component FJK74
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    J0 : in std_logic;
    J1 : in std_logic;
    J2 : in std_logic;
    J3 : in std_logic;
    K0 : in std_logic;
    K1 : in std_logic;
    K2 : in std_logic;
    K3 : in std_logic;
    SD : in std_logic);
end component;
component FJK74E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    J0 : in std_logic;
    J1 : in std_logic;
    J2 : in std_logic;
    J3 : in std_logic;
    K0 : in std_logic;
    K1 : in std_logic;
    K2 : in std_logic;
    K3 : in std_logic;
    SD : in std_logic);
end component;
component FJK78
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    J0 : in std_logic;
    J1 : in std_logic;
    J2 : in std_logic;
    J3 : in std_logic;
    J4 : in std_logic;
    J5 : in std_logic;
    J6 : in std_logic;
    J7 : in std_logic;
    K0 : in std_logic;
    K1 : in std_logic;
    K2 : in std_logic;
    K3 : in std_logic;
    K4 : in std_logic;
    K5 : in std_logic;
    K6 : in std_logic;
    K7 : in std_logic;
    SD : in std_logic);
end component;
component FJK78E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    J0 : in std_logic;
    J1 : in std_logic;
    J2 : in std_logic;
    J3 : in std_logic;
    J4 : in std_logic;
    J5 : in std_logic;
    J6 : in std_logic;
    J7 : in std_logic;
    K0 : in std_logic;
    K1 : in std_logic;
    K2 : in std_logic;
    K3 : in std_logic;
    K4 : in std_logic;
    K5 : in std_logic;
    K6 : in std_logic;
    K7 : in std_logic;
    SD : in std_logic);
end component;
component FT11
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    CLK : in std_logic;
    CD : in std_logic);
end component;
component FT21
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    CS : in std_logic);
end component;
component IB11
  port (
    Z0 : out std_logic;
    XI0 : in std_logic);
end component;
component ID11
  port (
    Q0 : out std_logic;
    XI0 : in std_logic;
    CLK : in std_logic);
end component;
component ID11E
  port (
    Q0 : out std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    XI0 : in std_logic);
end component;
component ID14
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic;
    CLK : in std_logic);
end component;
component ID14E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic);
end component;
component ID18
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic;
    XI4 : in std_logic;
    XI5 : in std_logic;
    XI6 : in std_logic;
    XI7 : in std_logic;
    CLK : in std_logic);
end component;
component ID21
  port (
    Q0 : out std_logic;
    XI0 : in std_logic;
    CLK : in std_logic);
end component;
component ID24
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic;
    CLK : in std_logic);
end component;
component ID28
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic;
    XI4 : in std_logic;
    XI5 : in std_logic;
    XI6 : in std_logic;
    XI7 : in std_logic;
    CLK : in std_logic);
end component;
component ID31
  port (
    Q0 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    XI0 : in std_logic);
end component;
component ID31E
  port (
    Q0 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    XI0 : in std_logic);
end component;
component ID34
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic);
end component;
component ID34E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic);
end component;
component ID41
  port (
    Q0 : out std_logic;
    CLK : in std_logic;
    SD : in std_logic;
    XI0 : in std_logic);
end component;
component ID41E
  port (
    Q0 : out std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    SD : in std_logic;
    XI0 : in std_logic);
end component;
component ID44
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CLK : in std_logic;
    SD : in std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic);
end component;
component ID44E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    SD : in std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic);
end component;
component ID51
  port (
    Q0 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    SD : in std_logic;
    XI0 : in std_logic);
end component;
component ID51E
  port (
    Q0 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    SD : in std_logic;
    XI0 : in std_logic);
end component;
component ID54
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    SD : in std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic);
end component;
component ID54E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    SD : in std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic);
end component;
component IL11
  port (
    Q0 : out std_logic;
    XI0 : in std_logic;
    G : in std_logic);
end component;
component IL14
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic;
    G : in std_logic);
end component;
component IL18
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic;
    XI4 : in std_logic;
    XI5 : in std_logic;
    XI6 : in std_logic;
    XI7 : in std_logic;
    G : in std_logic);
end component;
component IL21
  port (
    Q0 : out std_logic;
    XI0 : in std_logic;
    G : in std_logic);
end component;
component IL24
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic;
    G : in std_logic);
end component;
component IL28
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic;
    XI4 : in std_logic;
    XI5 : in std_logic;
    XI6 : in std_logic;
    XI7 : in std_logic;
    G : in std_logic);
end component;
component IL31
  port (
    Q0 : out std_logic;
    CD : in std_logic;
    G : in std_logic;
    XI0 : in std_logic);
end component;
component IL34
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    G : in std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic);
end component;
component IL41
  port (
    Q0 : out std_logic;
    G : in std_logic;
    SD : in std_logic;
    XI0 : in std_logic);
end component;
component IL44
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    G : in std_logic;
    SD : in std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic);
end component;
component IL51
  port (
    Q0 : out std_logic;
    CD : in std_logic;
    G : in std_logic;
    SD : in std_logic;
    XI0 : in std_logic);
end component;
component IL54
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    G : in std_logic;
    SD : in std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic);
end component;
component IT14
  port (
    O0 : out std_logic;
    O1 : out std_logic;
    O2 : out std_logic;
    O3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    OE : in std_logic);
end component;

component IT18
  port (
    O0 : out std_logic;
    O1 : out std_logic;
    O2 : out std_logic;
    O3 : out std_logic;
    O4 : out std_logic;
    O5 : out std_logic;
    O6 : out std_logic;
    O7 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    OE : in std_logic);
end component;
component IT21
  port (
    O0 : out std_logic;
    A0 : in std_logic;
    OE : in std_logic);
end component;
component IT24
  port (
    O0 : out std_logic;
    O1 : out std_logic;
    O2 : out std_logic;
    O3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    OE : in std_logic);
end component;
component IT28
  port (
    O0 : out std_logic;
    O1 : out std_logic;
    O2 : out std_logic;
    O3 : out std_logic;
    O4 : out std_logic;
    O5 : out std_logic;
    O6 : out std_logic;
    O7 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    OE : in std_logic);
end component;
component LD11
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    G : in std_logic);
end component;
component LD14
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic);
end component;
component LD18
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    G : in std_logic);
end component;
component LD21
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    G : in std_logic;
    CD : in std_logic);
end component;
component LD24
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    CD : in std_logic);
end component;
component LD28
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    G : in std_logic;
    CD : in std_logic);
end component;
component LD31
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    G : in std_logic;
    PD : in std_logic);
end component;
component LD34
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    PD : in std_logic);
end component;
component LD38
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    G : in std_logic;
    PD : in std_logic);
end component;
component LD41
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    G : in std_logic;
    PD : in std_logic;
    CD : in std_logic);
end component;
component LD44
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    PD : in std_logic;
    CD : in std_logic);
end component;
component LD48
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    G : in std_logic;
    PD : in std_logic;
    CD : in std_logic);
end component;
component LD51
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    G : in std_logic;
    PD : in std_logic;
    CD : in std_logic);
end component;
component LD54
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    PD : in std_logic;
    CD : in std_logic);
end component;
component LD58
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    G : in std_logic;
    PD : in std_logic;
    CD : in std_logic);
end component;
component LD61
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    TI0 : in std_logic;
    G : in std_logic;
    TG : in std_logic);
end component;
component LD64
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    G : in std_logic;
    TG : in std_logic);
end component;
component LD68
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    TI4 : in std_logic;
    TI5 : in std_logic;
    TI6 : in std_logic;
    TI7 : in std_logic;
    G : in std_logic;
    TG : in std_logic);
end component;
component LD71
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    TI0 : in std_logic;
    G : in std_logic;
    CD : in std_logic;
    TG : in std_logic);
end component;
component LD74
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    G : in std_logic;
    CD : in std_logic;
    TG : in std_logic);
end component;
component LD78
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    TI4 : in std_logic;
    TI5 : in std_logic;
    TI6 : in std_logic;
    TI7 : in std_logic;
    G : in std_logic;
    CD : in std_logic;
    TG : in std_logic);
end component;
component LD81
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    TI0 : in std_logic;
    G : in std_logic;
    PD : in std_logic;
    TG : in std_logic);
end component;
component LD84
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    G : in std_logic;
    PD : in std_logic;
    TG : in std_logic);
end component;
component LD88
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    TI4 : in std_logic;
    TI5 : in std_logic;
    TI6 : in std_logic;
    TI7 : in std_logic;
    G : in std_logic;
    PD : in std_logic;
    TG : in std_logic);
end component;
component LD91
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    TI0 : in std_logic;
    G : in std_logic;
    PD : in std_logic;
    CD : in std_logic;
    TG : in std_logic);
end component;
component LD94
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    G : in std_logic;
    PD : in std_logic;
    CD : in std_logic;
    TG : in std_logic);
end component;
component LD98
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    TI4 : in std_logic;
    TI5 : in std_logic;
    TI6 : in std_logic;
    TI7 : in std_logic;
    G : in std_logic;
    PD : in std_logic;
    CD : in std_logic;
    TG : in std_logic);
end component;
component LDA1
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    TI0 : in std_logic;
    G : in std_logic;
    PD : in std_logic;
    CD : in std_logic;
    TG : in std_logic);
end component;
component LDA4
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    G : in std_logic;
    PD : in std_logic;
    CD : in std_logic;
    TG : in std_logic);
end component;
component LDA8
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    TI4 : in std_logic;
    TI5 : in std_logic;
    TI6 : in std_logic;
    TI7 : in std_logic;
    G : in std_logic;
    PD : in std_logic;
    CD : in std_logic;
    TG : in std_logic);
end component;
component LDI14
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic);
end component;
component LDI18
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    G : in std_logic);
end component;
component LDI24
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic);
end component;
component LDI28
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    G : in std_logic);
end component;
component LDI34
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    SD : in std_logic);
end component;
component LDI38
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    G : in std_logic;
    SD : in std_logic);
end component;
component LDI44
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    SD : in std_logic);
end component;
component LDI48
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    G : in std_logic;
    SD : in std_logic);
end component;
component LSR1
  port (
    Q0 : out std_logic;
    S0 : in std_logic;
    R0 : in std_logic);
end component;
component LSR2
  port (
    Q0 : out std_logic;
    S0 : in std_logic;
    S1 : in std_logic;
    R0 : in std_logic;
    R1 : in std_logic);
end component;
component MAG2
  port (
    GT : out std_logic;
    EQ : out std_logic;
    LT : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    GTI : in std_logic;
    EQI : in std_logic;
    LTI : in std_logic);
end component;
component MAG4
  port (
    GT : out std_logic;
    EQ : out std_logic;
    LT : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    GTI : in std_logic;
    EQI : in std_logic;
    LTI : in std_logic);
end component;
component MAG8
  port (
    GT : out std_logic;
    EQ : out std_logic;
    LT : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    B4 : in std_logic;
    B5 : in std_logic;
    B6 : in std_logic;
    B7 : in std_logic;
    GTI : in std_logic;
    EQI : in std_logic;
    LTI : in std_logic);
end component;
component MULT24
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic);
end component;
component MULT44
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic);
end component;
component MUX16
  port (
    Z0 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    A8 : in std_logic;
    A9 : in std_logic;
    A10 : in std_logic;
    A11 : in std_logic;
    A12 : in std_logic;
    A13 : in std_logic;
    A14 : in std_logic;
    A15 : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic;
    S2 : in std_logic;
    S3 : in std_logic);
end component;
component MUX16E
  port (
    Z0 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    A8 : in std_logic;
    A9 : in std_logic;
    A10 : in std_logic;
    A11 : in std_logic;
    A12 : in std_logic;
    A13 : in std_logic;
    A14 : in std_logic;
    A15 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic;
    S2 : in std_logic;
    S3 : in std_logic);
end component;
component MUX2
  port (
    Z0 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    S0 : in std_logic);
end component;
component MUX22
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    S0 : in std_logic);
end component;
component MUX22E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic);
end component;
component MUX24
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    C0 : in std_logic;
    C1 : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component MUX24E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    C0 : in std_logic;
    C1 : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component MUX2E
  port (
    Z0 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic);
end component;
component MUX4
  port (
    Z0 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component MUX42
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    S0 : in std_logic);
end component;
component MUX42E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic);
end component;
component MUX44
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    C0 : in std_logic;
    C1 : in std_logic;
    C2 : in std_logic;
    C3 : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component MUX44A
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    C0 : in std_logic;
    C1 : in std_logic;
    C2 : in std_logic;
    C3 : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component MUX44AE
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    C0 : in std_logic;
    C1 : in std_logic;
    C2 : in std_logic;
    C3 : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component MUX44E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    C0 : in std_logic;
    C1 : in std_logic;
    C2 : in std_logic;
    C3 : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component MUX4E
  port (
    Z0 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component MUX8
  port (
    Z0 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic;
    S2 : in std_logic);
end component;
component MUX82
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    B4 : in std_logic;
    B5 : in std_logic;
    B6 : in std_logic;
    B7 : in std_logic;
    S0 : in std_logic);
end component;
component MUX82E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    B4 : in std_logic;
    B5 : in std_logic;
    B6 : in std_logic;
    B7 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic);
end component;
component MUX8E
  port (
    Z0 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic;
    S2 : in std_logic);
end component;
component OB11
  port (
    XO0 : out std_logic;
    A0 : in std_logic);
end component;
component OB21
  port (
    XO0 : out std_logic;
    A0 : in std_logic);
end component;
component OB24
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic);
end component;
component OB28
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    XO4 : out std_logic;
    XO5 : out std_logic;
    XO6 : out std_logic;
    XO7 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic);
end component;
component OD11
  port (
    XQ0 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic);
end component;
component OD11E
  port (
    XQ0 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    EN : in std_logic);
end component;
component OD14
  port (
    XQ0 : out std_logic;
    XQ1 : out std_logic;
    XQ2 : out std_logic;
    XQ3 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic);
end component;
component OD14E
  port (
    XQ0 : out std_logic;
    XQ1 : out std_logic;
    XQ2 : out std_logic;
    XQ3 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic);
end component;
component OD21
  port (
    XQ0 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic);
end component;
component OD24
  port (
    XQ0 : out std_logic;
    XQ1 : out std_logic;
    XQ2 : out std_logic;
    XQ3 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic);
end component;
component OD31
  port (
    XQ0 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic);
end component;
component OD31E
  port (
    XQ0 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    EN : in std_logic);
end component;
component OD34
  port (
    XQ0 : out std_logic;
    XQ1 : out std_logic;
    XQ2 : out std_logic;
    XQ3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic);
end component;
component OD34E
  port (
    XQ0 : out std_logic;
    XQ1 : out std_logic;
    XQ2 : out std_logic;
    XQ3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic);
end component;
component OD41
  port (
    XQ0 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    SD : in std_logic);
end component;
component OD41E
  port (
    XQ0 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component OD44
  port (
    XQ0 : out std_logic;
    XQ1 : out std_logic;
    XQ2 : out std_logic;
    XQ3 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    SD : in std_logic);
end component;
component OD44E
  port (
    XQ0 : out std_logic;
    XQ1 : out std_logic;
    XQ2 : out std_logic;
    XQ3 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component OD51
  port (
    XQ0 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    SD : in std_logic);
end component;
component OD51E
  port (
    XQ0 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component OD54
  port (
    XQ0 : out std_logic;
    XQ1 : out std_logic;
    XQ2 : out std_logic;
    XQ3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    SD : in std_logic);
end component;
component OD54E
  port (
    XQ0 : out std_logic;
    XQ1 : out std_logic;
    XQ2 : out std_logic;
    XQ3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component ODT11
  port (
    XO0 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    OE : in std_logic);
end component;
component ODT11E
  port (
    XO0 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    EN : in std_logic;
    OE : in std_logic);
end component;
component ODT14
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    OE : in std_logic);
end component;
component ODT14E
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    OE : in std_logic);
end component;
component ODT21
  port (
    XO0 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    OE : in std_logic);
end component;
component ODT21E
  port (
    XO0 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    EN : in std_logic;
    OE : in std_logic);
end component;
component ODT24
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    OE : in std_logic);
end component;
component ODT24E
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    OE : in std_logic);
end component;
component ODT31
  port (
    XO0 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component ODT31E
  port (
    XO0 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    EN : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component ODT34
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component ODT34E
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component ODT41
  port (
    XO0 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component ODT41E
  port (
    XO0 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    EN : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component ODT44
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component ODT44E
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component OL11
  port (
    XQ0 : out std_logic;
    D0 : in std_logic;
    G : in std_logic);
end component;
component OL14
  port (
    XQ0 : out std_logic;
    XQ1 : out std_logic;
    XQ2 : out std_logic;
    XQ3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic);
end component;
component OL21
  port (
    XQ0 : out std_logic;
    D0 : in std_logic;
    G : in std_logic);
end component;
component OL24
  port (
    XQ0 : out std_logic;
    XQ1 : out std_logic;
    XQ2 : out std_logic;
    XQ3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic);
end component;
component OL31
  port (
    XQ0 : out std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    G : in std_logic);
end component;
component OL34
  port (
    XQ0 : out std_logic;
    XQ1 : out std_logic;
    XQ2 : out std_logic;
    XQ3 : out std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic);
end component;
component OL41
  port (
    XQ0 : out std_logic;
    D0 : in std_logic;
    G : in std_logic;
    SD : in std_logic);
end component;
component OL44
  port (
    XQ0 : out std_logic;
    XQ1 : out std_logic;
    XQ2 : out std_logic;
    XQ3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    SD : in std_logic);
end component;
component OL51
  port (
    XQ0 : out std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    G : in std_logic;
    SD : in std_logic);
end component;
component OL54
  port (
    XQ0 : out std_logic;
    XQ1 : out std_logic;
    XQ2 : out std_logic;
    XQ3 : out std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    SD : in std_logic);
end component;
component OLT11
  port (
    XO0 : out std_logic;
    D0 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component OLT14
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component OLT21
  port (
    XO0 : out std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component OLT24
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component OLT31
  port (
    XO0 : out std_logic;
    D0 : in std_logic;
    G : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component OLT34
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component OLT41
  port (
    XO0 : out std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    G : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component OLT44
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component OT11
  port (
    XO0 : out std_logic;
    A0 : in std_logic;
    OE : in std_logic);
end component;
component OT14
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    OE : in std_logic);
end component;
component OT18
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    XO4 : out std_logic;
    XO5 : out std_logic;
    XO6 : out std_logic;
    XO7 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    OE : in std_logic);
end component;
component OT21
  port (
    XO0 : out std_logic;
    A0 : in std_logic;
    OE : in std_logic);
end component;
component OT24
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    OE : in std_logic);
end component;
component OT28
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    XO4 : out std_logic;
    XO5 : out std_logic;
    XO6 : out std_logic;
    XO7 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    OE : in std_logic);
end component;
component OT31
  port (
    XO0 : out std_logic;
    A0 : in std_logic;
    OE : in std_logic);
end component;
component OT34
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    OE : in std_logic);
end component;
component OT38
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    XO4 : out std_logic;
    XO5 : out std_logic;
    XO6 : out std_logic;
    XO7 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    OE : in std_logic);
end component;
component OT41
  port (
    XO0 : out std_logic;
    A0 : in std_logic;
    OE : in std_logic);
end component;
component OT44
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    OE : in std_logic);
end component;
component OT48
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    XO4 : out std_logic;
    XO5 : out std_logic;
    XO6 : out std_logic;
    XO7 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    OE : in std_logic);
end component;
component PG1
  port (
    PGO1 : out std_logic;
    GI1 : in std_logic;
    PI1 : in std_logic;
    PGI1 : in std_logic);
end component;
component PG2
  port (
    PGO2 : out std_logic;
    GI2 : in std_logic;
    PI2 : in std_logic;
    GI1 : in std_logic;
    PI1 : in std_logic;
    PGI1 : in std_logic);
end component;
component PG3
  port (
    PGO3 : out std_logic;
    GI3 : in std_logic;
    PI3 : in std_logic;
    GI2 : in std_logic;
    PI2 : in std_logic;
    GI1 : in std_logic;
    PI1 : in std_logic;
    PGI1 : in std_logic);
end component;
component PG4
  port (
    PGO4 : out std_logic;
    GI4 : in std_logic;
    PI4 : in std_logic;
    GI3 : in std_logic;
    PI3 : in std_logic;
    GI2 : in std_logic;
    PI2 : in std_logic;
    GI1 : in std_logic;
    PI1 : in std_logic;
    PGI1 : in std_logic);
end component;
component PREN10
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    S0 : in std_logic;
    S1 : in std_logic;
    S2 : in std_logic;
    S3 : in std_logic;
    S4 : in std_logic;
    S5 : in std_logic;
    S6 : in std_logic;
    S7 : in std_logic;
    S8 : in std_logic);
end component;
component PREN10E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    S0 : in std_logic;
    S1 : in std_logic;
    S2 : in std_logic;
    S3 : in std_logic;
    S4 : in std_logic;
    S5 : in std_logic;
    S6 : in std_logic;
    S7 : in std_logic;
    S8 : in std_logic;
    EN : in std_logic);
end component;
component PREN16
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    S0 : in std_logic;
    S1 : in std_logic;
    S2 : in std_logic;
    S3 : in std_logic;
    S4 : in std_logic;
    S5 : in std_logic;
    S6 : in std_logic;
    S7 : in std_logic;
    S8 : in std_logic;
    S9 : in std_logic;
    S10 : in std_logic;
    S11 : in std_logic;
    S12 : in std_logic;
    S13 : in std_logic;
    S14 : in std_logic);
end component;
component PREN16E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    S0 : in std_logic;
    S1 : in std_logic;
    S2 : in std_logic;
    S3 : in std_logic;
    S4 : in std_logic;
    S5 : in std_logic;
    S6 : in std_logic;
    S7 : in std_logic;
    S8 : in std_logic;
    S9 : in std_logic;
    S10 : in std_logic;
    S11 : in std_logic;
    S12 : in std_logic;
    S13 : in std_logic;
    S14 : in std_logic;
    EN : in std_logic);
end component;
component PREN8
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    S0 : in std_logic;
    S1 : in std_logic;
    S2 : in std_logic;
    S3 : in std_logic;
    S4 : in std_logic;
    S5 : in std_logic;
    S6 : in std_logic);
end component;
component PREN8E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    S0 : in std_logic;
    S1 : in std_logic;
    S2 : in std_logic;
    S3 : in std_logic;
    S4 : in std_logic;
    S5 : in std_logic;
    S6 : in std_logic;
    EN : in std_logic);
end component;
component SRR11
  port (
    Q0 : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    CD : in std_logic);
end component;
component SRR14
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    CD : in std_logic);
end component;
component SRR18
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    CD : in std_logic);
end component;
component SRR21
  port (
    Q0 : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component SRR24
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component SRR28
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component SRR31
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component SRR34
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component SRR38
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component SRR41
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component SRR44
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component SRR48
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component SRR51
  port (
    Q0 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component SRR54
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component SRR58
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component SRRL1
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    CAIR : in std_logic;
    CAIL : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    RL : in std_logic;
    CD : in std_logic;
    CS : in std_logic);
end component;
component SRRL1S
  port (
    Q0 : out std_logic;
    CAIL : in std_logic;
    CAIR : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    CS : in std_logic;
    D0 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    PS : in std_logic;
    RL : in std_logic;
    SD : in std_logic);
end component;
component SRRL4
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CAIR : in std_logic;
    CAIL : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    RL : in std_logic;
    CD : in std_logic;
    CS : in std_logic);
end component;
component SRRL4S
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAIL : in std_logic;
    CAIR : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    CS : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    PS : in std_logic;
    RL : in std_logic;
    SD : in std_logic);
end component;
component SRRL8
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CAIR : in std_logic;
    CAIL : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    RL : in std_logic;
    CD : in std_logic;
    CS : in std_logic);
end component;
component SRRL8S
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAIL : in std_logic;
    CAIR : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    CS : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    PS : in std_logic;
    RL : in std_logic;
    SD : in std_logic);
end component;
component SUBF1
  port (
    Z0 : out std_logic;
    BO : out std_logic;
    A0 : in std_logic;
    B0 : in std_logic;
    BI : in std_logic);
end component;
component SUBF16A
  port (
    BO : out std_logic;
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z10 : out std_logic;
    Z11 : out std_logic;
    Z12 : out std_logic;
    Z13 : out std_logic;
    Z14 : out std_logic;
    Z15 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    Z8 : out std_logic;
    Z9 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A10 : in std_logic;
    A11 : in std_logic;
    A12 : in std_logic;
    A13 : in std_logic;
    A14 : in std_logic;
    A15 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    A8 : in std_logic;
    A9 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B10 : in std_logic;
    B11 : in std_logic;
    B12 : in std_logic;
    B13 : in std_logic;
    B14 : in std_logic;
    B15 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    B4 : in std_logic;
    B5 : in std_logic;
    B6 : in std_logic;
    B7 : in std_logic;
    B8 : in std_logic;
    B9 : in std_logic;
    BI : in std_logic);
end component;
component SUBF2
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    BO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    BI : in std_logic);
end component;
component SUBF4
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    BO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    BI : in std_logic);
end component;
component SUBF8
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    BO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    B4 : in std_logic;
    B5 : in std_logic;
    B6 : in std_logic;
    B7 : in std_logic;
    BI : in std_logic);
end component;
component SUBF8A
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    BO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    B4 : in std_logic;
    B5 : in std_logic;
    B6 : in std_logic;
    B7 : in std_logic;
    BI : in std_logic);
end component;
component SUBH1
  port (
    Z0 : out std_logic;
    BO : out std_logic;
    A0 : in std_logic;
    B0 : in std_logic);
end component;
component SUBH16A
  port (
    BO : out std_logic;
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z10 : out std_logic;
    Z11 : out std_logic;
    Z12 : out std_logic;
    Z13 : out std_logic;
    Z14 : out std_logic;
    Z15 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    Z8 : out std_logic;
    Z9 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A10 : in std_logic;
    A11 : in std_logic;
    A12 : in std_logic;
    A13 : in std_logic;
    A14 : in std_logic;
    A15 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    A8 : in std_logic;
    A9 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B10 : in std_logic;
    B11 : in std_logic;
    B12 : in std_logic;
    B13 : in std_logic;
    B14 : in std_logic;
    B15 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    B4 : in std_logic;
    B5 : in std_logic;
    B6 : in std_logic;
    B7 : in std_logic;
    B8 : in std_logic;
    B9 : in std_logic);
end component;
component SUBH2
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    BO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic);
end component;
component SUBH3
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    BO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic);
end component;
component SUBH4
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    BO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic);
end component;
component SUBH8
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    BO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    B4 : in std_logic;
    B5 : in std_logic;
    B6 : in std_logic;
    B7 : in std_logic);
end component;
component SUBH8A
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    BO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    B4 : in std_logic;
    B5 : in std_logic;
    B6 : in std_logic;
    B7 : in std_logic);
end component;
component TCVRDC
  port (
    A : inout std_logic;
    B : inout std_logic;
    ENA : in std_logic;
    ENB : in std_logic);
end component;
component TCVRSC
  port (
    A : inout std_logic;
    B : inout std_logic;
    EN : in std_logic);
end component;
component LVPECLIN
   port(
      P_IN                       :	in    STD_ULOGIC;
      N_IN                       :	in    STD_ULOGIC;
      O                          :	out   STD_ULOGIC);
end component;
component LVPECLOUT
   port(
      I                          :	in    STD_ULOGIC;
      P_OUT                      :	out   STD_ULOGIC;
      N_OUT                      :	out   STD_ULOGIC);
end component;
component LVPECLTRI
   port(
      I                          :	in    STD_ULOGIC;
      OE                         :	in    STD_ULOGIC;
      P_OUT                      :	out   STD_ULOGIC;
      N_OUT                      :	out   STD_ULOGIC);
end component;


component SPLL
   generic (in_freq : string;
            CLK_OUT_TO_PIN: STRING := "OFF";
            WAKE_ON_LOCK: STRING := "OFF");
   port(
      CLK_IN                         :	in    STD_ULOGIC;
      CLK_OUT                        :	out   STD_ULOGIC);
end component;
component STDPLL
   generic (in_freq  : string  := "100.0";
            mult     : string  := "1";
            div      : string  := "1";
            post     : string  := "1";
            secdiv   : string  := "1";
            lock_cyc : integer := 1;
            CLK_OUT_TO_PIN: STRING := "OFF";
            WAKE_ON_LOCK: STRING := "OFF";
            pll_dly  : string  := "0.0");
   port(
      CLK_IN                         :	in    STD_ULOGIC;
      CLK_OUT                        :	out   STD_ULOGIC;
      PLL_LOCK                       :	out   STD_ULOGIC);
end component;
component STDPLLX
   generic (in_freq  : string  := "100.0";
            mult     : string  := "1";
            div      : string  := "1";
            post     : string  := "1";
            secdiv   : string  := "1";
            CLK_OUT_TO_PIN: STRING := "OFF";
            WAKE_ON_LOCK: STRING := "OFF";
            lock_cyc : integer := 1;
            pll_dly  : string  := "0.0");
   port(
      CLK_IN                         :	in    STD_ULOGIC;
      PLL_FBK                        :	in    STD_ULOGIC;
      PLL_RST                        :	in    STD_ULOGIC;
      CLK_OUT                        :	out   STD_ULOGIC;
      SEC_OUT                        :	out   STD_ULOGIC;
      PLL_LOCK                       :	out   STD_ULOGIC);
end component;
component LVDSIN
   port(
      P_IN                           :	in    STD_ULOGIC;
      N_IN                           :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
end component;
component BLVDSIN
   port(
      P_IN                           :	in    STD_ULOGIC;
      N_IN                           :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
end component;
component LVDSOUT
   port(
      I                              :	in    STD_ULOGIC;
      P_OUT                          :	out   STD_ULOGIC;
      N_OUT                          :	out   STD_ULOGIC);
end component;
component BLVDSOUT
   port(
      I                              :	in    STD_ULOGIC;
      P_OUT                          :	out   STD_ULOGIC;
      N_OUT                          :	out   STD_ULOGIC);
end component;
component LVDSTRI
   port(
      I                              :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      P_OUT                          :	out   STD_ULOGIC;
      N_OUT                          :	out   STD_ULOGIC);
end component;
component BLVDSTRI
   port(
      I                              :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      P_OUT                          :	out   STD_ULOGIC;
      N_OUT                          :	out   STD_ULOGIC);
end component;
component LVDSIO
   port(
      I                              :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      P_IO                           :	inout   STD_ULOGIC;
      N_IO                           :	inout   STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
end component;
component BLVDSIO
   port(
      I                              :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      P_IO                           :	inout   STD_ULOGIC;
      N_IO                           :	inout   STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
end component;

end VHD_PKG;

LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE STD.TEXTIO.ALL;

package components is
constant DefaultTimingChecksOn : Boolean := True;
constant DefaultXon : Boolean := True;
constant DefaultMsgOn : Boolean := True;

function Str2int( L : string) return integer;
function Str2real( L : string) return REAL;

component SPLL
   generic (in_freq : string;
            CLK_OUT_TO_PIN: STRING := "OFF";
            WAKE_ON_LOCK: STRING := "OFF");
   port(
      CLK_IN                         :	in    STD_ULOGIC;
      CLK_OUT                        :	out   STD_ULOGIC);
end component;
component STDPLL
   generic (in_freq  : string  := "100.0";
            mult     : string  := "1";
            div      : string  := "1";
            post     : string  := "1";
            secdiv   : string  := "1";
            CLK_OUT_TO_PIN: STRING := "OFF";
            WAKE_ON_LOCK: STRING := "OFF";
            lock_cyc : integer := 1;
            pll_dly  : string  := "0.0");
   port(
      CLK_IN                         :	in    STD_ULOGIC;
      CLK_OUT                        :	out   STD_ULOGIC;
      PLL_LOCK                       :	out   STD_ULOGIC);
end component;
component STDPLLX
   generic (in_freq  : string  := "100.0";
            mult     : string  := "1";
            div      : string  := "1";
            post     : string  := "1";
            secdiv   : string  := "1";
            CLK_OUT_TO_PIN: STRING := "OFF";
            WAKE_ON_LOCK: STRING := "OFF";
            lock_cyc : integer := 1;
            pll_dly  : string  := "1");
   port(
      CLK_IN                         :	in    STD_ULOGIC;
      PLL_FBK                        :	in    STD_ULOGIC;
      PLL_RST                        :	in    STD_ULOGIC;
      CLK_OUT                        :	out   STD_ULOGIC;
      SEC_OUT                        :	out   STD_ULOGIC;
      PLL_LOCK                       :	out   STD_ULOGIC);
end component;
component LVDSIN
   port(
      P_IN                           :	in    STD_ULOGIC;
      N_IN                           :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
end component;
component BLVDSIN
   port(
      P_IN                           :	in    STD_ULOGIC;
      N_IN                           :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
end component;
component LVDSOUT
   port(
      I                              :	in    STD_ULOGIC;
      P_OUT                          :	out   STD_ULOGIC;
      N_OUT                          :	out   STD_ULOGIC);
end component;
component BLVDSOUT
   port(
      I                              :	in    STD_ULOGIC;
      P_OUT                          :	out   STD_ULOGIC;
      N_OUT                          :	out   STD_ULOGIC);
end component;
component LVDSTRI
   port(
      I                              :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      P_OUT                          :	out   STD_ULOGIC;
      N_OUT                          :	out   STD_ULOGIC);
end component;
component BLVDSTRI
   port(
      I                              :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      P_OUT                          :	out   STD_ULOGIC;
      N_OUT                          :	out   STD_ULOGIC);
end component;
component LVDSIO
   port(
      I                              :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      P_IO                           :	inout   STD_ULOGIC;
      N_IO                           :	inout   STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
end component;
component BLVDSIO
   port(
      I                              :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      P_IO                           :	inout   STD_ULOGIC;
      N_IO                           :	inout   STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
end component;

component LVPECLIN
   port(
      P_IN                       :	in    STD_ULOGIC;
      N_IN                       :	in    STD_ULOGIC;
      O                          :	out   STD_ULOGIC);
end component;
component LVPECLOUT
   port(
      I                          :	in    STD_ULOGIC;
      P_OUT                      :	out   STD_ULOGIC;
      N_OUT                      :	out   STD_ULOGIC);
end component;
component LVPECLTRI
   port(
      I                          :	in    STD_ULOGIC;
      OE                         :	in    STD_ULOGIC;
      P_OUT                      :	out   STD_ULOGIC;
      N_OUT                      :	out   STD_ULOGIC);
end component;

	component SHFE 
		port( REF : IN std_logic;
			  DATA : IN std_logic);
	end component;

	component PW 
		port( PULSE : IN std_logic);
	end component;

	component INV 
		port( A0 : IN std_logic;
			  ZN0 : OUT std_logic);
	end component;

	component BUF 
		port( A0 : IN std_logic;
			  Z0 : OUT std_logic);
	end component;

	component LXOR2
		port(A0 : IN std_logic;
			 A1 : IN std_logic;
			 Z0 : OUT std_logic);
	end component;

	component FD11
		port(D0 : IN std_logic;
			 CLK : IN std_logic;
			 Q0 : OUT std_logic);
	end component;

	component FD21
		port(D0 : IN std_logic;
			 CLK : IN std_logic;
			 CD : IN std_logic;
			 Q0 : OUT std_logic);
	end component;

	component XINV 
		port( A0 : IN std_logic;
			  ZN0 : OUT std_logic);
	end component;

	component XINPUT 
		port( XI0 : IN std_logic;
			  Z0 : OUT std_logic);
	end component;

	component XOUTPUT 
		port( A0 : IN std_logic;
			  XO0 : OUT std_logic);
	end component;

	component XBIDI1 
		port ( A0 : IN std_logic;
			   OE : IN std_logic;
			   Z0 : OUT std_logic;
			   XB0 : INOUT std_logic);
	 end component;

	component XTRI1 
		port( A0 : IN  std_logic;
			  OE : IN  std_logic;
			  XO0 : OUT  std_logic);
	end component;

	component XDFF1
		port( D0 : IN std_logic;
			  CLK : IN std_logic;
			  Q0 : OUT std_logic);
	end component;

	component XDL1
		port ( D0 : IN std_logic;
				G : IN std_logic;
			   Q0 : OUT std_logic);
	end component;

component XOR2 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component XOR3 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component XOR4 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component XOR8 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component XOR9 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component OR2 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component OR3 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component OR4 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component OR5 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component OR6 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component OR7 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component OR8 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component OR9 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component OR10 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component OR11 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component OR12 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component OR16 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 A12 : IN std_logic;
		 A13 : IN std_logic;
		 A14 : IN std_logic;
		 A15 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND2 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND3 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND4 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND5 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND6 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND7 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND8 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND9 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND10 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND11 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND12 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND13 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 A12 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND14 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 A12 : IN std_logic;
		 A13 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND15 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 A12 : IN std_logic;
		 A13 : IN std_logic;
		 A14 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND16 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 A12 : IN std_logic;
		 A13 : IN std_logic;
		 A14 : IN std_logic;
		 A15 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND17 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 A12 : IN std_logic;
		 A13 : IN std_logic;
		 A14 : IN std_logic;
		 A15 : IN std_logic;
		 A16 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component AND18 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 A12 : IN std_logic;
		 A13 : IN std_logic;
		 A14 : IN std_logic;
		 A15 : IN std_logic;
		 A16 : IN std_logic;
		 A17 : IN std_logic;
		 Z0 : OUT std_logic);

end component;

component NAND2 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NAND3 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NAND4 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NAND5 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NAND6 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NAND7 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NAND8 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NAND9 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NAND10 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NAND11 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NAND12 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NAND16 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 A12 : IN std_logic;
		 A13 : IN std_logic;
		 A14 : IN std_logic;
		 A15 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NOR2 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NOR3 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NOR4 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NOR5 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NOR6 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NOR7 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NOR8 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NOR9 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NOR10 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NOR11 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NOR12 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component NOR16 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 A12 : IN std_logic;
		 A13 : IN std_logic;
		 A14 : IN std_logic;
		 A15 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component XNOR2 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component XNOR3 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component XNOR4 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component XNOR7 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component XNOR8 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component XNOR9 
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 ZN0 : OUT std_logic);

end component;

component FD11E
  port (D0, CLK, EN : IN std_logic;
	       Q0 : OUT std_logic);
end component;

component FD21E
  port (D0, CLK, CD, EN : IN std_logic;
	           Q0 : OUT std_logic);
end component;

component FDC1
  port (D0, CLK, SD : IN std_logic;
	       Q0 : OUT std_logic);
end component;

component FDC1E
  port (D0, CLK, SD, EN : IN std_logic;
	           Q0 : OUT std_logic);
end component;

component FDE1
  port (D0, CLK, CD, SD : IN std_logic;
	           Q0 : OUT std_logic);
end component;

component FDE1E
  port (D0, CLK, CD, SD, EN : IN std_logic;
	               Q0 : OUT std_logic);
end component;

component FTI21
  port (T0, CLK, CD : IN std_logic;
                 Q0 : OUT std_logic);
end component;

component FTI21E
  port (T0, CLK, CD, EN : IN std_logic;
                     Q0 : OUT std_logic);
end component;

component FTI31
  port (T0, CLK, SD : IN std_logic;
	       Q0 : OUT std_logic);
end component;

component FTI31E
  port (T0, CLK, SD, EN : IN std_logic;
		 Q0 : OUT std_logic);
end component;

component FTI41
  port (T0, CLK, SD, CD : IN std_logic;
		 Q0 : OUT std_logic);
end component;

component FTI41E
  port (T0, CLK, CD, SD, EN : IN std_logic;
		     Q0 : OUT std_logic);
end component;

component IT11
  port(A0, OE : IN std_logic;
	 O0 : OUT  std_logic);
end component;
       
component LDI11
  port (D0, G : IN std_logic;
           Q0 : OUT std_logic);
end component;

component LDI21
  port (D0, G, CD : IN std_logic;
	     Q0 : OUT std_logic);
end component;

component LDI31
  port (D0, G, SD : IN std_logic;
	     Q0 : OUT std_logic);
end component;

component LDI41
  port (D0, G, CD, SD : IN std_logic;
	         Q0 : OUT std_logic);
end component;

component XDFF1E
  port (D0, CLK, EN : IN std_logic;
	       Q0 : OUT std_logic);
end component;

component XDFF2
  port (D0, CLK, CD : IN std_logic;
	       Q0 : OUT std_logic);
end component;

component XDFF2E
  port (D0, CLK, CD, EN : IN std_logic;
	           Q0 : OUT std_logic);
end component;

component XDFF3
  port (D0, CLK, SD : IN std_logic;
	       Q0 : OUT std_logic);
end component;

component XDFF3E
  port (D0, CLK, SD, EN : IN std_logic;
	           Q0 : OUT std_logic);
end component;

component XDFF4
  port (D0, CLK, CD, SD : IN std_logic;
	           Q0 : OUT std_logic);
end component;

component XDFF4E
  port (D0, CLK, CD, SD, EN : IN std_logic;
	               Q0 : OUT std_logic);
end component;

component XDL2
  port (D0, G, CD : IN std_logic;
	     Q0 : OUT std_logic);
end component;

component XDL3
  port (D0, G, SD : IN std_logic;
	     Q0 : OUT std_logic);
end component;

component XDL4
  port (D0, G, CD, SD : IN std_logic;
	         Q0 : OUT std_logic);
end component;

component ADDF1
  port (
    Z0 : out std_logic;
    CO : out std_logic;
    A0 : in std_logic;
    B0 : in std_logic;
    CI : in std_logic);
end component;
component ADDF16A
  port (
    CO : out std_logic;
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z10 : out std_logic;
    Z11 : out std_logic;
    Z12 : out std_logic;
    Z13 : out std_logic;
    Z14 : out std_logic;
    Z15 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    Z8 : out std_logic;
    Z9 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A10 : in std_logic;
    A11 : in std_logic;
    A12 : in std_logic;
    A13 : in std_logic;
    A14 : in std_logic;
    A15 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    A8 : in std_logic;
    A9 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B10 : in std_logic;
    B11 : in std_logic;
    B12 : in std_logic;
    B13 : in std_logic;
    B14 : in std_logic;
    B15 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    B4 : in std_logic;
    B5 : in std_logic;
    B6 : in std_logic;
    B7 : in std_logic;
    B8 : in std_logic;
    B9 : in std_logic;
    CI : in std_logic);
end component;
component ADDF2
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    CO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    CI : in std_logic);
end component;
component ADDF4
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    CO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    CI : in std_logic);
end component;
component ADDF8
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    CO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    B4 : in std_logic;
    B5 : in std_logic;
    B6 : in std_logic;
    B7 : in std_logic;
    CI : in std_logic);
end component;
component ADDF8A
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    CO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    B4 : in std_logic;
    B5 : in std_logic;
    B6 : in std_logic;
    B7 : in std_logic;
    CI : in std_logic);
end component;
component ADDH1
  port (
    Z0 : out std_logic;
    CO : out std_logic;
    A0 : in std_logic;
    B0 : in std_logic);
end component;
component ADDH16A
  port (
    CO : out std_logic;
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z10 : out std_logic;
    Z11 : out std_logic;
    Z12 : out std_logic;
    Z13 : out std_logic;
    Z14 : out std_logic;
    Z15 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    Z8 : out std_logic;
    Z9 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A10 : in std_logic;
    A11 : in std_logic;
    A12 : in std_logic;
    A13 : in std_logic;
    A14 : in std_logic;
    A15 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    A8 : in std_logic;
    A9 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B10 : in std_logic;
    B11 : in std_logic;
    B12 : in std_logic;
    B13 : in std_logic;
    B14 : in std_logic;
    B15 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    B4 : in std_logic;
    B5 : in std_logic;
    B6 : in std_logic;
    B7 : in std_logic;
    B8 : in std_logic;
    B9 : in std_logic);
end component;
component ADDH2
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    CO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic);
end component;
component ADDH3
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    CO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic);
end component;
component ADDH4
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    CO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic);
end component;
component ADDH8
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    CO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    B4 : in std_logic;
    B5 : in std_logic;
    B6 : in std_logic;
    B7 : in std_logic);
end component;
component ADDH8A
  port (
    CO : out std_logic;
    Z7 : out std_logic;
    Z6 : out std_logic;
    Z5 : out std_logic;
    Z4 : out std_logic;
    Z3 : out std_logic;
    Z2 : out std_logic;
    Z1 : out std_logic;
    Z0 : out std_logic;
    B7 : in std_logic;
    B6 : in std_logic;
    B5 : in std_logic;
    B4 : in std_logic;
    B3 : in std_logic;
    B2 : in std_logic;
    B1 : in std_logic;
    B0 : in std_logic;
    A7 : in std_logic;
    A6 : in std_logic;
    A5 : in std_logic;
    A4 : in std_logic;
    A3 : in std_logic;
    A2 : in std_logic;
    A1 : in std_logic;
    A0 : in std_logic);
end component;
component BI11
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    OE : in std_logic);
end component;
component BI14
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    OE : in std_logic);
end component;
component BI18
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    OE : in std_logic);
end component;
component BI21
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    OE : in std_logic);
end component;
component BI24
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    OE : in std_logic);
end component;
component BI28
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    OE : in std_logic);
end component;
component BI31
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    OE : in std_logic);
end component;
component BI34
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    OE : in std_logic);
end component;
component BI38
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    OE : in std_logic);
end component;
component BI41
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    OE : in std_logic);
end component;
component BI44
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    OE : in std_logic);
end component;
component BI48
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    OE : in std_logic);
end component;
component BIID11
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID11E
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    OE : in std_logic);
end component;
component BIID14
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID14E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    OE : in std_logic);
end component;
component BIID18
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID21
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID24
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID28
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID31
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID34
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID38
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID41
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID44
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID48
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID51
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID54
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID58
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID61
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID64
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID68
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID71
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID74
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID78
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID81
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID84
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID88
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID91
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID91E
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    OE : in std_logic);
end component;
component BIID94
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    OE : in std_logic);
end component;
component BIID94E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    OE : in std_logic);
end component;
component BIIDA1
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIIDA1E
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIIDA4
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CLK : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIIDA4E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIIDB1
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIIDB1E
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIIDB4
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIIDB4E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIIL11
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL14
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL18
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL21
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL24
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL28
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL31
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL34
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL38
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL41
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL44
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL48
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL51
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL54
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL58
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL61
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL64
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL68
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL71
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL74
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL78
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL81
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL84
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL88
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    XB4 : inout std_logic;
    XB5 : inout std_logic;
    XB6 : inout std_logic;
    XB7 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL91
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CD : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIIL94
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CD : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIILA1
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    G : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIILA4
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    G : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIILB1
  port (
    Q0 : out std_logic;
    XB0 : inout std_logic;
    A0 : in std_logic;
    CD : in std_logic;
    G : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIILB4
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    CD : in std_logic;
    G : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIN27
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    EN : in std_logic);
end component;
component BIOD11
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    OE : in std_logic);
end component;
component BIOD11E
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    EN : in std_logic;
    OE : in std_logic);
end component;
component BIOD14
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    OE : in std_logic);
end component;
component BIOD14E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    OE : in std_logic);
end component;
component BIOD21
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    OE : in std_logic);
end component;
component BIOD21E
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    EN : in std_logic;
    OE : in std_logic);
end component;
component BIOD24
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    OE : in std_logic);
end component;
component BIOD24E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    OE : in std_logic);
end component;
component BIOD31
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIOD31E
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    EN : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIOD34
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIOD34E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIOD41
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIOD41E
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    EN : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIOD44
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIOD44E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIOL11
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    D0 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIOL14
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIOL21
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIOL24
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component BIOL31
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    D0 : in std_logic;
    G : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIOL34
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIOL41
  port (
    Z0 : out std_logic;
    XB0 : inout std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    G : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component BIOL44
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    XB0 : inout std_logic;
    XB1 : inout std_logic;
    XB2 : inout std_logic;
    XB3 : inout std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component CBD11
  port (
    Q0 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    CD : in std_logic);
end component;
component CBD12
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    CD : in std_logic);
end component;
component CBD14
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    CD : in std_logic);
end component;
component CBD18
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    CD : in std_logic);
end component;
component CBD21
  port (
    Q0 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBD22
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBD24
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBD28
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBD31
  port (
    Q0 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBD32
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBD34
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBD38
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBD41
  port (
    Q0 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CBD42
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CBD44
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CBD48
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CBD516
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    Q8 : out std_logic;
    Q9 : out std_logic;
    Q10 : out std_logic;
    Q11 : out std_logic;
    Q12 : out std_logic;
    Q13 : out std_logic;
    Q14 : out std_logic;
    Q15 : out std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBD616
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    Q8 : out std_logic;
    Q9 : out std_logic;
    Q10 : out std_logic;
    Q11 : out std_logic;
    Q12 : out std_logic;
    Q13 : out std_logic;
    Q14 : out std_logic;
    Q15 : out std_logic;
    CAO : out std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBD84
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component CBD88
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component CBD94
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component CBD98
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component CBDA16
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q10 : out std_logic;
    Q11 : out std_logic;
    Q12 : out std_logic;
    Q13 : out std_logic;
    Q14 : out std_logic;
    Q15 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    Q8 : out std_logic;
    Q9 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D10 : in std_logic;
    D11 : in std_logic;
    D12 : in std_logic;
    D13 : in std_logic;
    D14 : in std_logic;
    D15 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    D8 : in std_logic;
    D9 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component CBDA4
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component CBDA8
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component CBDB4
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    CS : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component CBDB8
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    CS : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component CBU11
  port (
    Q0 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    CD : in std_logic);
end component;
component CBU12
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    CD : in std_logic);
end component;
component CBU14
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    CD : in std_logic);
end component;
component CBU18
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    CD : in std_logic);
end component;
component CBU21
  port (
    Q0 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBU22
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBU24
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBU28
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAO : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBU31
  port (
    Q0 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBU32
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBU34
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBU38
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBU41
  port (
    Q0 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CBU42
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CBU44
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CBU48
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CBU516
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    Q8 : out std_logic;
    Q9 : out std_logic;
    Q10 : out std_logic;
    Q11 : out std_logic;
    Q12 : out std_logic;
    Q13 : out std_logic;
    Q14 : out std_logic;
    Q15 : out std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBU616
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    Q8 : out std_logic;
    Q9 : out std_logic;
    Q10 : out std_logic;
    Q11 : out std_logic;
    Q12 : out std_logic;
    Q13 : out std_logic;
    Q14 : out std_logic;
    Q15 : out std_logic;
    CAO : out std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CBU716
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q10 : out std_logic;
    Q11 : out std_logic;
    Q12 : out std_logic;
    Q13 : out std_logic;
    Q14 : out std_logic;
    Q15 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    Q8 : out std_logic;
    Q9 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D10 : in std_logic;
    D11 : in std_logic;
    D12 : in std_logic;
    D13 : in std_logic;
    D14 : in std_logic;
    D15 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    D8 : in std_logic;
    D9 : in std_logic;
    EN : in std_logic;
    LD : in std_logic);
end component;
component CBU84
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component CBU88
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component CBU94
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component CBU98
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component CBUA16
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q10 : out std_logic;
    Q11 : out std_logic;
    Q12 : out std_logic;
    Q13 : out std_logic;
    Q14 : out std_logic;
    Q15 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    Q8 : out std_logic;
    Q9 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D10 : in std_logic;
    D11 : in std_logic;
    D12 : in std_logic;
    D13 : in std_logic;
    D14 : in std_logic;
    D15 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    D8 : in std_logic;
    D9 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component CBUA4
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component CBUA8
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component CBUB4
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    CS : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component CBUB8
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    CS : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component CBUD1
  port (
    Q0 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    DNUP : in std_logic;
    CD : in std_logic;
    CS : in std_logic);
end component;
component CBUD2
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    DNUP : in std_logic;
    CD : in std_logic;
    CS : in std_logic);
end component;
component CBUD4
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    DNUP : in std_logic;
    CD : in std_logic;
    CS : in std_logic);
end component;
component CBUD4S
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    CS : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    DNUP : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component CBUD8
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    DNUP : in std_logic;
    CD : in std_logic;
    CS : in std_logic);
end component;
component CBUD8S
  port (
    CAO : out std_logic;
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    CS : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    DNUP : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component CDD14
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CDD18
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CDD24
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CDD28
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CDD34
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CDD38
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CDD44
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CDD48
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CDU14
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CDU18
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CDU24
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CDU28
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CDU34
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CDU38
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CDU44
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CDU48
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CDUD4
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    DNUP : in std_logic;
    CD : in std_logic;
    CS : in std_logic);
end component;
component CDUD4C
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    DNUP : in std_logic;
    CD : in std_logic;
    CS : in std_logic);
end component;
component CDUD8
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    DNUP : in std_logic;
    CD : in std_logic;
    CS : in std_logic);
end component;
component CDUD8C
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAO : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    DNUP : in std_logic;
    CD : in std_logic;
    CS : in std_logic);
end component;
component CGD14
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CGD24
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CGD34
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component CGU14
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component CGU24
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component CGU34
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component CGUD4
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    DNUP : in std_logic;
    CD : in std_logic;
    CS : in std_logic);
end component;
component CGUD4S
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    CS : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    DNUP : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component CMP2
  port (
    EQ : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic);
end component;
component CMP4
  port (
    EQ : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic);
end component;
component CMP8
  port (
    EQ : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    B4 : in std_logic;
    B5 : in std_logic;
    B6 : in std_logic;
    B7 : in std_logic);
end component;
component DEC2
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    S0 : in std_logic);
end component;
component DEC2E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    EN : in std_logic;
    S0 : in std_logic);
end component;
component DEC3
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component DEC3E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    EN : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component DEC4
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component DEC4E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    EN : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component DMUX2
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    A0 : in std_logic;
    S0 : in std_logic);
end component;
component DMUX22
  port (
    Y0 : out std_logic;
    Y1 : out std_logic;
    Z0 : out std_logic;
    Z1 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    S0 : in std_logic);
end component;
component DMUX22E
  port (
    Y0 : out std_logic;
    Y1 : out std_logic;
    Z0 : out std_logic;
    Z1 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic);
end component;
component DMUX24
  port (
    W0 : out std_logic;
    W1 : out std_logic;
    X0 : out std_logic;
    X1 : out std_logic;
    Y0 : out std_logic;
    Y1 : out std_logic;
    Z0 : out std_logic;
    Z1 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component DMUX24E
  port (
    W0 : out std_logic;
    W1 : out std_logic;
    X0 : out std_logic;
    X1 : out std_logic;
    Y0 : out std_logic;
    Y1 : out std_logic;
    Z0 : out std_logic;
    Z1 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component DMUX2E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    A0 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic);
end component;
component DMUX4
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    A0 : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component DMUX42
  port (
    Y0 : out std_logic;
    Y1 : out std_logic;
    Y2 : out std_logic;
    Y3 : out std_logic;
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    S0 : in std_logic);
end component;
component DMUX42E
  port (
    Y0 : out std_logic;
    Y1 : out std_logic;
    Y2 : out std_logic;
    Y3 : out std_logic;
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic);
end component;
component DMUX44
  port (
    W0 : out std_logic;
    W1 : out std_logic;
    W2 : out std_logic;
    W3 : out std_logic;
    X0 : out std_logic;
    X1 : out std_logic;
    X2 : out std_logic;
    X3 : out std_logic;
    Y0 : out std_logic;
    Y1 : out std_logic;
    Y2 : out std_logic;
    Y3 : out std_logic;
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component DMUX44E
  port (
    W0 : out std_logic;
    W1 : out std_logic;
    W2 : out std_logic;
    W3 : out std_logic;
    X0 : out std_logic;
    X1 : out std_logic;
    X2 : out std_logic;
    X3 : out std_logic;
    Y0 : out std_logic;
    Y1 : out std_logic;
    Y2 : out std_logic;
    Y3 : out std_logic;
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component DMUX4E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    A0 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component DMUX82
  port (
    Y0 : out std_logic;
    Y1 : out std_logic;
    Y2 : out std_logic;
    Y3 : out std_logic;
    Y4 : out std_logic;
    Y5 : out std_logic;
    Y6 : out std_logic;
    Y7 : out std_logic;
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    S0 : in std_logic);
end component;
component DMUX82E
  port (
    Y0 : out std_logic;
    Y1 : out std_logic;
    Y2 : out std_logic;
    Y3 : out std_logic;
    Y4 : out std_logic;
    Y5 : out std_logic;
    Y6 : out std_logic;
    Y7 : out std_logic;
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic);
end component;
component F3ADD
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    G012 : out std_logic;
    P012 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    CI : in std_logic);
end component;
component F3SUB
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    G012 : out std_logic;
    P012 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    BI : in std_logic);
end component;
component FD14
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic);
end component;
component FD14E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic);
end component;
component FD18
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CLK : in std_logic);
end component;
component FD18E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    EN : in std_logic);
end component;
component FD24
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic;
    CD : in std_logic);
end component;
component FD24E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic);
end component;
component FD28
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CLK : in std_logic;
    CD : in std_logic);
end component;
component FD28E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    EN : in std_logic);
end component;
component FD31
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic);
end component;
component FD34
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic);
end component;
component FD38
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic);
end component;
component FD41
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    CD : in std_logic);
end component;
component FD44
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    CD : in std_logic);
end component;
component FD48
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    CD : in std_logic);
end component;
component FD51
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    CS : in std_logic);
end component;
component FD54
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    CS : in std_logic);
end component;
component FD58
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    CS : in std_logic);
end component;
component FD61
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    TI0 : in std_logic;
    CLK : in std_logic;
    TE : in std_logic);
end component;
component FD64
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    CLK : in std_logic;
    TE : in std_logic);
end component;
component FD68
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    TI4 : in std_logic;
    TI5 : in std_logic;
    TI6 : in std_logic;
    TI7 : in std_logic;
    CLK : in std_logic;
    TE : in std_logic);
end component;
component FD71
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    TI0 : in std_logic;
    CLK : in std_logic;
    CD : in std_logic;
    TE : in std_logic);
end component;
component FD74
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    CLK : in std_logic;
    CD : in std_logic;
    TE : in std_logic);
end component;
component FD78
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    TI4 : in std_logic;
    TI5 : in std_logic;
    TI6 : in std_logic;
    TI7 : in std_logic;
    CLK : in std_logic;
    CD : in std_logic;
    TE : in std_logic);
end component;
component FD81
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    TI0 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    TE : in std_logic);
end component;
component FD84
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    TE : in std_logic);
end component;
component FD88
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    TI4 : in std_logic;
    TI5 : in std_logic;
    TI6 : in std_logic;
    TI7 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    TE : in std_logic);
end component;
component FD91
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    TI0 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    CD : in std_logic;
    TE : in std_logic);
end component;
component FD94
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    CD : in std_logic;
    TE : in std_logic);
end component;
component FD98
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    TI4 : in std_logic;
    TI5 : in std_logic;
    TI6 : in std_logic;
    TI7 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    CD : in std_logic;
    TE : in std_logic);
end component;
component FDA1
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    TI0 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    CS : in std_logic;
    TE : in std_logic);
end component;
component FDA4
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    CS : in std_logic;
    TE : in std_logic);
end component;
component FDA8
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    TI4 : in std_logic;
    TI5 : in std_logic;
    TI6 : in std_logic;
    TI7 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    CS : in std_logic;
    TE : in std_logic);
end component;
component FDB1
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    CLK : in std_logic;
    SD : in std_logic);
end component;
component FDB4
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CLK : in std_logic;
    SD : in std_logic);
end component;
component FDB8
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CLK : in std_logic;
    SD : in std_logic);
end component;
component FDC4
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    SD : in std_logic);
end component;
component FDC4E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component FDC8
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    SD : in std_logic);
end component;
component FDC8E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component FDE4
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    SD : in std_logic);
end component;
component FDE4E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component FDE8
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    SD : in std_logic);
end component;
component FDE8E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component FJK11
  port (
    Q0 : out std_logic;
    J0 : in std_logic;
    K0 : in std_logic;
    CLK : in std_logic);
end component;
component FJK21
  port (
    Q0 : out std_logic;
    J0 : in std_logic;
    K0 : in std_logic;
    CLK : in std_logic;
    CD : in std_logic);
end component;
component FJK31
  port (
    Q0 : out std_logic;
    J0 : in std_logic;
    K0 : in std_logic;
    TI0 : in std_logic;
    CLK : in std_logic;
    TE : in std_logic);
end component;
component FJK41
  port (
    Q0 : out std_logic;
    J0 : in std_logic;
    K0 : in std_logic;
    TI0 : in std_logic;
    CLK : in std_logic;
    CD : in std_logic;
    TE : in std_logic);
end component;
component FJK51
  port (
    Q0 : out std_logic;
    J0 : in std_logic;
    K0 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    CD : in std_logic);
end component;
component FJK61
  port (
    Q0 : out std_logic;
    CLK : in std_logic;
    J0 : in std_logic;
    K0 : in std_logic;
    SD : in std_logic);
end component;
component FJK64
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CLK : in std_logic;
    J0 : in std_logic;
    J1 : in std_logic;
    J2 : in std_logic;
    J3 : in std_logic;
    K0 : in std_logic;
    K1 : in std_logic;
    K2 : in std_logic;
    K3 : in std_logic;
    SD : in std_logic);
end component;
component FJK68
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CLK : in std_logic;
    J0 : in std_logic;
    J1 : in std_logic;
    J2 : in std_logic;
    J3 : in std_logic;
    J4 : in std_logic;
    J5 : in std_logic;
    J6 : in std_logic;
    J7 : in std_logic;
    K0 : in std_logic;
    K1 : in std_logic;
    K2 : in std_logic;
    K3 : in std_logic;
    K4 : in std_logic;
    K5 : in std_logic;
    K6 : in std_logic;
    K7 : in std_logic;
    SD : in std_logic);
end component;
component FJK71
  port (
    Q0 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    J0 : in std_logic;
    K0 : in std_logic;
    SD : in std_logic);
end component;
component FJK71E
  port (
    Q0 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    J0 : in std_logic;
    K0 : in std_logic;
    SD : in std_logic);
end component;
component FJK74
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    J0 : in std_logic;
    J1 : in std_logic;
    J2 : in std_logic;
    J3 : in std_logic;
    K0 : in std_logic;
    K1 : in std_logic;
    K2 : in std_logic;
    K3 : in std_logic;
    SD : in std_logic);
end component;
component FJK74E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    J0 : in std_logic;
    J1 : in std_logic;
    J2 : in std_logic;
    J3 : in std_logic;
    K0 : in std_logic;
    K1 : in std_logic;
    K2 : in std_logic;
    K3 : in std_logic;
    SD : in std_logic);
end component;
component FJK78
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    J0 : in std_logic;
    J1 : in std_logic;
    J2 : in std_logic;
    J3 : in std_logic;
    J4 : in std_logic;
    J5 : in std_logic;
    J6 : in std_logic;
    J7 : in std_logic;
    K0 : in std_logic;
    K1 : in std_logic;
    K2 : in std_logic;
    K3 : in std_logic;
    K4 : in std_logic;
    K5 : in std_logic;
    K6 : in std_logic;
    K7 : in std_logic;
    SD : in std_logic);
end component;
component FJK78E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    J0 : in std_logic;
    J1 : in std_logic;
    J2 : in std_logic;
    J3 : in std_logic;
    J4 : in std_logic;
    J5 : in std_logic;
    J6 : in std_logic;
    J7 : in std_logic;
    K0 : in std_logic;
    K1 : in std_logic;
    K2 : in std_logic;
    K3 : in std_logic;
    K4 : in std_logic;
    K5 : in std_logic;
    K6 : in std_logic;
    K7 : in std_logic;
    SD : in std_logic);
end component;
component FT11
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    CLK : in std_logic;
    CD : in std_logic);
end component;
component FT21
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    CS : in std_logic);
end component;
component IB11
  port (
    Z0 : out std_logic;
    XI0 : in std_logic);
end component;
component ID11
  port (
    Q0 : out std_logic;
    XI0 : in std_logic;
    CLK : in std_logic);
end component;
component ID11E
  port (
    Q0 : out std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    XI0 : in std_logic);
end component;
component ID14
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic;
    CLK : in std_logic);
end component;
component ID14E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic);
end component;
component ID18
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic;
    XI4 : in std_logic;
    XI5 : in std_logic;
    XI6 : in std_logic;
    XI7 : in std_logic;
    CLK : in std_logic);
end component;
component ID21
  port (
    Q0 : out std_logic;
    XI0 : in std_logic;
    CLK : in std_logic);
end component;
component ID24
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic;
    CLK : in std_logic);
end component;
component ID28
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic;
    XI4 : in std_logic;
    XI5 : in std_logic;
    XI6 : in std_logic;
    XI7 : in std_logic;
    CLK : in std_logic);
end component;
component ID31
  port (
    Q0 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    XI0 : in std_logic);
end component;
component ID31E
  port (
    Q0 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    XI0 : in std_logic);
end component;
component ID34
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic);
end component;
component ID34E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic);
end component;
component ID41
  port (
    Q0 : out std_logic;
    CLK : in std_logic;
    SD : in std_logic;
    XI0 : in std_logic);
end component;
component ID41E
  port (
    Q0 : out std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    SD : in std_logic;
    XI0 : in std_logic);
end component;
component ID44
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CLK : in std_logic;
    SD : in std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic);
end component;
component ID44E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    SD : in std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic);
end component;
component ID51
  port (
    Q0 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    SD : in std_logic;
    XI0 : in std_logic);
end component;
component ID51E
  port (
    Q0 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    SD : in std_logic;
    XI0 : in std_logic);
end component;
component ID54
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    SD : in std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic);
end component;
component ID54E
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    SD : in std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic);
end component;
component IL11
  port (
    Q0 : out std_logic;
    XI0 : in std_logic;
    G : in std_logic);
end component;
component IL14
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic;
    G : in std_logic);
end component;
component IL18
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic;
    XI4 : in std_logic;
    XI5 : in std_logic;
    XI6 : in std_logic;
    XI7 : in std_logic;
    G : in std_logic);
end component;
component IL21
  port (
    Q0 : out std_logic;
    XI0 : in std_logic;
    G : in std_logic);
end component;
component IL24
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic;
    G : in std_logic);
end component;
component IL28
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic;
    XI4 : in std_logic;
    XI5 : in std_logic;
    XI6 : in std_logic;
    XI7 : in std_logic;
    G : in std_logic);
end component;
component IL31
  port (
    Q0 : out std_logic;
    CD : in std_logic;
    G : in std_logic;
    XI0 : in std_logic);
end component;
component IL34
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    G : in std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic);
end component;
component IL41
  port (
    Q0 : out std_logic;
    G : in std_logic;
    SD : in std_logic;
    XI0 : in std_logic);
end component;
component IL44
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    G : in std_logic;
    SD : in std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic);
end component;
component IL51
  port (
    Q0 : out std_logic;
    CD : in std_logic;
    G : in std_logic;
    SD : in std_logic;
    XI0 : in std_logic);
end component;
component IL54
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    G : in std_logic;
    SD : in std_logic;
    XI0 : in std_logic;
    XI1 : in std_logic;
    XI2 : in std_logic;
    XI3 : in std_logic);
end component;
component IT14
  port (
    O0 : out std_logic;
    O1 : out std_logic;
    O2 : out std_logic;
    O3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    OE : in std_logic);
end component;

component IT18
  port (
    O0 : out std_logic;
    O1 : out std_logic;
    O2 : out std_logic;
    O3 : out std_logic;
    O4 : out std_logic;
    O5 : out std_logic;
    O6 : out std_logic;
    O7 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    OE : in std_logic);
end component;
component IT21
  port (
    O0 : out std_logic;
    A0 : in std_logic;
    OE : in std_logic);
end component;
component IT24
  port (
    O0 : out std_logic;
    O1 : out std_logic;
    O2 : out std_logic;
    O3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    OE : in std_logic);
end component;
component IT28
  port (
    O0 : out std_logic;
    O1 : out std_logic;
    O2 : out std_logic;
    O3 : out std_logic;
    O4 : out std_logic;
    O5 : out std_logic;
    O6 : out std_logic;
    O7 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    OE : in std_logic);
end component;
component LD11
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    G : in std_logic);
end component;
component LD14
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic);
end component;
component LD18
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    G : in std_logic);
end component;
component LD21
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    G : in std_logic;
    CD : in std_logic);
end component;
component LD24
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    CD : in std_logic);
end component;
component LD28
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    G : in std_logic;
    CD : in std_logic);
end component;
component LD31
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    G : in std_logic;
    PD : in std_logic);
end component;
component LD34
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    PD : in std_logic);
end component;
component LD38
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    G : in std_logic;
    PD : in std_logic);
end component;
component LD41
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    G : in std_logic;
    PD : in std_logic;
    CD : in std_logic);
end component;
component LD44
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    PD : in std_logic;
    CD : in std_logic);
end component;
component LD48
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    G : in std_logic;
    PD : in std_logic;
    CD : in std_logic);
end component;
component LD51
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    G : in std_logic;
    PD : in std_logic;
    CD : in std_logic);
end component;
component LD54
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    PD : in std_logic;
    CD : in std_logic);
end component;
component LD58
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    G : in std_logic;
    PD : in std_logic;
    CD : in std_logic);
end component;
component LD61
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    TI0 : in std_logic;
    G : in std_logic;
    TG : in std_logic);
end component;
component LD64
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    G : in std_logic;
    TG : in std_logic);
end component;
component LD68
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    TI4 : in std_logic;
    TI5 : in std_logic;
    TI6 : in std_logic;
    TI7 : in std_logic;
    G : in std_logic;
    TG : in std_logic);
end component;
component LD71
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    TI0 : in std_logic;
    G : in std_logic;
    CD : in std_logic;
    TG : in std_logic);
end component;
component LD74
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    G : in std_logic;
    CD : in std_logic;
    TG : in std_logic);
end component;
component LD78
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    TI4 : in std_logic;
    TI5 : in std_logic;
    TI6 : in std_logic;
    TI7 : in std_logic;
    G : in std_logic;
    CD : in std_logic;
    TG : in std_logic);
end component;
component LD81
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    TI0 : in std_logic;
    G : in std_logic;
    PD : in std_logic;
    TG : in std_logic);
end component;
component LD84
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    G : in std_logic;
    PD : in std_logic;
    TG : in std_logic);
end component;
component LD88
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    TI4 : in std_logic;
    TI5 : in std_logic;
    TI6 : in std_logic;
    TI7 : in std_logic;
    G : in std_logic;
    PD : in std_logic;
    TG : in std_logic);
end component;
component LD91
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    TI0 : in std_logic;
    G : in std_logic;
    PD : in std_logic;
    CD : in std_logic;
    TG : in std_logic);
end component;
component LD94
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    G : in std_logic;
    PD : in std_logic;
    CD : in std_logic;
    TG : in std_logic);
end component;
component LD98
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    TI4 : in std_logic;
    TI5 : in std_logic;
    TI6 : in std_logic;
    TI7 : in std_logic;
    G : in std_logic;
    PD : in std_logic;
    CD : in std_logic;
    TG : in std_logic);
end component;
component LDA1
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    TI0 : in std_logic;
    G : in std_logic;
    PD : in std_logic;
    CD : in std_logic;
    TG : in std_logic);
end component;
component LDA4
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    G : in std_logic;
    PD : in std_logic;
    CD : in std_logic;
    TG : in std_logic);
end component;
component LDA8
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    TI0 : in std_logic;
    TI1 : in std_logic;
    TI2 : in std_logic;
    TI3 : in std_logic;
    TI4 : in std_logic;
    TI5 : in std_logic;
    TI6 : in std_logic;
    TI7 : in std_logic;
    G : in std_logic;
    PD : in std_logic;
    CD : in std_logic;
    TG : in std_logic);
end component;
component LDI14
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic);
end component;
component LDI18
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    G : in std_logic);
end component;
component LDI24
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic);
end component;
component LDI28
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    G : in std_logic);
end component;
component LDI34
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    SD : in std_logic);
end component;
component LDI38
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    G : in std_logic;
    SD : in std_logic);
end component;
component LDI44
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    SD : in std_logic);
end component;
component LDI48
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    G : in std_logic;
    SD : in std_logic);
end component;
component LSR1
  port (
    Q0 : out std_logic;
    S0 : in std_logic;
    R0 : in std_logic);
end component;
component LSR2
  port (
    Q0 : out std_logic;
    S0 : in std_logic;
    S1 : in std_logic;
    R0 : in std_logic;
    R1 : in std_logic);
end component;
component MAG2
  port (
    GT : out std_logic;
    EQ : out std_logic;
    LT : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    GTI : in std_logic;
    EQI : in std_logic;
    LTI : in std_logic);
end component;
component MAG4
  port (
    GT : out std_logic;
    EQ : out std_logic;
    LT : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    GTI : in std_logic;
    EQI : in std_logic;
    LTI : in std_logic);
end component;
component MAG8
  port (
    GT : out std_logic;
    EQ : out std_logic;
    LT : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    B4 : in std_logic;
    B5 : in std_logic;
    B6 : in std_logic;
    B7 : in std_logic;
    GTI : in std_logic;
    EQI : in std_logic;
    LTI : in std_logic);
end component;
component MULT24
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic);
end component;
component MULT44
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic);
end component;
component MUX16
  port (
    Z0 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    A8 : in std_logic;
    A9 : in std_logic;
    A10 : in std_logic;
    A11 : in std_logic;
    A12 : in std_logic;
    A13 : in std_logic;
    A14 : in std_logic;
    A15 : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic;
    S2 : in std_logic;
    S3 : in std_logic);
end component;
component MUX16E
  port (
    Z0 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    A8 : in std_logic;
    A9 : in std_logic;
    A10 : in std_logic;
    A11 : in std_logic;
    A12 : in std_logic;
    A13 : in std_logic;
    A14 : in std_logic;
    A15 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic;
    S2 : in std_logic;
    S3 : in std_logic);
end component;
component MUX2
  port (
    Z0 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    S0 : in std_logic);
end component;
component MUX22
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    S0 : in std_logic);
end component;
component MUX22E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic);
end component;
component MUX24
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    C0 : in std_logic;
    C1 : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component MUX24E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    C0 : in std_logic;
    C1 : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component MUX2E
  port (
    Z0 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic);
end component;
component MUX4
  port (
    Z0 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component MUX42
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    S0 : in std_logic);
end component;
component MUX42E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic);
end component;
component MUX44
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    C0 : in std_logic;
    C1 : in std_logic;
    C2 : in std_logic;
    C3 : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component MUX44A
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    C0 : in std_logic;
    C1 : in std_logic;
    C2 : in std_logic;
    C3 : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component MUX44AE
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    C0 : in std_logic;
    C1 : in std_logic;
    C2 : in std_logic;
    C3 : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component MUX44E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    C0 : in std_logic;
    C1 : in std_logic;
    C2 : in std_logic;
    C3 : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component MUX4E
  port (
    Z0 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic);
end component;
component MUX8
  port (
    Z0 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic;
    S2 : in std_logic);
end component;
component MUX82
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    B4 : in std_logic;
    B5 : in std_logic;
    B6 : in std_logic;
    B7 : in std_logic;
    S0 : in std_logic);
end component;
component MUX82E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    B4 : in std_logic;
    B5 : in std_logic;
    B6 : in std_logic;
    B7 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic);
end component;
component MUX8E
  port (
    Z0 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    EN : in std_logic;
    S0 : in std_logic;
    S1 : in std_logic;
    S2 : in std_logic);
end component;
component OB11
  port (
    XO0 : out std_logic;
    A0 : in std_logic);
end component;
component OB21
  port (
    XO0 : out std_logic;
    A0 : in std_logic);
end component;
component OB24
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic);
end component;
component OB28
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    XO4 : out std_logic;
    XO5 : out std_logic;
    XO6 : out std_logic;
    XO7 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic);
end component;
component OD11
  port (
    XQ0 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic);
end component;
component OD11E
  port (
    XQ0 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    EN : in std_logic);
end component;
component OD14
  port (
    XQ0 : out std_logic;
    XQ1 : out std_logic;
    XQ2 : out std_logic;
    XQ3 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic);
end component;
component OD14E
  port (
    XQ0 : out std_logic;
    XQ1 : out std_logic;
    XQ2 : out std_logic;
    XQ3 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic);
end component;
component OD21
  port (
    XQ0 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic);
end component;
component OD24
  port (
    XQ0 : out std_logic;
    XQ1 : out std_logic;
    XQ2 : out std_logic;
    XQ3 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic);
end component;
component OD31
  port (
    XQ0 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic);
end component;
component OD31E
  port (
    XQ0 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    EN : in std_logic);
end component;
component OD34
  port (
    XQ0 : out std_logic;
    XQ1 : out std_logic;
    XQ2 : out std_logic;
    XQ3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic);
end component;
component OD34E
  port (
    XQ0 : out std_logic;
    XQ1 : out std_logic;
    XQ2 : out std_logic;
    XQ3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic);
end component;
component OD41
  port (
    XQ0 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    SD : in std_logic);
end component;
component OD41E
  port (
    XQ0 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component OD44
  port (
    XQ0 : out std_logic;
    XQ1 : out std_logic;
    XQ2 : out std_logic;
    XQ3 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    SD : in std_logic);
end component;
component OD44E
  port (
    XQ0 : out std_logic;
    XQ1 : out std_logic;
    XQ2 : out std_logic;
    XQ3 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component OD51
  port (
    XQ0 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    SD : in std_logic);
end component;
component OD51E
  port (
    XQ0 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component OD54
  port (
    XQ0 : out std_logic;
    XQ1 : out std_logic;
    XQ2 : out std_logic;
    XQ3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    SD : in std_logic);
end component;
component OD54E
  port (
    XQ0 : out std_logic;
    XQ1 : out std_logic;
    XQ2 : out std_logic;
    XQ3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    SD : in std_logic);
end component;
component ODT11
  port (
    XO0 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    OE : in std_logic);
end component;
component ODT11E
  port (
    XO0 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    EN : in std_logic;
    OE : in std_logic);
end component;
component ODT14
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    OE : in std_logic);
end component;
component ODT14E
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    OE : in std_logic);
end component;
component ODT21
  port (
    XO0 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    OE : in std_logic);
end component;
component ODT21E
  port (
    XO0 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    EN : in std_logic;
    OE : in std_logic);
end component;
component ODT24
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    OE : in std_logic);
end component;
component ODT24E
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    OE : in std_logic);
end component;
component ODT31
  port (
    XO0 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component ODT31E
  port (
    XO0 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    EN : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component ODT34
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component ODT34E
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component ODT41
  port (
    XO0 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component ODT41E
  port (
    XO0 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    EN : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component ODT44
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component ODT44E
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component OL11
  port (
    XQ0 : out std_logic;
    D0 : in std_logic;
    G : in std_logic);
end component;
component OL14
  port (
    XQ0 : out std_logic;
    XQ1 : out std_logic;
    XQ2 : out std_logic;
    XQ3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic);
end component;
component OL21
  port (
    XQ0 : out std_logic;
    D0 : in std_logic;
    G : in std_logic);
end component;
component OL24
  port (
    XQ0 : out std_logic;
    XQ1 : out std_logic;
    XQ2 : out std_logic;
    XQ3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic);
end component;
component OL31
  port (
    XQ0 : out std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    G : in std_logic);
end component;
component OL34
  port (
    XQ0 : out std_logic;
    XQ1 : out std_logic;
    XQ2 : out std_logic;
    XQ3 : out std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic);
end component;
component OL41
  port (
    XQ0 : out std_logic;
    D0 : in std_logic;
    G : in std_logic;
    SD : in std_logic);
end component;
component OL44
  port (
    XQ0 : out std_logic;
    XQ1 : out std_logic;
    XQ2 : out std_logic;
    XQ3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    SD : in std_logic);
end component;
component OL51
  port (
    XQ0 : out std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    G : in std_logic;
    SD : in std_logic);
end component;
component OL54
  port (
    XQ0 : out std_logic;
    XQ1 : out std_logic;
    XQ2 : out std_logic;
    XQ3 : out std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    SD : in std_logic);
end component;
component OLT11
  port (
    XO0 : out std_logic;
    D0 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component OLT14
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component OLT21
  port (
    XO0 : out std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component OLT24
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    OE : in std_logic);
end component;
component OLT31
  port (
    XO0 : out std_logic;
    D0 : in std_logic;
    G : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component OLT34
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component OLT41
  port (
    XO0 : out std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    G : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component OLT44
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    CD : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    G : in std_logic;
    OE : in std_logic;
    SD : in std_logic);
end component;
component OT11
  port (
    XO0 : out std_logic;
    A0 : in std_logic;
    OE : in std_logic);
end component;
component OT14
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    OE : in std_logic);
end component;
component OT18
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    XO4 : out std_logic;
    XO5 : out std_logic;
    XO6 : out std_logic;
    XO7 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    OE : in std_logic);
end component;
component OT21
  port (
    XO0 : out std_logic;
    A0 : in std_logic;
    OE : in std_logic);
end component;
component OT24
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    OE : in std_logic);
end component;
component OT28
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    XO4 : out std_logic;
    XO5 : out std_logic;
    XO6 : out std_logic;
    XO7 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    OE : in std_logic);
end component;
component OT31
  port (
    XO0 : out std_logic;
    A0 : in std_logic;
    OE : in std_logic);
end component;
component OT34
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    OE : in std_logic);
end component;
component OT38
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    XO4 : out std_logic;
    XO5 : out std_logic;
    XO6 : out std_logic;
    XO7 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    OE : in std_logic);
end component;
component OT41
  port (
    XO0 : out std_logic;
    A0 : in std_logic;
    OE : in std_logic);
end component;
component OT44
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    OE : in std_logic);
end component;
component OT48
  port (
    XO0 : out std_logic;
    XO1 : out std_logic;
    XO2 : out std_logic;
    XO3 : out std_logic;
    XO4 : out std_logic;
    XO5 : out std_logic;
    XO6 : out std_logic;
    XO7 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    OE : in std_logic);
end component;
component PG1
  port (
    PGO1 : out std_logic;
    GI1 : in std_logic;
    PI1 : in std_logic;
    PGI1 : in std_logic);
end component;
component PG2
  port (
    PGO2 : out std_logic;
    GI2 : in std_logic;
    PI2 : in std_logic;
    GI1 : in std_logic;
    PI1 : in std_logic;
    PGI1 : in std_logic);
end component;
component PG3
  port (
    PGO3 : out std_logic;
    GI3 : in std_logic;
    PI3 : in std_logic;
    GI2 : in std_logic;
    PI2 : in std_logic;
    GI1 : in std_logic;
    PI1 : in std_logic;
    PGI1 : in std_logic);
end component;
component PG4
  port (
    PGO4 : out std_logic;
    GI4 : in std_logic;
    PI4 : in std_logic;
    GI3 : in std_logic;
    PI3 : in std_logic;
    GI2 : in std_logic;
    PI2 : in std_logic;
    GI1 : in std_logic;
    PI1 : in std_logic;
    PGI1 : in std_logic);
end component;
component PREN10
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    S0 : in std_logic;
    S1 : in std_logic;
    S2 : in std_logic;
    S3 : in std_logic;
    S4 : in std_logic;
    S5 : in std_logic;
    S6 : in std_logic;
    S7 : in std_logic;
    S8 : in std_logic);
end component;
component PREN10E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    S0 : in std_logic;
    S1 : in std_logic;
    S2 : in std_logic;
    S3 : in std_logic;
    S4 : in std_logic;
    S5 : in std_logic;
    S6 : in std_logic;
    S7 : in std_logic;
    S8 : in std_logic;
    EN : in std_logic);
end component;
component PREN16
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    S0 : in std_logic;
    S1 : in std_logic;
    S2 : in std_logic;
    S3 : in std_logic;
    S4 : in std_logic;
    S5 : in std_logic;
    S6 : in std_logic;
    S7 : in std_logic;
    S8 : in std_logic;
    S9 : in std_logic;
    S10 : in std_logic;
    S11 : in std_logic;
    S12 : in std_logic;
    S13 : in std_logic;
    S14 : in std_logic);
end component;
component PREN16E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    S0 : in std_logic;
    S1 : in std_logic;
    S2 : in std_logic;
    S3 : in std_logic;
    S4 : in std_logic;
    S5 : in std_logic;
    S6 : in std_logic;
    S7 : in std_logic;
    S8 : in std_logic;
    S9 : in std_logic;
    S10 : in std_logic;
    S11 : in std_logic;
    S12 : in std_logic;
    S13 : in std_logic;
    S14 : in std_logic;
    EN : in std_logic);
end component;
component PREN8
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    S0 : in std_logic;
    S1 : in std_logic;
    S2 : in std_logic;
    S3 : in std_logic;
    S4 : in std_logic;
    S5 : in std_logic;
    S6 : in std_logic);
end component;
component PREN8E
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    S0 : in std_logic;
    S1 : in std_logic;
    S2 : in std_logic;
    S3 : in std_logic;
    S4 : in std_logic;
    S5 : in std_logic;
    S6 : in std_logic;
    EN : in std_logic);
end component;
component SRR11
  port (
    Q0 : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    CD : in std_logic);
end component;
component SRR14
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    CD : in std_logic);
end component;
component SRR18
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    CD : in std_logic);
end component;
component SRR21
  port (
    Q0 : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component SRR24
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component SRR28
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component SRR31
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component SRR34
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component SRR38
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CD : in std_logic);
end component;
component SRR41
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component SRR44
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component SRR48
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CAI : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    CS : in std_logic);
end component;
component SRR51
  port (
    Q0 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component SRR54
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component SRR58
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAI : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    SD : in std_logic);
end component;
component SRRL1
  port (
    Q0 : out std_logic;
    D0 : in std_logic;
    CAIR : in std_logic;
    CAIL : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    RL : in std_logic;
    CD : in std_logic;
    CS : in std_logic);
end component;
component SRRL1S
  port (
    Q0 : out std_logic;
    CAIL : in std_logic;
    CAIR : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    CS : in std_logic;
    D0 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    PS : in std_logic;
    RL : in std_logic;
    SD : in std_logic);
end component;
component SRRL4
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    CAIR : in std_logic;
    CAIL : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    RL : in std_logic;
    CD : in std_logic;
    CS : in std_logic);
end component;
component SRRL4S
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    CAIL : in std_logic;
    CAIR : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    CS : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    PS : in std_logic;
    RL : in std_logic;
    SD : in std_logic);
end component;
component SRRL8
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    CAIR : in std_logic;
    CAIL : in std_logic;
    CLK : in std_logic;
    PS : in std_logic;
    LD : in std_logic;
    EN : in std_logic;
    RL : in std_logic;
    CD : in std_logic;
    CS : in std_logic);
end component;
component SRRL8S
  port (
    Q0 : out std_logic;
    Q1 : out std_logic;
    Q2 : out std_logic;
    Q3 : out std_logic;
    Q4 : out std_logic;
    Q5 : out std_logic;
    Q6 : out std_logic;
    Q7 : out std_logic;
    CAIL : in std_logic;
    CAIR : in std_logic;
    CD : in std_logic;
    CLK : in std_logic;
    CS : in std_logic;
    D0 : in std_logic;
    D1 : in std_logic;
    D2 : in std_logic;
    D3 : in std_logic;
    D4 : in std_logic;
    D5 : in std_logic;
    D6 : in std_logic;
    D7 : in std_logic;
    EN : in std_logic;
    LD : in std_logic;
    PS : in std_logic;
    RL : in std_logic;
    SD : in std_logic);
end component;
component SUBF1
  port (
    Z0 : out std_logic;
    BO : out std_logic;
    A0 : in std_logic;
    B0 : in std_logic;
    BI : in std_logic);
end component;
component SUBF16A
  port (
    BO : out std_logic;
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z10 : out std_logic;
    Z11 : out std_logic;
    Z12 : out std_logic;
    Z13 : out std_logic;
    Z14 : out std_logic;
    Z15 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    Z8 : out std_logic;
    Z9 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A10 : in std_logic;
    A11 : in std_logic;
    A12 : in std_logic;
    A13 : in std_logic;
    A14 : in std_logic;
    A15 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    A8 : in std_logic;
    A9 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B10 : in std_logic;
    B11 : in std_logic;
    B12 : in std_logic;
    B13 : in std_logic;
    B14 : in std_logic;
    B15 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    B4 : in std_logic;
    B5 : in std_logic;
    B6 : in std_logic;
    B7 : in std_logic;
    B8 : in std_logic;
    B9 : in std_logic;
    BI : in std_logic);
end component;
component SUBF2
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    BO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    BI : in std_logic);
end component;
component SUBF4
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    BO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    BI : in std_logic);
end component;
component SUBF8
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    BO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    B4 : in std_logic;
    B5 : in std_logic;
    B6 : in std_logic;
    B7 : in std_logic;
    BI : in std_logic);
end component;
component SUBF8A
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    BO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    B4 : in std_logic;
    B5 : in std_logic;
    B6 : in std_logic;
    B7 : in std_logic;
    BI : in std_logic);
end component;
component SUBH1
  port (
    Z0 : out std_logic;
    BO : out std_logic;
    A0 : in std_logic;
    B0 : in std_logic);
end component;
component SUBH16A
  port (
    BO : out std_logic;
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z10 : out std_logic;
    Z11 : out std_logic;
    Z12 : out std_logic;
    Z13 : out std_logic;
    Z14 : out std_logic;
    Z15 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    Z8 : out std_logic;
    Z9 : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A10 : in std_logic;
    A11 : in std_logic;
    A12 : in std_logic;
    A13 : in std_logic;
    A14 : in std_logic;
    A15 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    A8 : in std_logic;
    A9 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B10 : in std_logic;
    B11 : in std_logic;
    B12 : in std_logic;
    B13 : in std_logic;
    B14 : in std_logic;
    B15 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    B4 : in std_logic;
    B5 : in std_logic;
    B6 : in std_logic;
    B7 : in std_logic;
    B8 : in std_logic;
    B9 : in std_logic);
end component;
component SUBH2
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    BO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic);
end component;
component SUBH3
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    BO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic);
end component;
component SUBH4
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    BO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic);
end component;
component SUBH8
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    BO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    B4 : in std_logic;
    B5 : in std_logic;
    B6 : in std_logic;
    B7 : in std_logic);
end component;
component SUBH8A
  port (
    Z0 : out std_logic;
    Z1 : out std_logic;
    Z2 : out std_logic;
    Z3 : out std_logic;
    Z4 : out std_logic;
    Z5 : out std_logic;
    Z6 : out std_logic;
    Z7 : out std_logic;
    BO : out std_logic;
    A0 : in std_logic;
    A1 : in std_logic;
    A2 : in std_logic;
    A3 : in std_logic;
    A4 : in std_logic;
    A5 : in std_logic;
    A6 : in std_logic;
    A7 : in std_logic;
    B0 : in std_logic;
    B1 : in std_logic;
    B2 : in std_logic;
    B3 : in std_logic;
    B4 : in std_logic;
    B5 : in std_logic;
    B6 : in std_logic;
    B7 : in std_logic);
end component;
component TCVRDC
  port (
    A : inout std_logic;
    B : inout std_logic;
    ENA : in std_logic;
    ENB : in std_logic);
end component;
component TCVRSC
  port (
    A : inout std_logic;
    B : inout std_logic;
    EN : in std_logic);
end component;
end components;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.std_logic_arith.all;

package body components is 
 
 
 function str2int( L : string) return integer is
	variable ok:         boolean;
	variable pos:        integer:=1;
	variable sign: integer := 1;
	variable rval: integer := 0;
	variable value: integer := 0;
    begin
	ok := FALSE;
	if pos < L'right and (L(pos) = '-' or L(pos) = '+') then
	    if L(pos) = '-' then
		sign := -1;
	    end if;
	    pos := pos + 1;
	end if;

	-- Once the optional leading sign is removed, an integer can
	--   contain only the digits '0' through '9' and the '_'
	--   (underscore) character.  VHDL disallows two successive
	--   underscores, and leading or trailing underscores.

	if pos <= L'right and L(pos) >= '0' and L(pos) <= '9' then
	    while pos <= L'right loop
		if L(pos) >= '0' and L(pos) <= '9' then
		    rval := rval * 10
		            + character'pos(L(pos)) - character'pos('0');
		    ok := TRUE;
		elsif L(pos) = '_' then
		    if pos = L'right
		    or L(pos + 1) < '0'
		    or L(pos + 1) > '9' then
			ok := FALSE;
			exit;
		    end if;
		else
		    exit;
		end if;
		pos := pos + 1;
	    end loop;
	end if;

	value := sign * rval;
        RETURN(value);
    end str2int;

    function str2real( L: string) return real is
	variable pos:        integer;
	variable value:      real;
	variable value1:      real;
	variable ok:         boolean;
	variable sign:       real := 1.0;
	variable rval:       real := 0.0;
        variable powerten:   real := 0.1;

        begin

	pos := L'left;
	if (pos <= L'right) and (L(pos) = '-') then
	    sign := -1.0;
	    pos := pos + 1;
	end if;

            ok := FALSE;
            rval := 0.0;
            if pos <= L'right and L(pos) >= '0' and L(pos) <= '9' then
                while pos <= L'right and L(pos) /= '.' and L(pos) /= ' ' and L(pos) /= HT  loop
                    if L(pos) >= '0' and L(pos) <= '9' then
                        rval := rval*10.0 + real(character'pos(L(pos)) - character'pos('0'));
                        pos := pos+1;
                        ok := true;
                    else
                        ok := false;
                        exit;
                    end if;
                end loop;
            end if;

	    if ok and pos <= L'right and L(pos) = '.' then
	    pos := pos + 1;
            end if;

            if pos <= L'right then
               while pos <= L'right and ((L(pos) >= '0' and L(pos) <= '9') or L(pos) = '_') loop
                       rval := rval + (real(character'pos(L(pos))-character'pos('0'))*powerten);
                       powerten := powerten*0.1;
                      pos := pos+1;
                     ok := true;
            end loop;
        end if;

        if ok then
            value := rval * sign;
        end if;

        if (L'right <= 2) then
           value1 := 0.25 * value;
        else
           value1 := value;
        end if;

        return (value1);
      end str2real;
 
end components;


LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library lattice;
use lattice.components.all;


-- entity declaration --
entity SPLL is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      IN_FREQ: STRING := "100.0";
      CLK_OUT_TO_PIN: STRING := "OFF";
      WAKE_ON_LOCK: STRING := "OFF";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_CLK_IN_CLK_OUT             :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_CLK_IN                    :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CLK_IN                         :	in    STD_ULOGIC;
      CLK_OUT                        :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of SPLL : entity is FALSE;
end SPLL;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture LATTICE_ARCH of SPLL is
   attribute VITAL_LEVEL1 of LATTICE_ARCH : architecture is FALSE;

   SIGNAL CLK_IN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CLK_IN_ipd, CLK_IN, tipd_CLK_IN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_IN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(CLK_IN_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => CLK_OUT,
       GlitchData => O_GlitchData,
       OutSignalName => "CLK_OUT",
       OutTemp => O_zd,
       Paths => (0 => (CLK_IN_ipd'last_event, tpd_CLK_IN_CLK_OUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end LATTICE_ARCH;

----- VITAL model for cell STDPLL -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library lattice;
use lattice.components.all;

-- entity declaration --
entity STDPLL is
   generic(
      IN_FREQ  : string  := "100.0";
      CLK_OUT_TO_PIN: STRING := "OFF";
      WAKE_ON_LOCK: STRING := "OFF";
      MULT     : string  := "1";
      DIV      : string  := "1";
      POST     : string  := "1";
      SECDIV   : string  := "2";
      lock_cyc : integer := 2;
      PLL_DLY  : string  := "0.0";
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_CLK_IN_CLK_OUT             :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_CLK_IN_PLL_LOCK             :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_CLK_IN             :	VitalDelayType01 := (0.000 ns, 0.000 ns));
   port(
      CLK_IN                         :	in    STD_ULOGIC;
      CLK_OUT                        :	out   STD_ULOGIC;
      PLL_LOCK                       :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of STDPLL : entity is FALSE;
end STDPLL;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library lattice;
use lattice.components.all;
architecture VITAL of STDPLL is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL CLK_IN_ipd	 : STD_ULOGIC := 'X';

  CONSTANT input_frequency : REAL := str2real(in_freq);

  SIGNAL clklock_half_period : TIME :=100 ns;
  SIGNAL clklock_half_period1 : TIME :=100 ns;
  SIGNAL clklock_half_period0 : TIME :=100 ns;
  SIGNAL clklock_half_period_minus_dly1 : TIME :=100 ns;
  SIGNAL clklock_half_period_minus_dly0 : TIME :=100 ns;
  SIGNAL start_inclk : STD_LOGIC ;
  SIGNAL clklock_rising_edge_count : INTEGER := 0 ;
  SIGNAL clklock_falling_edge_count : INTEGER := 0 ;
  SIGNAL clklock_last_rising_edge : TIME ;
  SIGNAL clklock_last_falling_edge : TIME ;

  SIGNAL clock_count : INTEGER := -1 ;
  SIGNAL clklock_lock : BOOLEAN := TRUE;
  SIGNAL CLK_OUT_sig_d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_not  : std_logic := '0';
  SIGNAL CLK_OUT_start  : std_logic := '0';
  SIGNAL CLK_OUT_sig_3d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_start  : std_logic := '0';
  SIGNAL CLK_OUT_sig1 : std_logic := '0';
  SIGNAL CLK_OUT_plus_delay : std_logic := '0';
  SIGNAL PLL_LOCK_plus : std_logic := '0';
  SIGNAL PLL_LOCK_minus : std_logic := '0';
  CONSTANT clockboost: integer := str2int(mult) / str2int(div);
  CONSTANT tpd: time := 1.0 ns * str2real(pll_dly);

BEGIN

   WireDelay : block
   begin
   VitalWireDelay (CLK_IN_ipd, CLK_IN, tipd_CLK_IN);
   end block;

edge_count: PROCESS
     VARIABLE input_cycle : REAL;
     VARIABLE real_cycle : REAL;
BEGIN
     clklock_half_period <= (clklock_half_period0 + clklock_half_period1)/2;

  WAIT UNTIL (CLK_IN_ipd'EVENT AND CLK_IN_ipd='1');	   
     clklock_rising_edge_count <= clklock_rising_edge_count +1;
     IF clklock_rising_edge_count = 0 THEN
        clklock_last_rising_edge <= NOW;	
	start_inclk <= CLK_IN_ipd;
     ELSE
     IF clklock_rising_edge_count = 1 THEN
       clklock_half_period0 <= (NOW - clklock_last_falling_edge)* real(str2int(div))/real(str2int(mult));
	input_cycle := 1000.0 / input_frequency;
	real_cycle := REAL( (NOW - clklock_last_rising_edge) / 1 ns);
	IF ( real_cycle < 0.9 * input_cycle OR
	     real_cycle > 1.1 * input_cycle ) THEN
  	      	ASSERT TRUE 
  		REPORT " Input_Frequency Violation "
  		SEVERITY WARNING;
  		clklock_lock <= FALSE;
        END IF;
       clklock_half_period_minus_dly0 <= (NOW - clklock_last_falling_edge) + tpd;
     END IF;
     END IF;
 
  WAIT UNTIL (CLK_IN_ipd'EVENT AND CLK_IN_ipd='0');
     clklock_falling_edge_count <= clklock_falling_edge_count +1;	  	
     IF clklock_falling_edge_count = 0 THEN	
	clklock_last_falling_edge <= NOW;
	clklock_half_period1 <= (NOW - clklock_last_rising_edge)* real(str2int(div))/real(str2int(mult)); 
     ELSIF clklock_falling_edge_count = 1 THEN
        clklock_half_period_minus_dly1 <= (NOW - clklock_last_rising_edge) + tpd;
     END IF;
END PROCESS edge_count;

toggle: PROCESS
BEGIN

     WAIT ON clklock_rising_edge_count;
     IF clklock_rising_edge_count > lock_cyc + 1 THEN
        if(clockboost >1) then
	   FOR i IN 1 TO (2*clockboost) LOOP 	         
		clock_count <= clock_count + 1;
		WAIT FOR clklock_half_period;
	END LOOP;
      else  
		clock_count <= clock_count + 1;
		WAIT FOR (clklock_half_period);
      end if;
     ELSE
	clock_count <= 0;
     END IF;
END PROCESS toggle;


gen_pll_lock_plus:process
begin
     wait until (clock_count=1);
          PLL_LOCK_plus <= '1';
end process;

gen_pll_lock_minus:process
begin
     wait until (clock_count=3);
          PLL_LOCK_minus <= '1';
end process;

process
begin 
    wait until clock_count = 1;
    CLK_OUT_sig_d_start <='1';
end process;

process
begin
   wait until CLK_OUT_sig_d_start = '1'; LOOP
     wait for clklock_half_period1;
   CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not;
     wait for clklock_half_period0;
   CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not ;
   END LOOP;
end process;

process(clklock_falling_edge_count)
begin
   if (clklock_falling_edge_count >= lock_cyc + 1) then
       CLK_OUT_start <= '1' after clklock_half_period_minus_dly0;
   end if;
end process;

process
begin
   wait until  CLK_OUT_start = '1'; LOOP
      CLK_OUT_sig_3d <= not CLK_OUT_sig_3d;
     wait for clklock_half_period1;
      CLK_OUT_sig_3d <= not CLK_OUT_sig_3d ;
     wait for clklock_half_period0;
     END LOOP;
end process;


    CLK_OUT_sig_d <= CLK_OUT_sig_d_start and not CLK_OUT_sig_d_not; 

    CLK_OUT_plus_delay <= CLK_OUT_sig_d after tpd when tpd >= 0 ns else
                          CLK_OUT_sig_3d; 

    CLK_OUT <= CLK_OUT_plus_delay;

    PLL_LOCK <= PLL_LOCK_plus when tpd >= 0 ns else
                PLL_LOCK_minus;
               

end VITAL;

configuration CFG_STDPLL_VITAL of STDPLL is 
        for VITAL
        end for; 
end CFG_STDPLL_VITAL;


----- VITAL model for cell STDPLLX -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library lattice;
use lattice.components.all;

-- entity declaration --
entity STDPLLX is
   generic(
      IN_FREQ  : string  := "100.0";
      CLK_OUT_TO_PIN: STRING := "OFF";
      WAKE_ON_LOCK: STRING := "OFF";
      MULT     : string  := "1";
      DIV      : string  := "1";
      POST     : string  := "1";
      LOCK_CYC : integer := 2;
      SECDIV   : string   := "2";
      PLL_DLY  : string  := "0.0";
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_PLL_RST_PLL_LOCK :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_IN_CLK_OUT             :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_CLK_IN_PLL_LOCK             :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_CLK_IN_SEC_OUT             :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_CLK_IN             :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PLL_FBK   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PLL_RST   :	VitalDelayType01 := (0.000 ns, 0.000 ns));
   port(
      CLK_IN            : in    STD_ULOGIC;
      PLL_FBK           : in    STD_ULOGIC;
      PLL_RST           : in    STD_ULOGIC;
      CLK_OUT           : out   STD_ULOGIC;
      SEC_OUT           : out   STD_ULOGIC;
      PLL_LOCK          : out   STD_ULOGIC);
attribute VITAL_LEVEL0 of STDPLLX : entity is FALSE;
end STDPLLX;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library lattice;
use lattice.components.all;


architecture VITAL of STDPLLX is
  attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

  SIGNAL CLK_IN_ipd	 : STD_ULOGIC := 'X';
  SIGNAL PLL_RST_ipd	 : STD_ULOGIC := 'X';

  CONSTANT input_frequency : REAL := str2real(in_freq);

  SIGNAL clklock_half_period : TIME :=100 ns;
  SIGNAL clklock_half_period1 : TIME :=100 ns;
  SIGNAL clklock_half_period0 : TIME :=100 ns;
  SIGNAL clklock_half_period_minus_dly1 : TIME :=100 ns;
  SIGNAL clklock_half_period_minus_dly0 : TIME :=100 ns;
  SIGNAL secd_delay_minus1 : TIME :=100 ns;
  SIGNAL secd_delay_minus0 : TIME :=100 ns;
  SIGNAL start_inclk : STD_LOGIC ;
  SIGNAL clklock_rising_edge_count : INTEGER := 0 ;
  SIGNAL clklock_falling_edge_count : INTEGER := 0 ;
  SIGNAL clklock_last_rising_edge : TIME ;
  SIGNAL clklock_last_falling_edge : TIME ;

  SIGNAL clock_count : INTEGER := -1 ;
  SIGNAL clklock_lock : BOOLEAN := TRUE;
  SIGNAL CLK_OUT_sig_d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_not  : std_logic := '0';

  SIGNAL CLK_OUT_sig_3d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_start  : std_logic := '0';
  SIGNAL CLK_OUT_start  : std_logic := '0';
  SIGNAL CLK_OUT_plus_delay : std_logic := '0';
  SIGNAL SEC_OUT_sig_d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_not  : std_logic := '0';

  SIGNAL SEC_OUT_sig_3d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_start  : std_logic := '0';
  SIGNAL SEC_OUT_start  : std_logic := '0';
  SIGNAL SEC_OUT_plus_delay : std_logic := '0';
  SIGNAL CLK_OUT_sig1 : std_logic := '0';
  SIGNAL PLL_LOCK_plus : std_logic := '0';
  SIGNAL PLL_LOCK_minus : std_logic := '0';

  CONSTANT secdiv_p: integer := str2int(secdiv);
  CONSTANT clockboost: integer := str2int(mult) / str2int(div);
  CONSTANT tpd: time := 1.0 ns * str2real(pll_dly);

BEGIN
   WireDelay : block
   begin
   VitalWireDelay (CLK_IN_ipd, CLK_IN, tipd_CLK_IN);
   VitalWireDelay (PLL_RST_ipd, PLL_RST, tipd_PLL_RST);
   end block;

edge_count: PROCESS
     VARIABLE input_cycle : REAL;
     VARIABLE real_cycle : REAL;
BEGIN
      clklock_half_period <= (clklock_half_period0 + clklock_half_period1)/2;

  WAIT UNTIL (CLK_IN_ipd'EVENT AND CLK_IN_ipd='1');	   
     clklock_rising_edge_count <= clklock_rising_edge_count +1;
     IF clklock_rising_edge_count = 0 THEN
        clklock_last_rising_edge <= NOW;	
	start_inclk <= CLK_IN_ipd;
     ELSE
     IF clklock_rising_edge_count = 1 THEN
       clklock_half_period0 <= (NOW - clklock_last_falling_edge)* real(str2int(div))/real(str2int(mult));
	input_cycle := 1000.0 / input_frequency;
	real_cycle := REAL( (NOW - clklock_last_rising_edge) / 1 ns);
	IF ( real_cycle < 0.9 * input_cycle OR
	     real_cycle > 1.1 * input_cycle ) THEN
  	      	ASSERT TRUE 
  		REPORT " Input_Frequency Violation "
  		SEVERITY WARNING;
  		clklock_lock <= FALSE;
        END IF;
       clklock_half_period_minus_dly0 <= (NOW - clklock_last_falling_edge) + tpd;
        secd_delay_minus0 <= clklock_half_period0 * secdiv_p + tpd;
     END IF;
     END IF;
 
  WAIT UNTIL (CLK_IN_ipd'EVENT AND CLK_IN_ipd='0');
     clklock_falling_edge_count <= clklock_falling_edge_count +1;	  	
     IF clklock_falling_edge_count = 0 THEN	
	clklock_last_falling_edge <= NOW;
	clklock_half_period1 <= (NOW - clklock_last_rising_edge)* real(str2int(div))/real(str2int(mult)); 
     ELSIF clklock_falling_edge_count = 1 THEN
        clklock_half_period_minus_dly1 <= (NOW - clklock_last_rising_edge) + tpd;
        secd_delay_minus1 <= clklock_half_period1 * secdiv_p + tpd;
     END IF;
END PROCESS edge_count;

toggle: PROCESS
BEGIN

     WAIT ON clklock_rising_edge_count;
     IF clklock_rising_edge_count > lock_cyc + 1 and PLL_RST_ipd ='0' THEN
        if(clockboost >1) then
	   FOR i IN 1 TO (2*clockboost) LOOP 	       
		clock_count <= clock_count + 1;
		WAIT FOR clklock_half_period;
	   END LOOP;
        else  
		clock_count <= clock_count + 1;
		WAIT FOR (clklock_half_period);
        end if;
     ELSE
	clock_count <= 0;
     END IF;
END PROCESS toggle;


gen_pll_lock_plus:process
begin
     wait until (clock_count=1);
          PLL_LOCK_plus <= '1';
end process;

gen_pll_lock_minus:process
begin
     wait until (clock_count=3);
          PLL_LOCK_minus <= '1';
end process;

process
begin 
    wait until clock_count = 1;
    CLK_OUT_sig_d_start <='1';
    SEC_OUT_sig_d_start <='1';
end process;

process
begin
   wait until CLK_OUT_sig_d_start = '1'; LOOP
     wait for clklock_half_period1;
   CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not;
     wait for clklock_half_period0;
   CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not ;
   END LOOP;
end process;

process(clklock_falling_edge_count)
begin
   if (clklock_falling_edge_count >= lock_cyc + 1 and PLL_RST_ipd = '0') then
       CLK_OUT_start <= '1' after clklock_half_period_minus_dly0;
   end if;
end process;

process
begin
   wait until  CLK_OUT_start = '1'; LOOP
      CLK_OUT_sig_3d <= not CLK_OUT_sig_3d;
     wait for clklock_half_period1;
      CLK_OUT_sig_3d <= not CLK_OUT_sig_3d ;
     wait for clklock_half_period0;
     END LOOP;
end process;

process
begin
   wait until SEC_OUT_sig_d_start = '1'; LOOP
     wait for clklock_half_period1 * secdiv_p;
   SEC_OUT_sig_d_not <= not SEC_OUT_sig_d_not;
     wait for clklock_half_period0 * secdiv_p;
   SEC_OUT_sig_d_not <= not SEC_OUT_sig_d_not ;
   END LOOP;
end process;

process(clklock_falling_edge_count)
begin
   if(clklock_falling_edge_count >= lock_cyc + 1 and PLL_RST_ipd = '0') then
        SEC_OUT_start <= '1' after clklock_half_period_minus_dly0;
   end if;
end process;

process
begin
   wait until  SEC_OUT_start = '1'; LOOP
      SEC_OUT_sig_3d <= not SEC_OUT_sig_3d;
     wait for clklock_half_period1 * secdiv_p;
      SEC_OUT_sig_3d <= not SEC_OUT_sig_3d ;
     wait for clklock_half_period0 * secdiv_p;
     END LOOP;
end process;

    CLK_OUT_sig_d <= CLK_OUT_sig_d_start and not CLK_OUT_sig_d_not; 

    CLK_OUT_plus_delay <= CLK_OUT_sig_d after tpd when tpd >= 0 ns else
                          CLK_OUT_sig_3d; 

    CLK_OUT <= CLK_OUT_plus_delay and not PLL_RST_ipd;

    PLL_LOCK <= PLL_LOCK_plus and not PLL_RST_ipd when tpd >= 0 ns else
                PLL_LOCK_minus and  not PLL_RST_ipd;

    SEC_OUT_sig_d <=  SEC_OUT_sig_d_start and not SEC_OUT_sig_d_not; 

    SEC_OUT_plus_delay <= SEC_OUT_sig_d after tpd when tpd >= 0 ns else
                          SEC_OUT_sig_3d; 

    SEC_OUT <= SEC_OUT_plus_delay and not PLL_RST_ipd;

end VITAL;

configuration CFG_STDPLLX_VITAL of STDPLLX is 
        for VITAL
        end for; 
end CFG_STDPLLX_VITAL;


----- VITAL model for cell LVDSIN -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity LVDSIN is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_P_IN_O                      :	VitalDelayType01 := ( 0.00 ns, 0.00 ns);
      tpd_N_IN_O                      :	VitalDelayType01 := ( 0.00 ns, 0.00 ns);
      tipd_N_IN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_P_IN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      N_IN                            :	in    STD_ULOGIC;
      P_IN                            :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of LVDSIN : entity is FALSE;
end LVDSIN;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture LATTICE_ARCH of LVDSIN is
   attribute VITAL_LEVEL1 of LATTICE_ARCH : architecture is FALSE;

   SIGNAL P_IN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (P_IN_ipd, P_IN, tipd_P_IN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (P_IN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(P_IN_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (P_IN_ipd'last_event, tpd_P_IN_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end LATTICE_ARCH;

----- VITAL model for cell LVDSOUT -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

-- entity declaration --
entity LVDSOUT is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I_P_OUT                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I_N_OUT                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I                             :	in    STD_ULOGIC;
      P_OUT                             :	out   STD_ULOGIC;
      N_OUT                             :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of LVDSOUT : entity is FALSE;
end LVDSOUT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture LATTICE_ARCH of LVDSOUT is
   attribute VITAL_LEVEL1 of LATTICE_ARCH : architecture is FALSE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(I_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => P_OUT,
       GlitchData => O_GlitchData,
       OutSignalName => "P_OUT",
       OutTemp => O_zd,
       Paths => (0 => (I_ipd'last_event, tpd_I_P_OUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end LATTICE_ARCH;

----- VITAL model for cell LVDSTRI -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity LVDSTRI is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_OE_P_OUT                    :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE_N_OUT                    :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_I_P_OUT                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I_N_OUT                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_OE                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I                             :	in    STD_ULOGIC;
      OE                            :	in    STD_ULOGIC;
      P_OUT                          :	out   STD_ULOGIC;
      N_OUT                          :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of LVDSTRI : entity is FALSE;
end LVDSTRI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture LATTICE_ARCH of LVDSTRI is
   attribute VITAL_LEVEL1 of LATTICE_ARCH : architecture is FALSE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalBUFIF0 (data => I_ipd,
              enable => (NOT OE_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => P_OUT,
       GlitchData => O_GlitchData,
       OutSignalName => "P_OUT",
       OutTemp => O_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_P_OUT), TRUE),
                 1 => (I_ipd'last_event, VitalExtendToFillDelay(tpd_I_P_OUT), TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

end process;
end LATTICE_ARCH;

----- VITAL model for cell LVDSIO -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

-- entity declaration --
entity LVDSIO is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_OE_P_IO                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE_N_IO                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_I_P_IO                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I_N_IO                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_P_IO_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_N_IO_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_OE                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_P_IO                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_N_IO                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I                             :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      P_IO                             :	inout STD_ULOGIC;
      N_IO                             :	inout STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of LVDSIO : entity is FALSE;
end LVDSIO;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture LATTICE_ARCH of LVDSIO is
   attribute VITAL_LEVEL1 of LATTICE_ARCH : architecture is FALSE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL P_IO_ipd	 : STD_ULOGIC := 'X';
   SIGNAL N_IO_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   VitalWireDelay (P_IO_ipd, P_IO, tipd_P_IO);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd, OE_ipd, P_IO_ipd)


   -- functionality results
--   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
     VARIABLE IO_zd : std_ulogic ;
     VARIABLE O_zd : std_ulogic ;

   -- output glitch detection variables
   VARIABLE IO_GlitchData	: VitalGlitchDataType;
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      IO_zd := VitalBUFIF1 (I_ipd, OE_ipd);
      O_zd := VitalBUF(P_IO_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => P_IO,
       GlitchData => IO_GlitchData,
       OutSignalName => "P_IO",
       OutTemp => IO_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_P_IO), TRUE),
                 1 => (I_ipd'last_event, VitalExtendToFillDelay(tpd_I_P_IO), TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (P_IO_ipd'last_event, tpd_P_IO_O, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end LATTICE_ARCH;

----- VITAL model for cell BLVDSIN -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BLVDSIN is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_P_IN_O                      :	VitalDelayType01 := ( 0.00 ns, 0.00 ns);
      tpd_N_IN_O                      :	VitalDelayType01 := ( 0.00 ns, 0.00 ns);
      tipd_N_IN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_P_IN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      N_IN                            :	in    STD_ULOGIC;
      P_IN                            :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BLVDSIN : entity is FALSE;
end BLVDSIN;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture LATTICE_ARCH of BLVDSIN is
   attribute VITAL_LEVEL1 of LATTICE_ARCH : architecture is FALSE;

   SIGNAL P_IN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (P_IN_ipd, P_IN, tipd_P_IN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (P_IN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(P_IN_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (P_IN_ipd'last_event, tpd_P_IN_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end LATTICE_ARCH;

----- VITAL model for cell BLVDSOUT -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

-- entity declaration --
entity BLVDSOUT is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I_P_OUT                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I_N_OUT                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I                             :	in    STD_ULOGIC;
      P_OUT                             :	out   STD_ULOGIC;
      N_OUT                             :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BLVDSOUT : entity is FALSE;
end BLVDSOUT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture LATTICE_ARCH of BLVDSOUT is
   attribute VITAL_LEVEL1 of LATTICE_ARCH : architecture is FALSE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(I_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => P_OUT,
       GlitchData => O_GlitchData,
       OutSignalName => "P_OUT",
       OutTemp => O_zd,
       Paths => (0 => (I_ipd'last_event, tpd_I_P_OUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end LATTICE_ARCH;

----- VITAL model for cell BLVDSTRI -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BLVDSTRI is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_OE_P_OUT                    :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE_N_OUT                    :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_I_P_OUT                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I_N_OUT                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_OE                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I                             :	in    STD_ULOGIC;
      OE                            :	in    STD_ULOGIC;
      P_OUT                          :	out   STD_ULOGIC;
      N_OUT                          :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BLVDSTRI : entity is FALSE;
end BLVDSTRI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture LATTICE_ARCH of BLVDSTRI is
   attribute VITAL_LEVEL1 of LATTICE_ARCH : architecture is FALSE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalBUFIF0 (data => I_ipd,
              enable => (NOT OE_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => P_OUT,
       GlitchData => O_GlitchData,
       OutSignalName => "P_OUT",
       OutTemp => O_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_P_OUT), TRUE),
                 1 => (I_ipd'last_event, VitalExtendToFillDelay(tpd_I_P_OUT), TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

end process;
end LATTICE_ARCH;

----- VITAL model for cell BLVDSIO -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

-- entity declaration --
entity BLVDSIO is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_OE_P_IO                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE_N_IO                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_I_P_IO                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I_N_IO                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_P_IO_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_N_IO_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_OE                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_P_IO                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_N_IO                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I                             :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      P_IO                             :	inout STD_ULOGIC;
      N_IO                             :	inout STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BLVDSIO : entity is FALSE;
end BLVDSIO;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture LATTICE_ARCH of BLVDSIO is
   attribute VITAL_LEVEL1 of LATTICE_ARCH : architecture is FALSE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL P_IO_ipd	 : STD_ULOGIC := 'X';
   SIGNAL N_IO_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   VitalWireDelay (P_IO_ipd, P_IO, tipd_P_IO);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd, OE_ipd, P_IO_ipd)


   -- functionality results
--   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
     VARIABLE IO_zd : std_ulogic ;
     VARIABLE O_zd : std_ulogic ;

   -- output glitch detection variables
   VARIABLE IO_GlitchData	: VitalGlitchDataType;
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      IO_zd := VitalBUFIF1 (I_ipd, OE_ipd);
      O_zd := VitalBUF(P_IO_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => P_IO,
       GlitchData => IO_GlitchData,
       OutSignalName => "P_IO",
       OutTemp => IO_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_P_IO), TRUE),
                 1 => (I_ipd'last_event, VitalExtendToFillDelay(tpd_I_P_IO), TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (P_IO_ipd'last_event, tpd_P_IO_O, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end LATTICE_ARCH;

----- VITAL model for cell LVPECLIN -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity LVPECLIN is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_P_IN_O                      :	VitalDelayType01 := ( 0.00 ns, 0.00 ns);
      tpd_N_IN_O                      :	VitalDelayType01 := ( 0.00 ns, 0.00 ns);
      tipd_N_IN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_P_IN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      N_IN                            :	in    STD_ULOGIC;
      P_IN                            :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of LVPECLIN : entity is FALSE;
end LVPECLIN;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture VITAL of LVPECLIN is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL P_IN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (P_IN_ipd, P_IN, tipd_P_IN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (P_IN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(P_IN_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (P_IN_ipd'last_event, tpd_P_IN_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

----- VITAL model for cell LVPECLOUT -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

-- entity declaration --
entity LVPECLOUT is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I_P_OUT                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I_N_OUT                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I                             :	in    STD_ULOGIC;
      P_OUT                             :	out   STD_ULOGIC;
      N_OUT                             :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of LVPECLOUT : entity is FALSE;
end LVPECLOUT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture VITAL of LVPECLOUT is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(I_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => P_OUT,
       GlitchData => O_GlitchData,
       OutSignalName => "P_OUT",
       OutTemp => O_zd,
       Paths => (0 => (I_ipd'last_event, tpd_I_P_OUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

----- VITAL model for cell LVPECLTRI -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity LVPECLTRI is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_OE_P_OUT                    :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_I_P_OUT                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I_N_OUT                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_OE                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I                             :	in    STD_ULOGIC;
      OE                            :	in    STD_ULOGIC;
      P_OUT                          :	out   STD_ULOGIC;
      N_OUT                          :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of LVPECLTRI : entity is FALSE;
end LVPECLTRI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture VITAL of LVPECLTRI is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalBUFIF0 (data => I_ipd,
              enable => (NOT OE_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => P_OUT,
       GlitchData => O_GlitchData,
       OutSignalName => "P_OUT",
       OutTemp => O_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_P_OUT), TRUE),
                 1 => (I_ipd'last_event, VitalExtendToFillDelay(tpd_I_P_OUT), TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

end process;
end VITAL;

LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;

entity AND10 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 Z0 : OUT std_logic);

end AND10;

architecture LATTICE_ARCH of AND10 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7, A8, A9)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 AND (A1 AND (A2 AND (A3 AND (A4 AND (A5 AND (A6 AND (A7 AND (A8 AND (A9))))))))));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity AND11 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 Z0 : OUT std_logic);

end AND11;

architecture LATTICE_ARCH of AND11 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 AND (A1 AND (A2 AND (A3 AND (A4 AND (A5 AND (A6 AND (A7 AND (A8 AND (A9 AND (A10)))))))))));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity AND12 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 Z0 : OUT std_logic);

end AND12;

architecture LATTICE_ARCH of AND12 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 AND (A1 AND (A2 AND (A3 AND (A4 AND (A5 AND (A6 AND (A7 AND (A8 AND (A9 AND (A10 AND (A11))))))))))));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity AND13 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 A12 : IN std_logic;
		 Z0 : OUT std_logic);

end AND13;

architecture LATTICE_ARCH of AND13 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 AND (A1 AND (A2 AND (A3 AND (A4 AND (A5 AND (A6 AND (A7 AND (A8 AND (A9 AND (A10 AND (A11 AND (A12)))))))))))));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity AND14 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 A12 : IN std_logic;
		 A13 : IN std_logic;
		 Z0 : OUT std_logic);

end AND14;

architecture LATTICE_ARCH of AND14 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 AND (A1 AND (A2 AND (A3 AND (A4 AND (A5 AND (A6 AND (A7 AND (A8 AND (A9 AND (A10 AND (A11 AND (A12 AND (A13))))))))))))));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity AND15 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 A12 : IN std_logic;
		 A13 : IN std_logic;
		 A14 : IN std_logic;
		 Z0 : OUT std_logic);

end AND15;

architecture LATTICE_ARCH of AND15 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 AND (A1 AND (A2 AND (A3 AND (A4 AND (A5 AND (A6 AND (A7 AND (A8 AND (A9 AND (A10 AND (A11 AND (A12 AND (A13 AND (A14)))))))))))))));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity AND16 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 A12 : IN std_logic;
		 A13 : IN std_logic;
		 A14 : IN std_logic;
		 A15 : IN std_logic;
		 Z0 : OUT std_logic);

end AND16;

architecture LATTICE_ARCH of AND16 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 AND (A1 AND (A2 AND (A3 AND (A4 AND (A5 AND (A6 AND (A7 AND (A8 AND (A9 AND (A10 AND (A11 AND (A12 AND (A13 AND (A14 AND (A15))))))))))))))));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity AND17 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 A12 : IN std_logic;
		 A13 : IN std_logic;
		 A14 : IN std_logic;
		 A15 : IN std_logic;
		 A16 : IN std_logic;
		 Z0 : OUT std_logic);

end AND17;

architecture LATTICE_ARCH of AND17 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 AND (A1 AND (A2 AND (A3 AND (A4 AND (A5 AND (A6 AND (A7 AND (A8 AND (A9 AND (A10 AND (A11 AND (A12 AND (A13 AND (A14 AND (A15 AND (A16)))))))))))))))));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity AND18 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 A12 : IN std_logic;
		 A13 : IN std_logic;
		 A14 : IN std_logic;
		 A15 : IN std_logic;
		 A16 : IN std_logic;
		 A17 : IN std_logic;
		 Z0 : OUT std_logic);

end AND18;

architecture LATTICE_ARCH of AND18 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := A0 AND A1 AND A2 AND A3 AND A4 AND A5 AND A6 AND A7 AND A8 AND A9 AND A10 AND A11 AND A12 AND A13 AND A14 AND A15 AND A16 AND A17;
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity AND2 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 Z0 : OUT std_logic);

end AND2;

architecture LATTICE_ARCH of AND2 is
begin
		process(A0, A1)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 AND (A1));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity AND3 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 Z0 : OUT std_logic);

end AND3;

architecture LATTICE_ARCH of AND3 is
begin
		process(A0, A1, A2)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 AND (A1 AND (A2)));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity AND4 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 Z0 : OUT std_logic);

end AND4;

architecture LATTICE_ARCH of AND4 is
begin
		process(A0, A1, A2, A3)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 AND (A1 AND (A2 AND (A3))));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity AND5 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 Z0 : OUT std_logic);

end AND5;

architecture LATTICE_ARCH of AND5 is
begin
		process(A0, A1, A2, A3, A4)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 AND (A1 AND (A2 AND (A3 AND (A4)))));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity AND6 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 Z0 : OUT std_logic);

end AND6;

architecture LATTICE_ARCH of AND6 is
begin
		process(A0, A1, A2, A3, A4, A5)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 AND (A1 AND (A2 AND (A3 AND (A4 AND (A5))))));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity AND7 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 Z0 : OUT std_logic);

end AND7;

architecture LATTICE_ARCH of AND7 is
begin
		process(A0, A1, A2, A3, A4, A5, A6)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 AND (A1 AND (A2 AND (A3 AND (A4 AND (A5 AND (A6)))))));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity AND8 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 Z0 : OUT std_logic);

end AND8;

architecture LATTICE_ARCH of AND8 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 AND (A1 AND (A2 AND (A3 AND (A4 AND (A5 AND (A6 AND (A7))))))));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity AND9 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 Z0 : OUT std_logic);

end AND9;

architecture LATTICE_ARCH of AND9 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7, A8)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 AND (A1 AND (A2 AND (A3 AND (A4 AND (A5 AND (A6 AND (A7 AND (A8)))))))));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
-------------------------------------------------
--		PRIMITVE BUF UNIT DELAY MODEL		-----
-------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;


entity BUF is

	generic( TDELAY : TIME := 1 ns);

	port (A0 : IN STD_LOGIC;
		  Z0 : OUT STD_LOGIC);
end BUF;


architecture LATTICE_ARCH of BUF is 

begin

	process(A0)

	begin 
			Z0 <= transport A0 after TDELAY;
	end process;

end LATTICE_ARCH;
-------------------------------------------------
--		PRIMITVE FD11 UNIT DELAY MODEL	-----
-------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

entity FD11 is
	generic ( TDELAY : TIME := 1 ns);

 	port( D0, CLK : IN std_logic;
			Q0 : OUT std_logic);

end FD11;

architecture LATTICE_ARCH of FD11 is

begin

	process(D0, CLK)
	variable pQ0 : std_logic;
	variable iQ0 : std_logic;

	begin 

		if CLK'EVENT AND CLK = '1' then
			pQ0 := iQ0;
			if (D0'EVENT) then
				iQ0 := D0'LAST_VALUE;
			elsif NOT(D0'EVENT) then
				iQ0 := D0;
			end if;

			if pQ0 /= iQ0 then
				Q0 <= transport iQ0 after TDELAY;
			else
				Q0 <= transport iQ0;
			end if;

		end if;

	end process;

end LATTICE_ARCH; --// FD11
-------------------------------------------------
--		PRIMITVE FD21 UNIT DELAY MODEL	-----
-------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
entity FD21 is
	generic ( TDELAY : TIME := 1 ns);

 	port( D0, CLK, CD : IN std_logic;
			Q0 : OUT std_logic);


end FD21;


architecture LATTICE_ARCH of FD21 is

begin

	process(D0, CLK, CD)
	variable pQ0 : std_logic;
	variable iQ0 : std_logic;

	begin 

		if CD = '1' then
			if NOT (iQ0 = '0') then
				iQ0 := '0';
				Q0 <= transport iQ0 after TDELAY;
			end if;

		elsif CD = '0' AND CLK'EVENT AND CLK = '1' then
			pQ0 := iQ0;
			if (D0'EVENT) then
				iQ0 := D0'LAST_VALUE;
			elsif NOT(D0'EVENT) then
				iQ0 := D0;
			end if;

			if pQ0 /= iQ0 then
				Q0 <= transport iQ0 after TDELAY;
			else
				Q0 <= transport iQ0;
			end if;

		end if;

	end process;

end LATTICE_ARCH; -- FD21
-------------------------------------------------
--		PRIMITVE INV UNIT DELAY MODEL		-----
-------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;


entity INV is

	generic( TDELAY : TIME := 1 ns);

	port (A0 : IN STD_LOGIC;
		  ZN0 : OUT STD_LOGIC);
end INV;


architecture LATTICE_ARCH of INV is 

begin

	process(A0)

	begin 
			ZN0 <= transport  NOT A0 after TDELAY;
	end process;

end LATTICE_ARCH;
-------------------------------------------------
--		PRIMITVE LXOR2 UNIT DELAY MODEL		-----
-------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;


entity LXOR2 is

	generic( TDELAY : TIME := 1 ns);

	port (A0 : IN STD_LOGIC;
		  A1 : IN STD_LOGIC;
		  Z0 : OUt STD_LOGIC);
end LXOR2;


architecture LATTICE_ARCH of LXOR2 is 

begin

	process(A0, A1)
	variable pZ0 : STD_LOGIC;
	variable iZ0 : STD_LOGIC;

	begin 
		pZ0 := iZ0;
		iZ0 := (A0 XOR A1);
		if pZ0 /= iZ0 then
			Z0 <= transport iZ0 after TDELAY;
		else 
			Z0 <= transport iZ0;
		end if;

	end process;

end LATTICE_ARCH; --// LXOR2
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity NAND10 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 ZN0 : OUT std_logic);

end NAND10;

architecture LATTICE_ARCH of NAND10 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7, A8, A9)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := NOT (A0 AND (A1 AND (A2 AND (A3 AND (A4 AND (A5 AND (A6 AND (A7 AND (A8 AND (A9))))))))));
			if pZ0 /= iZ0 then
				ZN0 <= transport iZ0 after TDELAY;
			else
				ZN0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity NAND11 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 ZN0 : OUT std_logic);

end NAND11;

architecture LATTICE_ARCH of NAND11 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := NOT (A0 AND (A1 AND (A2 AND (A3 AND (A4 AND (A5 AND (A6 AND (A7 AND (A8 AND (A9 AND (A10)))))))))));
			if pZ0 /= iZ0 then
				ZN0 <= transport iZ0 after TDELAY;
			else
				ZN0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity NAND12 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 ZN0 : OUT std_logic);

end NAND12;

architecture LATTICE_ARCH of NAND12 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := NOT (A0 AND (A1 AND (A2 AND (A3 AND (A4 AND (A5 AND (A6 AND (A7 AND (A8 AND (A9 AND (A10 AND (A11))))))))))));
			if pZ0 /= iZ0 then
				ZN0 <= transport iZ0 after TDELAY;
			else
				ZN0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity NAND16 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 A12 : IN std_logic;
		 A13 : IN std_logic;
		 A14 : IN std_logic;
		 A15 : IN std_logic;
		 ZN0 : OUT std_logic);

end NAND16;

architecture LATTICE_ARCH of NAND16 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := NOT (A0 AND (A1 AND (A2 AND (A3 AND (A4 AND (A5 AND (A6 AND (A7 AND (A8 AND (A9 AND (A10 AND (A11 AND (A12 AND (A13 AND (A14 AND (A15))))))))))))))));
			if pZ0 /= iZ0 then
				ZN0 <= transport iZ0 after TDELAY;
			else
				ZN0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity NAND2 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 ZN0 : OUT std_logic);

end NAND2;

architecture LATTICE_ARCH of NAND2 is
begin
		process(A0, A1)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := NOT (A0 AND (A1));
			if pZ0 /= iZ0 then
				ZN0 <= transport iZ0 after TDELAY;
			else
				ZN0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity NAND3 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 ZN0 : OUT std_logic);

end NAND3;

architecture LATTICE_ARCH of NAND3 is
begin
		process(A0, A1, A2)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := NOT (A0 AND (A1 AND (A2)));
			if pZ0 /= iZ0 then
				ZN0 <= transport iZ0 after TDELAY;
			else
				ZN0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity NAND4 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 ZN0 : OUT std_logic);

end NAND4;

architecture LATTICE_ARCH of NAND4 is
begin
		process(A0, A1, A2, A3)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := NOT (A0 AND (A1 AND (A2 AND (A3))));
			if pZ0 /= iZ0 then
				ZN0 <= transport iZ0 after TDELAY;
			else
				ZN0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity NAND5 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 ZN0 : OUT std_logic);

end NAND5;

architecture LATTICE_ARCH of NAND5 is
begin
		process(A0, A1, A2, A3, A4)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := NOT (A0 AND (A1 AND (A2 AND (A3 AND (A4)))));
			if pZ0 /= iZ0 then
				ZN0 <= transport iZ0 after TDELAY;
			else
				ZN0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity NAND6 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 ZN0 : OUT std_logic);

end NAND6;

architecture LATTICE_ARCH of NAND6 is
begin
		process(A0, A1, A2, A3, A4, A5)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := NOT (A0 AND (A1 AND (A2 AND (A3 AND (A4 AND (A5))))));
			if pZ0 /= iZ0 then
				ZN0 <= transport iZ0 after TDELAY;
			else
				ZN0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity NAND7 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 ZN0 : OUT std_logic);

end NAND7;

architecture LATTICE_ARCH of NAND7 is
begin
		process(A0, A1, A2, A3, A4, A5, A6)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := NOT (A0 AND (A1 AND (A2 AND (A3 AND (A4 AND (A5 AND (A6)))))));
			if pZ0 /= iZ0 then
				ZN0 <= transport iZ0 after TDELAY;
			else
				ZN0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity NAND8 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 ZN0 : OUT std_logic);

end NAND8;

architecture LATTICE_ARCH of NAND8 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := NOT (A0 AND (A1 AND (A2 AND (A3 AND (A4 AND (A5 AND (A6 AND (A7))))))));
			if pZ0 /= iZ0 then
				ZN0 <= transport iZ0 after TDELAY;
			else
				ZN0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity NAND9 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 ZN0 : OUT std_logic);

end NAND9;

architecture LATTICE_ARCH of NAND9 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7, A8)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := NOT (A0 AND (A1 AND (A2 AND (A3 AND (A4 AND (A5 AND (A6 AND (A7 AND (A8)))))))));
			if pZ0 /= iZ0 then
				ZN0 <= transport iZ0 after TDELAY;
			else
				ZN0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity NOR10 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 ZN0 : OUT std_logic);

end NOR10;

architecture LATTICE_ARCH of NOR10 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7, A8, A9)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := NOT (A0 OR (A1 OR (A2 OR (A3 OR (A4 OR (A5 OR (A6 OR (A7 OR (A8 OR (A9))))))))));
			if pZ0 /= iZ0 then
				ZN0 <= transport iZ0 after TDELAY;
			else
				ZN0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity NOR11 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 ZN0 : OUT std_logic);

end NOR11;

architecture LATTICE_ARCH of NOR11 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := NOT (A0 OR (A1 OR (A2 OR (A3 OR (A4 OR (A5 OR (A6 OR (A7 OR (A8 OR (A9 OR (A10)))))))))));
			if pZ0 /= iZ0 then
				ZN0 <= transport iZ0 after TDELAY;
			else
				ZN0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity NOR12 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 ZN0 : OUT std_logic);

end NOR12;

architecture LATTICE_ARCH of NOR12 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := NOT (A0 OR (A1 OR (A2 OR (A3 OR (A4 OR (A5 OR (A6 OR (A7 OR (A8 OR (A9 OR (A10 OR (A11))))))))))));
			if pZ0 /= iZ0 then
				ZN0 <= transport iZ0 after TDELAY;
			else
				ZN0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity NOR16 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 A12 : IN std_logic;
		 A13 : IN std_logic;
		 A14 : IN std_logic;
		 A15 : IN std_logic;
		 ZN0 : OUT std_logic);

end NOR16;

architecture LATTICE_ARCH of NOR16 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := NOT (A0 OR (A1 OR (A2 OR (A3 OR (A4 OR (A5 OR (A6 OR (A7 OR (A8 OR (A9 OR (A10 OR (A11 OR (A12 OR (A13 OR (A14 OR (A15))))))))))))))));
			if pZ0 /= iZ0 then
				ZN0 <= transport iZ0 after TDELAY;
			else
				ZN0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity NOR2 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 ZN0 : OUT std_logic);

end NOR2;

architecture LATTICE_ARCH of NOR2 is
begin
		process(A0, A1)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := NOT (A0 OR (A1));
			if pZ0 /= iZ0 then
				ZN0 <= transport iZ0 after TDELAY;
			else
				ZN0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity NOR3 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 ZN0 : OUT std_logic);

end NOR3;

architecture LATTICE_ARCH of NOR3 is
begin
		process(A0, A1, A2)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := NOT (A0 OR (A1 OR (A2)));
			if pZ0 /= iZ0 then
				ZN0 <= transport iZ0 after TDELAY;
			else
				ZN0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity NOR4 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 ZN0 : OUT std_logic);

end NOR4;

architecture LATTICE_ARCH of NOR4 is
begin
		process(A0, A1, A2, A3)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := NOT (A0 OR (A1 OR (A2 OR (A3))));
			if pZ0 /= iZ0 then
				ZN0 <= transport iZ0 after TDELAY;
			else
				ZN0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity NOR5 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 ZN0 : OUT std_logic);

end NOR5;

architecture LATTICE_ARCH of NOR5 is
begin
		process(A0, A1, A2, A3, A4)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := NOT (A0 OR (A1 OR (A2 OR (A3 OR (A4)))));
			if pZ0 /= iZ0 then
				ZN0 <= transport iZ0 after TDELAY;
			else
				ZN0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity NOR6 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 ZN0 : OUT std_logic);

end NOR6;

architecture LATTICE_ARCH of NOR6 is
begin
		process(A0, A1, A2, A3, A4, A5)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := NOT (A0 OR (A1 OR (A2 OR (A3 OR (A4 OR (A5))))));
			if pZ0 /= iZ0 then
				ZN0 <= transport iZ0 after TDELAY;
			else
				ZN0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity NOR7 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 ZN0 : OUT std_logic);

end NOR7;

architecture LATTICE_ARCH of NOR7 is
begin
		process(A0, A1, A2, A3, A4, A5, A6)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := NOT (A0 OR (A1 OR (A2 OR (A3 OR (A4 OR (A5 OR (A6)))))));
			if pZ0 /= iZ0 then
				ZN0 <= transport iZ0 after TDELAY;
			else
				ZN0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity NOR8 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 ZN0 : OUT std_logic);

end NOR8;

architecture LATTICE_ARCH of NOR8 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := NOT (A0 OR (A1 OR (A2 OR (A3 OR (A4 OR (A5 OR (A6 OR (A7))))))));
			if pZ0 /= iZ0 then
				ZN0 <= transport iZ0 after TDELAY;
			else
				ZN0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity NOR9 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 ZN0 : OUT std_logic);

end NOR9;

architecture LATTICE_ARCH of NOR9 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7, A8)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := NOT (A0 OR (A1 OR (A2 OR (A3 OR (A4 OR (A5 OR (A6 OR (A7 OR (A8)))))))));
			if pZ0 /= iZ0 then
				ZN0 <= transport iZ0 after TDELAY;
			else
				ZN0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity OR10 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 Z0 : OUT std_logic);

end OR10;

architecture LATTICE_ARCH of OR10 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7, A8, A9)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 OR (A1 OR (A2 OR (A3 OR (A4 OR (A5 OR (A6 OR (A7 OR (A8 OR (A9))))))))));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity OR11 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 Z0 : OUT std_logic);

end OR11;

architecture LATTICE_ARCH of OR11 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 OR (A1 OR (A2 OR (A3 OR (A4 OR (A5 OR (A6 OR (A7 OR (A8 OR (A9 OR (A10)))))))))));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity OR12 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 Z0 : OUT std_logic);

end OR12;

architecture LATTICE_ARCH of OR12 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 OR (A1 OR (A2 OR (A3 OR (A4 OR (A5 OR (A6 OR (A7 OR (A8 OR (A9 OR (A10 OR (A11))))))))))));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity OR16 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 A9 : IN std_logic;
		 A10 : IN std_logic;
		 A11 : IN std_logic;
		 A12 : IN std_logic;
		 A13 : IN std_logic;
		 A14 : IN std_logic;
		 A15 : IN std_logic;
		 Z0 : OUT std_logic);

end OR16;

architecture LATTICE_ARCH of OR16 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 OR (A1 OR (A2 OR (A3 OR (A4 OR (A5 OR (A6 OR (A7 OR (A8 OR (A9 OR (A10 OR (A11 OR (A12 OR (A13 OR (A14 OR (A15))))))))))))))));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity OR2 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 Z0 : OUT std_logic);

end OR2;

architecture LATTICE_ARCH of OR2 is
begin
		process(A0, A1)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 OR (A1));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity OR3 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 Z0 : OUT std_logic);

end OR3;

architecture LATTICE_ARCH of OR3 is
begin
		process(A0, A1, A2)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 OR (A1 OR (A2)));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity OR4 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 Z0 : OUT std_logic);

end OR4;

architecture LATTICE_ARCH of OR4 is
begin
		process(A0, A1, A2, A3)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 OR (A1 OR (A2 OR (A3))));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity OR5 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 Z0 : OUT std_logic);

end OR5;

architecture LATTICE_ARCH of OR5 is
begin
		process(A0, A1, A2, A3, A4)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 OR (A1 OR (A2 OR (A3 OR (A4)))));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity OR6 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 Z0 : OUT std_logic);

end OR6;

architecture LATTICE_ARCH of OR6 is
begin
		process(A0, A1, A2, A3, A4, A5)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 OR (A1 OR (A2 OR (A3 OR (A4 OR (A5))))));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity OR7 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 Z0 : OUT std_logic);

end OR7;

architecture LATTICE_ARCH of OR7 is
begin
		process(A0, A1, A2, A3, A4, A5, A6)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 OR (A1 OR (A2 OR (A3 OR (A4 OR (A5 OR (A6)))))));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity OR8 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 Z0 : OUT std_logic);

end OR8;

architecture LATTICE_ARCH of OR8 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 OR (A1 OR (A2 OR (A3 OR (A4 OR (A5 OR (A6 OR (A7))))))));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity OR9 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 Z0 : OUT std_logic);

end OR9;

architecture LATTICE_ARCH of OR9 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7, A8)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 OR (A1 OR (A2 OR (A3 OR (A4 OR (A5 OR (A6 OR (A7 OR (A8)))))))));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.std_logic_1164.all;


entity PW is

	port( PULSE : IN std_logic);

end PW;

architecture LATTICE_ARCH of PW is

begin

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.std_logic_1164.all;


entity SHFE is

	port( REF : IN std_logic;
		DATA : IN std_logic);

end SHFE;

architecture LATTICE_ARCH of SHFE is

begin

end LATTICE_ARCH; -- SHFE

-------------------------------------------------
--		PRIMITVE XBIDI UNIT DELAY MODEL	-----
-------------------------------------------------
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity XBIDI1 is
	
	generic ( TDELAY : TIME := 1 ns);
	port ( A0 : IN std_logic;
		   OE : IN std_logic;
		   Z0 : OUT std_logic;
		   XB0 : INOUT std_logic);

end XBIDI1;

architecture LATTICE_ARCH of XBIDI1 is

begin

	process(A0, OE, XB0)
	variable pZ0 : std_logic;
	variable iZ0 : std_logic;

	begin

	pZ0 := iZ0;
	if OE = '1' then
		iZ0 := A0;
		if pZ0 /= iZ0 then
			XB0 <= transport iZ0 after TDELAY;
			Z0 <= transport iZ0 after TDELAY;
		else 
			XB0 <= transport iZ0 ;
			Z0 <= transport iZ0 ;
		end if;
	elsif OE = '0' then
		iZ0 := 'Z';
		if pZ0 /= iZ0 then
			XB0 <= transport iZ0 after TDELAY;
			Z0 <= transport XB0 after TDELAY;
		else 
			XB0 <= transport iZ0 ;
			Z0 <= transport XB0 ;
		end if;
	end if;

	end process;

end LATTICE_ARCH;

-------------------------------------------------
--		PRIMITVE XDFF1 UNIT DELAY MODEL	-----
-------------------------------------------------
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;

entity XDFF1 is
	generic ( TDELAY : TIME := 1 ns);

 	port( D0, CLK : IN std_logic;
			Q0 : OUT std_logic);
end XDFF1;

architecture LATTICE_ARCH of XDFF1 is

begin

	process(D0, CLK)
	variable pQ0 : std_logic;
	variable iQ0 : std_logic;

	begin 

		if CLK'EVENT AND CLK = '1' then
			pQ0 := iQ0;
			if (D0'EVENT) then
				iQ0 := D0'LAST_VALUE;
			elsif NOT(D0'EVENT) then
				iQ0 := D0;
			end if;

			if pQ0 /= iQ0 then
				Q0 <= transport iQ0 after TDELAY;
			else
				Q0 <= transport iQ0;
			end if;

		end if;


	end process;

end LATTICE_ARCH;-- XDFF1
-------------------------------------------------
--		PRIMITVE XDL1 UNIT DELAY MODEL	-----
-------------------------------------------------
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity XDL1 is
	
		generic ( TDELAY : TIME := 1 ns);
		port ( D0 : IN std_logic;
				G : IN std_logic;
			   Q0 : OUT std_logic);
end XDL1;

architecture LATTICE_ARCH of XDL1 is

begin

	process(D0, G)

	variable pQ0 : std_logic;
	variable iQ0 : std_logic;
				
	begin

	pQ0 := iQ0;

	if G = '1' then

		iQ0 := D0;
		if pQ0 /= iQ0 then
			Q0 <= transport iQ0 after TDELAY;
		else 
			Q0 <= transport iQ0;
		end if;

	end if;
		
	end process;

end LATTICE_ARCH;
-------------------------------------------------
--		PRIMITVE XINPUT UNIT DELAY MODEL	-----
-------------------------------------------------
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;

entity XINPUT is

	generic( TDELAY : TIME := 1 ns);

	port( XI0 : IN  STD_LOGIC;
		  Z0  : OUT STD_LOGIC);

end XINPUT;


architecture LATTICE_ARCH of XINPUT is

begin

	process(XI0)

	begin 
			Z0 <= transport XI0 after TDELAY;
	end process;

--	component BUF
--		port( A0 : IN std_logic;
--			  Z0 : OUT std_logic);
--end component;

--begin
--	UQXIN : BUF
--		port map (Z0 => Z0, A0 => XI0);

end LATTICE_ARCH; -- XINPUT
-------------------------------------------------
--		PRIMITVE XINV UNIT DELAY MODEL		-----
-------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;


entity XINV is

	generic( TDELAY : TIME := 1 ns);

	port (A0 : IN STD_LOGIC;
		  ZN0 : OUT STD_LOGIC);
end XINV;


architecture LATTICE_ARCH of XINV is 

begin

	process(A0)

	begin 
			ZN0 <= transport  NOT A0 after TDELAY;
	end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity XNOR2 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 ZN0 : OUT std_logic);

end XNOR2;

architecture LATTICE_ARCH of XNOR2 is
begin
		process(A0, A1)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := NOT( A0 XOR (A1));
			if pZ0 /= iZ0 then
				ZN0 <= transport iZ0 after TDELAY;
			else
				ZN0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity XNOR3 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 ZN0 : OUT std_logic);

end XNOR3;

architecture LATTICE_ARCH of XNOR3 is
begin
		process(A0, A1, A2)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := NOT( A0 XOR (A1 XOR (A2)));
			if pZ0 /= iZ0 then
				ZN0 <= transport iZ0 after TDELAY;
			else
				ZN0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity XNOR4 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 ZN0 : OUT std_logic);

end XNOR4;

architecture LATTICE_ARCH of XNOR4 is
begin
		process(A0, A1, A2, A3)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := NOT( A0 XOR (A1 XOR (A2 XOR (A3))));
			if pZ0 /= iZ0 then
				ZN0 <= transport iZ0 after TDELAY;
			else
				ZN0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity XNOR7 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 ZN0 : OUT std_logic);

end XNOR7;

architecture LATTICE_ARCH of XNOR7 is
begin
		process(A0, A1, A2, A3, A4, A5, A6)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := NOT( A0 XOR (A1 XOR (A2 XOR (A3 XOR (A4 XOR (A5 XOR (A6)))))));
			if pZ0 /= iZ0 then
				ZN0 <= transport iZ0 after TDELAY;
			else
				ZN0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity XNOR8 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 ZN0 : OUT std_logic);

end XNOR8;

architecture LATTICE_ARCH of XNOR8 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := NOT( A0 XOR (A1 XOR (A2 XOR (A3 XOR (A4 XOR (A5 XOR (A6 XOR (A7))))))));
			if pZ0 /= iZ0 then
				ZN0 <= transport iZ0 after TDELAY;
			else
				ZN0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity XNOR9 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 ZN0 : OUT std_logic);

end XNOR9;

architecture LATTICE_ARCH of XNOR9 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7, A8)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := NOT( A0 XOR (A1 XOR (A2 XOR (A3 XOR (A4 XOR (A5 XOR (A6 XOR (A7 XOR (A8)))))))));
			if pZ0 /= iZ0 then
				ZN0 <= transport iZ0 after TDELAY;
			else
				ZN0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity XOR2 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 Z0 : OUT std_logic);

end XOR2;

architecture LATTICE_ARCH of XOR2 is
begin
		process(A0, A1)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 XOR (A1));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity XOR3 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 Z0 : OUT std_logic);

end XOR3;

architecture LATTICE_ARCH of XOR3 is
begin
		process(A0, A1, A2)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 XOR (A1 XOR (A2)));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity XOR4 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 Z0 : OUT std_logic);

end XOR4;

architecture LATTICE_ARCH of XOR4 is
begin
		process(A0, A1, A2, A3)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 XOR (A1 XOR (A2 XOR (A3))));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity XOR8 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 Z0 : OUT std_logic);

end XOR8;

architecture LATTICE_ARCH of XOR8 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 XOR (A1 XOR (A2 XOR (A3 XOR (A4 XOR (A5 XOR (A6 XOR (A7))))))));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;


entity XOR9 is
	generic ( TDELAY : TIME := 1 ns);
	port(A0 : IN std_logic;
		 A1 : IN std_logic;
		 A2 : IN std_logic;
		 A3 : IN std_logic;
		 A4 : IN std_logic;
		 A5 : IN std_logic;
		 A6 : IN std_logic;
		 A7 : IN std_logic;
		 A8 : IN std_logic;
		 Z0 : OUT std_logic);

end XOR9;

architecture LATTICE_ARCH of XOR9 is
begin
		process(A0, A1, A2, A3, A4, A5, A6, A7, A8)
		variable pZ0 : std_logic;
		variable iZ0 : std_logic;

		 begin
			pZ0 := iZ0;
			iZ0 := (A0 XOR (A1 XOR (A2 XOR (A3 XOR (A4 XOR (A5 XOR (A6 XOR (A7 XOR (A8)))))))));
			if pZ0 /= iZ0 then
				Z0 <= transport iZ0 after TDELAY;
			else
				Z0 <= transport iZ0;
			end if;
		end process;

end LATTICE_ARCH;
-------------------------------------------------
--		PRIMITVE XOUTPUT UNIT DELAY MODEL	-----
-------------------------------------------------
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;

entity XOUTPUT is

	generic( TDELAY : TIME := 1 ns);

	port( A0 : IN  STD_LOGIC;
		  XO0  : OUT STD_LOGIC);

end XOUTPUT;


architecture LATTICE_ARCH of XOUTPUT is

begin

	process(A0)

	begin 
			XO0 <= transport A0 after TDELAY;
	end process;

--	component BUF
--		port( A0 : IN std_logic;
--			  Z0 : OUT std_logic);

--end component;

--begin

--	UQXOUT : BUF
--		port map (Z0 => XO0, A0 => A0);

end LATTICE_ARCH; -- XOUTPUT


-------------------------------------------------
--		PRIMITVE XTRI1 UNIT DELAY MODEL	-----
-------------------------------------------------

LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
entity XTRI1 is

	generic ( TDELAY : TIME := 1 ns);

	port( A0 : IN  std_logic;
		  OE : IN  std_logic;
		  XO0 : OUT  std_logic);

end XTRI1;

architecture LATTICE_ARCH of XTRI1 is

begin

	process(A0, OE)

	variable pXO0 : std_logic;
	variable iXO0 : std_logic;

	begin

		pXO0 := iXO0;
		if OE'EVENT AND OE = '1' then
			iXO0 := A0;
			if pXO0 /= iXO0 then
				XO0 <=  transport iXO0 after TDELAY;
			else
				XO0 <= transport iXO0;
			end if;

		elsif OE'EVENT AND OE = '0' then
			iXO0 := 'Z';
			if pXO0 /= iXO0 then
				XO0 <=  transport iXO0 after TDELAY;
			else
				XO0 <= transport iXO0;
			end if;

		elsif A0'EVENT  AND OE = '1' then
			iXO0 := A0;
			if pXO0 /= iXO0 then
				XO0 <=  transport iXO0 after TDELAY;
			else 
				XO0 <= transport iXO0;
			end if;   

		end if;
	end process;

end LATTICE_ARCH; -- XTRI1
--*****************************************************--
--   The following primitives are built for 8K device  --
--   while unit delay is used                          --
--*****************************************************--

Library IEEE;
Use IEEE.STD_LOGIC_1164.all;

entity FD11E is
  generic (TDELAY : TIME := 1 ns);
  port (D0, CLK, EN : IN std_logic;
	       Q0 : OUT std_logic);
end FD11E;

architecture LATTICE_ARCH of FD11E is

signal iD0 : std_logic;

begin

  process(D0, CLK, EN)
  variable pQ0 : std_logic;
  variable iQ0 : std_logic;
  begin

    iD0 <= (D0 AND EN) OR (iQ0 AND NOT EN);

    if CLK'EVENT AND CLK = '1' then
       pQ0 := iQ0;

       if (iD0'EVENT) then
	iQ0 := iD0'last_value;
       elsif NOT(iD0'EVENT) then
	iQ0 := iD0;
       end if;

       if pQ0 /= iQ0 then
	Q0 <= transport iQ0 after TDELAY;
       else
	Q0 <= transport iQ0;
       end if;
    end if;

  end process;

end LATTICE_ARCH;
Library IEEE;
Use IEEE.STD_LOGIC_1164.all;

entity FD21E is
  generic (TDELAY : TIME := 1 ns);
  port (D0, CLK, CD, EN : IN std_logic;
	           Q0 : OUT std_logic);
end FD21E;

architecture LATTICE_ARCH of FD21E is

signal iD0 : std_logic;

begin

  process(D0, CLK, CD, EN)
  variable pQ0 : std_logic;
  variable iQ0 : std_logic;
  begin
    iD0 <= (D0 AND EN) OR (iQ0 AND NOT EN);

    if CD = '1' then
       if NOT (iQ0 = '0') then
	iQ0 := '0';
	Q0 <= transport iQ0 after TDELAY;
       end if;

    elsif CD = '0' AND CLK'EVENT AND CLK = '1' then
       pQ0 := iQ0;

       if (iD0'EVENT) then
	iQ0 := iD0'last_value;
       elsif NOT(iD0'EVENT) then
	iQ0 := iD0;
       end if;

       if pQ0 /= iQ0 then
	Q0 <= transport iQ0 after TDELAY;
       else
	Q0 <= transport iQ0;
       end if;
    end if;

  end process;

end LATTICE_ARCH;
Library IEEE;
Use IEEE.STD_LOGIC_1164.all;

entity FDC1 is
  generic (TDELAY : TIME := 1 ns);
  port (D0, CLK, SD : IN std_logic;
	       Q0 : OUT std_logic);
end FDC1;

architecture LATTICE_ARCH of FDC1 is

begin

  process(D0, CLK, SD)
  variable pQ0 : std_logic;
  variable iQ0 : std_logic;
  begin
    
    if SD = '1' then
       if NOT (iQ0 = '1') then
	iQ0 := '1';
	Q0 <= transport iQ0 after TDELAY;
       end if;

    elsif SD = '0' AND CLK'EVENT AND CLK = '1' then
       pQ0 := iQ0;
       if (D0'EVENT) then
	iQ0 := D0'last_value;
       elsif NOT(D0'EVENT) then
	iQ0 := D0;
       end if;

       if pQ0 /= iQ0 then
	Q0 <= transport iQ0 after TDELAY;
       else
	Q0 <= transport iQ0;
       end if;
    end if;

  end process;

end LATTICE_ARCH;
Library IEEE;
Use IEEE.STD_LOGIC_1164.all;

entity FDC1E is
  generic (TDELAY : TIME := 1 ns);
  port (D0, CLK, SD, EN : IN std_logic;
	           Q0 : OUT std_logic);
end FDC1E;

architecture LATTICE_ARCH of FDC1E is

signal iD0 : std_logic;

begin

  process(D0, CLK, SD, EN)
  variable pQ0 : std_logic;
  variable iQ0 : std_logic;
  begin
    iD0 <= (D0 AND EN) OR (iQ0 AND NOT EN);
    
    if SD = '1' then
       if NOT (iQ0 = '1') then
	iQ0 := '1';
	Q0 <= transport iQ0 after TDELAY;
       end if;

    elsif SD = '0' AND CLK'EVENT AND CLK = '1' then
       pQ0 := iQ0;
       if (iD0'EVENT) then
	iQ0 := iD0'last_value;
       elsif NOT(iD0'EVENT) then
	iQ0 := iD0;
       end if;

       if pQ0 /= iQ0 then
	Q0 <= transport iQ0 after TDELAY;
       else
	Q0 <= transport iQ0;
       end if;
    end if;

  end process;

end LATTICE_ARCH;
Library IEEE;
Use IEEE.STD_LOGIC_1164.all;

entity FDE1 is
  generic (TDELAY : TIME := 1 ns);
  port (D0, CLK, CD, SD : IN std_logic;
	           Q0 : OUT std_logic);
end FDE1;

architecture LATTICE_ARCH of FDE1 is

begin

  process(D0, CLK, CD, SD)
  variable pQ0 : std_logic;
  variable iQ0 : std_logic;
  begin
    
    if CD = '1' then
       if NOT (iQ0 = '0') then
	iQ0 := '0';
	Q0 <= transport iQ0 after TDELAY;
       end if;

    elsif SD = '1' AND CD = '0' then
       if NOT (iQ0 = '1') then
	iQ0 := '1';
	Q0 <= transport iQ0 after TDELAY;
       end if;

    elsif CD = '0' AND SD = '0' AND CLK'EVENT AND CLK = '1' then
       pQ0 := iQ0;
       if (D0'EVENT) then
	iQ0 := D0'last_value;
       elsif NOT(D0'EVENT) then
	iQ0 := D0;
       end if;

       if pQ0 /= iQ0 then
	Q0 <= transport iQ0 after TDELAY;
       else
	Q0 <= transport iQ0;
       end if;
    end if;

  end process;

end LATTICE_ARCH;
Library IEEE;
Use IEEE.STD_LOGIC_1164.all;

entity FDE1E is
  generic (TDELAY : TIME := 1 ns);
  port (D0, CLK, CD, SD, EN : IN std_logic;
	               Q0 : OUT std_logic);
end FDE1E;

architecture LATTICE_ARCH of FDE1E is

signal iD0 : std_logic;

begin

  process(D0, CLK, CD, SD, EN)
  variable pQ0 : std_logic;
  variable iQ0 : std_logic;
  begin
    iD0 <= (D0 AND EN) OR (iQ0 AND NOT EN);
    
    if CD = '1' then
       if NOT (iQ0 = '0') then
	iQ0 := '0';
	Q0 <= transport iQ0 after TDELAY;
       end if;

    elsif SD = '1' AND CD = '0' then
       if NOT (iQ0 = '1') then
	iQ0 := '1';
	Q0 <= transport iQ0 after TDELAY;
       end if;

    elsif CD = '0' AND SD = '0' AND CLK'EVENT AND CLK = '1' then
       pQ0 := iQ0;
       if (iD0'EVENT) then
	iQ0 := iD0'last_value;
       elsif NOT(iD0'EVENT) then
	iQ0 := iD0;
       end if;

       if pQ0 /= iQ0 then
	Q0 <= transport iQ0 after TDELAY;
       else
	Q0 <= transport iQ0;
       end if;
    end if;

  end process;

end LATTICE_ARCH;
Library IEEE;
Use IEEE.STD_LOGIC_1164.all;

entity FTI21 is
  generic (TDELAY : TIME := 1 ns);
  port (T0, CLK, CD : IN std_logic;
                 Q0 : OUT std_logic);
end FTI21;

architecture LATTICE_ARCH of FTI21 is
begin

  process(T0, CLK, CD)
  variable pQ0 : std_logic;
  variable iQ0 : std_logic;
  begin

    if CD = '1' then
       if NOT (iQ0 = '0') then
	iQ0 := '0';
	Q0 <= transport iQ0 after TDELAY;
       end if;

    elsif CD = '0' AND CLK'EVENT AND CLK='1' then
       pQ0 := iQ0;
       if (T0'EVENT) then
	iQ0 := T0'last_value XOR iQ0;
       elsif NOT(T0'EVENT) then
	iQ0 := T0 XOR iQ0;
       end if;

       if pQ0 /= iQ0 then
	Q0 <= transport iQ0 after TDELAY;
       else
	Q0 <= transport iQ0;
       end if;

     end if;
  end process;

end LATTICE_ARCH;
Library IEEE;
Use IEEE.STD_LOGIC_1164.all;

entity FTI21E is
  generic (TDELAY : TIME := 1 ns);
  port (T0, CLK, CD, EN : IN std_logic;
                     Q0 : OUT std_logic);
end FTI21E;

architecture LATTICE_ARCH of FTI21E is

signal iT0 : std_logic;

begin

  process(T0, CLK, CD, EN)
  variable pQ0 : std_logic;
  variable iQ0 : std_logic;
  begin
    iT0 <= T0 AND EN;

    if CD = '1' then
       if NOT (iQ0 = '0') then
	iQ0 := '0';
	Q0 <= transport iQ0 after TDELAY;
       end if;

    elsif CD = '0' AND CLK'EVENT AND CLK='1' then
       pQ0 := iQ0;
       if (iT0'EVENT) then
	iQ0 := iT0'last_value XOR iQ0;
       else
	iQ0 := iT0 XOR iQ0;
       end if;

       if pQ0 /= iQ0 then
	Q0 <= transport iQ0 after TDELAY;
       else
	Q0 <= transport iQ0;
       end if;

    end if;
  end process;

end LATTICE_ARCH;
Library IEEE;
Use IEEE.STD_LOGIC_1164.all;

entity FTI31 is
  generic (TDELAY : TIME := 1 nS);
  port (T0, CLK, SD : IN std_logic;
	       Q0 : OUT std_logic);
end FTI31;

architecture LATTICE_ARCH of FTI31 is
begin

  process(T0, CLK, SD)
  variable pQ0 : std_logic;
  variable iQ0 : std_logic;
  begin

    if SD = '1' then
       if NOT (iQ0 = '1') then
	iQ0 := '1';
	Q0 <= transport iQ0 after TDELAY;
       end if;

    elsif SD = '0' AND CLK'EVENT AND CLK = '1' then
       pQ0 := iQ0;
       if (T0'EVENT) then
	iQ0 := T0'last_value XOR iQ0;
       elsif NOT(T0'EVENT) then
	iQ0 := T0 XOR iQ0;
       end if;

       if pQ0 /= iQ0 then
	Q0 <= transport iQ0 after TDELAY;
       else
	Q0 <= transport iQ0;
       end if;

     end if;
   end process;

end LATTICE_ARCH;
Library IEEE;
Use IEEE.STD_LOGIC_1164.all;

entity FTI31E is
  generic (TDELAY : TIME := 1 ns);
  port (T0, CLK, SD, EN : IN std_logic;
		 Q0 : OUT std_logic);
end FTI31E;

architecture LATTICE_ARCH of FTI31E is

signal iT0 : std_logic;

begin

  process(T0, CLK, SD, EN)
  variable pQ0 : std_logic;
  variable iQ0 : std_logic;
  begin
    iT0 <= T0 AND EN;

    if SD = '1' then
       if NOT (iQ0 = '1') then
	iQ0 := '1';
	Q0 <= transport iQ0 after TDELAY;
       end if;

    elsif SD = '0' AND CLK'EVENT AND CLK = '1' then
       pQ0 := iQ0;
       if (iT0'EVENT) then
	iQ0 := iT0'last_value XOR iQ0;
       else
	iQ0 := iT0 XOR iQ0;
       end if;

       if pQ0 /= iQ0 then
	Q0 <= transport iQ0 after TDELAY;
       else
	Q0 <= transport iQ0;
       end if;

     end if;
   end process;

end LATTICE_ARCH;
Library IEEE;
Use IEEE.STD_LOGIC_1164.all;

entity FTI41 is
  generic (TDELAY : TIME := 1 ns);
  port (T0, CLK, SD, CD : IN std_logic;
		 Q0 : OUT std_logic);
end FTI41;

architecture LATTICE_ARCH of FTI41 is
begin

  process(T0, CLK, SD, CD)
  variable pQ0 : std_logic;
  variable iQ0 : std_logic;
  begin

    if CD = '1' then
       if NOT (iQ0 = '0') then
	iQ0 := '0';
	Q0 <= transport iQ0 after TDELAY;
       end if;

    elsif SD = '1' AND CD = '0' then
       if NOT (iQ0 = '1') then
	iQ0 := '1';
	Q0 <= transport iQ0 after TDELAY;
       end if;

    elsif SD = '0' AND CD = '0' AND CLK'EVENT AND CLK = '1' then
       pQ0 := iQ0;
       if (T0'EVENT) then
	iQ0 := T0'last_value XOR iQ0;
       elsif NOT(T0'EVENT) then
	iQ0 := T0 XOR iQ0;
       end if;

       if pQ0 /= iQ0 then
	Q0 <= transport iQ0 after TDELAY;
       else
	Q0 <= transport iQ0;
       end if;

     end if;
   end process;

end LATTICE_ARCH;
Library IEEE;
Use IEEE.STD_LOGIC_1164.all;

entity FTI41E is
  generic (TDELAY : TIME := 1 ns);
  port (T0, CLK, CD, SD, EN : IN std_logic;
		     Q0 : OUT std_logic);
end FTI41E;

architecture LATTICE_ARCH of FTI41E is

signal iT0 : std_logic;

begin

  process(T0, CLK, SD, CD, EN)
  variable pQ0 : std_logic;
  variable iQ0 : std_logic;
  begin
    iT0 <= T0 AND EN;

    if CD = '1' then
       if NOT (iQ0 = '0') then
	iQ0 := '0';
	Q0 <= transport iQ0 after TDELAY;
       end if;

    elsif SD = '1' AND CD = '0' then
       if NOT (iQ0 = '1') then
	iQ0 := '1';
	Q0 <= transport iQ0 after TDELAY;
       end if;

    elsif CD = '0' AND SD = '0' AND CLK'EVENT AND CLK = '1' then
       pQ0 := iQ0;
       if (iT0'EVENT) then
	iQ0 := iT0'last_value XOR iQ0;
       else
          iQ0 := iT0 XOR iQ0;
       end if;

       if pQ0 /= iQ0 then
	Q0 <= transport iQ0 after TDELAY;
       else
	Q0 <= transport iQ0;
       end if;

    end if;
  end process;

end LATTICE_ARCH;
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;

entity IT11 is
  generic (TDELAY : TIME := 1 ns);
  port(A0, OE : IN std_logic;
	 O0 : OUT  std_logic);
end IT11;
       
architecture LATTICE_ARCH of IT11 is
begin

  process(A0, OE)
  variable pO0 : std_logic;
  variable iO0 : std_logic;
  begin
    pO0 := iO0;

    if OE'EVENT AND OE = '1' then
      iO0 := A0;
      if pO0 /= iO0 then
        O0 <=  transport iO0 after TDELAY;
      else
        O0 <= transport iO0;
      end if;

    elsif OE'EVENT AND OE = '0' then
      iO0 := 'Z';
      if pO0 /= iO0 then
        O0 <=  transport iO0 after TDELAY;
      else
        O0 <= transport iO0;
      end if;

    elsif A0'EVENT  AND OE = '1' then
      iO0 := A0;
      if pO0 /= iO0 then
        O0 <=  transport iO0 after TDELAY;
      else
        O0 <= transport iO0;
      end if;

    end if;
  end process;

end LATTICE_ARCH;
Library IEEE;
Use IEEE.STD_LOGIC_1164.all;

entity LDI11 is
  generic (TDELAY : TIME := 1 ns);
  port (D0, G : IN std_logic;
           Q0 : OUT std_logic);
end LDI11;

architecture LATTICE_ARCH of LDI11 is

begin

  process(D0, G)
  variable pQ0 : std_logic;
  variable iQ0 : std_logic;
  begin
    pQ0 := iQ0;

    if G = '1' then
       iQ0 := D0;

       if pQ0 /= iQ0 then
	Q0 <= transport iQ0 after TDELAY;
       else
	Q0 <= transport iQ0;
       end if;
    end if;
  end process;

end LATTICE_ARCH;
Library IEEE;
Use IEEE.STD_LOGIC_1164.all;

entity LDI21 is
  generic (TDELAY : TIME := 1 ns);
  port (D0, G, CD : IN std_logic;
	     Q0 : OUT std_logic);
end LDI21;

architecture LATTICE_ARCH of LDI21 is

begin

  process(D0, G, CD)
  variable iQ0 : std_logic;
  variable pQ0 : std_logic;
  begin

    if CD = '1' then
       if NOT(iQ0 = '0') then
	iQ0 := '0';
	Q0 <= transport iQ0 after TDELAY;
       end if;
    
    elsif CD = '0' AND G = '1' then
       pQ0 := iQ0;
       iQ0 := D0;

       if pQ0 /= iQ0 then
	Q0 <= transport iQ0 after TDELAY;
       else
	Q0 <= transport iQ0;
       end if;
    end if;
  end process;

end LATTICE_ARCH;
Library IEEE;
Use IEEE.STD_LOGIC_1164.all;

entity LDI31 is
  generic (TDELAY : TIME := 1 ns);
  port (D0, G, SD : IN std_logic;
	     Q0 : OUT std_logic);
end LDI31;

architecture LATTICE_ARCH of LDI31 is

begin

  process(D0, G, SD)
  variable iQ0 : std_logic;
  variable pQ0 : std_logic;
  begin

    if SD = '1' then
       if NOT(iQ0 = '1') then
	iQ0 := '1';
	Q0 <= transport iQ0 after TDELAY;
       end if;
    
    elsif SD = '0' AND G = '1' then
       pQ0 := iQ0;
       iQ0 := D0;

       if pQ0 /= iQ0 then
	Q0 <= transport iQ0 after TDELAY;
       else
	Q0 <= transport iQ0;
       end if;
    end if;
  end process;

end LATTICE_ARCH;
Library IEEE;
Use IEEE.STD_LOGIC_1164.all;

entity LDI41 is
  generic (TDELAY : TIME := 1 ns);
  port (D0, G, CD, SD : IN std_logic;
	         Q0 : OUT std_logic);
end LDI41;

architecture LATTICE_ARCH of LDI41 is

begin

  process(D0, G, SD, CD)
  variable iQ0 : std_logic;
  variable pQ0 : std_logic;
  begin

    if CD = '1' then
       if NOT(iQ0 = '0') then
	iQ0 := '0';
	Q0 <= transport iQ0 after TDELAY;
       end if;

    elsif SD = '1' AND CD = '0' then
       if NOT(iQ0 = '1') then
	iQ0 := '1';
	Q0 <= transport iQ0 after TDELAY;
       end if;
    
    elsif CD = '0' AND SD = '0' AND G = '1' then
       pQ0 := iQ0;
       iQ0 := D0;

       if pQ0 /= iQ0 then
	Q0 <= transport iQ0 after TDELAY;
       else
	Q0 <= transport iQ0;
       end if;
    end if;
  end process;

end LATTICE_ARCH;
Library IEEE;
Use IEEE.STD_LOGIC_1164.all;

entity XDFF1E is
  generic (TDELAY : TIME := 1 ns);
  port (D0, CLK, EN : IN std_logic;
	       Q0 : OUT std_logic);
end XDFF1E;

architecture LATTICE_ARCH of XDFF1E is

signal iD0 : std_logic;

begin

  process(D0, CLK, EN)
  variable pQ0 : std_logic;
  variable iQ0 : std_logic;
  begin

    iD0 <= (D0 AND EN) OR (iQ0 AND NOT EN);

    if CLK'EVENT AND CLK = '1' then
       pQ0 := iQ0;

       if (iD0'EVENT) then
	iQ0 := iD0'last_value;
       elsif NOT(iD0'EVENT) then
	iQ0 := iD0;
       end if;

       if pQ0 /= iQ0 then
	Q0 <= transport iQ0 after TDELAY;
       else
	Q0 <= transport iQ0;
       end if;
    end if;

  end process;

end LATTICE_ARCH;
Library IEEE;
Use IEEE.STD_LOGIC_1164.all;

entity XDFF2 is
  generic (TDELAY : TIME := 1 ns);
  port (D0, CLK, CD : IN std_logic;
	       Q0 : OUT std_logic);
end XDFF2;

architecture LATTICE_ARCH of XDFF2 is

begin

  process(D0, CLK, CD)
  variable pQ0 : std_logic;
  variable iQ0 : std_logic;
  begin
    if CD = '1' then
       if NOT (iQ0 = '0') then
          iQ0 := '0';
          Q0 <= transport iQ0 after TDELAY;
       end if;

    elsif CD = '0' AND CLK'EVENT AND CLK = '1' then
       pQ0 := iQ0;
       if (D0'EVENT) then
          iQ0 := D0'last_value;
       elsif NOT(D0'EVENT) then
          iQ0 := D0;
       end if;

       if pQ0 /= iQ0 then
          Q0 <= transport iQ0 after TDELAY;
       else
          Q0 <= transport iQ0;
       end if;

    end if;

  end process;

end LATTICE_ARCH;
Library IEEE;
Use IEEE.STD_LOGIC_1164.all;

entity XDFF2E is
  generic (TDELAY : TIME := 1 ns);
  port (D0, CLK, CD, EN : IN std_logic;
	           Q0 : OUT std_logic);
end XDFF2E;

architecture LATTICE_ARCH of XDFF2E is

  signal iD0 : std_logic;

begin

  process(D0, CLK, CD, EN)
  variable pQ0 : std_logic;
  variable iQ0 : std_logic;
  begin
    iD0 <= (D0 AND EN) OR (iQ0 AND NOT EN);

    if CD = '1' then
       if NOT (iQ0 = '0') then
	iQ0 := '0';
	Q0 <= transport iQ0 after TDELAY;
       end if;

    elsif CD = '0' AND CLK'EVENT AND CLK = '1' then
       pQ0 := iQ0;

       if (iD0'EVENT) then
	iQ0 := iD0'last_value;
       elsif NOT(iD0'EVENT) then
	iQ0 := iD0;
       end if;

       if pQ0 /= iQ0 then
	Q0 <= transport iQ0 after TDELAY;
       else
	Q0 <= transport iQ0;
       end if;
    end if;

  end process;

end LATTICE_ARCH;
Library IEEE;
Use IEEE.STD_LOGIC_1164.all;

entity XDFF3 is
  generic (TDELAY : TIME := 1 ns);
  port (D0, CLK, SD : IN std_logic;
	       Q0 : OUT std_logic);
end XDFF3;

architecture LATTICE_ARCH of XDFF3 is

begin

  process(D0, CLK, SD)
  variable pQ0 : std_logic;
  variable iQ0 : std_logic;
  begin
    
    if SD = '1' then
       if NOT (iQ0 = '1') then
	iQ0 := '1';
	Q0 <= transport iQ0 after TDELAY;
       end if;

    elsif SD = '0' AND CLK'EVENT AND CLK = '1' then
       pQ0 := iQ0;
       if (D0'EVENT) then
	iQ0 := D0'last_value;
       elsif NOT(D0'EVENT) then
	iQ0 := D0;
       end if;

       if pQ0 /= iQ0 then
	Q0 <= transport iQ0 after TDELAY;
       else
	Q0 <= transport iQ0;
       end if;
    end if;

  end process;

end LATTICE_ARCH;
Library IEEE;
Use IEEE.STD_LOGIC_1164.all;

entity XDFF3E is
  generic (TDELAY : TIME := 1 ns);
  port (D0, CLK, SD, EN : IN std_logic;
	           Q0 : OUT std_logic);
end XDFF3E;

architecture LATTICE_ARCH of XDFF3E is

  signal iD0 : std_logic;

begin

  process(D0, CLK, SD, EN)
  variable pQ0 : std_logic;
  variable iQ0 : std_logic;
  begin
    iD0 <= (D0 AND EN) OR (iQ0 AND NOT EN);
    
    if SD = '1' then
       if NOT (iQ0 = '1') then
	iQ0 := '1';
	Q0 <= transport iQ0 after TDELAY;
       end if;

    elsif SD = '0' AND CLK'EVENT AND CLK = '1' then
       pQ0 := iQ0;
       if (iD0'EVENT) then
	iQ0 := iD0'last_value;
       elsif NOT(iD0'EVENT) then
	iQ0 := iD0;
       end if;

       if pQ0 /= iQ0 then
	Q0 <= transport iQ0 after TDELAY;
       else
	Q0 <= transport iQ0;
       end if;
    end if;

  end process;

end LATTICE_ARCH;
Library IEEE;
Use IEEE.STD_LOGIC_1164.all;

entity XDFF4 is
  generic (TDELAY : TIME := 1 ns);
  port (D0, CLK, CD, SD : IN std_logic;
	           Q0 : OUT std_logic);
end XDFF4;

architecture LATTICE_ARCH of XDFF4 is

begin

  process(D0, CLK, CD, SD)
  variable pQ0 : std_logic;
  variable iQ0 : std_logic;
  begin
    
    if CD = '1' then
       if NOT (iQ0 = '0') then
	iQ0 := '0';
	Q0 <= transport iQ0 after TDELAY;
       end if;

    elsif SD = '1' AND CD = '0' then
       if NOT (iQ0 = '1') then
	iQ0 := '1';
	Q0 <= transport iQ0 after TDELAY;
       end if;

    elsif CD = '0' AND SD = '0' AND CLK'EVENT AND CLK = '1' then
       pQ0 := iQ0;
       if (D0'EVENT) then
	iQ0 := D0'last_value;
       elsif NOT(D0'EVENT) then
	iQ0 := D0;
       end if;

       if pQ0 /= iQ0 then
	Q0 <= transport iQ0 after TDELAY;
       else
	Q0 <= transport iQ0;
       end if;
    end if;

  end process;

end LATTICE_ARCH;
Library IEEE;
Use IEEE.STD_LOGIC_1164.all;

entity XDFF4E is
  generic (TDELAY : TIME := 1 ns);
  port (D0, CLK, CD, SD, EN : IN std_logic;
	               Q0 : OUT std_logic);
end XDFF4E;

architecture LATTICE_ARCH of XDFF4E is

  signal iD0 : std_logic;

begin

  process(D0, CLK, CD, SD, EN)
  variable pQ0 : std_logic;
  variable iQ0 : std_logic;
  begin
    iD0 <= (D0 AND EN) OR (iQ0 AND NOT EN);
    
    if CD = '1' then
       if NOT (iQ0 = '0') then
	iQ0 := '0';
	Q0 <= transport iQ0 after TDELAY;
       end if;

    elsif SD = '1' AND CD = '0' then
       if NOT (iQ0 = '1') then
	iQ0 := '1';
	Q0 <= transport iQ0 after TDELAY;
       end if;

    elsif CD = '0' AND SD = '0' AND CLK'EVENT AND CLK = '1' then
       pQ0 := iQ0;
       if (iD0'EVENT) then
	iQ0 := iD0'last_value;
       elsif NOT(iD0'EVENT) then
	iQ0 := iD0;
       end if;

       if pQ0 /= iQ0 then
	Q0 <= transport iQ0 after TDELAY;
       else
	Q0 <= transport iQ0;
       end if;
    end if;

  end process;

end LATTICE_ARCH;
Library IEEE;
Use IEEE.STD_LOGIC_1164.all;

entity XDL2 is
  generic (TDELAY : TIME := 1 ns);
  port (D0, G, CD : IN std_logic;
	     Q0 : OUT std_logic);
end XDL2;

architecture LATTICE_ARCH of XDL2 is

begin

  process(D0, G, CD)
  variable iQ0 : std_logic;
  variable pQ0 : std_logic;
  begin

    if CD = '1' then
       if NOT(iQ0 = '0') then
	iQ0 := '0';
	Q0 <= transport iQ0 after TDELAY;
       end if;
    
    elsif CD = '0' AND G = '1' then
       pQ0 := iQ0;
       iQ0 := D0;

       if pQ0 /= iQ0 then
	Q0 <= transport iQ0 after TDELAY;
       else
	Q0 <= transport iQ0;
       end if;
    end if;
  end process;

end LATTICE_ARCH;
Library IEEE;
Use IEEE.STD_LOGIC_1164.all;

entity XDL3 is
  generic (TDELAY : TIME := 1 ns);
  port (D0, G, SD : IN std_logic;
	     Q0 : OUT std_logic);
end XDL3;

architecture LATTICE_ARCH of XDL3 is

begin

  process(D0, G, SD)
  variable iQ0 : std_logic;
  variable pQ0 : std_logic;
  begin

    if SD = '1' then
       if NOT(iQ0 = '1') then
	iQ0 := '1';
	Q0 <= transport iQ0 after TDELAY;
       end if;
    
    elsif SD = '0' AND G = '1' then
       pQ0 := iQ0;
       iQ0 := D0;

       if pQ0 /= iQ0 then
	Q0 <= transport iQ0 after TDELAY;
       else
	Q0 <= transport iQ0;
       end if;
    end if;
  end process;

end LATTICE_ARCH;
Library IEEE;
Use IEEE.STD_LOGIC_1164.all;

entity XDL4 is
  generic (TDELAY : TIME := 1 ns);
  port (D0, G, CD, SD : IN std_logic;
	         Q0 : OUT std_logic);
end XDL4;

architecture LATTICE_ARCH of XDL4 is

begin

  process(D0, G, SD, CD)
  variable iQ0 : std_logic;
  variable pQ0 : std_logic;
  begin

    if CD = '1' then
       if NOT(iQ0 = '0') then
	iQ0 := '0';
	Q0 <= transport iQ0 after TDELAY;
       end if;

    elsif SD = '1' AND CD = '0' then
       if NOT(iQ0 = '1') then
	iQ0 := '1';
	Q0 <= transport iQ0 after TDELAY;
       end if;
    
    elsif CD = '0' AND SD = '0' AND G = '1' then
       pQ0 := iQ0;
       iQ0 := D0;

       if pQ0 /= iQ0 then
	Q0 <= transport iQ0 after TDELAY;
       else
	Q0 <= transport iQ0;
       end if;
    end if;
  end process;

end LATTICE_ARCH;

--*********************************************************
--	This file contains the VHDL source of the macros
--	of the lattice library.
--*********************************************************

-- VHDL netlist for ADDF1
-- Date: 15.5.95 13.44.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY ADDF1 IS 
    PORT (
        A0 : IN std_logic;
        B0 : IN std_logic;
        CI : IN std_logic;
        Z0 : OUT std_logic;
        CO : OUT std_logic
    );
END ADDF1;


ARCHITECTURE lattice_arch OF ADDF1 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8 : std_logic;


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT OR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR2 use  entity  lattice.OR2(lattice_arch);


  COMPONENT XOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: XOR2 use  entity  lattice.XOR2(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT OR3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR3 use  entity  lattice.OR3(lattice_arch);


BEGIN

UQVB_B1 : AND2
	PORT MAP (Z0 => UQVN_N2, A0 => UQVN_N8, A1 => CI);
UQVB_B2 : AND2
	PORT MAP (Z0 => UQVN_N3, A0 => B0, A1 => UQVN_N1);
UQVB_B3 : OR2
	PORT MAP (Z0 => UQVN_N4, A0 => UQVN_N3, A1 => UQVN_N2);
UQVB_B4 : XOR2
	PORT MAP (Z0 => Z0, A0 => A0, A1 => UQVN_N4);
UQVB_B5 : INV
	PORT MAP (ZN0 => UQVN_N8, A0 => B0);
UQVB_B6 : INV
	PORT MAP (ZN0 => UQVN_N1, A0 => CI);
UQVB_B7 : AND2
	PORT MAP (Z0 => UQVN_N5, A0 => CI, A1 => B0);
UQVB_B8 : AND2
	PORT MAP (Z0 => UQVN_N6, A0 => CI, A1 => A0);
UQVB_B9 : AND2
	PORT MAP (Z0 => UQVN_N7, A0 => B0, A1 => A0);
UQVB_B10 : OR3
	PORT MAP (Z0 => CO, A0 => UQVN_N5, A1 => UQVN_N6, A2 => UQVN_N7);
END lattice_arch;
-- VHDL netlist for ADDF16A
-- Date: 15.5.95 13.44.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY ADDF16A IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A10 : IN std_logic;
        A11 : IN std_logic;
        A12 : IN std_logic;
        A13 : IN std_logic;
        A14 : IN std_logic;
        A15 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        A9 : IN std_logic;
        B0 : IN std_logic;
        B1 : IN std_logic;
        B10 : IN std_logic;
        B11 : IN std_logic;
        B12 : IN std_logic;
        B13 : IN std_logic;
        B14 : IN std_logic;
        B15 : IN std_logic;
        B2 : IN std_logic;
        B3 : IN std_logic;
        B4 : IN std_logic;
        B5 : IN std_logic;
        B6 : IN std_logic;
        B7 : IN std_logic;
        B8 : IN std_logic;
        B9 : IN std_logic;
        CI : IN std_logic;
        CO : OUT std_logic;
        Z0 : OUT std_logic;
        Z1 : OUT std_logic;
        Z10 : OUT std_logic;
        Z11 : OUT std_logic;
        Z12 : OUT std_logic;
        Z13 : OUT std_logic;
        Z14 : OUT std_logic;
        Z15 : OUT std_logic;
        Z2 : OUT std_logic;
        Z3 : OUT std_logic;
        Z4 : OUT std_logic;
        Z5 : OUT std_logic;
        Z6 : OUT std_logic;
        Z7 : OUT std_logic;
        Z8 : OUT std_logic;
        Z9 : OUT std_logic
    );
END ADDF16A;


ARCHITECTURE lattice_arch OF ADDF16A IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, UQVN_N23, UQVN_N24,
	 UQVN_N25, UQVN_N26, UQVN_N27, UQVN_N28,
	 UQVN_N29, UQVN_N30, UQVN_N31, UQVN_N32,
	 UQVN_N33, UQVN_N34, UQVN_N35, UQVN_N36,
	 UQVN_N37, UQVN_N38, UQVN_N39, UQVN_N40,
	 UQVN_N41, UQVN_N42, UQVN_N43, UQVN_N44,
	 UQVN_N45, UQVN_N46, UQVN_N47, UQVN_N48,
	 UQVN_N49, UQVN_N50, UQVN_N51, UQVN_N52,
	 UQVN_N53, UQVN_N54, UQVN_N55, UQVN_N56,
	 UQVN_N57, UQVN_N58, UQVN_N59, UQVN_N60,
	 UQVN_N61, UQVN_N62, UQVN_N63, UQVN_N64,
	 UQVN_N65, UQVN_N66, UQVN_N67, UQVN_N68,
	 UQVN_N69, UQVN_N70, UQVN_N71, UQVN_N72,
	 UQVN_N73, UQVN_N74, UQVN_N75, UQVN_N76,
	 UQVN_N77, UQVN_N78, UQVN_N79, UQVN_N80,
	 UQVN_N81, UQVN_N82, UQVN_N83, UQVN_N84,
	 UQVN_N85, UQVN_N86, UQVN_N87, UQVN_N88,
	 UQVN_N89, UQVN_N90, UQVN_N91, UQVN_N92,
	 UQVN_N93, UQVN_N94, UQVN_N95, UQVN_N96,
	 UQVN_N97, UQVN_N98, UQVN_N99, UQVN_N100,
	 UQVN_N101, UQVN_N102, UQVN_N103, UQVN_N104,
	 UQVN_N105, UQVN_N106, UQVN_N107, UQVN_N108,
	 UQVN_N109, UQVN_N110, UQVN_N111, UQVN_N112,
	 UQVN_N113, UQVN_N114, UQVN_N115, UQVN_N116,
	 UQVN_N117, UQVN_N118, UQVN_N119, UQVN_N120,
	 UQVN_N121, UQVN_N122, UQVN_N123, UQVN_N124,
	 UQVN_N125, UQVN_N126, UQVN_N127, UQVN_N128,
	 UQVN_N129, UQVN_N130, UQVN_N131, UQVN_N132,
	 UQVN_N133, UQVN_N134, UQVN_N135, UQVN_N136,
	 UQVN_N137, UQVN_N138, UQVN_N139, UQVN_N140,
	 UQVN_N141, UQVN_N142, UQVN_N143, UQVN_N144,
	 UQVN_N145, UQVN_N146, UQVN_N147, UQVN_N148,
	 UQVN_N149, UQVN_N150, UQVN_N151, UQVN_N152,
	 UQVN_N153, UQVN_N154, UQVN_N155, UQVN_N156,
	 UQVN_N157, UQVN_N158, UQVN_N159, UQVN_N160,
	 UQVN_N161, UQVN_N162, UQVN_N163, UQVN_N164,
	 UQVN_N165, UQVN_N166, UQVN_N167, UQVN_N168,
	 UQVN_N169, UQVN_N170, UQVN_N171, UQVN_N172,
	 UQVN_N173, UQVN_N174, UQVN_N175, UQVN_N176,
	 UQVN_N177, UQVN_N178, UQVN_N179, UQVN_N180,
	 UQVN_N181, UQVN_N182, UQVN_N183, UQVN_N184,
	 UQVN_N185, UQVN_N186, UQVN_N187, UQVN_N188,
	 UQVN_N189, UQVN_N190, UQVN_N191, UQVN_N192,
	 UQVN_N193, UQVN_N194, UQVN_N195, UQVN_N196,
	 UQVN_N197, UQVN_N198, UQVN_N199, UQVN_N200,
	 UQVN_N201, UQVN_N202, UQVN_N203, UQVN_N204,
	 UQVN_N205, UQVN_N206, UQVN_N207, UQVN_N208,
	 UQVN_N209, UQVN_N210, UQVN_N211, UQVN_N212,
	 UQVN_N213, UQVN_N214, UQVN_N215, UQVN_N216,
	 UQVN_N217, UQVN_N218, UQVN_N219, UQVN_N220,
	 UQVN_N221, UQVN_N222, UQVN_N223, UQVN_N224,
	 UQVN_N225, UQVN_N226, UQVN_N227, UQVN_N228,
	 UQVN_N229, UQVN_N230, UQVN_N231, UQVN_N232,
	 UQVN_N233, UQVN_N234, UQVN_N235, UQVN_N236,
	 UQVN_N237, UQVN_N238, UQVN_N239, G012,
	 G1214, G345, G678, G911,
	 P012, P1214, P345, P678,
	 P911 : std_logic;


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT OR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR2 use  entity  lattice.OR2(lattice_arch);


  COMPONENT OR3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR3 use  entity  lattice.OR3(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT OR4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR4 use  entity  lattice.OR4(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT OR5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR5 use  entity  lattice.OR5(lattice_arch);


  COMPONENT AND5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND5 use  entity  lattice.AND5(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


  COMPONENT OR6
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR6 use  entity  lattice.OR6(lattice_arch);


  COMPONENT OR7
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR7 use  entity  lattice.OR7(lattice_arch);


  COMPONENT NOR3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: NOR3 use  entity  lattice.NOR3(lattice_arch);


  COMPONENT OR12
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        A9 : IN std_logic;
        A10 : IN std_logic;
        A11 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR12 use  entity  lattice.OR12(lattice_arch);


  COMPONENT XOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: XOR2 use  entity  lattice.XOR2(lattice_arch);


BEGIN

UQVB_B1 : AND2
	PORT MAP (Z0 => UQVN_N1, A0 => P345, A1 => UQVN_N239);
UQVB_B2 : OR2
	PORT MAP (Z0 => UQVN_N235, A0 => G345, A1 => UQVN_N1);
UQVB_B3 : OR3
	PORT MAP (Z0 => UQVN_N236, A0 => G678, A1 => UQVN_N2, A2 => UQVN_N3);
UQVB_B4 : AND3
	PORT MAP (Z0 => UQVN_N3, A0 => P678, A1 => P345, A2 => UQVN_N239);
UQVB_B5 : AND2
	PORT MAP (Z0 => UQVN_N2, A0 => P678, A1 => G345);
UQVB_B6 : OR4
	PORT MAP (Z0 => UQVN_N237, A0 => G911, A1 => UQVN_N4, A2 => UQVN_N5, 
	A3 => UQVN_N6);
UQVB_B7 : AND2
	PORT MAP (Z0 => UQVN_N4, A0 => P911, A1 => G678);
UQVB_B8 : AND3
	PORT MAP (Z0 => UQVN_N5, A0 => P911, A1 => P678, A2 => G345);
UQVB_B9 : AND4
	PORT MAP (Z0 => UQVN_N6, A0 => P911, A1 => P678, A2 => P345, 
	A3 => UQVN_N239);
UQVB_B10 : OR5
	PORT MAP (Z0 => UQVN_N238, A0 => G1214, A1 => UQVN_N7, A2 => UQVN_N8, 
	A3 => UQVN_N9, A4 => UQVN_N10);
UQVB_B11 : AND2
	PORT MAP (Z0 => UQVN_N7, A0 => P1214, A1 => G911);
UQVB_B12 : AND3
	PORT MAP (Z0 => UQVN_N8, A0 => P1214, A1 => P911, A2 => G678);
UQVB_B13 : AND4
	PORT MAP (Z0 => UQVN_N9, A0 => P1214, A1 => P911, A2 => P678, 
	A3 => G345);
UQVB_B14 : AND5
	PORT MAP (Z0 => UQVN_N10, A0 => P1214, A1 => P911, A2 => P678, 
	A3 => P345, A4 => UQVN_N239);
UQVB_B15 : AND2
	PORT MAP (Z0 => UQVN_N11, A0 => P012, A1 => CI);
UQVB_B16 : OR2
	PORT MAP (Z0 => UQVN_N239, A0 => G012, A1 => UQVN_N11);
UQVB_B17 : INV
	PORT MAP (ZN0 => UQVN_N54, A0 => CI);
UQVB_B18 : INV
	PORT MAP (ZN0 => UQVN_N52, A0 => B1);
UQVB_B19 : INV
	PORT MAP (ZN0 => UQVN_N53, A0 => B2);
UQVB_B20 : INV
	PORT MAP (ZN0 => UQVN_N48, A0 => A0);
UQVB_B21 : AND2
	PORT MAP (Z0 => UQVN_N12, A0 => UQVN_N51, A1 => CI);
UQVB_B22 : AND2
	PORT MAP (Z0 => UQVN_N13, A0 => B0, A1 => UQVN_N54);
UQVB_B23 : OR2
	PORT MAP (Z0 => UQVN_N14, A0 => UQVN_N12, A1 => UQVN_N13);
UQVB_B24 : LXOR2
	PORT MAP (Z0 => Z0, A0 => A0, A1 => UQVN_N14);
UQVB_B25 : AND3
	PORT MAP (Z0 => UQVN_N20, A0 => UQVN_N48, A1 => B1, A2 => UQVN_N51);
UQVB_B26 : AND3
	PORT MAP (Z0 => UQVN_N16, A0 => UQVN_N52, A1 => B0, A2 => CI);
UQVB_B27 : AND3
	PORT MAP (Z0 => UQVN_N15, A0 => A0, A1 => UQVN_N52, A2 => CI);
UQVB_B28 : AND3
	PORT MAP (Z0 => UQVN_N17, A0 => B1, A1 => UQVN_N51, A2 => UQVN_N54);
UQVB_B29 : AND3
	PORT MAP (Z0 => UQVN_N18, A0 => UQVN_N48, A1 => B1, A2 => UQVN_N54);
UQVB_B30 : OR6
	PORT MAP (Z0 => UQVN_N21, A0 => UQVN_N18, A1 => UQVN_N17, A2 => UQVN_N15, 
	A3 => UQVN_N16, A4 => UQVN_N20, A5 => UQVN_N19);
UQVB_B31 : LXOR2
	PORT MAP (Z0 => Z1, A0 => A1, A1 => UQVN_N21);
UQVB_B32 : AND3
	PORT MAP (Z0 => UQVN_N19, A0 => A0, A1 => UQVN_N52, A2 => B0);
UQVB_B33 : AND4
	PORT MAP (Z0 => UQVN_N25, A0 => A0, A1 => A1, A2 => A2, 
	A3 => B0);
UQVB_B34 : AND3
	PORT MAP (Z0 => UQVN_N24, A0 => A1, A1 => A2, A2 => B1);
UQVB_B35 : AND4
	PORT MAP (Z0 => UQVN_N23, A0 => A0, A1 => A2, A2 => B0, 
	A3 => B1);
UQVB_B36 : AND2
	PORT MAP (Z0 => UQVN_N22, A0 => A2, A1 => B2);
UQVB_B37 : AND4
	PORT MAP (Z0 => UQVN_N26, A0 => A0, A1 => A1, A2 => B0, 
	A3 => B2);
UQVB_B38 : AND3
	PORT MAP (Z0 => UQVN_N27, A0 => A1, A1 => B1, A2 => B2);
UQVB_B39 : AND4
	PORT MAP (Z0 => UQVN_N28, A0 => A0, A1 => B0, A2 => B1, 
	A3 => B2);
UQVB_B40 : OR7
	PORT MAP (Z0 => G012, A0 => UQVN_N25, A1 => UQVN_N24, A2 => UQVN_N23, 
	A3 => UQVN_N22, A4 => UQVN_N26, A5 => UQVN_N27, A6 => UQVN_N28);
UQVB_B41 : AND2
	PORT MAP (Z0 => UQVN_N31, A0 => UQVN_N48, A1 => UQVN_N51);
UQVB_B42 : AND2
	PORT MAP (Z0 => UQVN_N29, A0 => UQVN_N49, A1 => UQVN_N52);
UQVB_B43 : AND2
	PORT MAP (Z0 => UQVN_N30, A0 => UQVN_N50, A1 => UQVN_N53);
UQVB_B44 : NOR3
	PORT MAP (ZN0 => P012, A0 => UQVN_N31, A1 => UQVN_N29, A2 => UQVN_N30);
UQVB_B45 : INV
	PORT MAP (ZN0 => UQVN_N51, A0 => B0);
UQVB_B46 : INV
	PORT MAP (ZN0 => UQVN_N49, A0 => A1);
UQVB_B47 : INV
	PORT MAP (ZN0 => UQVN_N50, A0 => A2);
UQVB_B48 : LXOR2
	PORT MAP (Z0 => Z2, A0 => A2, A1 => UQVN_N45);
UQVB_B49 : AND4
	PORT MAP (Z0 => UQVN_N44, A0 => UQVN_N51, A1 => UQVN_N52, A2 => B2, 
	A3 => UQVN_N54);
UQVB_B50 : AND4
	PORT MAP (Z0 => UQVN_N46, A0 => UQVN_N48, A1 => UQVN_N52, A2 => B2, 
	A3 => UQVN_N54);
UQVB_B51 : AND4
	PORT MAP (Z0 => UQVN_N43, A0 => UQVN_N49, A1 => UQVN_N51, A2 => B2, 
	A3 => UQVN_N54);
UQVB_B52 : AND4
	PORT MAP (Z0 => UQVN_N42, A0 => UQVN_N48, A1 => UQVN_N49, A2 => B2, 
	A3 => UQVN_N54);
UQVB_B53 : AND4
	PORT MAP (Z0 => UQVN_N41, A0 => B0, A1 => B1, A2 => UQVN_N53, 
	A3 => CI);
UQVB_B54 : AND4
	PORT MAP (Z0 => UQVN_N40, A0 => A0, A1 => B1, A2 => UQVN_N53, 
	A3 => CI);
UQVB_B55 : AND4
	PORT MAP (Z0 => UQVN_N39, A0 => A1, A1 => B0, A2 => UQVN_N53, 
	A3 => CI);
UQVB_B56 : AND4
	PORT MAP (Z0 => UQVN_N38, A0 => A0, A1 => A1, A2 => UQVN_N53, 
	A3 => CI);
UQVB_B57 : AND4
	PORT MAP (Z0 => UQVN_N37, A0 => A0, A1 => B0, A2 => B1, 
	A3 => UQVN_N53);
UQVB_B58 : AND3
	PORT MAP (Z0 => UQVN_N36, A0 => A1, A1 => B1, A2 => UQVN_N53);
UQVB_B59 : AND4
	PORT MAP (Z0 => UQVN_N35, A0 => A0, A1 => A1, A2 => B0, 
	A3 => UQVN_N53);
UQVB_B60 : AND4
	PORT MAP (Z0 => UQVN_N34, A0 => UQVN_N48, A1 => UQVN_N51, A2 => UQVN_N52, 
	A3 => B2);
UQVB_B61 : AND3
	PORT MAP (Z0 => UQVN_N33, A0 => UQVN_N49, A1 => UQVN_N52, A2 => B2);
UQVB_B62 : AND4
	PORT MAP (Z0 => UQVN_N32, A0 => UQVN_N48, A1 => UQVN_N49, A2 => UQVN_N51, 
	A3 => B2);
UQVB_B63 : OR12
	PORT MAP (Z0 => UQVN_N47, A0 => UQVN_N43, A1 => UQVN_N42, A2 => UQVN_N41, 
	A3 => UQVN_N40, A4 => UQVN_N39, A5 => UQVN_N38, A6 => UQVN_N37, 
	A7 => UQVN_N36, A8 => UQVN_N35, A9 => UQVN_N34, A10 => UQVN_N33, 
	A11 => UQVN_N32);
UQVB_B64 : OR3
	PORT MAP (Z0 => UQVN_N45, A0 => UQVN_N44, A1 => UQVN_N46, A2 => UQVN_N47);
UQVB_B65 : INV
	PORT MAP (ZN0 => UQVN_N97, A0 => UQVN_N239);
UQVB_B66 : INV
	PORT MAP (ZN0 => UQVN_N95, A0 => B4);
UQVB_B67 : INV
	PORT MAP (ZN0 => UQVN_N96, A0 => B5);
UQVB_B68 : INV
	PORT MAP (ZN0 => UQVN_N91, A0 => A3);
UQVB_B69 : AND2
	PORT MAP (Z0 => UQVN_N55, A0 => UQVN_N94, A1 => UQVN_N239);
UQVB_B70 : AND2
	PORT MAP (Z0 => UQVN_N56, A0 => B3, A1 => UQVN_N97);
UQVB_B71 : OR2
	PORT MAP (Z0 => UQVN_N57, A0 => UQVN_N55, A1 => UQVN_N56);
UQVB_B72 : LXOR2
	PORT MAP (Z0 => Z3, A0 => A3, A1 => UQVN_N57);
UQVB_B73 : AND3
	PORT MAP (Z0 => UQVN_N63, A0 => UQVN_N91, A1 => B4, A2 => UQVN_N94);
UQVB_B74 : AND3
	PORT MAP (Z0 => UQVN_N59, A0 => UQVN_N95, A1 => B3, A2 => UQVN_N239);
UQVB_B75 : AND3
	PORT MAP (Z0 => UQVN_N58, A0 => A3, A1 => UQVN_N95, A2 => UQVN_N239);
UQVB_B76 : AND3
	PORT MAP (Z0 => UQVN_N60, A0 => B4, A1 => UQVN_N94, A2 => UQVN_N97);
UQVB_B77 : AND3
	PORT MAP (Z0 => UQVN_N61, A0 => UQVN_N91, A1 => B4, A2 => UQVN_N97);
UQVB_B78 : OR6
	PORT MAP (Z0 => UQVN_N64, A0 => UQVN_N61, A1 => UQVN_N60, A2 => UQVN_N58, 
	A3 => UQVN_N59, A4 => UQVN_N63, A5 => UQVN_N62);
UQVB_B79 : LXOR2
	PORT MAP (Z0 => Z4, A0 => A4, A1 => UQVN_N64);
UQVB_B80 : AND3
	PORT MAP (Z0 => UQVN_N62, A0 => A3, A1 => UQVN_N95, A2 => B3);
UQVB_B81 : AND4
	PORT MAP (Z0 => UQVN_N68, A0 => A3, A1 => A4, A2 => A5, 
	A3 => B3);
UQVB_B82 : AND3
	PORT MAP (Z0 => UQVN_N67, A0 => A4, A1 => A5, A2 => B4);
UQVB_B83 : AND4
	PORT MAP (Z0 => UQVN_N66, A0 => A3, A1 => A5, A2 => B3, 
	A3 => B4);
UQVB_B84 : AND2
	PORT MAP (Z0 => UQVN_N65, A0 => A5, A1 => B5);
UQVB_B85 : AND4
	PORT MAP (Z0 => UQVN_N69, A0 => A3, A1 => A4, A2 => B3, 
	A3 => B5);
UQVB_B86 : AND3
	PORT MAP (Z0 => UQVN_N70, A0 => A4, A1 => B4, A2 => B5);
UQVB_B87 : AND4
	PORT MAP (Z0 => UQVN_N71, A0 => A3, A1 => B3, A2 => B4, 
	A3 => B5);
UQVB_B88 : OR7
	PORT MAP (Z0 => G345, A0 => UQVN_N68, A1 => UQVN_N67, A2 => UQVN_N66, 
	A3 => UQVN_N65, A4 => UQVN_N69, A5 => UQVN_N70, A6 => UQVN_N71);
UQVB_B89 : AND2
	PORT MAP (Z0 => UQVN_N74, A0 => UQVN_N91, A1 => UQVN_N94);
UQVB_B90 : AND2
	PORT MAP (Z0 => UQVN_N72, A0 => UQVN_N92, A1 => UQVN_N95);
UQVB_B91 : AND2
	PORT MAP (Z0 => UQVN_N73, A0 => UQVN_N93, A1 => UQVN_N96);
UQVB_B92 : NOR3
	PORT MAP (ZN0 => P345, A0 => UQVN_N74, A1 => UQVN_N72, A2 => UQVN_N73);
UQVB_B93 : INV
	PORT MAP (ZN0 => UQVN_N94, A0 => B3);
UQVB_B94 : INV
	PORT MAP (ZN0 => UQVN_N92, A0 => A4);
UQVB_B95 : INV
	PORT MAP (ZN0 => UQVN_N93, A0 => A5);
UQVB_B96 : LXOR2
	PORT MAP (Z0 => Z5, A0 => A5, A1 => UQVN_N88);
UQVB_B97 : AND4
	PORT MAP (Z0 => UQVN_N87, A0 => UQVN_N94, A1 => UQVN_N95, A2 => B5, 
	A3 => UQVN_N97);
UQVB_B98 : AND4
	PORT MAP (Z0 => UQVN_N89, A0 => UQVN_N91, A1 => UQVN_N95, A2 => B5, 
	A3 => UQVN_N97);
UQVB_B99 : AND4
	PORT MAP (Z0 => UQVN_N86, A0 => UQVN_N92, A1 => UQVN_N94, A2 => B5, 
	A3 => UQVN_N97);
UQVB_B100 : AND4
	PORT MAP (Z0 => UQVN_N85, A0 => UQVN_N91, A1 => UQVN_N92, A2 => B5, 
	A3 => UQVN_N97);
UQVB_B101 : AND4
	PORT MAP (Z0 => UQVN_N84, A0 => B3, A1 => B4, A2 => UQVN_N96, 
	A3 => UQVN_N239);
UQVB_B102 : AND4
	PORT MAP (Z0 => UQVN_N83, A0 => A3, A1 => B4, A2 => UQVN_N96, 
	A3 => UQVN_N239);
UQVB_B103 : AND4
	PORT MAP (Z0 => UQVN_N82, A0 => A4, A1 => B3, A2 => UQVN_N96, 
	A3 => UQVN_N239);
UQVB_B104 : AND4
	PORT MAP (Z0 => UQVN_N81, A0 => A3, A1 => A4, A2 => UQVN_N96, 
	A3 => UQVN_N239);
UQVB_B105 : AND4
	PORT MAP (Z0 => UQVN_N80, A0 => A3, A1 => B3, A2 => B4, 
	A3 => UQVN_N96);
UQVB_B106 : AND3
	PORT MAP (Z0 => UQVN_N79, A0 => A4, A1 => B4, A2 => UQVN_N96);
UQVB_B107 : AND4
	PORT MAP (Z0 => UQVN_N78, A0 => A3, A1 => A4, A2 => B3, 
	A3 => UQVN_N96);
UQVB_B108 : AND4
	PORT MAP (Z0 => UQVN_N77, A0 => UQVN_N91, A1 => UQVN_N94, A2 => UQVN_N95, 
	A3 => B5);
UQVB_B109 : AND3
	PORT MAP (Z0 => UQVN_N76, A0 => UQVN_N92, A1 => UQVN_N95, A2 => B5);
UQVB_B110 : AND4
	PORT MAP (Z0 => UQVN_N75, A0 => UQVN_N91, A1 => UQVN_N92, A2 => UQVN_N94, 
	A3 => B5);
UQVB_B111 : OR12
	PORT MAP (Z0 => UQVN_N90, A0 => UQVN_N86, A1 => UQVN_N85, A2 => UQVN_N84, 
	A3 => UQVN_N83, A4 => UQVN_N82, A5 => UQVN_N81, A6 => UQVN_N80, 
	A7 => UQVN_N79, A8 => UQVN_N78, A9 => UQVN_N77, A10 => UQVN_N76, 
	A11 => UQVN_N75);
UQVB_B112 : OR3
	PORT MAP (Z0 => UQVN_N88, A0 => UQVN_N87, A1 => UQVN_N89, A2 => UQVN_N90);
UQVB_B113 : INV
	PORT MAP (ZN0 => UQVN_N140, A0 => UQVN_N235);
UQVB_B114 : INV
	PORT MAP (ZN0 => UQVN_N138, A0 => B7);
UQVB_B115 : INV
	PORT MAP (ZN0 => UQVN_N139, A0 => B8);
UQVB_B116 : INV
	PORT MAP (ZN0 => UQVN_N134, A0 => A6);
UQVB_B117 : AND2
	PORT MAP (Z0 => UQVN_N98, A0 => UQVN_N137, A1 => UQVN_N235);
UQVB_B118 : AND2
	PORT MAP (Z0 => UQVN_N99, A0 => B6, A1 => UQVN_N140);
UQVB_B119 : OR2
	PORT MAP (Z0 => UQVN_N100, A0 => UQVN_N98, A1 => UQVN_N99);
UQVB_B120 : LXOR2
	PORT MAP (Z0 => Z6, A0 => A6, A1 => UQVN_N100);
UQVB_B121 : AND3
	PORT MAP (Z0 => UQVN_N106, A0 => UQVN_N134, A1 => B7, A2 => UQVN_N137);
UQVB_B122 : AND3
	PORT MAP (Z0 => UQVN_N102, A0 => UQVN_N138, A1 => B6, A2 => UQVN_N235);
UQVB_B123 : AND3
	PORT MAP (Z0 => UQVN_N101, A0 => A6, A1 => UQVN_N138, A2 => UQVN_N235);
UQVB_B124 : AND3
	PORT MAP (Z0 => UQVN_N103, A0 => B7, A1 => UQVN_N137, A2 => UQVN_N140);
UQVB_B125 : AND3
	PORT MAP (Z0 => UQVN_N104, A0 => UQVN_N134, A1 => B7, A2 => UQVN_N140);
UQVB_B126 : OR6
	PORT MAP (Z0 => UQVN_N107, A0 => UQVN_N104, A1 => UQVN_N103, A2 => UQVN_N101, 
	A3 => UQVN_N102, A4 => UQVN_N106, A5 => UQVN_N105);
UQVB_B127 : LXOR2
	PORT MAP (Z0 => Z7, A0 => A7, A1 => UQVN_N107);
UQVB_B128 : AND3
	PORT MAP (Z0 => UQVN_N105, A0 => A6, A1 => UQVN_N138, A2 => B6);
UQVB_B129 : AND4
	PORT MAP (Z0 => UQVN_N111, A0 => A6, A1 => A7, A2 => A8, 
	A3 => B6);
UQVB_B130 : AND3
	PORT MAP (Z0 => UQVN_N110, A0 => A7, A1 => A8, A2 => B7);
UQVB_B131 : AND4
	PORT MAP (Z0 => UQVN_N109, A0 => A6, A1 => A8, A2 => B6, 
	A3 => B7);
UQVB_B132 : AND2
	PORT MAP (Z0 => UQVN_N108, A0 => A8, A1 => B8);
UQVB_B133 : AND4
	PORT MAP (Z0 => UQVN_N112, A0 => A6, A1 => A7, A2 => B6, 
	A3 => B8);
UQVB_B134 : AND3
	PORT MAP (Z0 => UQVN_N113, A0 => A7, A1 => B7, A2 => B8);
UQVB_B135 : AND4
	PORT MAP (Z0 => UQVN_N114, A0 => A6, A1 => B6, A2 => B7, 
	A3 => B8);
UQVB_B136 : OR7
	PORT MAP (Z0 => G678, A0 => UQVN_N111, A1 => UQVN_N110, A2 => UQVN_N109, 
	A3 => UQVN_N108, A4 => UQVN_N112, A5 => UQVN_N113, A6 => UQVN_N114);
UQVB_B137 : AND2
	PORT MAP (Z0 => UQVN_N117, A0 => UQVN_N134, A1 => UQVN_N137);
UQVB_B138 : AND2
	PORT MAP (Z0 => UQVN_N115, A0 => UQVN_N135, A1 => UQVN_N138);
UQVB_B139 : AND2
	PORT MAP (Z0 => UQVN_N116, A0 => UQVN_N136, A1 => UQVN_N139);
UQVB_B140 : NOR3
	PORT MAP (ZN0 => P678, A0 => UQVN_N117, A1 => UQVN_N115, A2 => UQVN_N116);
UQVB_B141 : INV
	PORT MAP (ZN0 => UQVN_N137, A0 => B6);
UQVB_B142 : INV
	PORT MAP (ZN0 => UQVN_N135, A0 => A7);
UQVB_B143 : INV
	PORT MAP (ZN0 => UQVN_N136, A0 => A8);
UQVB_B144 : LXOR2
	PORT MAP (Z0 => Z8, A0 => A8, A1 => UQVN_N131);
UQVB_B145 : AND4
	PORT MAP (Z0 => UQVN_N130, A0 => UQVN_N137, A1 => UQVN_N138, A2 => B8, 
	A3 => UQVN_N140);
UQVB_B146 : AND4
	PORT MAP (Z0 => UQVN_N132, A0 => UQVN_N134, A1 => UQVN_N138, A2 => B8, 
	A3 => UQVN_N140);
UQVB_B147 : AND4
	PORT MAP (Z0 => UQVN_N129, A0 => UQVN_N135, A1 => UQVN_N137, A2 => B8, 
	A3 => UQVN_N140);
UQVB_B148 : AND4
	PORT MAP (Z0 => UQVN_N128, A0 => UQVN_N134, A1 => UQVN_N135, A2 => B8, 
	A3 => UQVN_N140);
UQVB_B149 : AND4
	PORT MAP (Z0 => UQVN_N127, A0 => B6, A1 => B7, A2 => UQVN_N139, 
	A3 => UQVN_N235);
UQVB_B150 : AND4
	PORT MAP (Z0 => UQVN_N126, A0 => A6, A1 => B7, A2 => UQVN_N139, 
	A3 => UQVN_N235);
UQVB_B151 : AND4
	PORT MAP (Z0 => UQVN_N125, A0 => A7, A1 => B6, A2 => UQVN_N139, 
	A3 => UQVN_N235);
UQVB_B152 : AND4
	PORT MAP (Z0 => UQVN_N124, A0 => A6, A1 => A7, A2 => UQVN_N139, 
	A3 => UQVN_N235);
UQVB_B153 : AND4
	PORT MAP (Z0 => UQVN_N123, A0 => A6, A1 => B6, A2 => B7, 
	A3 => UQVN_N139);
UQVB_B154 : AND3
	PORT MAP (Z0 => UQVN_N122, A0 => A7, A1 => B7, A2 => UQVN_N139);
UQVB_B155 : AND4
	PORT MAP (Z0 => UQVN_N121, A0 => A6, A1 => A7, A2 => B6, 
	A3 => UQVN_N139);
UQVB_B156 : AND4
	PORT MAP (Z0 => UQVN_N120, A0 => UQVN_N134, A1 => UQVN_N137, A2 => UQVN_N138, 
	A3 => B8);
UQVB_B157 : AND3
	PORT MAP (Z0 => UQVN_N119, A0 => UQVN_N135, A1 => UQVN_N138, A2 => B8);
UQVB_B158 : AND4
	PORT MAP (Z0 => UQVN_N118, A0 => UQVN_N134, A1 => UQVN_N135, A2 => UQVN_N137, 
	A3 => B8);
UQVB_B159 : OR12
	PORT MAP (Z0 => UQVN_N133, A0 => UQVN_N129, A1 => UQVN_N128, A2 => UQVN_N127, 
	A3 => UQVN_N126, A4 => UQVN_N125, A5 => UQVN_N124, A6 => UQVN_N123, 
	A7 => UQVN_N122, A8 => UQVN_N121, A9 => UQVN_N120, A10 => UQVN_N119, 
	A11 => UQVN_N118);
UQVB_B160 : OR3
	PORT MAP (Z0 => UQVN_N131, A0 => UQVN_N130, A1 => UQVN_N132, A2 => UQVN_N133);
UQVB_B161 : INV
	PORT MAP (ZN0 => UQVN_N183, A0 => UQVN_N236);
UQVB_B162 : INV
	PORT MAP (ZN0 => UQVN_N181, A0 => B10);
UQVB_B163 : INV
	PORT MAP (ZN0 => UQVN_N182, A0 => B11);
UQVB_B164 : INV
	PORT MAP (ZN0 => UQVN_N177, A0 => A9);
UQVB_B165 : AND2
	PORT MAP (Z0 => UQVN_N141, A0 => UQVN_N180, A1 => UQVN_N236);
UQVB_B166 : AND2
	PORT MAP (Z0 => UQVN_N142, A0 => B9, A1 => UQVN_N183);
UQVB_B167 : OR2
	PORT MAP (Z0 => UQVN_N143, A0 => UQVN_N141, A1 => UQVN_N142);
UQVB_B168 : LXOR2
	PORT MAP (Z0 => Z9, A0 => A9, A1 => UQVN_N143);
UQVB_B169 : AND3
	PORT MAP (Z0 => UQVN_N149, A0 => UQVN_N177, A1 => B10, A2 => UQVN_N180);
UQVB_B170 : AND3
	PORT MAP (Z0 => UQVN_N145, A0 => UQVN_N181, A1 => B9, A2 => UQVN_N236);
UQVB_B171 : AND3
	PORT MAP (Z0 => UQVN_N144, A0 => A9, A1 => UQVN_N181, A2 => UQVN_N236);
UQVB_B172 : AND3
	PORT MAP (Z0 => UQVN_N146, A0 => B10, A1 => UQVN_N180, A2 => UQVN_N183);
UQVB_B173 : AND3
	PORT MAP (Z0 => UQVN_N147, A0 => UQVN_N177, A1 => B10, A2 => UQVN_N183);
UQVB_B174 : OR6
	PORT MAP (Z0 => UQVN_N150, A0 => UQVN_N147, A1 => UQVN_N146, A2 => UQVN_N144, 
	A3 => UQVN_N145, A4 => UQVN_N149, A5 => UQVN_N148);
UQVB_B175 : LXOR2
	PORT MAP (Z0 => Z10, A0 => A10, A1 => UQVN_N150);
UQVB_B176 : AND3
	PORT MAP (Z0 => UQVN_N148, A0 => A9, A1 => UQVN_N181, A2 => B9);
UQVB_B177 : AND4
	PORT MAP (Z0 => UQVN_N154, A0 => A9, A1 => A10, A2 => A11, 
	A3 => B9);
UQVB_B178 : AND3
	PORT MAP (Z0 => UQVN_N153, A0 => A10, A1 => A11, A2 => B10);
UQVB_B179 : AND4
	PORT MAP (Z0 => UQVN_N152, A0 => A9, A1 => A11, A2 => B9, 
	A3 => B10);
UQVB_B180 : AND2
	PORT MAP (Z0 => UQVN_N151, A0 => A11, A1 => B11);
UQVB_B181 : AND4
	PORT MAP (Z0 => UQVN_N155, A0 => A9, A1 => A10, A2 => B9, 
	A3 => B11);
UQVB_B182 : AND3
	PORT MAP (Z0 => UQVN_N156, A0 => A10, A1 => B10, A2 => B11);
UQVB_B183 : AND4
	PORT MAP (Z0 => UQVN_N157, A0 => A9, A1 => B9, A2 => B10, 
	A3 => B11);
UQVB_B184 : OR7
	PORT MAP (Z0 => G911, A0 => UQVN_N154, A1 => UQVN_N153, A2 => UQVN_N152, 
	A3 => UQVN_N151, A4 => UQVN_N155, A5 => UQVN_N156, A6 => UQVN_N157);
UQVB_B185 : AND2
	PORT MAP (Z0 => UQVN_N160, A0 => UQVN_N177, A1 => UQVN_N180);
UQVB_B186 : AND2
	PORT MAP (Z0 => UQVN_N158, A0 => UQVN_N178, A1 => UQVN_N181);
UQVB_B187 : AND2
	PORT MAP (Z0 => UQVN_N159, A0 => UQVN_N179, A1 => UQVN_N182);
UQVB_B188 : NOR3
	PORT MAP (ZN0 => P911, A0 => UQVN_N160, A1 => UQVN_N158, A2 => UQVN_N159);
UQVB_B189 : INV
	PORT MAP (ZN0 => UQVN_N180, A0 => B9);
UQVB_B190 : INV
	PORT MAP (ZN0 => UQVN_N178, A0 => A10);
UQVB_B191 : INV
	PORT MAP (ZN0 => UQVN_N179, A0 => A11);
UQVB_B192 : LXOR2
	PORT MAP (Z0 => Z11, A0 => A11, A1 => UQVN_N174);
UQVB_B193 : AND4
	PORT MAP (Z0 => UQVN_N173, A0 => UQVN_N180, A1 => UQVN_N181, A2 => B11, 
	A3 => UQVN_N183);
UQVB_B194 : AND4
	PORT MAP (Z0 => UQVN_N175, A0 => UQVN_N177, A1 => UQVN_N181, A2 => B11, 
	A3 => UQVN_N183);
UQVB_B195 : AND4
	PORT MAP (Z0 => UQVN_N172, A0 => UQVN_N178, A1 => UQVN_N180, A2 => B11, 
	A3 => UQVN_N183);
UQVB_B196 : AND4
	PORT MAP (Z0 => UQVN_N171, A0 => UQVN_N177, A1 => UQVN_N178, A2 => B11, 
	A3 => UQVN_N183);
UQVB_B197 : AND4
	PORT MAP (Z0 => UQVN_N170, A0 => B9, A1 => B10, A2 => UQVN_N182, 
	A3 => UQVN_N236);
UQVB_B198 : AND4
	PORT MAP (Z0 => UQVN_N169, A0 => A9, A1 => B10, A2 => UQVN_N182, 
	A3 => UQVN_N236);
UQVB_B199 : AND4
	PORT MAP (Z0 => UQVN_N168, A0 => A10, A1 => B9, A2 => UQVN_N182, 
	A3 => UQVN_N236);
UQVB_B200 : AND4
	PORT MAP (Z0 => UQVN_N167, A0 => A9, A1 => A10, A2 => UQVN_N182, 
	A3 => UQVN_N236);
UQVB_B201 : AND4
	PORT MAP (Z0 => UQVN_N166, A0 => A9, A1 => B9, A2 => B10, 
	A3 => UQVN_N182);
UQVB_B202 : AND3
	PORT MAP (Z0 => UQVN_N165, A0 => A10, A1 => B10, A2 => UQVN_N182);
UQVB_B203 : AND4
	PORT MAP (Z0 => UQVN_N164, A0 => A9, A1 => A10, A2 => B9, 
	A3 => UQVN_N182);
UQVB_B204 : AND4
	PORT MAP (Z0 => UQVN_N163, A0 => UQVN_N177, A1 => UQVN_N180, A2 => UQVN_N181, 
	A3 => B11);
UQVB_B205 : AND3
	PORT MAP (Z0 => UQVN_N162, A0 => UQVN_N178, A1 => UQVN_N181, A2 => B11);
UQVB_B206 : AND4
	PORT MAP (Z0 => UQVN_N161, A0 => UQVN_N177, A1 => UQVN_N178, A2 => UQVN_N180, 
	A3 => B11);
UQVB_B207 : OR12
	PORT MAP (Z0 => UQVN_N176, A0 => UQVN_N172, A1 => UQVN_N171, A2 => UQVN_N170, 
	A3 => UQVN_N169, A4 => UQVN_N168, A5 => UQVN_N167, A6 => UQVN_N166, 
	A7 => UQVN_N165, A8 => UQVN_N164, A9 => UQVN_N163, A10 => UQVN_N162, 
	A11 => UQVN_N161);
UQVB_B208 : OR3
	PORT MAP (Z0 => UQVN_N174, A0 => UQVN_N173, A1 => UQVN_N175, A2 => UQVN_N176);
UQVB_B209 : INV
	PORT MAP (ZN0 => UQVN_N226, A0 => UQVN_N237);
UQVB_B210 : INV
	PORT MAP (ZN0 => UQVN_N224, A0 => B13);
UQVB_B211 : INV
	PORT MAP (ZN0 => UQVN_N225, A0 => B14);
UQVB_B212 : INV
	PORT MAP (ZN0 => UQVN_N220, A0 => A12);
UQVB_B213 : AND2
	PORT MAP (Z0 => UQVN_N184, A0 => UQVN_N223, A1 => UQVN_N237);
UQVB_B214 : AND2
	PORT MAP (Z0 => UQVN_N185, A0 => B12, A1 => UQVN_N226);
UQVB_B215 : OR2
	PORT MAP (Z0 => UQVN_N186, A0 => UQVN_N184, A1 => UQVN_N185);
UQVB_B216 : LXOR2
	PORT MAP (Z0 => Z12, A0 => A12, A1 => UQVN_N186);
UQVB_B217 : AND3
	PORT MAP (Z0 => UQVN_N192, A0 => UQVN_N220, A1 => B13, A2 => UQVN_N223);
UQVB_B218 : AND3
	PORT MAP (Z0 => UQVN_N188, A0 => UQVN_N224, A1 => B12, A2 => UQVN_N237);
UQVB_B219 : AND3
	PORT MAP (Z0 => UQVN_N187, A0 => A12, A1 => UQVN_N224, A2 => UQVN_N237);
UQVB_B220 : AND3
	PORT MAP (Z0 => UQVN_N189, A0 => B13, A1 => UQVN_N223, A2 => UQVN_N226);
UQVB_B221 : AND3
	PORT MAP (Z0 => UQVN_N190, A0 => UQVN_N220, A1 => B13, A2 => UQVN_N226);
UQVB_B222 : OR6
	PORT MAP (Z0 => UQVN_N193, A0 => UQVN_N190, A1 => UQVN_N189, A2 => UQVN_N187, 
	A3 => UQVN_N188, A4 => UQVN_N192, A5 => UQVN_N191);
UQVB_B223 : LXOR2
	PORT MAP (Z0 => Z13, A0 => A13, A1 => UQVN_N193);
UQVB_B224 : AND3
	PORT MAP (Z0 => UQVN_N191, A0 => A12, A1 => UQVN_N224, A2 => B12);
UQVB_B225 : AND4
	PORT MAP (Z0 => UQVN_N197, A0 => A12, A1 => A13, A2 => A14, 
	A3 => B12);
UQVB_B226 : AND3
	PORT MAP (Z0 => UQVN_N196, A0 => A13, A1 => A14, A2 => B13);
UQVB_B227 : AND4
	PORT MAP (Z0 => UQVN_N195, A0 => A12, A1 => A14, A2 => B12, 
	A3 => B13);
UQVB_B228 : AND2
	PORT MAP (Z0 => UQVN_N194, A0 => A14, A1 => B14);
UQVB_B229 : AND4
	PORT MAP (Z0 => UQVN_N198, A0 => A12, A1 => A13, A2 => B12, 
	A3 => B14);
UQVB_B230 : AND3
	PORT MAP (Z0 => UQVN_N199, A0 => A13, A1 => B13, A2 => B14);
UQVB_B231 : AND4
	PORT MAP (Z0 => UQVN_N200, A0 => A12, A1 => B12, A2 => B13, 
	A3 => B14);
UQVB_B232 : OR7
	PORT MAP (Z0 => G1214, A0 => UQVN_N197, A1 => UQVN_N196, A2 => UQVN_N195, 
	A3 => UQVN_N194, A4 => UQVN_N198, A5 => UQVN_N199, A6 => UQVN_N200);
UQVB_B233 : AND2
	PORT MAP (Z0 => UQVN_N203, A0 => UQVN_N220, A1 => UQVN_N223);
UQVB_B234 : AND2
	PORT MAP (Z0 => UQVN_N201, A0 => UQVN_N221, A1 => UQVN_N224);
UQVB_B235 : AND2
	PORT MAP (Z0 => UQVN_N202, A0 => UQVN_N222, A1 => UQVN_N225);
UQVB_B236 : NOR3
	PORT MAP (ZN0 => P1214, A0 => UQVN_N203, A1 => UQVN_N201, A2 => UQVN_N202);
UQVB_B237 : INV
	PORT MAP (ZN0 => UQVN_N223, A0 => B12);
UQVB_B238 : INV
	PORT MAP (ZN0 => UQVN_N221, A0 => A13);
UQVB_B239 : INV
	PORT MAP (ZN0 => UQVN_N222, A0 => A14);
UQVB_B240 : LXOR2
	PORT MAP (Z0 => Z14, A0 => A14, A1 => UQVN_N217);
UQVB_B241 : AND4
	PORT MAP (Z0 => UQVN_N216, A0 => UQVN_N223, A1 => UQVN_N224, A2 => B14, 
	A3 => UQVN_N226);
UQVB_B242 : AND4
	PORT MAP (Z0 => UQVN_N218, A0 => UQVN_N220, A1 => UQVN_N224, A2 => B14, 
	A3 => UQVN_N226);
UQVB_B243 : AND4
	PORT MAP (Z0 => UQVN_N215, A0 => UQVN_N221, A1 => UQVN_N223, A2 => B14, 
	A3 => UQVN_N226);
UQVB_B244 : AND4
	PORT MAP (Z0 => UQVN_N214, A0 => UQVN_N220, A1 => UQVN_N221, A2 => B14, 
	A3 => UQVN_N226);
UQVB_B245 : AND4
	PORT MAP (Z0 => UQVN_N213, A0 => B12, A1 => B13, A2 => UQVN_N225, 
	A3 => UQVN_N237);
UQVB_B246 : AND4
	PORT MAP (Z0 => UQVN_N212, A0 => A12, A1 => B13, A2 => UQVN_N225, 
	A3 => UQVN_N237);
UQVB_B247 : AND4
	PORT MAP (Z0 => UQVN_N211, A0 => A13, A1 => B12, A2 => UQVN_N225, 
	A3 => UQVN_N237);
UQVB_B248 : AND4
	PORT MAP (Z0 => UQVN_N210, A0 => A12, A1 => A13, A2 => UQVN_N225, 
	A3 => UQVN_N237);
UQVB_B249 : AND4
	PORT MAP (Z0 => UQVN_N209, A0 => A12, A1 => B12, A2 => B13, 
	A3 => UQVN_N225);
UQVB_B250 : AND3
	PORT MAP (Z0 => UQVN_N208, A0 => A13, A1 => B13, A2 => UQVN_N225);
UQVB_B251 : AND4
	PORT MAP (Z0 => UQVN_N207, A0 => A12, A1 => A13, A2 => B12, 
	A3 => UQVN_N225);
UQVB_B252 : AND4
	PORT MAP (Z0 => UQVN_N206, A0 => UQVN_N220, A1 => UQVN_N223, A2 => UQVN_N224, 
	A3 => B14);
UQVB_B253 : AND3
	PORT MAP (Z0 => UQVN_N205, A0 => UQVN_N221, A1 => UQVN_N224, A2 => B14);
UQVB_B254 : AND4
	PORT MAP (Z0 => UQVN_N204, A0 => UQVN_N220, A1 => UQVN_N221, A2 => UQVN_N223, 
	A3 => B14);
UQVB_B255 : OR12
	PORT MAP (Z0 => UQVN_N219, A0 => UQVN_N215, A1 => UQVN_N214, A2 => UQVN_N213, 
	A3 => UQVN_N212, A4 => UQVN_N211, A5 => UQVN_N210, A6 => UQVN_N209, 
	A7 => UQVN_N208, A8 => UQVN_N207, A9 => UQVN_N206, A10 => UQVN_N205, 
	A11 => UQVN_N204);
UQVB_B256 : OR3
	PORT MAP (Z0 => UQVN_N217, A0 => UQVN_N216, A1 => UQVN_N218, A2 => UQVN_N219);
UQVB_B257 : AND2
	PORT MAP (Z0 => UQVN_N228, A0 => UQVN_N234, A1 => UQVN_N238);
UQVB_B258 : AND2
	PORT MAP (Z0 => UQVN_N229, A0 => B15, A1 => UQVN_N227);
UQVB_B259 : OR2
	PORT MAP (Z0 => UQVN_N230, A0 => UQVN_N229, A1 => UQVN_N228);
UQVB_B260 : XOR2
	PORT MAP (Z0 => Z15, A0 => A15, A1 => UQVN_N230);
UQVB_B261 : INV
	PORT MAP (ZN0 => UQVN_N234, A0 => B15);
UQVB_B262 : INV
	PORT MAP (ZN0 => UQVN_N227, A0 => UQVN_N238);
UQVB_B263 : AND2
	PORT MAP (Z0 => UQVN_N231, A0 => UQVN_N238, A1 => B15);
UQVB_B264 : AND2
	PORT MAP (Z0 => UQVN_N232, A0 => UQVN_N238, A1 => A15);
UQVB_B265 : AND2
	PORT MAP (Z0 => UQVN_N233, A0 => B15, A1 => A15);
UQVB_B266 : OR3
	PORT MAP (Z0 => CO, A0 => UQVN_N231, A1 => UQVN_N232, A2 => UQVN_N233);
END lattice_arch;
-- VHDL netlist for ADDF2
-- Date: 15.5.95 13.44.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY ADDF2 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        B0 : IN std_logic;
        B1 : IN std_logic;
        CI : IN std_logic;
        Z0 : OUT std_logic;
        Z1 : OUT std_logic;
        CO : OUT std_logic
    );
END ADDF2;


ARCHITECTURE lattice_arch OF ADDF2 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21 : std_logic;


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT OR7
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR7 use  entity  lattice.OR7(lattice_arch);


  COMPONENT OR6
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR6 use  entity  lattice.OR6(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


  COMPONENT XOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: XOR2 use  entity  lattice.XOR2(lattice_arch);


  COMPONENT OR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR2 use  entity  lattice.OR2(lattice_arch);


BEGIN

UQVB_B1 : INV
	PORT MAP (ZN0 => UQVN_N21, A0 => CI);
UQVB_B2 : AND3
	PORT MAP (Z0 => UQVN_N3, A0 => CI, A1 => A1, A2 => A0);
UQVB_B3 : AND3
	PORT MAP (Z0 => UQVN_N2, A0 => CI, A1 => A1, A2 => B0);
UQVB_B4 : AND3
	PORT MAP (Z0 => UQVN_N1, A0 => CI, A1 => A0, A2 => B1);
UQVB_B5 : AND3
	PORT MAP (Z0 => UQVN_N4, A0 => CI, A1 => B1, A2 => B0);
UQVB_B6 : AND3
	PORT MAP (Z0 => UQVN_N5, A0 => A1, A1 => A0, A2 => B0);
UQVB_B7 : AND3
	PORT MAP (Z0 => UQVN_N7, A0 => A0, A1 => B1, A2 => B0);
UQVB_B8 : AND2
	PORT MAP (Z0 => UQVN_N6, A0 => A1, A1 => B1);
UQVB_B9 : OR7
	PORT MAP (Z0 => CO, A0 => UQVN_N3, A1 => UQVN_N2, A2 => UQVN_N1, 
	A3 => UQVN_N4, A4 => UQVN_N5, A5 => UQVN_N7, A6 => UQVN_N6);
UQVB_B10 : AND3
	PORT MAP (Z0 => UQVN_N8, A0 => UQVN_N18, A1 => B1, A2 => UQVN_N21);
UQVB_B11 : AND3
	PORT MAP (Z0 => UQVN_N9, A0 => B1, A1 => UQVN_N19, A2 => UQVN_N21);
UQVB_B12 : AND3
	PORT MAP (Z0 => UQVN_N10, A0 => A0, A1 => UQVN_N20, A2 => CI);
UQVB_B13 : AND3
	PORT MAP (Z0 => UQVN_N11, A0 => UQVN_N20, A1 => B0, A2 => CI);
UQVB_B14 : AND3
	PORT MAP (Z0 => UQVN_N12, A0 => UQVN_N18, A1 => B1, A2 => UQVN_N19);
UQVB_B15 : AND3
	PORT MAP (Z0 => UQVN_N13, A0 => A0, A1 => UQVN_N20, A2 => B0);
UQVB_B16 : OR6
	PORT MAP (Z0 => UQVN_N14, A0 => UQVN_N8, A1 => UQVN_N9, A2 => UQVN_N10, 
	A3 => UQVN_N11, A4 => UQVN_N12, A5 => UQVN_N13);
UQVB_B17 : LXOR2
	PORT MAP (Z0 => Z1, A0 => A1, A1 => UQVN_N14);
UQVB_B18 : INV
	PORT MAP (ZN0 => UQVN_N19, A0 => B0);
UQVB_B19 : INV
	PORT MAP (ZN0 => UQVN_N20, A0 => B1);
UQVB_B20 : INV
	PORT MAP (ZN0 => UQVN_N18, A0 => A0);
UQVB_B21 : XOR2
	PORT MAP (Z0 => Z0, A0 => A0, A1 => UQVN_N15);
UQVB_B22 : AND2
	PORT MAP (Z0 => UQVN_N16, A0 => CI, A1 => UQVN_N19);
UQVB_B23 : OR2
	PORT MAP (Z0 => UQVN_N15, A0 => UQVN_N16, A1 => UQVN_N17);
UQVB_B24 : AND2
	PORT MAP (Z0 => UQVN_N17, A0 => UQVN_N21, A1 => B0);
END lattice_arch;
-- VHDL netlist for ADDF4
-- Date: 15.5.95 13.44.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY ADDF4 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        B0 : IN std_logic;
        B1 : IN std_logic;
        B2 : IN std_logic;
        B3 : IN std_logic;
        CI : IN std_logic;
        Z0 : OUT std_logic;
        Z1 : OUT std_logic;
        Z2 : OUT std_logic;
        Z3 : OUT std_logic;
        CO : OUT std_logic
    );
END ADDF4;


ARCHITECTURE lattice_arch OF ADDF4 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, UQVN_N23, UQVN_N24,
	 UQVN_N25, UQVN_N26, UQVN_N27, UQVN_N28,
	 UQVN_N29, UQVN_N30, UQVN_N31, UQVN_N32,
	 UQVN_N33, UQVN_N34, UQVN_N35, UQVN_N36,
	 UQVN_N37, UQVN_N38, UQVN_N39, UQVN_N40,
	 UQVN_N41, UQVN_N42, UQVN_N43 : std_logic;


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT OR7
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR7 use  entity  lattice.OR7(lattice_arch);


  COMPONENT OR6
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR6 use  entity  lattice.OR6(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


  COMPONENT XOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: XOR2 use  entity  lattice.XOR2(lattice_arch);


  COMPONENT OR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR2 use  entity  lattice.OR2(lattice_arch);


BEGIN

UQVB_B1 : INV
	PORT MAP (ZN0 => UQVN_N21, A0 => CI);
UQVB_B2 : AND3
	PORT MAP (Z0 => UQVN_N3, A0 => CI, A1 => A1, A2 => A0);
UQVB_B3 : AND3
	PORT MAP (Z0 => UQVN_N2, A0 => CI, A1 => A1, A2 => B0);
UQVB_B4 : AND3
	PORT MAP (Z0 => UQVN_N1, A0 => CI, A1 => A0, A2 => B1);
UQVB_B5 : AND3
	PORT MAP (Z0 => UQVN_N4, A0 => CI, A1 => B1, A2 => B0);
UQVB_B6 : AND3
	PORT MAP (Z0 => UQVN_N5, A0 => A1, A1 => A0, A2 => B0);
UQVB_B7 : AND3
	PORT MAP (Z0 => UQVN_N7, A0 => A0, A1 => B1, A2 => B0);
UQVB_B8 : AND2
	PORT MAP (Z0 => UQVN_N6, A0 => A1, A1 => B1);
UQVB_B9 : OR7
	PORT MAP (Z0 => UQVN_N43, A0 => UQVN_N3, A1 => UQVN_N2, A2 => UQVN_N1, 
	A3 => UQVN_N4, A4 => UQVN_N5, A5 => UQVN_N7, A6 => UQVN_N6);
UQVB_B10 : AND3
	PORT MAP (Z0 => UQVN_N8, A0 => UQVN_N18, A1 => B1, A2 => UQVN_N21);
UQVB_B11 : AND3
	PORT MAP (Z0 => UQVN_N9, A0 => B1, A1 => UQVN_N19, A2 => UQVN_N21);
UQVB_B12 : AND3
	PORT MAP (Z0 => UQVN_N10, A0 => A0, A1 => UQVN_N20, A2 => CI);
UQVB_B13 : AND3
	PORT MAP (Z0 => UQVN_N11, A0 => UQVN_N20, A1 => B0, A2 => CI);
UQVB_B14 : AND3
	PORT MAP (Z0 => UQVN_N12, A0 => UQVN_N18, A1 => B1, A2 => UQVN_N19);
UQVB_B15 : AND3
	PORT MAP (Z0 => UQVN_N13, A0 => A0, A1 => UQVN_N20, A2 => B0);
UQVB_B16 : OR6
	PORT MAP (Z0 => UQVN_N14, A0 => UQVN_N8, A1 => UQVN_N9, A2 => UQVN_N10, 
	A3 => UQVN_N11, A4 => UQVN_N12, A5 => UQVN_N13);
UQVB_B17 : LXOR2
	PORT MAP (Z0 => Z1, A0 => A1, A1 => UQVN_N14);
UQVB_B18 : INV
	PORT MAP (ZN0 => UQVN_N19, A0 => B0);
UQVB_B19 : INV
	PORT MAP (ZN0 => UQVN_N20, A0 => B1);
UQVB_B20 : INV
	PORT MAP (ZN0 => UQVN_N18, A0 => A0);
UQVB_B21 : XOR2
	PORT MAP (Z0 => Z0, A0 => A0, A1 => UQVN_N15);
UQVB_B22 : AND2
	PORT MAP (Z0 => UQVN_N16, A0 => CI, A1 => UQVN_N19);
UQVB_B23 : OR2
	PORT MAP (Z0 => UQVN_N15, A0 => UQVN_N16, A1 => UQVN_N17);
UQVB_B24 : AND2
	PORT MAP (Z0 => UQVN_N17, A0 => UQVN_N21, A1 => B0);
UQVB_B25 : INV
	PORT MAP (ZN0 => UQVN_N42, A0 => UQVN_N43);
UQVB_B26 : AND3
	PORT MAP (Z0 => UQVN_N24, A0 => UQVN_N43, A1 => A3, A2 => A2);
UQVB_B27 : AND3
	PORT MAP (Z0 => UQVN_N23, A0 => UQVN_N43, A1 => A3, A2 => B2);
UQVB_B28 : AND3
	PORT MAP (Z0 => UQVN_N22, A0 => UQVN_N43, A1 => A2, A2 => B3);
UQVB_B29 : AND3
	PORT MAP (Z0 => UQVN_N25, A0 => UQVN_N43, A1 => B3, A2 => B2);
UQVB_B30 : AND3
	PORT MAP (Z0 => UQVN_N26, A0 => A3, A1 => A2, A2 => B2);
UQVB_B31 : AND3
	PORT MAP (Z0 => UQVN_N28, A0 => A2, A1 => B3, A2 => B2);
UQVB_B32 : AND2
	PORT MAP (Z0 => UQVN_N27, A0 => A3, A1 => B3);
UQVB_B33 : OR7
	PORT MAP (Z0 => CO, A0 => UQVN_N24, A1 => UQVN_N23, A2 => UQVN_N22, 
	A3 => UQVN_N25, A4 => UQVN_N26, A5 => UQVN_N28, A6 => UQVN_N27);
UQVB_B34 : AND3
	PORT MAP (Z0 => UQVN_N29, A0 => UQVN_N39, A1 => B3, A2 => UQVN_N42);
UQVB_B35 : AND3
	PORT MAP (Z0 => UQVN_N30, A0 => B3, A1 => UQVN_N40, A2 => UQVN_N42);
UQVB_B36 : AND3
	PORT MAP (Z0 => UQVN_N31, A0 => A2, A1 => UQVN_N41, A2 => UQVN_N43);
UQVB_B37 : AND3
	PORT MAP (Z0 => UQVN_N32, A0 => UQVN_N41, A1 => B2, A2 => UQVN_N43);
UQVB_B38 : AND3
	PORT MAP (Z0 => UQVN_N33, A0 => UQVN_N39, A1 => B3, A2 => UQVN_N40);
UQVB_B39 : AND3
	PORT MAP (Z0 => UQVN_N34, A0 => A2, A1 => UQVN_N41, A2 => B2);
UQVB_B40 : OR6
	PORT MAP (Z0 => UQVN_N35, A0 => UQVN_N29, A1 => UQVN_N30, A2 => UQVN_N31, 
	A3 => UQVN_N32, A4 => UQVN_N33, A5 => UQVN_N34);
UQVB_B41 : LXOR2
	PORT MAP (Z0 => Z3, A0 => A3, A1 => UQVN_N35);
UQVB_B42 : INV
	PORT MAP (ZN0 => UQVN_N40, A0 => B2);
UQVB_B43 : INV
	PORT MAP (ZN0 => UQVN_N41, A0 => B3);
UQVB_B44 : INV
	PORT MAP (ZN0 => UQVN_N39, A0 => A2);
UQVB_B45 : XOR2
	PORT MAP (Z0 => Z2, A0 => A2, A1 => UQVN_N36);
UQVB_B46 : AND2
	PORT MAP (Z0 => UQVN_N37, A0 => UQVN_N43, A1 => UQVN_N40);
UQVB_B47 : OR2
	PORT MAP (Z0 => UQVN_N36, A0 => UQVN_N37, A1 => UQVN_N38);
UQVB_B48 : AND2
	PORT MAP (Z0 => UQVN_N38, A0 => UQVN_N42, A1 => B2);
END lattice_arch;
-- VHDL netlist for ADDF8
-- Date: 15.5.95 13.44.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY ADDF8 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        B0 : IN std_logic;
        B1 : IN std_logic;
        B2 : IN std_logic;
        B3 : IN std_logic;
        B4 : IN std_logic;
        B5 : IN std_logic;
        B6 : IN std_logic;
        B7 : IN std_logic;
        CI : IN std_logic;
        Z0 : OUT std_logic;
        Z1 : OUT std_logic;
        Z2 : OUT std_logic;
        Z3 : OUT std_logic;
        Z4 : OUT std_logic;
        Z5 : OUT std_logic;
        Z6 : OUT std_logic;
        Z7 : OUT std_logic;
        CO : OUT std_logic
    );
END ADDF8;


ARCHITECTURE lattice_arch OF ADDF8 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, UQVN_N23, UQVN_N24,
	 UQVN_N25, UQVN_N26, UQVN_N27, UQVN_N28,
	 UQVN_N29, UQVN_N30, UQVN_N31, UQVN_N32,
	 UQVN_N33, UQVN_N34, UQVN_N35, UQVN_N36,
	 UQVN_N37, UQVN_N38, UQVN_N39, UQVN_N40,
	 UQVN_N41, UQVN_N42, UQVN_N43, UQVN_N44,
	 UQVN_N45, UQVN_N46, UQVN_N47, UQVN_N48,
	 UQVN_N49, G0, G1, G2,
	 G3, G4, G5, G6,
	 G7, P0, P1, P2,
	 P3, P4, P5, P6,
	 P7 : std_logic;


  COMPONENT XOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: XOR2 use  entity  lattice.XOR2(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT AND8
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND8 use  entity  lattice.AND8(lattice_arch);


  COMPONENT OR6
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR6 use  entity  lattice.OR6(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


  COMPONENT AND7
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND7 use  entity  lattice.AND7(lattice_arch);


  COMPONENT OR5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR5 use  entity  lattice.OR5(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT OR3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR3 use  entity  lattice.OR3(lattice_arch);


  COMPONENT AND9
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND9 use  entity  lattice.AND9(lattice_arch);


  COMPONENT AND6
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND6 use  entity  lattice.AND6(lattice_arch);


  COMPONENT AND5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND5 use  entity  lattice.AND5(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT OR4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR4 use  entity  lattice.OR4(lattice_arch);


  COMPONENT OR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR2 use  entity  lattice.OR2(lattice_arch);


BEGIN

UQVB_B1 : XOR2
	PORT MAP (Z0 => P7, A0 => A7, A1 => B7);
UQVB_B2 : XOR2
	PORT MAP (Z0 => P6, A0 => A6, A1 => B6);
UQVB_B3 : XOR2
	PORT MAP (Z0 => P5, A0 => A5, A1 => B5);
UQVB_B4 : XOR2
	PORT MAP (Z0 => P4, A0 => A4, A1 => B4);
UQVB_B5 : XOR2
	PORT MAP (Z0 => P3, A0 => A3, A1 => B3);
UQVB_B6 : XOR2
	PORT MAP (Z0 => P2, A0 => A2, A1 => B2);
UQVB_B7 : XOR2
	PORT MAP (Z0 => P1, A0 => A1, A1 => B1);
UQVB_B8 : XOR2
	PORT MAP (Z0 => P0, A0 => A0, A1 => B0);
UQVB_B9 : AND2
	PORT MAP (Z0 => G7, A0 => A7, A1 => B7);
UQVB_B10 : AND2
	PORT MAP (Z0 => G6, A0 => A6, A1 => B6);
UQVB_B11 : AND2
	PORT MAP (Z0 => G5, A0 => A5, A1 => B5);
UQVB_B12 : AND2
	PORT MAP (Z0 => G4, A0 => A4, A1 => B4);
UQVB_B13 : AND2
	PORT MAP (Z0 => G3, A0 => A3, A1 => B3);
UQVB_B14 : AND2
	PORT MAP (Z0 => G2, A0 => A2, A1 => B2);
UQVB_B15 : AND2
	PORT MAP (Z0 => G1, A0 => A1, A1 => B1);
UQVB_B16 : AND2
	PORT MAP (Z0 => G0, A0 => A0, A1 => B0);
UQVB_B17 : AND8
	PORT MAP (Z0 => UQVN_N11, A0 => G0, A1 => P1, A2 => P2, 
	A3 => P3, A4 => P4, A5 => P5, A6 => P6, 
	A7 => P7);
UQVB_B18 : OR6
	PORT MAP (Z0 => UQVN_N6, A0 => UQVN_N3, A1 => UQVN_N2, A2 => UQVN_N1, 
	A3 => UQVN_N4, A4 => UQVN_N5, A5 => G4);
UQVB_B19 : LXOR2
	PORT MAP (Z0 => Z5, A0 => UQVN_N6, A1 => P5);
UQVB_B20 : AND7
	PORT MAP (Z0 => UQVN_N10, A0 => G1, A1 => P2, A2 => P3, 
	A3 => P4, A4 => P5, A5 => P6, A6 => P7);
UQVB_B21 : OR5
	PORT MAP (Z0 => UQVN_N18, A0 => UQVN_N15, A1 => UQVN_N14, A2 => UQVN_N17, 
	A3 => UQVN_N16, A4 => G7);
UQVB_B22 : AND2
	PORT MAP (Z0 => UQVN_N8, A0 => G0, A1 => P1);
UQVB_B23 : AND3
	PORT MAP (Z0 => UQVN_N7, A0 => CI, A1 => P0, A2 => P1);
UQVB_B24 : OR3
	PORT MAP (Z0 => UQVN_N9, A0 => UQVN_N7, A1 => UQVN_N8, A2 => G1);
UQVB_B25 : AND9
	PORT MAP (Z0 => UQVN_N13, A0 => CI, A1 => P0, A2 => P1, 
	A3 => P2, A4 => P3, A5 => P4, A6 => P5, 
	A7 => P6, A8 => P7);
UQVB_B26 : LXOR2
	PORT MAP (Z0 => Z2, A0 => UQVN_N9, A1 => P2);
UQVB_B27 : AND6
	PORT MAP (Z0 => UQVN_N12, A0 => G2, A1 => P3, A2 => P4, 
	A3 => P5, A4 => P6, A5 => P7);
UQVB_B28 : AND5
	PORT MAP (Z0 => UQVN_N15, A0 => G3, A1 => P4, A2 => P5, 
	A3 => P6, A4 => P7);
UQVB_B29 : AND2
	PORT MAP (Z0 => UQVN_N16, A0 => G6, A1 => P7);
UQVB_B30 : AND3
	PORT MAP (Z0 => UQVN_N17, A0 => G5, A1 => P6, A2 => P7);
UQVB_B31 : AND4
	PORT MAP (Z0 => UQVN_N14, A0 => G4, A1 => P5, A2 => P6, 
	A3 => P7);
UQVB_B32 : OR4
	PORT MAP (Z0 => UQVN_N19, A0 => UQVN_N13, A1 => UQVN_N11, A2 => UQVN_N10, 
	A3 => UQVN_N12);
UQVB_B33 : OR2
	PORT MAP (Z0 => CO, A0 => UQVN_N19, A1 => UQVN_N18);
UQVB_B34 : AND6
	PORT MAP (Z0 => UQVN_N3, A0 => CI, A1 => P0, A2 => P1, 
	A3 => P2, A4 => P3, A5 => P4);
UQVB_B35 : AND5
	PORT MAP (Z0 => UQVN_N2, A0 => G0, A1 => P1, A2 => P2, 
	A3 => P3, A4 => P4);
UQVB_B36 : AND4
	PORT MAP (Z0 => UQVN_N1, A0 => G1, A1 => P2, A2 => P3, 
	A3 => P4);
UQVB_B37 : AND3
	PORT MAP (Z0 => UQVN_N4, A0 => G2, A1 => P3, A2 => P4);
UQVB_B38 : AND2
	PORT MAP (Z0 => UQVN_N5, A0 => G3, A1 => P4);
UQVB_B39 : AND2
	PORT MAP (Z0 => UQVN_N31, A0 => CI, A1 => P0);
UQVB_B40 : OR2
	PORT MAP (Z0 => UQVN_N30, A0 => UQVN_N31, A1 => G0);
UQVB_B41 : OR2
	PORT MAP (Z0 => UQVN_N29, A0 => UQVN_N21, A1 => UQVN_N20);
UQVB_B42 : LXOR2
	PORT MAP (Z0 => Z1, A0 => UQVN_N30, A1 => P1);
UQVB_B43 : XOR2
	PORT MAP (Z0 => Z0, A0 => CI, A1 => P0);
UQVB_B44 : AND2
	PORT MAP (Z0 => UQVN_N28, A0 => G5, A1 => P6);
UQVB_B45 : AND3
	PORT MAP (Z0 => UQVN_N26, A0 => G4, A1 => P5, A2 => P6);
UQVB_B46 : AND4
	PORT MAP (Z0 => UQVN_N27, A0 => G3, A1 => P4, A2 => P5, 
	A3 => P6);
UQVB_B47 : AND5
	PORT MAP (Z0 => UQVN_N24, A0 => G2, A1 => P3, A2 => P4, 
	A3 => P5, A4 => P6);
UQVB_B48 : AND6
	PORT MAP (Z0 => UQVN_N22, A0 => G1, A1 => P2, A2 => P3, 
	A3 => P4, A4 => P5, A5 => P6);
UQVB_B49 : AND7
	PORT MAP (Z0 => UQVN_N23, A0 => G0, A1 => P1, A2 => P2, 
	A3 => P3, A4 => P4, A5 => P5, A6 => P6);
UQVB_B50 : AND8
	PORT MAP (Z0 => UQVN_N25, A0 => CI, A1 => P0, A2 => P1, 
	A3 => P2, A4 => P3, A5 => P4, A6 => P5, 
	A7 => P6);
UQVB_B51 : OR5
	PORT MAP (Z0 => UQVN_N21, A0 => UQVN_N25, A1 => UQVN_N23, A2 => UQVN_N22, 
	A3 => UQVN_N24, A4 => UQVN_N27);
UQVB_B52 : OR3
	PORT MAP (Z0 => UQVN_N20, A0 => UQVN_N26, A1 => UQVN_N28, A2 => G6);
UQVB_B53 : LXOR2
	PORT MAP (Z0 => Z7, A0 => UQVN_N29, A1 => P7);
UQVB_B54 : AND2
	PORT MAP (Z0 => UQVN_N46, A0 => G2, A1 => P3);
UQVB_B55 : AND3
	PORT MAP (Z0 => UQVN_N45, A0 => G1, A1 => P2, A2 => P3);
UQVB_B56 : AND4
	PORT MAP (Z0 => UQVN_N47, A0 => G0, A1 => P1, A2 => P2, 
	A3 => P3);
UQVB_B57 : AND5
	PORT MAP (Z0 => UQVN_N48, A0 => CI, A1 => P0, A2 => P1, 
	A3 => P2, A4 => P3);
UQVB_B58 : OR5
	PORT MAP (Z0 => UQVN_N44, A0 => UQVN_N48, A1 => UQVN_N47, A2 => UQVN_N45, 
	A3 => UQVN_N46, A4 => G3);
UQVB_B59 : LXOR2
	PORT MAP (Z0 => Z3, A0 => UQVN_N32, A1 => P3);
UQVB_B60 : AND2
	PORT MAP (Z0 => UQVN_N35, A0 => G1, A1 => P2);
UQVB_B61 : AND3
	PORT MAP (Z0 => UQVN_N34, A0 => G0, A1 => P1, A2 => P2);
UQVB_B62 : AND4
	PORT MAP (Z0 => UQVN_N33, A0 => CI, A1 => P0, A2 => P1, 
	A3 => P2);
UQVB_B63 : OR4
	PORT MAP (Z0 => UQVN_N32, A0 => UQVN_N33, A1 => UQVN_N34, A2 => UQVN_N35, 
	A3 => G2);
UQVB_B64 : OR2
	PORT MAP (Z0 => UQVN_N49, A0 => UQVN_N37, A1 => UQVN_N36);
UQVB_B65 : OR4
	PORT MAP (Z0 => UQVN_N37, A0 => UQVN_N41, A1 => UQVN_N39, A2 => UQVN_N38, 
	A3 => UQVN_N40);
UQVB_B66 : LXOR2
	PORT MAP (Z0 => Z4, A0 => UQVN_N44, A1 => P4);
UQVB_B67 : AND2
	PORT MAP (Z0 => UQVN_N42, A0 => G4, A1 => P5);
UQVB_B68 : AND3
	PORT MAP (Z0 => UQVN_N43, A0 => G3, A1 => P4, A2 => P5);
UQVB_B69 : AND4
	PORT MAP (Z0 => UQVN_N40, A0 => G2, A1 => P3, A2 => P4, 
	A3 => P5);
UQVB_B70 : AND5
	PORT MAP (Z0 => UQVN_N38, A0 => G1, A1 => P2, A2 => P3, 
	A3 => P4, A4 => P5);
UQVB_B71 : AND6
	PORT MAP (Z0 => UQVN_N39, A0 => G0, A1 => P1, A2 => P2, 
	A3 => P3, A4 => P4, A5 => P5);
UQVB_B72 : AND7
	PORT MAP (Z0 => UQVN_N41, A0 => CI, A1 => P0, A2 => P1, 
	A3 => P2, A4 => P3, A5 => P4, A6 => P5);
UQVB_B73 : OR3
	PORT MAP (Z0 => UQVN_N36, A0 => UQVN_N43, A1 => UQVN_N42, A2 => G5);
UQVB_B74 : LXOR2
	PORT MAP (Z0 => Z6, A0 => UQVN_N49, A1 => P6);
END lattice_arch;
-- VHDL netlist for ADDF8A
-- Date: 15.5.95 13.44.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY ADDF8A IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        B0 : IN std_logic;
        B1 : IN std_logic;
        B2 : IN std_logic;
        B3 : IN std_logic;
        B4 : IN std_logic;
        B5 : IN std_logic;
        B6 : IN std_logic;
        B7 : IN std_logic;
        CI : IN std_logic;
        Z0 : OUT std_logic;
        Z1 : OUT std_logic;
        Z2 : OUT std_logic;
        Z3 : OUT std_logic;
        Z4 : OUT std_logic;
        Z5 : OUT std_logic;
        Z6 : OUT std_logic;
        Z7 : OUT std_logic;
        CO : OUT std_logic
    );
END ADDF8A;


ARCHITECTURE lattice_arch OF ADDF8A IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, UQVN_N23, UQVN_N24,
	 UQVN_N25, UQVN_N26, UQVN_N27, UQVN_N28,
	 UQVN_N29, UQVN_N30, UQVN_N31, UQVN_N32,
	 UQVN_N33, UQVN_N34, UQVN_N35, UQVN_N36,
	 UQVN_N37, UQVN_N38, UQVN_N39, UQVN_N40,
	 UQVN_N41, UQVN_N42, UQVN_N43, UQVN_N44,
	 UQVN_N45, UQVN_N46, UQVN_N47, UQVN_N48,
	 UQVN_N49, UQVN_N50, UQVN_N51, UQVN_N52,
	 UQVN_N53, UQVN_N54, UQVN_N55, UQVN_N56,
	 UQVN_N57, UQVN_N58, UQVN_N59, UQVN_N60,
	 UQVN_N61, UQVN_N62, UQVN_N63, UQVN_N64,
	 UQVN_N65, UQVN_N66, UQVN_N67, UQVN_N68,
	 UQVN_N69, UQVN_N70, UQVN_N71, UQVN_N72,
	 UQVN_N73, UQVN_N74, UQVN_N75, UQVN_N76,
	 UQVN_N77, UQVN_N78, UQVN_N79, UQVN_N80,
	 UQVN_N81, UQVN_N82, UQVN_N83, UQVN_N84,
	 UQVN_N85, UQVN_N86, UQVN_N87, UQVN_N88,
	 UQVN_N89, UQVN_N90, UQVN_N91, UQVN_N92,
	 UQVN_N93, UQVN_N94, UQVN_N95, UQVN_N96,
	 UQVN_N97, UQVN_N98, UQVN_N99, UQVN_N100,
	 UQVN_N101, UQVN_N102, UQVN_N103, UQVN_N104,
	 UQVN_N105, UQVN_N106, UQVN_N107, UQVN_N108,
	 UQVN_N109, UQVN_N110, UQVN_N111, UQVN_N112,
	 G012, G345, P012, P345 : std_logic;


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT OR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR2 use  entity  lattice.OR2(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT OR6
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR6 use  entity  lattice.OR6(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT OR7
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR7 use  entity  lattice.OR7(lattice_arch);


  COMPONENT NOR3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: NOR3 use  entity  lattice.NOR3(lattice_arch);


  COMPONENT OR12
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        A9 : IN std_logic;
        A10 : IN std_logic;
        A11 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR12 use  entity  lattice.OR12(lattice_arch);


  COMPONENT OR3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR3 use  entity  lattice.OR3(lattice_arch);


  COMPONENT XOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: XOR2 use  entity  lattice.XOR2(lattice_arch);


BEGIN

UQVB_B1 : INV
	PORT MAP (ZN0 => UQVN_N43, A0 => CI);
UQVB_B2 : INV
	PORT MAP (ZN0 => UQVN_N41, A0 => B1);
UQVB_B3 : INV
	PORT MAP (ZN0 => UQVN_N42, A0 => B2);
UQVB_B4 : INV
	PORT MAP (ZN0 => UQVN_N37, A0 => A0);
UQVB_B5 : AND2
	PORT MAP (Z0 => UQVN_N1, A0 => UQVN_N40, A1 => CI);
UQVB_B6 : AND2
	PORT MAP (Z0 => UQVN_N2, A0 => B0, A1 => UQVN_N43);
UQVB_B7 : OR2
	PORT MAP (Z0 => UQVN_N3, A0 => UQVN_N1, A1 => UQVN_N2);
UQVB_B8 : LXOR2
	PORT MAP (Z0 => Z0, A0 => A0, A1 => UQVN_N3);
UQVB_B9 : AND3
	PORT MAP (Z0 => UQVN_N9, A0 => UQVN_N37, A1 => B1, A2 => UQVN_N40);
UQVB_B10 : AND3
	PORT MAP (Z0 => UQVN_N5, A0 => UQVN_N41, A1 => B0, A2 => CI);
UQVB_B11 : AND3
	PORT MAP (Z0 => UQVN_N4, A0 => A0, A1 => UQVN_N41, A2 => CI);
UQVB_B12 : AND3
	PORT MAP (Z0 => UQVN_N6, A0 => B1, A1 => UQVN_N40, A2 => UQVN_N43);
UQVB_B13 : AND3
	PORT MAP (Z0 => UQVN_N7, A0 => UQVN_N37, A1 => B1, A2 => UQVN_N43);
UQVB_B14 : OR6
	PORT MAP (Z0 => UQVN_N10, A0 => UQVN_N7, A1 => UQVN_N6, A2 => UQVN_N4, 
	A3 => UQVN_N5, A4 => UQVN_N9, A5 => UQVN_N8);
UQVB_B15 : LXOR2
	PORT MAP (Z0 => Z1, A0 => A1, A1 => UQVN_N10);
UQVB_B16 : AND3
	PORT MAP (Z0 => UQVN_N8, A0 => A0, A1 => UQVN_N41, A2 => B0);
UQVB_B17 : AND4
	PORT MAP (Z0 => UQVN_N14, A0 => A0, A1 => A1, A2 => A2, 
	A3 => B0);
UQVB_B18 : AND3
	PORT MAP (Z0 => UQVN_N13, A0 => A1, A1 => A2, A2 => B1);
UQVB_B19 : AND4
	PORT MAP (Z0 => UQVN_N12, A0 => A0, A1 => A2, A2 => B0, 
	A3 => B1);
UQVB_B20 : AND2
	PORT MAP (Z0 => UQVN_N11, A0 => A2, A1 => B2);
UQVB_B21 : AND4
	PORT MAP (Z0 => UQVN_N15, A0 => A0, A1 => A1, A2 => B0, 
	A3 => B2);
UQVB_B22 : AND3
	PORT MAP (Z0 => UQVN_N16, A0 => A1, A1 => B1, A2 => B2);
UQVB_B23 : AND4
	PORT MAP (Z0 => UQVN_N17, A0 => A0, A1 => B0, A2 => B1, 
	A3 => B2);
UQVB_B24 : OR7
	PORT MAP (Z0 => G012, A0 => UQVN_N14, A1 => UQVN_N13, A2 => UQVN_N12, 
	A3 => UQVN_N11, A4 => UQVN_N15, A5 => UQVN_N16, A6 => UQVN_N17);
UQVB_B25 : AND2
	PORT MAP (Z0 => UQVN_N20, A0 => UQVN_N37, A1 => UQVN_N40);
UQVB_B26 : AND2
	PORT MAP (Z0 => UQVN_N18, A0 => UQVN_N38, A1 => UQVN_N41);
UQVB_B27 : AND2
	PORT MAP (Z0 => UQVN_N19, A0 => UQVN_N39, A1 => UQVN_N42);
UQVB_B28 : NOR3
	PORT MAP (ZN0 => P012, A0 => UQVN_N20, A1 => UQVN_N18, A2 => UQVN_N19);
UQVB_B29 : INV
	PORT MAP (ZN0 => UQVN_N40, A0 => B0);
UQVB_B30 : INV
	PORT MAP (ZN0 => UQVN_N38, A0 => A1);
UQVB_B31 : INV
	PORT MAP (ZN0 => UQVN_N39, A0 => A2);
UQVB_B32 : LXOR2
	PORT MAP (Z0 => Z2, A0 => A2, A1 => UQVN_N34);
UQVB_B33 : AND4
	PORT MAP (Z0 => UQVN_N33, A0 => UQVN_N40, A1 => UQVN_N41, A2 => B2, 
	A3 => UQVN_N43);
UQVB_B34 : AND4
	PORT MAP (Z0 => UQVN_N35, A0 => UQVN_N37, A1 => UQVN_N41, A2 => B2, 
	A3 => UQVN_N43);
UQVB_B35 : AND4
	PORT MAP (Z0 => UQVN_N32, A0 => UQVN_N38, A1 => UQVN_N40, A2 => B2, 
	A3 => UQVN_N43);
UQVB_B36 : AND4
	PORT MAP (Z0 => UQVN_N31, A0 => UQVN_N37, A1 => UQVN_N38, A2 => B2, 
	A3 => UQVN_N43);
UQVB_B37 : AND4
	PORT MAP (Z0 => UQVN_N30, A0 => B0, A1 => B1, A2 => UQVN_N42, 
	A3 => CI);
UQVB_B38 : AND4
	PORT MAP (Z0 => UQVN_N29, A0 => A0, A1 => B1, A2 => UQVN_N42, 
	A3 => CI);
UQVB_B39 : AND4
	PORT MAP (Z0 => UQVN_N28, A0 => A1, A1 => B0, A2 => UQVN_N42, 
	A3 => CI);
UQVB_B40 : AND4
	PORT MAP (Z0 => UQVN_N27, A0 => A0, A1 => A1, A2 => UQVN_N42, 
	A3 => CI);
UQVB_B41 : AND4
	PORT MAP (Z0 => UQVN_N26, A0 => A0, A1 => B0, A2 => B1, 
	A3 => UQVN_N42);
UQVB_B42 : AND3
	PORT MAP (Z0 => UQVN_N25, A0 => A1, A1 => B1, A2 => UQVN_N42);
UQVB_B43 : AND4
	PORT MAP (Z0 => UQVN_N24, A0 => A0, A1 => A1, A2 => B0, 
	A3 => UQVN_N42);
UQVB_B44 : AND4
	PORT MAP (Z0 => UQVN_N23, A0 => UQVN_N37, A1 => UQVN_N40, A2 => UQVN_N41, 
	A3 => B2);
UQVB_B45 : AND3
	PORT MAP (Z0 => UQVN_N22, A0 => UQVN_N38, A1 => UQVN_N41, A2 => B2);
UQVB_B46 : AND4
	PORT MAP (Z0 => UQVN_N21, A0 => UQVN_N37, A1 => UQVN_N38, A2 => UQVN_N40, 
	A3 => B2);
UQVB_B47 : OR12
	PORT MAP (Z0 => UQVN_N36, A0 => UQVN_N32, A1 => UQVN_N31, A2 => UQVN_N30, 
	A3 => UQVN_N29, A4 => UQVN_N28, A5 => UQVN_N27, A6 => UQVN_N26, 
	A7 => UQVN_N25, A8 => UQVN_N24, A9 => UQVN_N23, A10 => UQVN_N22, 
	A11 => UQVN_N21);
UQVB_B48 : OR3
	PORT MAP (Z0 => UQVN_N34, A0 => UQVN_N33, A1 => UQVN_N35, A2 => UQVN_N36);
UQVB_B49 : AND2
	PORT MAP (Z0 => UQVN_N44, A0 => P012, A1 => CI);
UQVB_B50 : OR2
	PORT MAP (Z0 => UQVN_N111, A0 => G012, A1 => UQVN_N44);
UQVB_B51 : INV
	PORT MAP (ZN0 => UQVN_N87, A0 => UQVN_N111);
UQVB_B52 : INV
	PORT MAP (ZN0 => UQVN_N85, A0 => B4);
UQVB_B53 : INV
	PORT MAP (ZN0 => UQVN_N86, A0 => B5);
UQVB_B54 : INV
	PORT MAP (ZN0 => UQVN_N81, A0 => A3);
UQVB_B55 : AND2
	PORT MAP (Z0 => UQVN_N45, A0 => UQVN_N84, A1 => UQVN_N111);
UQVB_B56 : AND2
	PORT MAP (Z0 => UQVN_N46, A0 => B3, A1 => UQVN_N87);
UQVB_B57 : OR2
	PORT MAP (Z0 => UQVN_N47, A0 => UQVN_N45, A1 => UQVN_N46);
UQVB_B58 : LXOR2
	PORT MAP (Z0 => Z3, A0 => A3, A1 => UQVN_N47);
UQVB_B59 : AND3
	PORT MAP (Z0 => UQVN_N53, A0 => UQVN_N81, A1 => B4, A2 => UQVN_N84);
UQVB_B60 : AND3
	PORT MAP (Z0 => UQVN_N49, A0 => UQVN_N85, A1 => B3, A2 => UQVN_N111);
UQVB_B61 : AND3
	PORT MAP (Z0 => UQVN_N48, A0 => A3, A1 => UQVN_N85, A2 => UQVN_N111);
UQVB_B62 : AND3
	PORT MAP (Z0 => UQVN_N50, A0 => B4, A1 => UQVN_N84, A2 => UQVN_N87);
UQVB_B63 : AND3
	PORT MAP (Z0 => UQVN_N51, A0 => UQVN_N81, A1 => B4, A2 => UQVN_N87);
UQVB_B64 : OR6
	PORT MAP (Z0 => UQVN_N54, A0 => UQVN_N51, A1 => UQVN_N50, A2 => UQVN_N48, 
	A3 => UQVN_N49, A4 => UQVN_N53, A5 => UQVN_N52);
UQVB_B65 : LXOR2
	PORT MAP (Z0 => Z4, A0 => A4, A1 => UQVN_N54);
UQVB_B66 : AND3
	PORT MAP (Z0 => UQVN_N52, A0 => A3, A1 => UQVN_N85, A2 => B3);
UQVB_B67 : AND4
	PORT MAP (Z0 => UQVN_N58, A0 => A3, A1 => A4, A2 => A5, 
	A3 => B3);
UQVB_B68 : AND3
	PORT MAP (Z0 => UQVN_N57, A0 => A4, A1 => A5, A2 => B4);
UQVB_B69 : AND4
	PORT MAP (Z0 => UQVN_N56, A0 => A3, A1 => A5, A2 => B3, 
	A3 => B4);
UQVB_B70 : AND2
	PORT MAP (Z0 => UQVN_N55, A0 => A5, A1 => B5);
UQVB_B71 : AND4
	PORT MAP (Z0 => UQVN_N59, A0 => A3, A1 => A4, A2 => B3, 
	A3 => B5);
UQVB_B72 : AND3
	PORT MAP (Z0 => UQVN_N60, A0 => A4, A1 => B4, A2 => B5);
UQVB_B73 : AND4
	PORT MAP (Z0 => UQVN_N61, A0 => A3, A1 => B3, A2 => B4, 
	A3 => B5);
UQVB_B74 : OR7
	PORT MAP (Z0 => G345, A0 => UQVN_N58, A1 => UQVN_N57, A2 => UQVN_N56, 
	A3 => UQVN_N55, A4 => UQVN_N59, A5 => UQVN_N60, A6 => UQVN_N61);
UQVB_B75 : AND2
	PORT MAP (Z0 => UQVN_N64, A0 => UQVN_N81, A1 => UQVN_N84);
UQVB_B76 : AND2
	PORT MAP (Z0 => UQVN_N62, A0 => UQVN_N82, A1 => UQVN_N85);
UQVB_B77 : AND2
	PORT MAP (Z0 => UQVN_N63, A0 => UQVN_N83, A1 => UQVN_N86);
UQVB_B78 : NOR3
	PORT MAP (ZN0 => P345, A0 => UQVN_N64, A1 => UQVN_N62, A2 => UQVN_N63);
UQVB_B79 : INV
	PORT MAP (ZN0 => UQVN_N84, A0 => B3);
UQVB_B80 : INV
	PORT MAP (ZN0 => UQVN_N82, A0 => A4);
UQVB_B81 : INV
	PORT MAP (ZN0 => UQVN_N83, A0 => A5);
UQVB_B82 : LXOR2
	PORT MAP (Z0 => Z5, A0 => A5, A1 => UQVN_N78);
UQVB_B83 : AND4
	PORT MAP (Z0 => UQVN_N77, A0 => UQVN_N84, A1 => UQVN_N85, A2 => B5, 
	A3 => UQVN_N87);
UQVB_B84 : AND4
	PORT MAP (Z0 => UQVN_N79, A0 => UQVN_N81, A1 => UQVN_N85, A2 => B5, 
	A3 => UQVN_N87);
UQVB_B85 : AND4
	PORT MAP (Z0 => UQVN_N76, A0 => UQVN_N82, A1 => UQVN_N84, A2 => B5, 
	A3 => UQVN_N87);
UQVB_B86 : AND4
	PORT MAP (Z0 => UQVN_N75, A0 => UQVN_N81, A1 => UQVN_N82, A2 => B5, 
	A3 => UQVN_N87);
UQVB_B87 : AND4
	PORT MAP (Z0 => UQVN_N74, A0 => B3, A1 => B4, A2 => UQVN_N86, 
	A3 => UQVN_N111);
UQVB_B88 : AND4
	PORT MAP (Z0 => UQVN_N73, A0 => A3, A1 => B4, A2 => UQVN_N86, 
	A3 => UQVN_N111);
UQVB_B89 : AND4
	PORT MAP (Z0 => UQVN_N72, A0 => A4, A1 => B3, A2 => UQVN_N86, 
	A3 => UQVN_N111);
UQVB_B90 : AND4
	PORT MAP (Z0 => UQVN_N71, A0 => A3, A1 => A4, A2 => UQVN_N86, 
	A3 => UQVN_N111);
UQVB_B91 : AND4
	PORT MAP (Z0 => UQVN_N70, A0 => A3, A1 => B3, A2 => B4, 
	A3 => UQVN_N86);
UQVB_B92 : AND3
	PORT MAP (Z0 => UQVN_N69, A0 => A4, A1 => B4, A2 => UQVN_N86);
UQVB_B93 : AND4
	PORT MAP (Z0 => UQVN_N68, A0 => A3, A1 => A4, A2 => B3, 
	A3 => UQVN_N86);
UQVB_B94 : AND4
	PORT MAP (Z0 => UQVN_N67, A0 => UQVN_N81, A1 => UQVN_N84, A2 => UQVN_N85, 
	A3 => B5);
UQVB_B95 : AND3
	PORT MAP (Z0 => UQVN_N66, A0 => UQVN_N82, A1 => UQVN_N85, A2 => B5);
UQVB_B96 : AND4
	PORT MAP (Z0 => UQVN_N65, A0 => UQVN_N81, A1 => UQVN_N82, A2 => UQVN_N84, 
	A3 => B5);
UQVB_B97 : OR12
	PORT MAP (Z0 => UQVN_N80, A0 => UQVN_N76, A1 => UQVN_N75, A2 => UQVN_N74, 
	A3 => UQVN_N73, A4 => UQVN_N72, A5 => UQVN_N71, A6 => UQVN_N70, 
	A7 => UQVN_N69, A8 => UQVN_N68, A9 => UQVN_N67, A10 => UQVN_N66, 
	A11 => UQVN_N65);
UQVB_B98 : OR3
	PORT MAP (Z0 => UQVN_N78, A0 => UQVN_N77, A1 => UQVN_N79, A2 => UQVN_N80);
UQVB_B99 : OR3
	PORT MAP (Z0 => UQVN_N112, A0 => G345, A1 => UQVN_N88, A2 => UQVN_N89);
UQVB_B100 : AND3
	PORT MAP (Z0 => UQVN_N89, A0 => P345, A1 => P012, A2 => CI);
UQVB_B101 : AND2
	PORT MAP (Z0 => UQVN_N88, A0 => P345, A1 => G012);
UQVB_B102 : INV
	PORT MAP (ZN0 => UQVN_N110, A0 => UQVN_N112);
UQVB_B103 : AND3
	PORT MAP (Z0 => UQVN_N92, A0 => UQVN_N112, A1 => A7, A2 => A6);
UQVB_B104 : AND3
	PORT MAP (Z0 => UQVN_N91, A0 => UQVN_N112, A1 => A7, A2 => B6);
UQVB_B105 : AND3
	PORT MAP (Z0 => UQVN_N90, A0 => UQVN_N112, A1 => A6, A2 => B7);
UQVB_B106 : AND3
	PORT MAP (Z0 => UQVN_N93, A0 => UQVN_N112, A1 => B7, A2 => B6);
UQVB_B107 : AND3
	PORT MAP (Z0 => UQVN_N94, A0 => A7, A1 => A6, A2 => B6);
UQVB_B108 : AND3
	PORT MAP (Z0 => UQVN_N96, A0 => A6, A1 => B7, A2 => B6);
UQVB_B109 : AND2
	PORT MAP (Z0 => UQVN_N95, A0 => A7, A1 => B7);
UQVB_B110 : OR7
	PORT MAP (Z0 => CO, A0 => UQVN_N92, A1 => UQVN_N91, A2 => UQVN_N90, 
	A3 => UQVN_N93, A4 => UQVN_N94, A5 => UQVN_N96, A6 => UQVN_N95);
UQVB_B111 : AND3
	PORT MAP (Z0 => UQVN_N97, A0 => UQVN_N107, A1 => B7, A2 => UQVN_N110);
UQVB_B112 : AND3
	PORT MAP (Z0 => UQVN_N98, A0 => B7, A1 => UQVN_N108, A2 => UQVN_N110);
UQVB_B113 : AND3
	PORT MAP (Z0 => UQVN_N99, A0 => A6, A1 => UQVN_N109, A2 => UQVN_N112);
UQVB_B114 : AND3
	PORT MAP (Z0 => UQVN_N100, A0 => UQVN_N109, A1 => B6, A2 => UQVN_N112);
UQVB_B115 : AND3
	PORT MAP (Z0 => UQVN_N101, A0 => UQVN_N107, A1 => B7, A2 => UQVN_N108);
UQVB_B116 : AND3
	PORT MAP (Z0 => UQVN_N102, A0 => A6, A1 => UQVN_N109, A2 => B6);
UQVB_B117 : OR6
	PORT MAP (Z0 => UQVN_N103, A0 => UQVN_N97, A1 => UQVN_N98, A2 => UQVN_N99, 
	A3 => UQVN_N100, A4 => UQVN_N101, A5 => UQVN_N102);
UQVB_B118 : LXOR2
	PORT MAP (Z0 => Z7, A0 => A7, A1 => UQVN_N103);
UQVB_B119 : INV
	PORT MAP (ZN0 => UQVN_N108, A0 => B6);
UQVB_B120 : INV
	PORT MAP (ZN0 => UQVN_N109, A0 => B7);
UQVB_B121 : INV
	PORT MAP (ZN0 => UQVN_N107, A0 => A6);
UQVB_B122 : XOR2
	PORT MAP (Z0 => Z6, A0 => A6, A1 => UQVN_N104);
UQVB_B123 : AND2
	PORT MAP (Z0 => UQVN_N105, A0 => UQVN_N112, A1 => UQVN_N108);
UQVB_B124 : OR2
	PORT MAP (Z0 => UQVN_N104, A0 => UQVN_N105, A1 => UQVN_N106);
UQVB_B125 : AND2
	PORT MAP (Z0 => UQVN_N106, A0 => UQVN_N110, A1 => B6);
END lattice_arch;
-- VHDL netlist for ADDH1
-- Date: 15.5.95 13.44.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY ADDH1 IS 
    PORT (
        A0 : IN std_logic;
        B0 : IN std_logic;
        Z0 : OUT std_logic;
        CO : OUT std_logic
    );
END ADDH1;


ARCHITECTURE lattice_arch OF ADDH1 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4 : std_logic;


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT OR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR2 use  entity  lattice.OR2(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


BEGIN

UQVB_B1 : AND2
	PORT MAP (Z0 => UQVN_N1, A0 => UQVN_N4, A1 => B0);
UQVB_B2 : AND2
	PORT MAP (Z0 => UQVN_N2, A0 => UQVN_N3, A1 => A0);
UQVB_B3 : AND2
	PORT MAP (Z0 => CO, A0 => B0, A1 => A0);
UQVB_B4 : OR2
	PORT MAP (Z0 => Z0, A0 => UQVN_N1, A1 => UQVN_N2);
UQVB_B5 : INV
	PORT MAP (ZN0 => UQVN_N3, A0 => B0);
UQVB_B6 : INV
	PORT MAP (ZN0 => UQVN_N4, A0 => A0);
END lattice_arch;
-- VHDL netlist for ADDH16A
-- Date: 15.5.95 13.44.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY ADDH16A IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A10 : IN std_logic;
        A11 : IN std_logic;
        A12 : IN std_logic;
        A13 : IN std_logic;
        A14 : IN std_logic;
        A15 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        A9 : IN std_logic;
        B0 : IN std_logic;
        B1 : IN std_logic;
        B10 : IN std_logic;
        B11 : IN std_logic;
        B12 : IN std_logic;
        B13 : IN std_logic;
        B14 : IN std_logic;
        B15 : IN std_logic;
        B2 : IN std_logic;
        B3 : IN std_logic;
        B4 : IN std_logic;
        B5 : IN std_logic;
        B6 : IN std_logic;
        B7 : IN std_logic;
        B8 : IN std_logic;
        B9 : IN std_logic;
        CO : OUT std_logic;
        Z0 : OUT std_logic;
        Z1 : OUT std_logic;
        Z10 : OUT std_logic;
        Z11 : OUT std_logic;
        Z12 : OUT std_logic;
        Z13 : OUT std_logic;
        Z14 : OUT std_logic;
        Z15 : OUT std_logic;
        Z2 : OUT std_logic;
        Z3 : OUT std_logic;
        Z4 : OUT std_logic;
        Z5 : OUT std_logic;
        Z6 : OUT std_logic;
        Z7 : OUT std_logic;
        Z8 : OUT std_logic;
        Z9 : OUT std_logic
    );
END ADDH16A;


ARCHITECTURE lattice_arch OF ADDH16A IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, UQVN_N23, UQVN_N24,
	 UQVN_N25, UQVN_N26, UQVN_N27, UQVN_N28,
	 UQVN_N29, UQVN_N30, UQVN_N31, UQVN_N32,
	 UQVN_N33, UQVN_N34, UQVN_N35, UQVN_N36,
	 UQVN_N37, UQVN_N38, UQVN_N39, UQVN_N40,
	 UQVN_N41, UQVN_N42, UQVN_N43, UQVN_N44,
	 UQVN_N45, UQVN_N46, UQVN_N47, UQVN_N48,
	 UQVN_N49, UQVN_N50, UQVN_N51, UQVN_N52,
	 UQVN_N53, UQVN_N54, UQVN_N55, UQVN_N56,
	 UQVN_N57, UQVN_N58, UQVN_N59, UQVN_N60,
	 UQVN_N61, UQVN_N62, UQVN_N63, UQVN_N64,
	 UQVN_N65, UQVN_N66, UQVN_N67, UQVN_N68,
	 UQVN_N69, UQVN_N70, UQVN_N71, UQVN_N72,
	 UQVN_N73, UQVN_N74, UQVN_N75, UQVN_N76,
	 UQVN_N77, UQVN_N78, UQVN_N79, UQVN_N80,
	 UQVN_N81, UQVN_N82, UQVN_N83, UQVN_N84,
	 UQVN_N85, UQVN_N86, UQVN_N87, UQVN_N88,
	 UQVN_N89, UQVN_N90, UQVN_N91, UQVN_N92,
	 UQVN_N93, UQVN_N94, UQVN_N95, UQVN_N96,
	 UQVN_N97, UQVN_N98, UQVN_N99, UQVN_N100,
	 UQVN_N101, UQVN_N102, UQVN_N103, UQVN_N104,
	 UQVN_N105, UQVN_N106, UQVN_N107, UQVN_N108,
	 UQVN_N109, UQVN_N110, UQVN_N111, UQVN_N112,
	 UQVN_N113, UQVN_N114, UQVN_N115, UQVN_N116,
	 UQVN_N117, UQVN_N118, UQVN_N119, UQVN_N120,
	 UQVN_N121, UQVN_N122, UQVN_N123, UQVN_N124,
	 UQVN_N125, UQVN_N126, UQVN_N127, UQVN_N128,
	 UQVN_N129, UQVN_N130, UQVN_N131, UQVN_N132,
	 UQVN_N133, UQVN_N134, UQVN_N135, UQVN_N136,
	 UQVN_N137, UQVN_N138, UQVN_N139, UQVN_N140,
	 UQVN_N141, UQVN_N142, UQVN_N143, UQVN_N144,
	 UQVN_N145, UQVN_N146, UQVN_N147, UQVN_N148,
	 UQVN_N149, UQVN_N150, UQVN_N151, UQVN_N152,
	 UQVN_N153, UQVN_N154, UQVN_N155, UQVN_N156,
	 UQVN_N157, UQVN_N158, UQVN_N159, UQVN_N160,
	 UQVN_N161, UQVN_N162, UQVN_N163, UQVN_N164,
	 UQVN_N165, UQVN_N166, UQVN_N167, UQVN_N168,
	 UQVN_N169, UQVN_N170, UQVN_N171, UQVN_N172,
	 UQVN_N173, UQVN_N174, UQVN_N175, UQVN_N176,
	 UQVN_N177, UQVN_N178, UQVN_N179, UQVN_N180,
	 UQVN_N181, UQVN_N182, UQVN_N183, UQVN_N184,
	 UQVN_N185, UQVN_N186, UQVN_N187, UQVN_N188,
	 UQVN_N189, UQVN_N190, UQVN_N191, UQVN_N192,
	 UQVN_N193, UQVN_N194, UQVN_N195, UQVN_N196,
	 UQVN_N197, UQVN_N198, UQVN_N199, UQVN_N200,
	 UQVN_N201, UQVN_N202, UQVN_N203, UQVN_N204,
	 UQVN_N205, UQVN_N206, UQVN_N207, UQVN_N208,
	 UQVN_N209, UQVN_N210, UQVN_N211, UQVN_N212,
	 UQVN_N213, UQVN_N214, UQVN_N215, UQVN_N216,
	 UQVN_N217, UQVN_N218, UQVN_N219, G012,
	 G1214, G345, G678, G911,
	 P1214, P345, P678, P911 : std_logic;


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT OR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR2 use  entity  lattice.OR2(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT OR6
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR6 use  entity  lattice.OR6(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT OR7
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR7 use  entity  lattice.OR7(lattice_arch);


  COMPONENT NOR3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: NOR3 use  entity  lattice.NOR3(lattice_arch);


  COMPONENT OR12
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        A9 : IN std_logic;
        A10 : IN std_logic;
        A11 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR12 use  entity  lattice.OR12(lattice_arch);


  COMPONENT OR3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR3 use  entity  lattice.OR3(lattice_arch);


  COMPONENT OR4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR4 use  entity  lattice.OR4(lattice_arch);


  COMPONENT OR5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR5 use  entity  lattice.OR5(lattice_arch);


  COMPONENT AND5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND5 use  entity  lattice.AND5(lattice_arch);


  COMPONENT OR8
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR8 use  entity  lattice.OR8(lattice_arch);


  COMPONENT XOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: XOR2 use  entity  lattice.XOR2(lattice_arch);


BEGIN

UQVB_B1 : INV
	PORT MAP (ZN0 => UQVN_N43, A0 => G012);
UQVB_B2 : INV
	PORT MAP (ZN0 => UQVN_N41, A0 => B4);
UQVB_B3 : INV
	PORT MAP (ZN0 => UQVN_N42, A0 => B5);
UQVB_B4 : INV
	PORT MAP (ZN0 => UQVN_N37, A0 => A3);
UQVB_B5 : AND2
	PORT MAP (Z0 => UQVN_N1, A0 => UQVN_N40, A1 => G012);
UQVB_B6 : AND2
	PORT MAP (Z0 => UQVN_N2, A0 => B3, A1 => UQVN_N43);
UQVB_B7 : OR2
	PORT MAP (Z0 => UQVN_N3, A0 => UQVN_N1, A1 => UQVN_N2);
UQVB_B8 : LXOR2
	PORT MAP (Z0 => Z3, A0 => A3, A1 => UQVN_N3);
UQVB_B9 : AND3
	PORT MAP (Z0 => UQVN_N9, A0 => UQVN_N37, A1 => B4, A2 => UQVN_N40);
UQVB_B10 : AND3
	PORT MAP (Z0 => UQVN_N5, A0 => UQVN_N41, A1 => B3, A2 => G012);
UQVB_B11 : AND3
	PORT MAP (Z0 => UQVN_N4, A0 => A3, A1 => UQVN_N41, A2 => G012);
UQVB_B12 : AND3
	PORT MAP (Z0 => UQVN_N6, A0 => B4, A1 => UQVN_N40, A2 => UQVN_N43);
UQVB_B13 : AND3
	PORT MAP (Z0 => UQVN_N7, A0 => UQVN_N37, A1 => B4, A2 => UQVN_N43);
UQVB_B14 : OR6
	PORT MAP (Z0 => UQVN_N10, A0 => UQVN_N7, A1 => UQVN_N6, A2 => UQVN_N4, 
	A3 => UQVN_N5, A4 => UQVN_N9, A5 => UQVN_N8);
UQVB_B15 : LXOR2
	PORT MAP (Z0 => Z4, A0 => A4, A1 => UQVN_N10);
UQVB_B16 : AND3
	PORT MAP (Z0 => UQVN_N8, A0 => A3, A1 => UQVN_N41, A2 => B3);
UQVB_B17 : AND4
	PORT MAP (Z0 => UQVN_N14, A0 => A3, A1 => A4, A2 => A5, 
	A3 => B3);
UQVB_B18 : AND3
	PORT MAP (Z0 => UQVN_N13, A0 => A4, A1 => A5, A2 => B4);
UQVB_B19 : AND4
	PORT MAP (Z0 => UQVN_N12, A0 => A3, A1 => A5, A2 => B3, 
	A3 => B4);
UQVB_B20 : AND2
	PORT MAP (Z0 => UQVN_N11, A0 => A5, A1 => B5);
UQVB_B21 : AND4
	PORT MAP (Z0 => UQVN_N15, A0 => A3, A1 => A4, A2 => B3, 
	A3 => B5);
UQVB_B22 : AND3
	PORT MAP (Z0 => UQVN_N16, A0 => A4, A1 => B4, A2 => B5);
UQVB_B23 : AND4
	PORT MAP (Z0 => UQVN_N17, A0 => A3, A1 => B3, A2 => B4, 
	A3 => B5);
UQVB_B24 : OR7
	PORT MAP (Z0 => G345, A0 => UQVN_N14, A1 => UQVN_N13, A2 => UQVN_N12, 
	A3 => UQVN_N11, A4 => UQVN_N15, A5 => UQVN_N16, A6 => UQVN_N17);
UQVB_B25 : AND2
	PORT MAP (Z0 => UQVN_N20, A0 => UQVN_N37, A1 => UQVN_N40);
UQVB_B26 : AND2
	PORT MAP (Z0 => UQVN_N18, A0 => UQVN_N38, A1 => UQVN_N41);
UQVB_B27 : AND2
	PORT MAP (Z0 => UQVN_N19, A0 => UQVN_N39, A1 => UQVN_N42);
UQVB_B28 : NOR3
	PORT MAP (ZN0 => P345, A0 => UQVN_N20, A1 => UQVN_N18, A2 => UQVN_N19);
UQVB_B29 : INV
	PORT MAP (ZN0 => UQVN_N40, A0 => B3);
UQVB_B30 : INV
	PORT MAP (ZN0 => UQVN_N38, A0 => A4);
UQVB_B31 : INV
	PORT MAP (ZN0 => UQVN_N39, A0 => A5);
UQVB_B32 : LXOR2
	PORT MAP (Z0 => Z5, A0 => A5, A1 => UQVN_N34);
UQVB_B33 : AND4
	PORT MAP (Z0 => UQVN_N33, A0 => UQVN_N40, A1 => UQVN_N41, A2 => B5, 
	A3 => UQVN_N43);
UQVB_B34 : AND4
	PORT MAP (Z0 => UQVN_N35, A0 => UQVN_N37, A1 => UQVN_N41, A2 => B5, 
	A3 => UQVN_N43);
UQVB_B35 : AND4
	PORT MAP (Z0 => UQVN_N32, A0 => UQVN_N38, A1 => UQVN_N40, A2 => B5, 
	A3 => UQVN_N43);
UQVB_B36 : AND4
	PORT MAP (Z0 => UQVN_N31, A0 => UQVN_N37, A1 => UQVN_N38, A2 => B5, 
	A3 => UQVN_N43);
UQVB_B37 : AND4
	PORT MAP (Z0 => UQVN_N30, A0 => B3, A1 => B4, A2 => UQVN_N42, 
	A3 => G012);
UQVB_B38 : AND4
	PORT MAP (Z0 => UQVN_N29, A0 => A3, A1 => B4, A2 => UQVN_N42, 
	A3 => G012);
UQVB_B39 : AND4
	PORT MAP (Z0 => UQVN_N28, A0 => A4, A1 => B3, A2 => UQVN_N42, 
	A3 => G012);
UQVB_B40 : AND4
	PORT MAP (Z0 => UQVN_N27, A0 => A3, A1 => A4, A2 => UQVN_N42, 
	A3 => G012);
UQVB_B41 : AND4
	PORT MAP (Z0 => UQVN_N26, A0 => A3, A1 => B3, A2 => B4, 
	A3 => UQVN_N42);
UQVB_B42 : AND3
	PORT MAP (Z0 => UQVN_N25, A0 => A4, A1 => B4, A2 => UQVN_N42);
UQVB_B43 : AND4
	PORT MAP (Z0 => UQVN_N24, A0 => A3, A1 => A4, A2 => B3, 
	A3 => UQVN_N42);
UQVB_B44 : AND4
	PORT MAP (Z0 => UQVN_N23, A0 => UQVN_N37, A1 => UQVN_N40, A2 => UQVN_N41, 
	A3 => B5);
UQVB_B45 : AND3
	PORT MAP (Z0 => UQVN_N22, A0 => UQVN_N38, A1 => UQVN_N41, A2 => B5);
UQVB_B46 : AND4
	PORT MAP (Z0 => UQVN_N21, A0 => UQVN_N37, A1 => UQVN_N38, A2 => UQVN_N40, 
	A3 => B5);
UQVB_B47 : OR12
	PORT MAP (Z0 => UQVN_N36, A0 => UQVN_N32, A1 => UQVN_N31, A2 => UQVN_N30, 
	A3 => UQVN_N29, A4 => UQVN_N28, A5 => UQVN_N27, A6 => UQVN_N26, 
	A7 => UQVN_N25, A8 => UQVN_N24, A9 => UQVN_N23, A10 => UQVN_N22, 
	A11 => UQVN_N21);
UQVB_B48 : OR3
	PORT MAP (Z0 => UQVN_N34, A0 => UQVN_N33, A1 => UQVN_N35, A2 => UQVN_N36);
UQVB_B49 : INV
	PORT MAP (ZN0 => UQVN_N86, A0 => UQVN_N217);
UQVB_B50 : INV
	PORT MAP (ZN0 => UQVN_N84, A0 => B10);
UQVB_B51 : INV
	PORT MAP (ZN0 => UQVN_N85, A0 => B11);
UQVB_B52 : INV
	PORT MAP (ZN0 => UQVN_N80, A0 => A9);
UQVB_B53 : AND2
	PORT MAP (Z0 => UQVN_N44, A0 => UQVN_N83, A1 => UQVN_N217);
UQVB_B54 : AND2
	PORT MAP (Z0 => UQVN_N45, A0 => B9, A1 => UQVN_N86);
UQVB_B55 : OR2
	PORT MAP (Z0 => UQVN_N46, A0 => UQVN_N44, A1 => UQVN_N45);
UQVB_B56 : LXOR2
	PORT MAP (Z0 => Z9, A0 => A9, A1 => UQVN_N46);
UQVB_B57 : AND3
	PORT MAP (Z0 => UQVN_N52, A0 => UQVN_N80, A1 => B10, A2 => UQVN_N83);
UQVB_B58 : AND3
	PORT MAP (Z0 => UQVN_N48, A0 => UQVN_N84, A1 => B9, A2 => UQVN_N217);
UQVB_B59 : AND3
	PORT MAP (Z0 => UQVN_N47, A0 => A9, A1 => UQVN_N84, A2 => UQVN_N217);
UQVB_B60 : AND3
	PORT MAP (Z0 => UQVN_N49, A0 => B10, A1 => UQVN_N83, A2 => UQVN_N86);
UQVB_B61 : AND3
	PORT MAP (Z0 => UQVN_N50, A0 => UQVN_N80, A1 => B10, A2 => UQVN_N86);
UQVB_B62 : OR6
	PORT MAP (Z0 => UQVN_N53, A0 => UQVN_N50, A1 => UQVN_N49, A2 => UQVN_N47, 
	A3 => UQVN_N48, A4 => UQVN_N52, A5 => UQVN_N51);
UQVB_B63 : LXOR2
	PORT MAP (Z0 => Z10, A0 => A10, A1 => UQVN_N53);
UQVB_B64 : AND3
	PORT MAP (Z0 => UQVN_N51, A0 => A9, A1 => UQVN_N84, A2 => B9);
UQVB_B65 : AND4
	PORT MAP (Z0 => UQVN_N57, A0 => A9, A1 => A10, A2 => A11, 
	A3 => B9);
UQVB_B66 : AND3
	PORT MAP (Z0 => UQVN_N56, A0 => A10, A1 => A11, A2 => B10);
UQVB_B67 : AND4
	PORT MAP (Z0 => UQVN_N55, A0 => A9, A1 => A11, A2 => B9, 
	A3 => B10);
UQVB_B68 : AND2
	PORT MAP (Z0 => UQVN_N54, A0 => A11, A1 => B11);
UQVB_B69 : AND4
	PORT MAP (Z0 => UQVN_N58, A0 => A9, A1 => A10, A2 => B9, 
	A3 => B11);
UQVB_B70 : AND3
	PORT MAP (Z0 => UQVN_N59, A0 => A10, A1 => B10, A2 => B11);
UQVB_B71 : AND4
	PORT MAP (Z0 => UQVN_N60, A0 => A9, A1 => B9, A2 => B10, 
	A3 => B11);
UQVB_B72 : OR7
	PORT MAP (Z0 => G911, A0 => UQVN_N57, A1 => UQVN_N56, A2 => UQVN_N55, 
	A3 => UQVN_N54, A4 => UQVN_N58, A5 => UQVN_N59, A6 => UQVN_N60);
UQVB_B73 : AND2
	PORT MAP (Z0 => UQVN_N63, A0 => UQVN_N80, A1 => UQVN_N83);
UQVB_B74 : AND2
	PORT MAP (Z0 => UQVN_N61, A0 => UQVN_N81, A1 => UQVN_N84);
UQVB_B75 : AND2
	PORT MAP (Z0 => UQVN_N62, A0 => UQVN_N82, A1 => UQVN_N85);
UQVB_B76 : NOR3
	PORT MAP (ZN0 => P911, A0 => UQVN_N63, A1 => UQVN_N61, A2 => UQVN_N62);
UQVB_B77 : INV
	PORT MAP (ZN0 => UQVN_N83, A0 => B9);
UQVB_B78 : INV
	PORT MAP (ZN0 => UQVN_N81, A0 => A10);
UQVB_B79 : INV
	PORT MAP (ZN0 => UQVN_N82, A0 => A11);
UQVB_B80 : LXOR2
	PORT MAP (Z0 => Z11, A0 => A11, A1 => UQVN_N77);
UQVB_B81 : AND4
	PORT MAP (Z0 => UQVN_N76, A0 => UQVN_N83, A1 => UQVN_N84, A2 => B11, 
	A3 => UQVN_N86);
UQVB_B82 : AND4
	PORT MAP (Z0 => UQVN_N78, A0 => UQVN_N80, A1 => UQVN_N84, A2 => B11, 
	A3 => UQVN_N86);
UQVB_B83 : AND4
	PORT MAP (Z0 => UQVN_N75, A0 => UQVN_N81, A1 => UQVN_N83, A2 => B11, 
	A3 => UQVN_N86);
UQVB_B84 : AND4
	PORT MAP (Z0 => UQVN_N74, A0 => UQVN_N80, A1 => UQVN_N81, A2 => B11, 
	A3 => UQVN_N86);
UQVB_B85 : AND4
	PORT MAP (Z0 => UQVN_N73, A0 => B9, A1 => B10, A2 => UQVN_N85, 
	A3 => UQVN_N217);
UQVB_B86 : AND4
	PORT MAP (Z0 => UQVN_N72, A0 => A9, A1 => B10, A2 => UQVN_N85, 
	A3 => UQVN_N217);
UQVB_B87 : AND4
	PORT MAP (Z0 => UQVN_N71, A0 => A10, A1 => B9, A2 => UQVN_N85, 
	A3 => UQVN_N217);
UQVB_B88 : AND4
	PORT MAP (Z0 => UQVN_N70, A0 => A9, A1 => A10, A2 => UQVN_N85, 
	A3 => UQVN_N217);
UQVB_B89 : AND4
	PORT MAP (Z0 => UQVN_N69, A0 => A9, A1 => B9, A2 => B10, 
	A3 => UQVN_N85);
UQVB_B90 : AND3
	PORT MAP (Z0 => UQVN_N68, A0 => A10, A1 => B10, A2 => UQVN_N85);
UQVB_B91 : AND4
	PORT MAP (Z0 => UQVN_N67, A0 => A9, A1 => A10, A2 => B9, 
	A3 => UQVN_N85);
UQVB_B92 : AND4
	PORT MAP (Z0 => UQVN_N66, A0 => UQVN_N80, A1 => UQVN_N83, A2 => UQVN_N84, 
	A3 => B11);
UQVB_B93 : AND3
	PORT MAP (Z0 => UQVN_N65, A0 => UQVN_N81, A1 => UQVN_N84, A2 => B11);
UQVB_B94 : AND4
	PORT MAP (Z0 => UQVN_N64, A0 => UQVN_N80, A1 => UQVN_N81, A2 => UQVN_N83, 
	A3 => B11);
UQVB_B95 : OR12
	PORT MAP (Z0 => UQVN_N79, A0 => UQVN_N75, A1 => UQVN_N74, A2 => UQVN_N73, 
	A3 => UQVN_N72, A4 => UQVN_N71, A5 => UQVN_N70, A6 => UQVN_N69, 
	A7 => UQVN_N68, A8 => UQVN_N67, A9 => UQVN_N66, A10 => UQVN_N65, 
	A11 => UQVN_N64);
UQVB_B96 : OR3
	PORT MAP (Z0 => UQVN_N77, A0 => UQVN_N76, A1 => UQVN_N78, A2 => UQVN_N79);
UQVB_B97 : INV
	PORT MAP (ZN0 => UQVN_N129, A0 => UQVN_N218);
UQVB_B98 : INV
	PORT MAP (ZN0 => UQVN_N127, A0 => B13);
UQVB_B99 : INV
	PORT MAP (ZN0 => UQVN_N128, A0 => B14);
UQVB_B100 : INV
	PORT MAP (ZN0 => UQVN_N123, A0 => A12);
UQVB_B101 : AND2
	PORT MAP (Z0 => UQVN_N87, A0 => UQVN_N126, A1 => UQVN_N218);
UQVB_B102 : AND2
	PORT MAP (Z0 => UQVN_N88, A0 => B12, A1 => UQVN_N129);
UQVB_B103 : OR2
	PORT MAP (Z0 => UQVN_N89, A0 => UQVN_N87, A1 => UQVN_N88);
UQVB_B104 : LXOR2
	PORT MAP (Z0 => Z12, A0 => A12, A1 => UQVN_N89);
UQVB_B105 : AND3
	PORT MAP (Z0 => UQVN_N95, A0 => UQVN_N123, A1 => B13, A2 => UQVN_N126);
UQVB_B106 : AND3
	PORT MAP (Z0 => UQVN_N91, A0 => UQVN_N127, A1 => B12, A2 => UQVN_N218);
UQVB_B107 : AND3
	PORT MAP (Z0 => UQVN_N90, A0 => A12, A1 => UQVN_N127, A2 => UQVN_N218);
UQVB_B108 : AND3
	PORT MAP (Z0 => UQVN_N92, A0 => B13, A1 => UQVN_N126, A2 => UQVN_N129);
UQVB_B109 : AND3
	PORT MAP (Z0 => UQVN_N93, A0 => UQVN_N123, A1 => B13, A2 => UQVN_N129);
UQVB_B110 : OR6
	PORT MAP (Z0 => UQVN_N96, A0 => UQVN_N93, A1 => UQVN_N92, A2 => UQVN_N90, 
	A3 => UQVN_N91, A4 => UQVN_N95, A5 => UQVN_N94);
UQVB_B111 : LXOR2
	PORT MAP (Z0 => Z13, A0 => A13, A1 => UQVN_N96);
UQVB_B112 : AND3
	PORT MAP (Z0 => UQVN_N94, A0 => A12, A1 => UQVN_N127, A2 => B12);
UQVB_B113 : AND4
	PORT MAP (Z0 => UQVN_N100, A0 => A12, A1 => A13, A2 => A14, 
	A3 => B12);
UQVB_B114 : AND3
	PORT MAP (Z0 => UQVN_N99, A0 => A13, A1 => A14, A2 => B13);
UQVB_B115 : AND4
	PORT MAP (Z0 => UQVN_N98, A0 => A12, A1 => A14, A2 => B12, 
	A3 => B13);
UQVB_B116 : AND2
	PORT MAP (Z0 => UQVN_N97, A0 => A14, A1 => B14);
UQVB_B117 : AND4
	PORT MAP (Z0 => UQVN_N101, A0 => A12, A1 => A13, A2 => B12, 
	A3 => B14);
UQVB_B118 : AND3
	PORT MAP (Z0 => UQVN_N102, A0 => A13, A1 => B13, A2 => B14);
UQVB_B119 : AND4
	PORT MAP (Z0 => UQVN_N103, A0 => A12, A1 => B12, A2 => B13, 
	A3 => B14);
UQVB_B120 : OR7
	PORT MAP (Z0 => G1214, A0 => UQVN_N100, A1 => UQVN_N99, A2 => UQVN_N98, 
	A3 => UQVN_N97, A4 => UQVN_N101, A5 => UQVN_N102, A6 => UQVN_N103);
UQVB_B121 : AND2
	PORT MAP (Z0 => UQVN_N106, A0 => UQVN_N123, A1 => UQVN_N126);
UQVB_B122 : AND2
	PORT MAP (Z0 => UQVN_N104, A0 => UQVN_N124, A1 => UQVN_N127);
UQVB_B123 : AND2
	PORT MAP (Z0 => UQVN_N105, A0 => UQVN_N125, A1 => UQVN_N128);
UQVB_B124 : NOR3
	PORT MAP (ZN0 => P1214, A0 => UQVN_N106, A1 => UQVN_N104, A2 => UQVN_N105);
UQVB_B125 : INV
	PORT MAP (ZN0 => UQVN_N126, A0 => B12);
UQVB_B126 : INV
	PORT MAP (ZN0 => UQVN_N124, A0 => A13);
UQVB_B127 : INV
	PORT MAP (ZN0 => UQVN_N125, A0 => A14);
UQVB_B128 : LXOR2
	PORT MAP (Z0 => Z14, A0 => A14, A1 => UQVN_N120);
UQVB_B129 : AND4
	PORT MAP (Z0 => UQVN_N119, A0 => UQVN_N126, A1 => UQVN_N127, A2 => B14, 
	A3 => UQVN_N129);
UQVB_B130 : AND4
	PORT MAP (Z0 => UQVN_N121, A0 => UQVN_N123, A1 => UQVN_N127, A2 => B14, 
	A3 => UQVN_N129);
UQVB_B131 : AND4
	PORT MAP (Z0 => UQVN_N118, A0 => UQVN_N124, A1 => UQVN_N126, A2 => B14, 
	A3 => UQVN_N129);
UQVB_B132 : AND4
	PORT MAP (Z0 => UQVN_N117, A0 => UQVN_N123, A1 => UQVN_N124, A2 => B14, 
	A3 => UQVN_N129);
UQVB_B133 : AND4
	PORT MAP (Z0 => UQVN_N116, A0 => B12, A1 => B13, A2 => UQVN_N128, 
	A3 => UQVN_N218);
UQVB_B134 : AND4
	PORT MAP (Z0 => UQVN_N115, A0 => A12, A1 => B13, A2 => UQVN_N128, 
	A3 => UQVN_N218);
UQVB_B135 : AND4
	PORT MAP (Z0 => UQVN_N114, A0 => A13, A1 => B12, A2 => UQVN_N128, 
	A3 => UQVN_N218);
UQVB_B136 : AND4
	PORT MAP (Z0 => UQVN_N113, A0 => A12, A1 => A13, A2 => UQVN_N128, 
	A3 => UQVN_N218);
UQVB_B137 : AND4
	PORT MAP (Z0 => UQVN_N112, A0 => A12, A1 => B12, A2 => B13, 
	A3 => UQVN_N128);
UQVB_B138 : AND3
	PORT MAP (Z0 => UQVN_N111, A0 => A13, A1 => B13, A2 => UQVN_N128);
UQVB_B139 : AND4
	PORT MAP (Z0 => UQVN_N110, A0 => A12, A1 => A13, A2 => B12, 
	A3 => UQVN_N128);
UQVB_B140 : AND4
	PORT MAP (Z0 => UQVN_N109, A0 => UQVN_N123, A1 => UQVN_N126, A2 => UQVN_N127, 
	A3 => B14);
UQVB_B141 : AND3
	PORT MAP (Z0 => UQVN_N108, A0 => UQVN_N124, A1 => UQVN_N127, A2 => B14);
UQVB_B142 : AND4
	PORT MAP (Z0 => UQVN_N107, A0 => UQVN_N123, A1 => UQVN_N124, A2 => UQVN_N126, 
	A3 => B14);
UQVB_B143 : OR12
	PORT MAP (Z0 => UQVN_N122, A0 => UQVN_N118, A1 => UQVN_N117, A2 => UQVN_N116, 
	A3 => UQVN_N115, A4 => UQVN_N114, A5 => UQVN_N113, A6 => UQVN_N112, 
	A7 => UQVN_N111, A8 => UQVN_N110, A9 => UQVN_N109, A10 => UQVN_N108, 
	A11 => UQVN_N107);
UQVB_B144 : OR3
	PORT MAP (Z0 => UQVN_N120, A0 => UQVN_N119, A1 => UQVN_N121, A2 => UQVN_N122);
UQVB_B145 : AND2
	PORT MAP (Z0 => UQVN_N130, A0 => P345, A1 => G012);
UQVB_B146 : OR2
	PORT MAP (Z0 => UQVN_N216, A0 => G345, A1 => UQVN_N130);
UQVB_B147 : INV
	PORT MAP (ZN0 => UQVN_N173, A0 => UQVN_N216);
UQVB_B148 : INV
	PORT MAP (ZN0 => UQVN_N171, A0 => B7);
UQVB_B149 : INV
	PORT MAP (ZN0 => UQVN_N172, A0 => B8);
UQVB_B150 : INV
	PORT MAP (ZN0 => UQVN_N167, A0 => A6);
UQVB_B151 : AND2
	PORT MAP (Z0 => UQVN_N131, A0 => UQVN_N170, A1 => UQVN_N216);
UQVB_B152 : AND2
	PORT MAP (Z0 => UQVN_N132, A0 => B6, A1 => UQVN_N173);
UQVB_B153 : OR2
	PORT MAP (Z0 => UQVN_N133, A0 => UQVN_N131, A1 => UQVN_N132);
UQVB_B154 : LXOR2
	PORT MAP (Z0 => Z6, A0 => A6, A1 => UQVN_N133);
UQVB_B155 : AND3
	PORT MAP (Z0 => UQVN_N139, A0 => UQVN_N167, A1 => B7, A2 => UQVN_N170);
UQVB_B156 : AND3
	PORT MAP (Z0 => UQVN_N135, A0 => UQVN_N171, A1 => B6, A2 => UQVN_N216);
UQVB_B157 : AND3
	PORT MAP (Z0 => UQVN_N134, A0 => A6, A1 => UQVN_N171, A2 => UQVN_N216);
UQVB_B158 : AND3
	PORT MAP (Z0 => UQVN_N136, A0 => B7, A1 => UQVN_N170, A2 => UQVN_N173);
UQVB_B159 : AND3
	PORT MAP (Z0 => UQVN_N137, A0 => UQVN_N167, A1 => B7, A2 => UQVN_N173);
UQVB_B160 : OR6
	PORT MAP (Z0 => UQVN_N140, A0 => UQVN_N137, A1 => UQVN_N136, A2 => UQVN_N134, 
	A3 => UQVN_N135, A4 => UQVN_N139, A5 => UQVN_N138);
UQVB_B161 : LXOR2
	PORT MAP (Z0 => Z7, A0 => A7, A1 => UQVN_N140);
UQVB_B162 : AND3
	PORT MAP (Z0 => UQVN_N138, A0 => A6, A1 => UQVN_N171, A2 => B6);
UQVB_B163 : AND4
	PORT MAP (Z0 => UQVN_N144, A0 => A6, A1 => A7, A2 => A8, 
	A3 => B6);
UQVB_B164 : AND3
	PORT MAP (Z0 => UQVN_N143, A0 => A7, A1 => A8, A2 => B7);
UQVB_B165 : AND4
	PORT MAP (Z0 => UQVN_N142, A0 => A6, A1 => A8, A2 => B6, 
	A3 => B7);
UQVB_B166 : AND2
	PORT MAP (Z0 => UQVN_N141, A0 => A8, A1 => B8);
UQVB_B167 : AND4
	PORT MAP (Z0 => UQVN_N145, A0 => A6, A1 => A7, A2 => B6, 
	A3 => B8);
UQVB_B168 : AND3
	PORT MAP (Z0 => UQVN_N146, A0 => A7, A1 => B7, A2 => B8);
UQVB_B169 : AND4
	PORT MAP (Z0 => UQVN_N147, A0 => A6, A1 => B6, A2 => B7, 
	A3 => B8);
UQVB_B170 : OR7
	PORT MAP (Z0 => G678, A0 => UQVN_N144, A1 => UQVN_N143, A2 => UQVN_N142, 
	A3 => UQVN_N141, A4 => UQVN_N145, A5 => UQVN_N146, A6 => UQVN_N147);
UQVB_B171 : AND2
	PORT MAP (Z0 => UQVN_N150, A0 => UQVN_N167, A1 => UQVN_N170);
UQVB_B172 : AND2
	PORT MAP (Z0 => UQVN_N148, A0 => UQVN_N168, A1 => UQVN_N171);
UQVB_B173 : AND2
	PORT MAP (Z0 => UQVN_N149, A0 => UQVN_N169, A1 => UQVN_N172);
UQVB_B174 : NOR3
	PORT MAP (ZN0 => P678, A0 => UQVN_N150, A1 => UQVN_N148, A2 => UQVN_N149);
UQVB_B175 : INV
	PORT MAP (ZN0 => UQVN_N170, A0 => B6);
UQVB_B176 : INV
	PORT MAP (ZN0 => UQVN_N168, A0 => A7);
UQVB_B177 : INV
	PORT MAP (ZN0 => UQVN_N169, A0 => A8);
UQVB_B178 : LXOR2
	PORT MAP (Z0 => Z8, A0 => A8, A1 => UQVN_N164);
UQVB_B179 : AND4
	PORT MAP (Z0 => UQVN_N163, A0 => UQVN_N170, A1 => UQVN_N171, A2 => B8, 
	A3 => UQVN_N173);
UQVB_B180 : AND4
	PORT MAP (Z0 => UQVN_N165, A0 => UQVN_N167, A1 => UQVN_N171, A2 => B8, 
	A3 => UQVN_N173);
UQVB_B181 : AND4
	PORT MAP (Z0 => UQVN_N162, A0 => UQVN_N168, A1 => UQVN_N170, A2 => B8, 
	A3 => UQVN_N173);
UQVB_B182 : AND4
	PORT MAP (Z0 => UQVN_N161, A0 => UQVN_N167, A1 => UQVN_N168, A2 => B8, 
	A3 => UQVN_N173);
UQVB_B183 : AND4
	PORT MAP (Z0 => UQVN_N160, A0 => B6, A1 => B7, A2 => UQVN_N172, 
	A3 => UQVN_N216);
UQVB_B184 : AND4
	PORT MAP (Z0 => UQVN_N159, A0 => A6, A1 => B7, A2 => UQVN_N172, 
	A3 => UQVN_N216);
UQVB_B185 : AND4
	PORT MAP (Z0 => UQVN_N158, A0 => A7, A1 => B6, A2 => UQVN_N172, 
	A3 => UQVN_N216);
UQVB_B186 : AND4
	PORT MAP (Z0 => UQVN_N157, A0 => A6, A1 => A7, A2 => UQVN_N172, 
	A3 => UQVN_N216);
UQVB_B187 : AND4
	PORT MAP (Z0 => UQVN_N156, A0 => A6, A1 => B6, A2 => B7, 
	A3 => UQVN_N172);
UQVB_B188 : AND3
	PORT MAP (Z0 => UQVN_N155, A0 => A7, A1 => B7, A2 => UQVN_N172);
UQVB_B189 : AND4
	PORT MAP (Z0 => UQVN_N154, A0 => A6, A1 => A7, A2 => B6, 
	A3 => UQVN_N172);
UQVB_B190 : AND4
	PORT MAP (Z0 => UQVN_N153, A0 => UQVN_N167, A1 => UQVN_N170, A2 => UQVN_N171, 
	A3 => B8);
UQVB_B191 : AND3
	PORT MAP (Z0 => UQVN_N152, A0 => UQVN_N168, A1 => UQVN_N171, A2 => B8);
UQVB_B192 : AND4
	PORT MAP (Z0 => UQVN_N151, A0 => UQVN_N167, A1 => UQVN_N168, A2 => UQVN_N170, 
	A3 => B8);
UQVB_B193 : OR12
	PORT MAP (Z0 => UQVN_N166, A0 => UQVN_N162, A1 => UQVN_N161, A2 => UQVN_N160, 
	A3 => UQVN_N159, A4 => UQVN_N158, A5 => UQVN_N157, A6 => UQVN_N156, 
	A7 => UQVN_N155, A8 => UQVN_N154, A9 => UQVN_N153, A10 => UQVN_N152, 
	A11 => UQVN_N151);
UQVB_B194 : OR3
	PORT MAP (Z0 => UQVN_N164, A0 => UQVN_N163, A1 => UQVN_N165, A2 => UQVN_N166);
UQVB_B195 : OR3
	PORT MAP (Z0 => UQVN_N217, A0 => G678, A1 => UQVN_N174, A2 => UQVN_N175);
UQVB_B196 : AND3
	PORT MAP (Z0 => UQVN_N175, A0 => P678, A1 => P345, A2 => G012);
UQVB_B197 : AND2
	PORT MAP (Z0 => UQVN_N174, A0 => P678, A1 => G345);
UQVB_B198 : OR4
	PORT MAP (Z0 => UQVN_N218, A0 => G911, A1 => UQVN_N176, A2 => UQVN_N177, 
	A3 => UQVN_N178);
UQVB_B199 : AND2
	PORT MAP (Z0 => UQVN_N176, A0 => P911, A1 => G678);
UQVB_B200 : AND3
	PORT MAP (Z0 => UQVN_N177, A0 => P911, A1 => P678, A2 => G345);
UQVB_B201 : AND4
	PORT MAP (Z0 => UQVN_N178, A0 => P911, A1 => P678, A2 => P345, 
	A3 => G012);
UQVB_B202 : OR5
	PORT MAP (Z0 => UQVN_N219, A0 => G1214, A1 => UQVN_N179, A2 => UQVN_N180, 
	A3 => UQVN_N181, A4 => UQVN_N182);
UQVB_B203 : AND2
	PORT MAP (Z0 => UQVN_N179, A0 => P1214, A1 => G911);
UQVB_B204 : AND3
	PORT MAP (Z0 => UQVN_N180, A0 => P1214, A1 => P911, A2 => G678);
UQVB_B205 : AND4
	PORT MAP (Z0 => UQVN_N181, A0 => P1214, A1 => P911, A2 => P678, 
	A3 => G345);
UQVB_B206 : AND5
	PORT MAP (Z0 => UQVN_N182, A0 => P1214, A1 => P911, A2 => P678, 
	A3 => P345, A4 => G012);
UQVB_B207 : INV
	PORT MAP (ZN0 => UQVN_N206, A0 => B1);
UQVB_B208 : INV
	PORT MAP (ZN0 => UQVN_N203, A0 => A0);
UQVB_B209 : LXOR2
	PORT MAP (Z0 => Z0, A0 => A0, A1 => B0);
UQVB_B210 : LXOR2
	PORT MAP (Z0 => Z1, A0 => A1, A1 => UQVN_N186);
UQVB_B211 : AND3
	PORT MAP (Z0 => UQVN_N185, A0 => A0, A1 => UQVN_N206, A2 => B0);
UQVB_B212 : AND4
	PORT MAP (Z0 => UQVN_N190, A0 => A0, A1 => A1, A2 => A2, 
	A3 => B0);
UQVB_B213 : AND3
	PORT MAP (Z0 => UQVN_N189, A0 => A1, A1 => A2, A2 => B1);
UQVB_B214 : AND4
	PORT MAP (Z0 => UQVN_N188, A0 => A0, A1 => A2, A2 => B0, 
	A3 => B1);
UQVB_B215 : AND2
	PORT MAP (Z0 => UQVN_N187, A0 => A2, A1 => B2);
UQVB_B216 : AND4
	PORT MAP (Z0 => UQVN_N191, A0 => A0, A1 => A1, A2 => B0, 
	A3 => B2);
UQVB_B217 : AND3
	PORT MAP (Z0 => UQVN_N192, A0 => A1, A1 => B1, A2 => B2);
UQVB_B218 : AND4
	PORT MAP (Z0 => UQVN_N193, A0 => A0, A1 => B0, A2 => B1, 
	A3 => B2);
UQVB_B219 : OR7
	PORT MAP (Z0 => G012, A0 => UQVN_N190, A1 => UQVN_N189, A2 => UQVN_N188, 
	A3 => UQVN_N187, A4 => UQVN_N191, A5 => UQVN_N192, A6 => UQVN_N193);
UQVB_B220 : INV
	PORT MAP (ZN0 => UQVN_N205, A0 => B0);
UQVB_B221 : INV
	PORT MAP (ZN0 => UQVN_N204, A0 => A1);
UQVB_B222 : AND2
	PORT MAP (Z0 => UQVN_N184, A0 => UQVN_N203, A1 => B1);
UQVB_B223 : AND2
	PORT MAP (Z0 => UQVN_N183, A0 => B1, A1 => UQVN_N205);
UQVB_B224 : OR3
	PORT MAP (Z0 => UQVN_N186, A0 => UQVN_N184, A1 => UQVN_N183, A2 => UQVN_N185);
UQVB_B225 : INV
	PORT MAP (ZN0 => UQVN_N207, A0 => B2);
UQVB_B226 : LXOR2
	PORT MAP (Z0 => Z2, A0 => A2, A1 => UQVN_N198);
UQVB_B227 : AND4
	PORT MAP (Z0 => UQVN_N197, A0 => A0, A1 => B0, A2 => B1, 
	A3 => UQVN_N207);
UQVB_B228 : AND3
	PORT MAP (Z0 => UQVN_N196, A0 => A1, A1 => B1, A2 => UQVN_N207);
UQVB_B229 : AND4
	PORT MAP (Z0 => UQVN_N195, A0 => A0, A1 => A1, A2 => B0, 
	A3 => UQVN_N207);
UQVB_B230 : AND3
	PORT MAP (Z0 => UQVN_N194, A0 => UQVN_N204, A1 => UQVN_N206, A2 => B2);
UQVB_B231 : AND3
	PORT MAP (Z0 => UQVN_N202, A0 => UQVN_N205, A1 => UQVN_N206, A2 => B2);
UQVB_B232 : AND3
	PORT MAP (Z0 => UQVN_N201, A0 => UQVN_N203, A1 => UQVN_N206, A2 => B2);
UQVB_B233 : AND3
	PORT MAP (Z0 => UQVN_N200, A0 => UQVN_N204, A1 => UQVN_N205, A2 => B2);
UQVB_B234 : AND3
	PORT MAP (Z0 => UQVN_N199, A0 => UQVN_N203, A1 => UQVN_N204, A2 => B2);
UQVB_B235 : OR8
	PORT MAP (Z0 => UQVN_N198, A0 => UQVN_N202, A1 => UQVN_N201, A2 => UQVN_N200, 
	A3 => UQVN_N199, A4 => UQVN_N197, A5 => UQVN_N196, A6 => UQVN_N195, 
	A7 => UQVN_N194);
UQVB_B236 : AND2
	PORT MAP (Z0 => UQVN_N209, A0 => UQVN_N215, A1 => UQVN_N219);
UQVB_B237 : AND2
	PORT MAP (Z0 => UQVN_N210, A0 => B15, A1 => UQVN_N208);
UQVB_B238 : OR2
	PORT MAP (Z0 => UQVN_N211, A0 => UQVN_N210, A1 => UQVN_N209);
UQVB_B239 : XOR2
	PORT MAP (Z0 => Z15, A0 => A15, A1 => UQVN_N211);
UQVB_B240 : INV
	PORT MAP (ZN0 => UQVN_N215, A0 => B15);
UQVB_B241 : INV
	PORT MAP (ZN0 => UQVN_N208, A0 => UQVN_N219);
UQVB_B242 : AND2
	PORT MAP (Z0 => UQVN_N212, A0 => UQVN_N219, A1 => B15);
UQVB_B243 : AND2
	PORT MAP (Z0 => UQVN_N213, A0 => UQVN_N219, A1 => A15);
UQVB_B244 : AND2
	PORT MAP (Z0 => UQVN_N214, A0 => B15, A1 => A15);
UQVB_B245 : OR3
	PORT MAP (Z0 => CO, A0 => UQVN_N212, A1 => UQVN_N213, A2 => UQVN_N214);
END lattice_arch;
-- VHDL netlist for ADDH2
-- Date: 15.5.95 13.44.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY ADDH2 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        B0 : IN std_logic;
        B1 : IN std_logic;
        Z0 : OUT std_logic;
        Z1 : OUT std_logic;
        CO : OUT std_logic
    );
END ADDH2;


ARCHITECTURE lattice_arch OF ADDH2 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15 : std_logic;


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT OR3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR3 use  entity  lattice.OR3(lattice_arch);


  COMPONENT OR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR2 use  entity  lattice.OR2(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT OR6
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR6 use  entity  lattice.OR6(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


BEGIN

UQVB_B1 : AND2
	PORT MAP (Z0 => UQVN_N2, A0 => UQVN_N12, A1 => B0);
UQVB_B2 : AND2
	PORT MAP (Z0 => UQVN_N1, A0 => A0, A1 => UQVN_N14);
UQVB_B3 : AND3
	PORT MAP (Z0 => UQVN_N3, A0 => A1, A1 => A0, A2 => B0);
UQVB_B4 : AND3
	PORT MAP (Z0 => UQVN_N5, A0 => A0, A1 => B1, A2 => B0);
UQVB_B5 : AND2
	PORT MAP (Z0 => UQVN_N4, A0 => A1, A1 => B1);
UQVB_B6 : OR3
	PORT MAP (Z0 => CO, A0 => UQVN_N3, A1 => UQVN_N5, A2 => UQVN_N4);
UQVB_B7 : OR2
	PORT MAP (Z0 => Z0, A0 => UQVN_N2, A1 => UQVN_N1);
UQVB_B8 : INV
	PORT MAP (ZN0 => UQVN_N14, A0 => B0);
UQVB_B9 : INV
	PORT MAP (ZN0 => UQVN_N15, A0 => B1);
UQVB_B10 : OR6
	PORT MAP (Z0 => Z1, A0 => UQVN_N6, A1 => UQVN_N8, A2 => UQVN_N7, 
	A3 => UQVN_N9, A4 => UQVN_N10, A5 => UQVN_N11);
UQVB_B11 : AND3
	PORT MAP (Z0 => UQVN_N6, A0 => UQVN_N13, A1 => B1, A2 => UQVN_N12);
UQVB_B12 : AND3
	PORT MAP (Z0 => UQVN_N8, A0 => UQVN_N13, A1 => B1, A2 => UQVN_N14);
UQVB_B13 : AND3
	PORT MAP (Z0 => UQVN_N7, A0 => A1, A1 => UQVN_N15, A2 => UQVN_N12);
UQVB_B14 : AND3
	PORT MAP (Z0 => UQVN_N9, A0 => A1, A1 => UQVN_N15, A2 => UQVN_N14);
UQVB_B15 : AND4
	PORT MAP (Z0 => UQVN_N10, A0 => UQVN_N13, A1 => UQVN_N15, A2 => A0, 
	A3 => B0);
UQVB_B16 : AND4
	PORT MAP (Z0 => UQVN_N11, A0 => A1, A1 => B1, A2 => A0, 
	A3 => B0);
UQVB_B17 : INV
	PORT MAP (ZN0 => UQVN_N12, A0 => A0);
UQVB_B18 : INV
	PORT MAP (ZN0 => UQVN_N13, A0 => A1);
END lattice_arch;
-- VHDL netlist for ADDH3
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY ADDH3 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        B0 : IN std_logic;
        B1 : IN std_logic;
        B2 : IN std_logic;
        Z0 : OUT std_logic;
        Z1 : OUT std_logic;
        Z2 : OUT std_logic;
        CO : OUT std_logic
    );
END ADDH3;


ARCHITECTURE lattice_arch OF ADDH3 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, UQVN_N23, UQVN_N24,
	 UQVN_N25 : std_logic;


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT OR7
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR7 use  entity  lattice.OR7(lattice_arch);


  COMPONENT OR3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR3 use  entity  lattice.OR3(lattice_arch);


  COMPONENT OR8
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR8 use  entity  lattice.OR8(lattice_arch);


BEGIN

UQVB_B1 : INV
	PORT MAP (ZN0 => UQVN_N24, A0 => B1);
UQVB_B2 : INV
	PORT MAP (ZN0 => UQVN_N21, A0 => A0);
UQVB_B3 : LXOR2
	PORT MAP (Z0 => Z0, A0 => A0, A1 => B0);
UQVB_B4 : LXOR2
	PORT MAP (Z0 => Z1, A0 => A1, A1 => UQVN_N4);
UQVB_B5 : AND3
	PORT MAP (Z0 => UQVN_N3, A0 => A0, A1 => UQVN_N24, A2 => B0);
UQVB_B6 : AND4
	PORT MAP (Z0 => UQVN_N8, A0 => A0, A1 => A1, A2 => A2, 
	A3 => B0);
UQVB_B7 : AND3
	PORT MAP (Z0 => UQVN_N7, A0 => A1, A1 => A2, A2 => B1);
UQVB_B8 : AND4
	PORT MAP (Z0 => UQVN_N6, A0 => A0, A1 => A2, A2 => B0, 
	A3 => B1);
UQVB_B9 : AND2
	PORT MAP (Z0 => UQVN_N5, A0 => A2, A1 => B2);
UQVB_B10 : AND4
	PORT MAP (Z0 => UQVN_N9, A0 => A0, A1 => A1, A2 => B0, 
	A3 => B2);
UQVB_B11 : AND3
	PORT MAP (Z0 => UQVN_N10, A0 => A1, A1 => B1, A2 => B2);
UQVB_B12 : AND4
	PORT MAP (Z0 => UQVN_N11, A0 => A0, A1 => B0, A2 => B1, 
	A3 => B2);
UQVB_B13 : OR7
	PORT MAP (Z0 => CO, A0 => UQVN_N8, A1 => UQVN_N7, A2 => UQVN_N6, 
	A3 => UQVN_N5, A4 => UQVN_N9, A5 => UQVN_N10, A6 => UQVN_N11);
UQVB_B14 : INV
	PORT MAP (ZN0 => UQVN_N23, A0 => B0);
UQVB_B15 : INV
	PORT MAP (ZN0 => UQVN_N22, A0 => A1);
UQVB_B16 : AND2
	PORT MAP (Z0 => UQVN_N2, A0 => UQVN_N21, A1 => B1);
UQVB_B17 : AND2
	PORT MAP (Z0 => UQVN_N1, A0 => B1, A1 => UQVN_N23);
UQVB_B18 : OR3
	PORT MAP (Z0 => UQVN_N4, A0 => UQVN_N2, A1 => UQVN_N1, A2 => UQVN_N3);
UQVB_B19 : INV
	PORT MAP (ZN0 => UQVN_N25, A0 => B2);
UQVB_B20 : LXOR2
	PORT MAP (Z0 => Z2, A0 => A2, A1 => UQVN_N16);
UQVB_B21 : AND4
	PORT MAP (Z0 => UQVN_N15, A0 => A0, A1 => B0, A2 => B1, 
	A3 => UQVN_N25);
UQVB_B22 : AND3
	PORT MAP (Z0 => UQVN_N14, A0 => A1, A1 => B1, A2 => UQVN_N25);
UQVB_B23 : AND4
	PORT MAP (Z0 => UQVN_N13, A0 => A0, A1 => A1, A2 => B0, 
	A3 => UQVN_N25);
UQVB_B24 : AND3
	PORT MAP (Z0 => UQVN_N12, A0 => UQVN_N22, A1 => UQVN_N24, A2 => B2);
UQVB_B25 : AND3
	PORT MAP (Z0 => UQVN_N20, A0 => UQVN_N23, A1 => UQVN_N24, A2 => B2);
UQVB_B26 : AND3
	PORT MAP (Z0 => UQVN_N19, A0 => UQVN_N21, A1 => UQVN_N24, A2 => B2);
UQVB_B27 : AND3
	PORT MAP (Z0 => UQVN_N18, A0 => UQVN_N22, A1 => UQVN_N23, A2 => B2);
UQVB_B28 : AND3
	PORT MAP (Z0 => UQVN_N17, A0 => UQVN_N21, A1 => UQVN_N22, A2 => B2);
UQVB_B29 : OR8
	PORT MAP (Z0 => UQVN_N16, A0 => UQVN_N20, A1 => UQVN_N19, A2 => UQVN_N18, 
	A3 => UQVN_N17, A4 => UQVN_N15, A5 => UQVN_N14, A6 => UQVN_N13, 
	A7 => UQVN_N12);
END lattice_arch;
-- VHDL netlist for ADDH4
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY ADDH4 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        B0 : IN std_logic;
        B1 : IN std_logic;
        B2 : IN std_logic;
        B3 : IN std_logic;
        Z0 : OUT std_logic;
        Z1 : OUT std_logic;
        Z2 : OUT std_logic;
        Z3 : OUT std_logic;
        CO : OUT std_logic
    );
END ADDH4;


ARCHITECTURE lattice_arch OF ADDH4 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, UQVN_N23, UQVN_N24,
	 UQVN_N25, UQVN_N26, UQVN_N27, UQVN_N28,
	 UQVN_N29, UQVN_N30, UQVN_N31, UQVN_N32,
	 UQVN_N33, UQVN_N34, UQVN_N35, UQVN_N36,
	 UQVN_N37 : std_logic;


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT OR3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR3 use  entity  lattice.OR3(lattice_arch);


  COMPONENT OR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR2 use  entity  lattice.OR2(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT OR6
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR6 use  entity  lattice.OR6(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT OR7
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR7 use  entity  lattice.OR7(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


  COMPONENT XOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: XOR2 use  entity  lattice.XOR2(lattice_arch);


BEGIN

UQVB_B1 : AND2
	PORT MAP (Z0 => UQVN_N2, A0 => UQVN_N12, A1 => B0);
UQVB_B2 : AND2
	PORT MAP (Z0 => UQVN_N1, A0 => A0, A1 => UQVN_N14);
UQVB_B3 : AND3
	PORT MAP (Z0 => UQVN_N3, A0 => A1, A1 => A0, A2 => B0);
UQVB_B4 : AND3
	PORT MAP (Z0 => UQVN_N5, A0 => A0, A1 => B1, A2 => B0);
UQVB_B5 : AND2
	PORT MAP (Z0 => UQVN_N4, A0 => A1, A1 => B1);
UQVB_B6 : OR3
	PORT MAP (Z0 => UQVN_N37, A0 => UQVN_N3, A1 => UQVN_N5, A2 => UQVN_N4);
UQVB_B7 : OR2
	PORT MAP (Z0 => Z0, A0 => UQVN_N2, A1 => UQVN_N1);
UQVB_B8 : INV
	PORT MAP (ZN0 => UQVN_N14, A0 => B0);
UQVB_B9 : INV
	PORT MAP (ZN0 => UQVN_N15, A0 => B1);
UQVB_B10 : OR6
	PORT MAP (Z0 => Z1, A0 => UQVN_N6, A1 => UQVN_N8, A2 => UQVN_N7, 
	A3 => UQVN_N9, A4 => UQVN_N10, A5 => UQVN_N11);
UQVB_B11 : AND3
	PORT MAP (Z0 => UQVN_N6, A0 => UQVN_N13, A1 => B1, A2 => UQVN_N12);
UQVB_B12 : AND3
	PORT MAP (Z0 => UQVN_N8, A0 => UQVN_N13, A1 => B1, A2 => UQVN_N14);
UQVB_B13 : AND3
	PORT MAP (Z0 => UQVN_N7, A0 => A1, A1 => UQVN_N15, A2 => UQVN_N12);
UQVB_B14 : AND3
	PORT MAP (Z0 => UQVN_N9, A0 => A1, A1 => UQVN_N15, A2 => UQVN_N14);
UQVB_B15 : AND4
	PORT MAP (Z0 => UQVN_N10, A0 => UQVN_N13, A1 => UQVN_N15, A2 => A0, 
	A3 => B0);
UQVB_B16 : AND4
	PORT MAP (Z0 => UQVN_N11, A0 => A1, A1 => B1, A2 => A0, 
	A3 => B0);
UQVB_B17 : INV
	PORT MAP (ZN0 => UQVN_N12, A0 => A0);
UQVB_B18 : INV
	PORT MAP (ZN0 => UQVN_N13, A0 => A1);
UQVB_B19 : INV
	PORT MAP (ZN0 => UQVN_N36, A0 => UQVN_N37);
UQVB_B20 : AND3
	PORT MAP (Z0 => UQVN_N18, A0 => UQVN_N37, A1 => A3, A2 => A2);
UQVB_B21 : AND3
	PORT MAP (Z0 => UQVN_N17, A0 => UQVN_N37, A1 => A3, A2 => B2);
UQVB_B22 : AND3
	PORT MAP (Z0 => UQVN_N16, A0 => UQVN_N37, A1 => A2, A2 => B3);
UQVB_B23 : AND3
	PORT MAP (Z0 => UQVN_N19, A0 => UQVN_N37, A1 => B3, A2 => B2);
UQVB_B24 : AND3
	PORT MAP (Z0 => UQVN_N20, A0 => A3, A1 => A2, A2 => B2);
UQVB_B25 : AND3
	PORT MAP (Z0 => UQVN_N22, A0 => A2, A1 => B3, A2 => B2);
UQVB_B26 : AND2
	PORT MAP (Z0 => UQVN_N21, A0 => A3, A1 => B3);
UQVB_B27 : OR7
	PORT MAP (Z0 => CO, A0 => UQVN_N18, A1 => UQVN_N17, A2 => UQVN_N16, 
	A3 => UQVN_N19, A4 => UQVN_N20, A5 => UQVN_N22, A6 => UQVN_N21);
UQVB_B28 : AND3
	PORT MAP (Z0 => UQVN_N23, A0 => UQVN_N33, A1 => B3, A2 => UQVN_N36);
UQVB_B29 : AND3
	PORT MAP (Z0 => UQVN_N24, A0 => B3, A1 => UQVN_N34, A2 => UQVN_N36);
UQVB_B30 : AND3
	PORT MAP (Z0 => UQVN_N25, A0 => A2, A1 => UQVN_N35, A2 => UQVN_N37);
UQVB_B31 : AND3
	PORT MAP (Z0 => UQVN_N26, A0 => UQVN_N35, A1 => B2, A2 => UQVN_N37);
UQVB_B32 : AND3
	PORT MAP (Z0 => UQVN_N27, A0 => UQVN_N33, A1 => B3, A2 => UQVN_N34);
UQVB_B33 : AND3
	PORT MAP (Z0 => UQVN_N28, A0 => A2, A1 => UQVN_N35, A2 => B2);
UQVB_B34 : OR6
	PORT MAP (Z0 => UQVN_N29, A0 => UQVN_N23, A1 => UQVN_N24, A2 => UQVN_N25, 
	A3 => UQVN_N26, A4 => UQVN_N27, A5 => UQVN_N28);
UQVB_B35 : LXOR2
	PORT MAP (Z0 => Z3, A0 => A3, A1 => UQVN_N29);
UQVB_B36 : INV
	PORT MAP (ZN0 => UQVN_N34, A0 => B2);
UQVB_B37 : INV
	PORT MAP (ZN0 => UQVN_N35, A0 => B3);
UQVB_B38 : INV
	PORT MAP (ZN0 => UQVN_N33, A0 => A2);
UQVB_B39 : XOR2
	PORT MAP (Z0 => Z2, A0 => A2, A1 => UQVN_N30);
UQVB_B40 : AND2
	PORT MAP (Z0 => UQVN_N31, A0 => UQVN_N37, A1 => UQVN_N34);
UQVB_B41 : OR2
	PORT MAP (Z0 => UQVN_N30, A0 => UQVN_N31, A1 => UQVN_N32);
UQVB_B42 : AND2
	PORT MAP (Z0 => UQVN_N32, A0 => UQVN_N36, A1 => B2);
END lattice_arch;
-- VHDL netlist for ADDH8
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY ADDH8 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        B0 : IN std_logic;
        B1 : IN std_logic;
        B2 : IN std_logic;
        B3 : IN std_logic;
        B4 : IN std_logic;
        B5 : IN std_logic;
        B6 : IN std_logic;
        B7 : IN std_logic;
        Z0 : OUT std_logic;
        Z1 : OUT std_logic;
        Z2 : OUT std_logic;
        Z3 : OUT std_logic;
        Z4 : OUT std_logic;
        Z5 : OUT std_logic;
        Z6 : OUT std_logic;
        Z7 : OUT std_logic;
        CO : OUT std_logic
    );
END ADDH8;


ARCHITECTURE lattice_arch OF ADDH8 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, UQVN_N23, UQVN_N24,
	 UQVN_N25, UQVN_N26, UQVN_N27, UQVN_N28,
	 UQVN_N29, UQVN_N30, UQVN_N31, UQVN_N32,
	 UQVN_N33, UQVN_N34, UQVN_N35, UQVN_N36,
	 UQVN_N37, UQVN_N38, UQVN_N39, UQVN_N40,
	 UQVN_N41, G1, G2, G3,
	 G4, G5, G6, G7,
	 P1, P2, P3, P4,
	 P5, P6, P7 : std_logic;


  COMPONENT XOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: XOR2 use  entity  lattice.XOR2(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


  COMPONENT AND9
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND9 use  entity  lattice.AND9(lattice_arch);


  COMPONENT OR5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR5 use  entity  lattice.OR5(lattice_arch);


  COMPONENT AND7
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND7 use  entity  lattice.AND7(lattice_arch);


  COMPONENT OR4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR4 use  entity  lattice.OR4(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT OR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR2 use  entity  lattice.OR2(lattice_arch);


  COMPONENT OR3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR3 use  entity  lattice.OR3(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT AND6
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND6 use  entity  lattice.AND6(lattice_arch);


  COMPONENT AND5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND5 use  entity  lattice.AND5(lattice_arch);


  COMPONENT AND8
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND8 use  entity  lattice.AND8(lattice_arch);


BEGIN

UQVB_B1 : XOR2
	PORT MAP (Z0 => P7, A0 => A7, A1 => B7);
UQVB_B2 : XOR2
	PORT MAP (Z0 => P6, A0 => A6, A1 => B6);
UQVB_B3 : XOR2
	PORT MAP (Z0 => P5, A0 => A5, A1 => B5);
UQVB_B4 : XOR2
	PORT MAP (Z0 => P4, A0 => A4, A1 => B4);
UQVB_B5 : XOR2
	PORT MAP (Z0 => P3, A0 => A3, A1 => B3);
UQVB_B6 : XOR2
	PORT MAP (Z0 => P2, A0 => A2, A1 => B2);
UQVB_B7 : XOR2
	PORT MAP (Z0 => P1, A0 => A1, A1 => B1);
UQVB_B8 : XOR2
	PORT MAP (Z0 => Z0, A0 => A0, A1 => B0);
UQVB_B9 : AND2
	PORT MAP (Z0 => G7, A0 => A7, A1 => B7);
UQVB_B10 : AND2
	PORT MAP (Z0 => G6, A0 => A6, A1 => B6);
UQVB_B11 : AND2
	PORT MAP (Z0 => G5, A0 => A5, A1 => B5);
UQVB_B12 : AND2
	PORT MAP (Z0 => G4, A0 => A4, A1 => B4);
UQVB_B13 : AND2
	PORT MAP (Z0 => G3, A0 => A3, A1 => B3);
UQVB_B14 : AND2
	PORT MAP (Z0 => G2, A0 => A2, A1 => B2);
UQVB_B15 : AND2
	PORT MAP (Z0 => G1, A0 => A1, A1 => B1);
UQVB_B16 : AND2
	PORT MAP (Z0 => UQVN_N1, A0 => A0, A1 => B0);
UQVB_B17 : LXOR2
	PORT MAP (Z0 => Z1, A0 => P1, A1 => UQVN_N1);
UQVB_B18 : AND9
	PORT MAP (Z0 => UQVN_N13, A0 => A0, A1 => B0, A2 => P1, 
	A3 => P2, A4 => P3, A5 => P4, A6 => P5, 
	A7 => P6, A8 => P7);
UQVB_B19 : OR5
	PORT MAP (Z0 => UQVN_N6, A0 => UQVN_N3, A1 => UQVN_N2, A2 => UQVN_N4, 
	A3 => UQVN_N5, A4 => G4);
UQVB_B20 : LXOR2
	PORT MAP (Z0 => Z5, A0 => UQVN_N6, A1 => P5);
UQVB_B21 : AND7
	PORT MAP (Z0 => UQVN_N12, A0 => G1, A1 => P2, A2 => P3, 
	A3 => P4, A4 => P5, A5 => P6, A6 => P7);
UQVB_B22 : OR4
	PORT MAP (Z0 => UQVN_N19, A0 => UQVN_N15, A1 => UQVN_N18, A2 => UQVN_N17, 
	A3 => G7);
UQVB_B23 : AND3
	PORT MAP (Z0 => UQVN_N8, A0 => A0, A1 => B0, A2 => P1);
UQVB_B24 : OR2
	PORT MAP (Z0 => UQVN_N7, A0 => UQVN_N8, A1 => G1);
UQVB_B25 : LXOR2
	PORT MAP (Z0 => Z2, A0 => UQVN_N7, A1 => P2);
UQVB_B26 : OR4
	PORT MAP (Z0 => UQVN_N20, A0 => UQVN_N13, A1 => UQVN_N12, A2 => UQVN_N14, 
	A3 => UQVN_N16);
UQVB_B27 : OR3
	PORT MAP (Z0 => UQVN_N10, A0 => UQVN_N11, A1 => UQVN_N9, A2 => G2);
UQVB_B28 : AND2
	PORT MAP (Z0 => UQVN_N9, A0 => G1, A1 => P2);
UQVB_B29 : LXOR2
	PORT MAP (Z0 => Z3, A0 => UQVN_N10, A1 => P3);
UQVB_B30 : AND4
	PORT MAP (Z0 => UQVN_N11, A0 => A0, A1 => B0, A2 => P1, 
	A3 => P2);
UQVB_B31 : AND6
	PORT MAP (Z0 => UQVN_N14, A0 => G2, A1 => P3, A2 => P4, 
	A3 => P5, A4 => P6, A5 => P7);
UQVB_B32 : AND5
	PORT MAP (Z0 => UQVN_N16, A0 => G3, A1 => P4, A2 => P5, 
	A3 => P6, A4 => P7);
UQVB_B33 : AND2
	PORT MAP (Z0 => UQVN_N17, A0 => G6, A1 => P7);
UQVB_B34 : AND3
	PORT MAP (Z0 => UQVN_N18, A0 => G5, A1 => P6, A2 => P7);
UQVB_B35 : AND4
	PORT MAP (Z0 => UQVN_N15, A0 => G4, A1 => P5, A2 => P6, 
	A3 => P7);
UQVB_B36 : OR2
	PORT MAP (Z0 => CO, A0 => UQVN_N20, A1 => UQVN_N19);
UQVB_B37 : AND6
	PORT MAP (Z0 => UQVN_N3, A0 => A0, A1 => B0, A2 => P1, 
	A3 => P2, A4 => P3, A5 => P4);
UQVB_B38 : AND4
	PORT MAP (Z0 => UQVN_N2, A0 => G1, A1 => P2, A2 => P3, 
	A3 => P4);
UQVB_B39 : AND3
	PORT MAP (Z0 => UQVN_N4, A0 => G2, A1 => P3, A2 => P4);
UQVB_B40 : AND2
	PORT MAP (Z0 => UQVN_N5, A0 => G3, A1 => P4);
UQVB_B41 : AND3
	PORT MAP (Z0 => UQVN_N24, A0 => G3, A1 => P4, A2 => P5);
UQVB_B42 : AND4
	PORT MAP (Z0 => UQVN_N25, A0 => G2, A1 => P3, A2 => P4, 
	A3 => P5);
UQVB_B43 : AND5
	PORT MAP (Z0 => UQVN_N22, A0 => G1, A1 => P2, A2 => P3, 
	A3 => P4, A4 => P5);
UQVB_B44 : AND2
	PORT MAP (Z0 => UQVN_N23, A0 => G4, A1 => P5);
UQVB_B45 : OR3
	PORT MAP (Z0 => UQVN_N26, A0 => UQVN_N24, A1 => UQVN_N23, A2 => G5);
UQVB_B46 : OR3
	PORT MAP (Z0 => UQVN_N27, A0 => UQVN_N28, A1 => UQVN_N22, A2 => UQVN_N25);
UQVB_B47 : OR2
	PORT MAP (Z0 => UQVN_N21, A0 => UQVN_N27, A1 => UQVN_N26);
UQVB_B48 : LXOR2
	PORT MAP (Z0 => Z6, A0 => UQVN_N21, A1 => P6);
UQVB_B49 : AND7
	PORT MAP (Z0 => UQVN_N28, A0 => A0, A1 => B0, A2 => P1, 
	A3 => P2, A4 => P3, A5 => P4, A6 => P5);
UQVB_B50 : AND5
	PORT MAP (Z0 => UQVN_N32, A0 => A0, A1 => B0, A2 => P1, 
	A3 => P2, A4 => P3);
UQVB_B51 : AND3
	PORT MAP (Z0 => UQVN_N29, A0 => G1, A1 => P2, A2 => P3);
UQVB_B52 : AND2
	PORT MAP (Z0 => UQVN_N30, A0 => G2, A1 => P3);
UQVB_B53 : OR4
	PORT MAP (Z0 => UQVN_N31, A0 => UQVN_N32, A1 => UQVN_N29, A2 => UQVN_N30, 
	A3 => G3);
UQVB_B54 : LXOR2
	PORT MAP (Z0 => Z4, A0 => UQVN_N31, A1 => P4);
UQVB_B55 : OR2
	PORT MAP (Z0 => UQVN_N41, A0 => UQVN_N34, A1 => UQVN_N33);
UQVB_B56 : AND2
	PORT MAP (Z0 => UQVN_N40, A0 => G5, A1 => P6);
UQVB_B57 : AND3
	PORT MAP (Z0 => UQVN_N38, A0 => G4, A1 => P5, A2 => P6);
UQVB_B58 : AND4
	PORT MAP (Z0 => UQVN_N39, A0 => G3, A1 => P4, A2 => P5, 
	A3 => P6);
UQVB_B59 : AND5
	PORT MAP (Z0 => UQVN_N37, A0 => G2, A1 => P3, A2 => P4, 
	A3 => P5, A4 => P6);
UQVB_B60 : AND6
	PORT MAP (Z0 => UQVN_N35, A0 => G1, A1 => P2, A2 => P3, 
	A3 => P4, A4 => P5, A5 => P6);
UQVB_B61 : AND8
	PORT MAP (Z0 => UQVN_N36, A0 => A0, A1 => B0, A2 => P1, 
	A3 => P2, A4 => P3, A5 => P4, A6 => P5, 
	A7 => P6);
UQVB_B62 : OR4
	PORT MAP (Z0 => UQVN_N34, A0 => UQVN_N36, A1 => UQVN_N35, A2 => UQVN_N37, 
	A3 => UQVN_N39);
UQVB_B63 : OR3
	PORT MAP (Z0 => UQVN_N33, A0 => UQVN_N38, A1 => UQVN_N40, A2 => G6);
UQVB_B64 : LXOR2
	PORT MAP (Z0 => Z7, A0 => UQVN_N41, A1 => P7);
END lattice_arch;
-- VHDL netlist for ADDH8A
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY ADDH8A IS 
    PORT (
        B7 : IN std_logic;
        B6 : IN std_logic;
        B5 : IN std_logic;
        B4 : IN std_logic;
        B3 : IN std_logic;
        B2 : IN std_logic;
        B1 : IN std_logic;
        B0 : IN std_logic;
        A7 : IN std_logic;
        A6 : IN std_logic;
        A5 : IN std_logic;
        A4 : IN std_logic;
        A3 : IN std_logic;
        A2 : IN std_logic;
        A1 : IN std_logic;
        A0 : IN std_logic;
        CO : OUT std_logic;
        Z7 : OUT std_logic;
        Z6 : OUT std_logic;
        Z5 : OUT std_logic;
        Z4 : OUT std_logic;
        Z3 : OUT std_logic;
        Z2 : OUT std_logic;
        Z1 : OUT std_logic;
        Z0 : OUT std_logic
    );
END ADDH8A;


ARCHITECTURE lattice_arch OF ADDH8A IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, UQVN_N23, UQVN_N24,
	 UQVN_N25, UQVN_N26, UQVN_N27, UQVN_N28,
	 UQVN_N29, UQVN_N30, UQVN_N31, UQVN_N32,
	 UQVN_N33, UQVN_N34, UQVN_N35, UQVN_N36,
	 UQVN_N37, UQVN_N38, UQVN_N39, UQVN_N40,
	 UQVN_N41, UQVN_N42, UQVN_N43, UQVN_N44,
	 UQVN_N45, UQVN_N46, UQVN_N47, UQVN_N48,
	 UQVN_N49, UQVN_N50, UQVN_N51, UQVN_N52,
	 UQVN_N53, UQVN_N54, UQVN_N55, UQVN_N56,
	 UQVN_N57, UQVN_N58, UQVN_N59, UQVN_N60,
	 UQVN_N61, UQVN_N62, UQVN_N63, UQVN_N64,
	 UQVN_N65, UQVN_N66, UQVN_N67, UQVN_N68,
	 UQVN_N69, UQVN_N70, UQVN_N71, UQVN_N72,
	 UQVN_N73, UQVN_N74, UQVN_N75, UQVN_N76,
	 UQVN_N77, UQVN_N78, UQVN_N79, UQVN_N80,
	 UQVN_N81, UQVN_N82, UQVN_N83, UQVN_N84,
	 UQVN_N85, UQVN_N86, UQVN_N87, UQVN_N88,
	 UQVN_N89, UQVN_N90, UQVN_N91, G012,
	 G345, P345 : std_logic;


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT OR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR2 use  entity  lattice.OR2(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT OR6
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR6 use  entity  lattice.OR6(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT OR7
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR7 use  entity  lattice.OR7(lattice_arch);


  COMPONENT NOR3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: NOR3 use  entity  lattice.NOR3(lattice_arch);


  COMPONENT OR12
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        A9 : IN std_logic;
        A10 : IN std_logic;
        A11 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR12 use  entity  lattice.OR12(lattice_arch);


  COMPONENT OR3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR3 use  entity  lattice.OR3(lattice_arch);


  COMPONENT OR8
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR8 use  entity  lattice.OR8(lattice_arch);


  COMPONENT XOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: XOR2 use  entity  lattice.XOR2(lattice_arch);


BEGIN

UQVB_B1 : INV
	PORT MAP (ZN0 => UQVN_N43, A0 => G012);
UQVB_B2 : INV
	PORT MAP (ZN0 => UQVN_N41, A0 => B4);
UQVB_B3 : INV
	PORT MAP (ZN0 => UQVN_N42, A0 => B5);
UQVB_B4 : INV
	PORT MAP (ZN0 => UQVN_N37, A0 => A3);
UQVB_B5 : AND2
	PORT MAP (Z0 => UQVN_N1, A0 => UQVN_N40, A1 => G012);
UQVB_B6 : AND2
	PORT MAP (Z0 => UQVN_N2, A0 => B3, A1 => UQVN_N43);
UQVB_B7 : OR2
	PORT MAP (Z0 => UQVN_N3, A0 => UQVN_N1, A1 => UQVN_N2);
UQVB_B8 : LXOR2
	PORT MAP (Z0 => Z3, A0 => A3, A1 => UQVN_N3);
UQVB_B9 : AND3
	PORT MAP (Z0 => UQVN_N9, A0 => UQVN_N37, A1 => B4, A2 => UQVN_N40);
UQVB_B10 : AND3
	PORT MAP (Z0 => UQVN_N5, A0 => UQVN_N41, A1 => B3, A2 => G012);
UQVB_B11 : AND3
	PORT MAP (Z0 => UQVN_N4, A0 => A3, A1 => UQVN_N41, A2 => G012);
UQVB_B12 : AND3
	PORT MAP (Z0 => UQVN_N6, A0 => B4, A1 => UQVN_N40, A2 => UQVN_N43);
UQVB_B13 : AND3
	PORT MAP (Z0 => UQVN_N7, A0 => UQVN_N37, A1 => B4, A2 => UQVN_N43);
UQVB_B14 : OR6
	PORT MAP (Z0 => UQVN_N10, A0 => UQVN_N7, A1 => UQVN_N6, A2 => UQVN_N4, 
	A3 => UQVN_N5, A4 => UQVN_N9, A5 => UQVN_N8);
UQVB_B15 : LXOR2
	PORT MAP (Z0 => Z4, A0 => A4, A1 => UQVN_N10);
UQVB_B16 : AND3
	PORT MAP (Z0 => UQVN_N8, A0 => A3, A1 => UQVN_N41, A2 => B3);
UQVB_B17 : AND4
	PORT MAP (Z0 => UQVN_N14, A0 => A3, A1 => A4, A2 => A5, 
	A3 => B3);
UQVB_B18 : AND3
	PORT MAP (Z0 => UQVN_N13, A0 => A4, A1 => A5, A2 => B4);
UQVB_B19 : AND4
	PORT MAP (Z0 => UQVN_N12, A0 => A3, A1 => A5, A2 => B3, 
	A3 => B4);
UQVB_B20 : AND2
	PORT MAP (Z0 => UQVN_N11, A0 => A5, A1 => B5);
UQVB_B21 : AND4
	PORT MAP (Z0 => UQVN_N15, A0 => A3, A1 => A4, A2 => B3, 
	A3 => B5);
UQVB_B22 : AND3
	PORT MAP (Z0 => UQVN_N16, A0 => A4, A1 => B4, A2 => B5);
UQVB_B23 : AND4
	PORT MAP (Z0 => UQVN_N17, A0 => A3, A1 => B3, A2 => B4, 
	A3 => B5);
UQVB_B24 : OR7
	PORT MAP (Z0 => G345, A0 => UQVN_N14, A1 => UQVN_N13, A2 => UQVN_N12, 
	A3 => UQVN_N11, A4 => UQVN_N15, A5 => UQVN_N16, A6 => UQVN_N17);
UQVB_B25 : AND2
	PORT MAP (Z0 => UQVN_N20, A0 => UQVN_N37, A1 => UQVN_N40);
UQVB_B26 : AND2
	PORT MAP (Z0 => UQVN_N18, A0 => UQVN_N38, A1 => UQVN_N41);
UQVB_B27 : AND2
	PORT MAP (Z0 => UQVN_N19, A0 => UQVN_N39, A1 => UQVN_N42);
UQVB_B28 : NOR3
	PORT MAP (ZN0 => P345, A0 => UQVN_N20, A1 => UQVN_N18, A2 => UQVN_N19);
UQVB_B29 : INV
	PORT MAP (ZN0 => UQVN_N40, A0 => B3);
UQVB_B30 : INV
	PORT MAP (ZN0 => UQVN_N38, A0 => A4);
UQVB_B31 : INV
	PORT MAP (ZN0 => UQVN_N39, A0 => A5);
UQVB_B32 : LXOR2
	PORT MAP (Z0 => Z5, A0 => A5, A1 => UQVN_N34);
UQVB_B33 : AND4
	PORT MAP (Z0 => UQVN_N33, A0 => UQVN_N40, A1 => UQVN_N41, A2 => B5, 
	A3 => UQVN_N43);
UQVB_B34 : AND4
	PORT MAP (Z0 => UQVN_N35, A0 => UQVN_N37, A1 => UQVN_N41, A2 => B5, 
	A3 => UQVN_N43);
UQVB_B35 : AND4
	PORT MAP (Z0 => UQVN_N32, A0 => UQVN_N38, A1 => UQVN_N40, A2 => B5, 
	A3 => UQVN_N43);
UQVB_B36 : AND4
	PORT MAP (Z0 => UQVN_N31, A0 => UQVN_N37, A1 => UQVN_N38, A2 => B5, 
	A3 => UQVN_N43);
UQVB_B37 : AND4
	PORT MAP (Z0 => UQVN_N30, A0 => B3, A1 => B4, A2 => UQVN_N42, 
	A3 => G012);
UQVB_B38 : AND4
	PORT MAP (Z0 => UQVN_N29, A0 => A3, A1 => B4, A2 => UQVN_N42, 
	A3 => G012);
UQVB_B39 : AND4
	PORT MAP (Z0 => UQVN_N28, A0 => A4, A1 => B3, A2 => UQVN_N42, 
	A3 => G012);
UQVB_B40 : AND4
	PORT MAP (Z0 => UQVN_N27, A0 => A3, A1 => A4, A2 => UQVN_N42, 
	A3 => G012);
UQVB_B41 : AND4
	PORT MAP (Z0 => UQVN_N26, A0 => A3, A1 => B3, A2 => B4, 
	A3 => UQVN_N42);
UQVB_B42 : AND3
	PORT MAP (Z0 => UQVN_N25, A0 => A4, A1 => B4, A2 => UQVN_N42);
UQVB_B43 : AND4
	PORT MAP (Z0 => UQVN_N24, A0 => A3, A1 => A4, A2 => B3, 
	A3 => UQVN_N42);
UQVB_B44 : AND4
	PORT MAP (Z0 => UQVN_N23, A0 => UQVN_N37, A1 => UQVN_N40, A2 => UQVN_N41, 
	A3 => B5);
UQVB_B45 : AND3
	PORT MAP (Z0 => UQVN_N22, A0 => UQVN_N38, A1 => UQVN_N41, A2 => B5);
UQVB_B46 : AND4
	PORT MAP (Z0 => UQVN_N21, A0 => UQVN_N37, A1 => UQVN_N38, A2 => UQVN_N40, 
	A3 => B5);
UQVB_B47 : OR12
	PORT MAP (Z0 => UQVN_N36, A0 => UQVN_N32, A1 => UQVN_N31, A2 => UQVN_N30, 
	A3 => UQVN_N29, A4 => UQVN_N28, A5 => UQVN_N27, A6 => UQVN_N26, 
	A7 => UQVN_N25, A8 => UQVN_N24, A9 => UQVN_N23, A10 => UQVN_N22, 
	A11 => UQVN_N21);
UQVB_B48 : OR3
	PORT MAP (Z0 => UQVN_N34, A0 => UQVN_N33, A1 => UQVN_N35, A2 => UQVN_N36);
UQVB_B49 : AND2
	PORT MAP (Z0 => UQVN_N44, A0 => P345, A1 => G012);
UQVB_B50 : OR2
	PORT MAP (Z0 => UQVN_N91, A0 => G345, A1 => UQVN_N44);
UQVB_B51 : INV
	PORT MAP (ZN0 => UQVN_N68, A0 => B1);
UQVB_B52 : INV
	PORT MAP (ZN0 => UQVN_N65, A0 => A0);
UQVB_B53 : LXOR2
	PORT MAP (Z0 => Z0, A0 => A0, A1 => B0);
UQVB_B54 : LXOR2
	PORT MAP (Z0 => Z1, A0 => A1, A1 => UQVN_N48);
UQVB_B55 : AND3
	PORT MAP (Z0 => UQVN_N47, A0 => A0, A1 => UQVN_N68, A2 => B0);
UQVB_B56 : AND4
	PORT MAP (Z0 => UQVN_N52, A0 => A0, A1 => A1, A2 => A2, 
	A3 => B0);
UQVB_B57 : AND3
	PORT MAP (Z0 => UQVN_N51, A0 => A1, A1 => A2, A2 => B1);
UQVB_B58 : AND4
	PORT MAP (Z0 => UQVN_N50, A0 => A0, A1 => A2, A2 => B0, 
	A3 => B1);
UQVB_B59 : AND2
	PORT MAP (Z0 => UQVN_N49, A0 => A2, A1 => B2);
UQVB_B60 : AND4
	PORT MAP (Z0 => UQVN_N53, A0 => A0, A1 => A1, A2 => B0, 
	A3 => B2);
UQVB_B61 : AND3
	PORT MAP (Z0 => UQVN_N54, A0 => A1, A1 => B1, A2 => B2);
UQVB_B62 : AND4
	PORT MAP (Z0 => UQVN_N55, A0 => A0, A1 => B0, A2 => B1, 
	A3 => B2);
UQVB_B63 : OR7
	PORT MAP (Z0 => G012, A0 => UQVN_N52, A1 => UQVN_N51, A2 => UQVN_N50, 
	A3 => UQVN_N49, A4 => UQVN_N53, A5 => UQVN_N54, A6 => UQVN_N55);
UQVB_B64 : INV
	PORT MAP (ZN0 => UQVN_N67, A0 => B0);
UQVB_B65 : INV
	PORT MAP (ZN0 => UQVN_N66, A0 => A1);
UQVB_B66 : AND2
	PORT MAP (Z0 => UQVN_N46, A0 => UQVN_N65, A1 => B1);
UQVB_B67 : AND2
	PORT MAP (Z0 => UQVN_N45, A0 => B1, A1 => UQVN_N67);
UQVB_B68 : OR3
	PORT MAP (Z0 => UQVN_N48, A0 => UQVN_N46, A1 => UQVN_N45, A2 => UQVN_N47);
UQVB_B69 : INV
	PORT MAP (ZN0 => UQVN_N69, A0 => B2);
UQVB_B70 : LXOR2
	PORT MAP (Z0 => Z2, A0 => A2, A1 => UQVN_N60);
UQVB_B71 : AND4
	PORT MAP (Z0 => UQVN_N59, A0 => A0, A1 => B0, A2 => B1, 
	A3 => UQVN_N69);
UQVB_B72 : AND3
	PORT MAP (Z0 => UQVN_N58, A0 => A1, A1 => B1, A2 => UQVN_N69);
UQVB_B73 : AND4
	PORT MAP (Z0 => UQVN_N57, A0 => A0, A1 => A1, A2 => B0, 
	A3 => UQVN_N69);
UQVB_B74 : AND3
	PORT MAP (Z0 => UQVN_N56, A0 => UQVN_N66, A1 => UQVN_N68, A2 => B2);
UQVB_B75 : AND3
	PORT MAP (Z0 => UQVN_N64, A0 => UQVN_N67, A1 => UQVN_N68, A2 => B2);
UQVB_B76 : AND3
	PORT MAP (Z0 => UQVN_N63, A0 => UQVN_N65, A1 => UQVN_N68, A2 => B2);
UQVB_B77 : AND3
	PORT MAP (Z0 => UQVN_N62, A0 => UQVN_N66, A1 => UQVN_N67, A2 => B2);
UQVB_B78 : AND3
	PORT MAP (Z0 => UQVN_N61, A0 => UQVN_N65, A1 => UQVN_N66, A2 => B2);
UQVB_B79 : OR8
	PORT MAP (Z0 => UQVN_N60, A0 => UQVN_N64, A1 => UQVN_N63, A2 => UQVN_N62, 
	A3 => UQVN_N61, A4 => UQVN_N59, A5 => UQVN_N58, A6 => UQVN_N57, 
	A7 => UQVN_N56);
UQVB_B80 : INV
	PORT MAP (ZN0 => UQVN_N90, A0 => UQVN_N91);
UQVB_B81 : AND3
	PORT MAP (Z0 => UQVN_N72, A0 => UQVN_N91, A1 => A7, A2 => A6);
UQVB_B82 : AND3
	PORT MAP (Z0 => UQVN_N71, A0 => UQVN_N91, A1 => A7, A2 => B6);
UQVB_B83 : AND3
	PORT MAP (Z0 => UQVN_N70, A0 => UQVN_N91, A1 => A6, A2 => B7);
UQVB_B84 : AND3
	PORT MAP (Z0 => UQVN_N73, A0 => UQVN_N91, A1 => B7, A2 => B6);
UQVB_B85 : AND3
	PORT MAP (Z0 => UQVN_N74, A0 => A7, A1 => A6, A2 => B6);
UQVB_B86 : AND3
	PORT MAP (Z0 => UQVN_N76, A0 => A6, A1 => B7, A2 => B6);
UQVB_B87 : AND2
	PORT MAP (Z0 => UQVN_N75, A0 => A7, A1 => B7);
UQVB_B88 : OR7
	PORT MAP (Z0 => CO, A0 => UQVN_N72, A1 => UQVN_N71, A2 => UQVN_N70, 
	A3 => UQVN_N73, A4 => UQVN_N74, A5 => UQVN_N76, A6 => UQVN_N75);
UQVB_B89 : AND3
	PORT MAP (Z0 => UQVN_N77, A0 => UQVN_N87, A1 => B7, A2 => UQVN_N90);
UQVB_B90 : AND3
	PORT MAP (Z0 => UQVN_N78, A0 => B7, A1 => UQVN_N88, A2 => UQVN_N90);
UQVB_B91 : AND3
	PORT MAP (Z0 => UQVN_N79, A0 => A6, A1 => UQVN_N89, A2 => UQVN_N91);
UQVB_B92 : AND3
	PORT MAP (Z0 => UQVN_N80, A0 => UQVN_N89, A1 => B6, A2 => UQVN_N91);
UQVB_B93 : AND3
	PORT MAP (Z0 => UQVN_N81, A0 => UQVN_N87, A1 => B7, A2 => UQVN_N88);
UQVB_B94 : AND3
	PORT MAP (Z0 => UQVN_N82, A0 => A6, A1 => UQVN_N89, A2 => B6);
UQVB_B95 : OR6
	PORT MAP (Z0 => UQVN_N83, A0 => UQVN_N77, A1 => UQVN_N78, A2 => UQVN_N79, 
	A3 => UQVN_N80, A4 => UQVN_N81, A5 => UQVN_N82);
UQVB_B96 : LXOR2
	PORT MAP (Z0 => Z7, A0 => A7, A1 => UQVN_N83);
UQVB_B97 : INV
	PORT MAP (ZN0 => UQVN_N88, A0 => B6);
UQVB_B98 : INV
	PORT MAP (ZN0 => UQVN_N89, A0 => B7);
UQVB_B99 : INV
	PORT MAP (ZN0 => UQVN_N87, A0 => A6);
UQVB_B100 : XOR2
	PORT MAP (Z0 => Z6, A0 => A6, A1 => UQVN_N84);
UQVB_B101 : AND2
	PORT MAP (Z0 => UQVN_N85, A0 => UQVN_N91, A1 => UQVN_N88);
UQVB_B102 : OR2
	PORT MAP (Z0 => UQVN_N84, A0 => UQVN_N85, A1 => UQVN_N86);
UQVB_B103 : AND2
	PORT MAP (Z0 => UQVN_N86, A0 => UQVN_N90, A1 => B6);
END lattice_arch;
-- VHDL netlist for BI11
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BI11 IS 
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
END BI11;


ARCHITECTURE lattice_arch OF BI11 IS

  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XBIDI1
	PORT MAP (Z0 => Z0, XB0 => XB0, A0 => A0, OE => OE);
END lattice_arch;
-- VHDL netlist for BI14
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BI14 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        Z1 : OUT std_logic;
        Z2 : OUT std_logic;
        Z3 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic
    );
END BI14;


ARCHITECTURE lattice_arch OF BI14 IS

  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XBIDI1
	PORT MAP (Z0 => Z3, XB0 => XB3, A0 => A3, OE => OE);
UQVB_B2 : XBIDI1
	PORT MAP (Z0 => Z2, XB0 => XB2, A0 => A2, OE => OE);
UQVB_B3 : XBIDI1
	PORT MAP (Z0 => Z1, XB0 => XB1, A0 => A1, OE => OE);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => Z0, XB0 => XB0, A0 => A0, OE => OE);
END lattice_arch;
-- VHDL netlist for BI18
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BI18 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        Z1 : OUT std_logic;
        Z2 : OUT std_logic;
        Z3 : OUT std_logic;
        Z4 : OUT std_logic;
        Z5 : OUT std_logic;
        Z6 : OUT std_logic;
        Z7 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic;
        XB4 : INOUT std_logic;
        XB5 : INOUT std_logic;
        XB6 : INOUT std_logic;
        XB7 : INOUT std_logic
    );
END BI18;


ARCHITECTURE lattice_arch OF BI18 IS

  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XBIDI1
	PORT MAP (Z0 => Z3, XB0 => XB3, A0 => A3, OE => OE);
UQVB_B2 : XBIDI1
	PORT MAP (Z0 => Z2, XB0 => XB2, A0 => A2, OE => OE);
UQVB_B3 : XBIDI1
	PORT MAP (Z0 => Z1, XB0 => XB1, A0 => A1, OE => OE);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => Z0, XB0 => XB0, A0 => A0, OE => OE);
UQVB_B5 : XBIDI1
	PORT MAP (Z0 => Z4, XB0 => XB4, A0 => A4, OE => OE);
UQVB_B6 : XBIDI1
	PORT MAP (Z0 => Z5, XB0 => XB5, A0 => A5, OE => OE);
UQVB_B7 : XBIDI1
	PORT MAP (Z0 => Z6, XB0 => XB6, A0 => A6, OE => OE);
UQVB_B8 : XBIDI1
	PORT MAP (Z0 => Z7, XB0 => XB7, A0 => A7, OE => OE);
END lattice_arch;
-- VHDL netlist for BI21
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BI21 IS 
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
END BI21;


ARCHITECTURE lattice_arch OF BI21 IS
SIGNAL  UQVN_N1 : std_logic;


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


BEGIN

UQVB_B1 : XBIDI1
	PORT MAP (Z0 => Z0, XB0 => XB0, A0 => UQVN_N1, OE => OE);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => A0);
END lattice_arch;
-- VHDL netlist for BI24
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BI24 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        Z1 : OUT std_logic;
        Z2 : OUT std_logic;
        Z3 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic
    );
END BI24;


ARCHITECTURE lattice_arch OF BI24 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4 : std_logic;


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


BEGIN

UQVB_B1 : XBIDI1
	PORT MAP (Z0 => Z3, XB0 => XB3, A0 => UQVN_N1, OE => OE);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => A3);
UQVB_B3 : XBIDI1
	PORT MAP (Z0 => Z2, XB0 => XB2, A0 => UQVN_N2, OE => OE);
UQVB_B4 : XINV
	PORT MAP (ZN0 => UQVN_N2, A0 => A2);
UQVB_B5 : XBIDI1
	PORT MAP (Z0 => Z1, XB0 => XB1, A0 => UQVN_N3, OE => OE);
UQVB_B6 : XINV
	PORT MAP (ZN0 => UQVN_N3, A0 => A1);
UQVB_B7 : XBIDI1
	PORT MAP (Z0 => Z0, XB0 => XB0, A0 => UQVN_N4, OE => OE);
UQVB_B8 : XINV
	PORT MAP (ZN0 => UQVN_N4, A0 => A0);
END lattice_arch;
-- VHDL netlist for BI28
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BI28 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        Z1 : OUT std_logic;
        Z2 : OUT std_logic;
        Z3 : OUT std_logic;
        Z4 : OUT std_logic;
        Z5 : OUT std_logic;
        Z6 : OUT std_logic;
        Z7 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic;
        XB4 : INOUT std_logic;
        XB5 : INOUT std_logic;
        XB6 : INOUT std_logic;
        XB7 : INOUT std_logic
    );
END BI28;


ARCHITECTURE lattice_arch OF BI28 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8 : std_logic;


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


BEGIN

UQVB_B1 : XBIDI1
	PORT MAP (Z0 => Z3, XB0 => XB3, A0 => UQVN_N1, OE => OE);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => A3);
UQVB_B3 : XBIDI1
	PORT MAP (Z0 => Z2, XB0 => XB2, A0 => UQVN_N2, OE => OE);
UQVB_B4 : XINV
	PORT MAP (ZN0 => UQVN_N2, A0 => A2);
UQVB_B5 : XBIDI1
	PORT MAP (Z0 => Z1, XB0 => XB1, A0 => UQVN_N3, OE => OE);
UQVB_B6 : XINV
	PORT MAP (ZN0 => UQVN_N3, A0 => A1);
UQVB_B7 : XBIDI1
	PORT MAP (Z0 => Z0, XB0 => XB0, A0 => UQVN_N4, OE => OE);
UQVB_B8 : XINV
	PORT MAP (ZN0 => UQVN_N4, A0 => A0);
UQVB_B9 : XBIDI1
	PORT MAP (Z0 => Z4, XB0 => XB4, A0 => UQVN_N5, OE => OE);
UQVB_B10 : XINV
	PORT MAP (ZN0 => UQVN_N5, A0 => A4);
UQVB_B11 : XBIDI1
	PORT MAP (Z0 => Z5, XB0 => XB5, A0 => UQVN_N6, OE => OE);
UQVB_B12 : XINV
	PORT MAP (ZN0 => UQVN_N6, A0 => A5);
UQVB_B13 : XBIDI1
	PORT MAP (Z0 => Z6, XB0 => XB6, A0 => UQVN_N7, OE => OE);
UQVB_B14 : XINV
	PORT MAP (ZN0 => UQVN_N7, A0 => A6);
UQVB_B15 : XBIDI1
	PORT MAP (Z0 => Z7, XB0 => XB7, A0 => UQVN_N8, OE => OE);
UQVB_B16 : XINV
	PORT MAP (ZN0 => UQVN_N8, A0 => A7);
END lattice_arch;
-- VHDL netlist for BI31
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BI31 IS 
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
END BI31;


ARCHITECTURE lattice_arch OF BI31 IS
SIGNAL  UQVN_N1 : std_logic;


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


BEGIN

UQVB_B1 : XBIDI1
	PORT MAP (Z0 => Z0, XB0 => XB0, A0 => A0, OE => UQVN_N1);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => OE);
END lattice_arch;
-- VHDL netlist for BI34
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BI34 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        Z1 : OUT std_logic;
        Z2 : OUT std_logic;
        Z3 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic
    );
END BI34;


ARCHITECTURE lattice_arch OF BI34 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4 : std_logic;


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


BEGIN

UQVB_B1 : XBIDI1
	PORT MAP (Z0 => Z3, XB0 => XB3, A0 => A3, OE => UQVN_N1);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => OE);
UQVB_B3 : XBIDI1
	PORT MAP (Z0 => Z2, XB0 => XB2, A0 => A2, OE => UQVN_N2);
UQVB_B4 : XINV
	PORT MAP (ZN0 => UQVN_N2, A0 => OE);
UQVB_B5 : XBIDI1
	PORT MAP (Z0 => Z1, XB0 => XB1, A0 => A1, OE => UQVN_N3);
UQVB_B6 : XINV
	PORT MAP (ZN0 => UQVN_N3, A0 => OE);
UQVB_B7 : XBIDI1
	PORT MAP (Z0 => Z0, XB0 => XB0, A0 => A0, OE => UQVN_N4);
UQVB_B8 : XINV
	PORT MAP (ZN0 => UQVN_N4, A0 => OE);
END lattice_arch;
-- VHDL netlist for BI38
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BI38 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        Z1 : OUT std_logic;
        Z2 : OUT std_logic;
        Z3 : OUT std_logic;
        Z4 : OUT std_logic;
        Z5 : OUT std_logic;
        Z6 : OUT std_logic;
        Z7 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic;
        XB4 : INOUT std_logic;
        XB5 : INOUT std_logic;
        XB6 : INOUT std_logic;
        XB7 : INOUT std_logic
    );
END BI38;


ARCHITECTURE lattice_arch OF BI38 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8 : std_logic;


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


BEGIN

UQVB_B1 : XBIDI1
	PORT MAP (Z0 => Z3, XB0 => XB3, A0 => A3, OE => UQVN_N1);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => OE);
UQVB_B3 : XBIDI1
	PORT MAP (Z0 => Z2, XB0 => XB2, A0 => A2, OE => UQVN_N2);
UQVB_B4 : XINV
	PORT MAP (ZN0 => UQVN_N2, A0 => OE);
UQVB_B5 : XBIDI1
	PORT MAP (Z0 => Z1, XB0 => XB1, A0 => A1, OE => UQVN_N3);
UQVB_B6 : XINV
	PORT MAP (ZN0 => UQVN_N3, A0 => OE);
UQVB_B7 : XBIDI1
	PORT MAP (Z0 => Z0, XB0 => XB0, A0 => A0, OE => UQVN_N4);
UQVB_B8 : XINV
	PORT MAP (ZN0 => UQVN_N4, A0 => OE);
UQVB_B9 : XBIDI1
	PORT MAP (Z0 => Z4, XB0 => XB4, A0 => A4, OE => UQVN_N5);
UQVB_B10 : XINV
	PORT MAP (ZN0 => UQVN_N5, A0 => OE);
UQVB_B11 : XBIDI1
	PORT MAP (Z0 => Z5, XB0 => XB5, A0 => A5, OE => UQVN_N6);
UQVB_B12 : XINV
	PORT MAP (ZN0 => UQVN_N6, A0 => OE);
UQVB_B13 : XBIDI1
	PORT MAP (Z0 => Z6, XB0 => XB6, A0 => A6, OE => UQVN_N7);
UQVB_B14 : XINV
	PORT MAP (ZN0 => UQVN_N7, A0 => OE);
UQVB_B15 : XBIDI1
	PORT MAP (Z0 => Z7, XB0 => XB7, A0 => A7, OE => UQVN_N8);
UQVB_B16 : XINV
	PORT MAP (ZN0 => UQVN_N8, A0 => OE);
END lattice_arch;
-- VHDL netlist for BI41
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BI41 IS 
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
END BI41;


ARCHITECTURE lattice_arch OF BI41 IS
SIGNAL  UQVN_N1, UQVN_N2 : std_logic;


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


BEGIN

UQVB_B1 : XBIDI1
	PORT MAP (Z0 => Z0, XB0 => XB0, A0 => UQVN_N2, OE => UQVN_N1);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => OE);
UQVB_B3 : XINV
	PORT MAP (ZN0 => UQVN_N2, A0 => A0);
END lattice_arch;
-- VHDL netlist for BI44
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BI44 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        Z1 : OUT std_logic;
        Z2 : OUT std_logic;
        Z3 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic
    );
END BI44;


ARCHITECTURE lattice_arch OF BI44 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8 : std_logic;


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


BEGIN

UQVB_B1 : XBIDI1
	PORT MAP (Z0 => Z3, XB0 => XB3, A0 => UQVN_N2, OE => UQVN_N1);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => OE);
UQVB_B3 : XINV
	PORT MAP (ZN0 => UQVN_N2, A0 => A3);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => Z2, XB0 => XB2, A0 => UQVN_N4, OE => UQVN_N3);
UQVB_B5 : XINV
	PORT MAP (ZN0 => UQVN_N3, A0 => OE);
UQVB_B6 : XINV
	PORT MAP (ZN0 => UQVN_N4, A0 => A2);
UQVB_B7 : XBIDI1
	PORT MAP (Z0 => Z1, XB0 => XB1, A0 => UQVN_N6, OE => UQVN_N5);
UQVB_B8 : XINV
	PORT MAP (ZN0 => UQVN_N5, A0 => OE);
UQVB_B9 : XINV
	PORT MAP (ZN0 => UQVN_N6, A0 => A1);
UQVB_B10 : XBIDI1
	PORT MAP (Z0 => Z0, XB0 => XB0, A0 => UQVN_N8, OE => UQVN_N7);
UQVB_B11 : XINV
	PORT MAP (ZN0 => UQVN_N7, A0 => OE);
UQVB_B12 : XINV
	PORT MAP (ZN0 => UQVN_N8, A0 => A0);
END lattice_arch;
-- VHDL netlist for BI48
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BI48 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        Z1 : OUT std_logic;
        Z2 : OUT std_logic;
        Z3 : OUT std_logic;
        Z4 : OUT std_logic;
        Z5 : OUT std_logic;
        Z6 : OUT std_logic;
        Z7 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic;
        XB4 : INOUT std_logic;
        XB5 : INOUT std_logic;
        XB6 : INOUT std_logic;
        XB7 : INOUT std_logic
    );
END BI48;


ARCHITECTURE lattice_arch OF BI48 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16 : std_logic;


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


BEGIN

UQVB_B1 : XBIDI1
	PORT MAP (Z0 => Z3, XB0 => XB3, A0 => UQVN_N2, OE => UQVN_N1);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => OE);
UQVB_B3 : XINV
	PORT MAP (ZN0 => UQVN_N2, A0 => A3);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => Z2, XB0 => XB2, A0 => UQVN_N4, OE => UQVN_N3);
UQVB_B5 : XINV
	PORT MAP (ZN0 => UQVN_N3, A0 => OE);
UQVB_B6 : XINV
	PORT MAP (ZN0 => UQVN_N4, A0 => A2);
UQVB_B7 : XBIDI1
	PORT MAP (Z0 => Z1, XB0 => XB1, A0 => UQVN_N6, OE => UQVN_N5);
UQVB_B8 : XINV
	PORT MAP (ZN0 => UQVN_N5, A0 => OE);
UQVB_B9 : XINV
	PORT MAP (ZN0 => UQVN_N6, A0 => A1);
UQVB_B10 : XBIDI1
	PORT MAP (Z0 => Z0, XB0 => XB0, A0 => UQVN_N8, OE => UQVN_N7);
UQVB_B11 : XINV
	PORT MAP (ZN0 => UQVN_N7, A0 => OE);
UQVB_B12 : XINV
	PORT MAP (ZN0 => UQVN_N8, A0 => A0);
UQVB_B13 : XBIDI1
	PORT MAP (Z0 => Z4, XB0 => XB4, A0 => UQVN_N10, OE => UQVN_N9);
UQVB_B14 : XINV
	PORT MAP (ZN0 => UQVN_N9, A0 => OE);
UQVB_B15 : XINV
	PORT MAP (ZN0 => UQVN_N10, A0 => A4);
UQVB_B16 : XBIDI1
	PORT MAP (Z0 => Z5, XB0 => XB5, A0 => UQVN_N12, OE => UQVN_N11);
UQVB_B17 : XINV
	PORT MAP (ZN0 => UQVN_N11, A0 => OE);
UQVB_B18 : XINV
	PORT MAP (ZN0 => UQVN_N12, A0 => A5);
UQVB_B19 : XBIDI1
	PORT MAP (Z0 => Z6, XB0 => XB6, A0 => UQVN_N14, OE => UQVN_N13);
UQVB_B20 : XINV
	PORT MAP (ZN0 => UQVN_N13, A0 => OE);
UQVB_B21 : XINV
	PORT MAP (ZN0 => UQVN_N14, A0 => A6);
UQVB_B22 : XBIDI1
	PORT MAP (Z0 => Z7, XB0 => XB7, A0 => UQVN_N16, OE => UQVN_N15);
UQVB_B23 : XINV
	PORT MAP (ZN0 => UQVN_N15, A0 => OE);
UQVB_B24 : XINV
	PORT MAP (ZN0 => UQVN_N16, A0 => A7);
END lattice_arch;
-- VHDL netlist for BIID11
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIID11 IS 
    PORT (
        A0 : IN std_logic;
        CLK : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
END BIID11;


ARCHITECTURE lattice_arch OF BIID11 IS
SIGNAL  UQVN_N1 : std_logic;


  COMPONENT XDFF1
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDFF1 use  entity  lattice.XDFF1(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDFF1
	PORT MAP (Q0 => Q0, D0 => UQVN_N1, CLK => CLK);
UQVB_B2 : XBIDI1
	PORT MAP (Z0 => UQVN_N1, XB0 => XB0, A0 => A0, OE => OE);
END lattice_arch;
-- VHDL netlist for BIID14
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIID14 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        CLK : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic
    );
END BIID14;


ARCHITECTURE lattice_arch OF BIID14 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4 : std_logic;


  COMPONENT XDFF1
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDFF1 use  entity  lattice.XDFF1(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDFF1
	PORT MAP (Q0 => Q3, D0 => UQVN_N1, CLK => CLK);
UQVB_B2 : XBIDI1
	PORT MAP (Z0 => UQVN_N1, XB0 => XB3, A0 => A3, OE => OE);
UQVB_B3 : XDFF1
	PORT MAP (Q0 => Q2, D0 => UQVN_N2, CLK => CLK);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => UQVN_N2, XB0 => XB2, A0 => A2, OE => OE);
UQVB_B5 : XDFF1
	PORT MAP (Q0 => Q1, D0 => UQVN_N3, CLK => CLK);
UQVB_B6 : XBIDI1
	PORT MAP (Z0 => UQVN_N3, XB0 => XB1, A0 => A1, OE => OE);
UQVB_B7 : XDFF1
	PORT MAP (Q0 => Q0, D0 => UQVN_N4, CLK => CLK);
UQVB_B8 : XBIDI1
	PORT MAP (Z0 => UQVN_N4, XB0 => XB0, A0 => A0, OE => OE);
END lattice_arch;
-- VHDL netlist for BIID18
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIID18 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        CLK : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        Q4 : OUT std_logic;
        Q5 : OUT std_logic;
        Q6 : OUT std_logic;
        Q7 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic;
        XB4 : INOUT std_logic;
        XB5 : INOUT std_logic;
        XB6 : INOUT std_logic;
        XB7 : INOUT std_logic
    );
END BIID18;


ARCHITECTURE lattice_arch OF BIID18 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8 : std_logic;


  COMPONENT XDFF1
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDFF1 use  entity  lattice.XDFF1(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDFF1
	PORT MAP (Q0 => Q7, D0 => UQVN_N1, CLK => CLK);
UQVB_B2 : XBIDI1
	PORT MAP (Z0 => UQVN_N1, XB0 => XB7, A0 => A7, OE => OE);
UQVB_B3 : XDFF1
	PORT MAP (Q0 => Q6, D0 => UQVN_N2, CLK => CLK);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => UQVN_N2, XB0 => XB6, A0 => A6, OE => OE);
UQVB_B5 : XDFF1
	PORT MAP (Q0 => Q5, D0 => UQVN_N3, CLK => CLK);
UQVB_B6 : XBIDI1
	PORT MAP (Z0 => UQVN_N3, XB0 => XB5, A0 => A5, OE => OE);
UQVB_B7 : XDFF1
	PORT MAP (Q0 => Q4, D0 => UQVN_N4, CLK => CLK);
UQVB_B8 : XBIDI1
	PORT MAP (Z0 => UQVN_N4, XB0 => XB4, A0 => A4, OE => OE);
UQVB_B9 : XDFF1
	PORT MAP (Q0 => Q0, D0 => UQVN_N5, CLK => CLK);
UQVB_B10 : XBIDI1
	PORT MAP (Z0 => UQVN_N5, XB0 => XB0, A0 => A0, OE => OE);
UQVB_B11 : XDFF1
	PORT MAP (Q0 => Q1, D0 => UQVN_N6, CLK => CLK);
UQVB_B12 : XBIDI1
	PORT MAP (Z0 => UQVN_N6, XB0 => XB1, A0 => A1, OE => OE);
UQVB_B13 : XDFF1
	PORT MAP (Q0 => Q3, D0 => UQVN_N7, CLK => CLK);
UQVB_B14 : XBIDI1
	PORT MAP (Z0 => UQVN_N7, XB0 => XB3, A0 => A3, OE => OE);
UQVB_B15 : XDFF1
	PORT MAP (Q0 => Q2, D0 => UQVN_N8, CLK => CLK);
UQVB_B16 : XBIDI1
	PORT MAP (Z0 => UQVN_N8, XB0 => XB2, A0 => A2, OE => OE);
END lattice_arch;
-- VHDL netlist for BIID21
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIID21 IS 
    PORT (
        A0 : IN std_logic;
        CLK : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
END BIID21;


ARCHITECTURE lattice_arch OF BIID21 IS
SIGNAL  UQVN_N1, UQVN_N2 : std_logic;


  COMPONENT XDFF1
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDFF1 use  entity  lattice.XDFF1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDFF1
	PORT MAP (Q0 => Q0, D0 => UQVN_N2, CLK => CLK);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => A0);
UQVB_B3 : XBIDI1
	PORT MAP (Z0 => UQVN_N2, XB0 => XB0, A0 => UQVN_N1, OE => OE);
END lattice_arch;
-- VHDL netlist for BIID24
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIID24 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        CLK : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic
    );
END BIID24;


ARCHITECTURE lattice_arch OF BIID24 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8 : std_logic;


  COMPONENT XDFF1
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDFF1 use  entity  lattice.XDFF1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDFF1
	PORT MAP (Q0 => Q3, D0 => UQVN_N2, CLK => CLK);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => A3);
UQVB_B3 : XBIDI1
	PORT MAP (Z0 => UQVN_N2, XB0 => XB3, A0 => UQVN_N1, OE => OE);
UQVB_B4 : XDFF1
	PORT MAP (Q0 => Q2, D0 => UQVN_N4, CLK => CLK);
UQVB_B5 : XINV
	PORT MAP (ZN0 => UQVN_N3, A0 => A2);
UQVB_B6 : XBIDI1
	PORT MAP (Z0 => UQVN_N4, XB0 => XB2, A0 => UQVN_N3, OE => OE);
UQVB_B7 : XDFF1
	PORT MAP (Q0 => Q1, D0 => UQVN_N6, CLK => CLK);
UQVB_B8 : XINV
	PORT MAP (ZN0 => UQVN_N5, A0 => A1);
UQVB_B9 : XBIDI1
	PORT MAP (Z0 => UQVN_N6, XB0 => XB1, A0 => UQVN_N5, OE => OE);
UQVB_B10 : XDFF1
	PORT MAP (Q0 => Q0, D0 => UQVN_N8, CLK => CLK);
UQVB_B11 : XINV
	PORT MAP (ZN0 => UQVN_N7, A0 => A0);
UQVB_B12 : XBIDI1
	PORT MAP (Z0 => UQVN_N8, XB0 => XB0, A0 => UQVN_N7, OE => OE);
END lattice_arch;
-- VHDL netlist for BIID28
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIID28 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        CLK : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        Q4 : OUT std_logic;
        Q5 : OUT std_logic;
        Q6 : OUT std_logic;
        Q7 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic;
        XB4 : INOUT std_logic;
        XB5 : INOUT std_logic;
        XB6 : INOUT std_logic;
        XB7 : INOUT std_logic
    );
END BIID28;


ARCHITECTURE lattice_arch OF BIID28 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16 : std_logic;


  COMPONENT XDFF1
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDFF1 use  entity  lattice.XDFF1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDFF1
	PORT MAP (Q0 => Q7, D0 => UQVN_N2, CLK => CLK);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => A7);
UQVB_B3 : XBIDI1
	PORT MAP (Z0 => UQVN_N2, XB0 => XB7, A0 => UQVN_N1, OE => OE);
UQVB_B4 : XDFF1
	PORT MAP (Q0 => Q6, D0 => UQVN_N4, CLK => CLK);
UQVB_B5 : XINV
	PORT MAP (ZN0 => UQVN_N3, A0 => A6);
UQVB_B6 : XBIDI1
	PORT MAP (Z0 => UQVN_N4, XB0 => XB6, A0 => UQVN_N3, OE => OE);
UQVB_B7 : XDFF1
	PORT MAP (Q0 => Q5, D0 => UQVN_N6, CLK => CLK);
UQVB_B8 : XINV
	PORT MAP (ZN0 => UQVN_N5, A0 => A5);
UQVB_B9 : XBIDI1
	PORT MAP (Z0 => UQVN_N6, XB0 => XB5, A0 => UQVN_N5, OE => OE);
UQVB_B10 : XDFF1
	PORT MAP (Q0 => Q4, D0 => UQVN_N8, CLK => CLK);
UQVB_B11 : XINV
	PORT MAP (ZN0 => UQVN_N7, A0 => A4);
UQVB_B12 : XBIDI1
	PORT MAP (Z0 => UQVN_N8, XB0 => XB4, A0 => UQVN_N7, OE => OE);
UQVB_B13 : XDFF1
	PORT MAP (Q0 => Q0, D0 => UQVN_N10, CLK => CLK);
UQVB_B14 : XINV
	PORT MAP (ZN0 => UQVN_N9, A0 => A0);
UQVB_B15 : XBIDI1
	PORT MAP (Z0 => UQVN_N10, XB0 => XB0, A0 => UQVN_N9, OE => OE);
UQVB_B16 : XDFF1
	PORT MAP (Q0 => Q1, D0 => UQVN_N12, CLK => CLK);
UQVB_B17 : XINV
	PORT MAP (ZN0 => UQVN_N11, A0 => A1);
UQVB_B18 : XBIDI1
	PORT MAP (Z0 => UQVN_N12, XB0 => XB1, A0 => UQVN_N11, OE => OE);
UQVB_B19 : XDFF1
	PORT MAP (Q0 => Q3, D0 => UQVN_N14, CLK => CLK);
UQVB_B20 : XINV
	PORT MAP (ZN0 => UQVN_N13, A0 => A3);
UQVB_B21 : XBIDI1
	PORT MAP (Z0 => UQVN_N14, XB0 => XB3, A0 => UQVN_N13, OE => OE);
UQVB_B22 : XDFF1
	PORT MAP (Q0 => Q2, D0 => UQVN_N16, CLK => CLK);
UQVB_B23 : XINV
	PORT MAP (ZN0 => UQVN_N15, A0 => A2);
UQVB_B24 : XBIDI1
	PORT MAP (Z0 => UQVN_N16, XB0 => XB2, A0 => UQVN_N15, OE => OE);
END lattice_arch;
-- VHDL netlist for BIID31
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIID31 IS 
    PORT (
        A0 : IN std_logic;
        CLK : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
END BIID31;


ARCHITECTURE lattice_arch OF BIID31 IS
SIGNAL  UQVN_N1, UQVN_N2 : std_logic;


  COMPONENT XDFF1
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDFF1 use  entity  lattice.XDFF1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDFF1
	PORT MAP (Q0 => Q0, D0 => UQVN_N1, CLK => CLK);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N2, A0 => OE);
UQVB_B3 : XBIDI1
	PORT MAP (Z0 => UQVN_N1, XB0 => XB0, A0 => A0, OE => UQVN_N2);
END lattice_arch;
-- VHDL netlist for BIID34
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIID34 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        CLK : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic
    );
END BIID34;


ARCHITECTURE lattice_arch OF BIID34 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8 : std_logic;


  COMPONENT XDFF1
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDFF1 use  entity  lattice.XDFF1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDFF1
	PORT MAP (Q0 => Q3, D0 => UQVN_N1, CLK => CLK);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N2, A0 => OE);
UQVB_B3 : XBIDI1
	PORT MAP (Z0 => UQVN_N1, XB0 => XB3, A0 => A3, OE => UQVN_N2);
UQVB_B4 : XDFF1
	PORT MAP (Q0 => Q2, D0 => UQVN_N3, CLK => CLK);
UQVB_B5 : XINV
	PORT MAP (ZN0 => UQVN_N4, A0 => OE);
UQVB_B6 : XBIDI1
	PORT MAP (Z0 => UQVN_N3, XB0 => XB2, A0 => A2, OE => UQVN_N4);
UQVB_B7 : XDFF1
	PORT MAP (Q0 => Q1, D0 => UQVN_N5, CLK => CLK);
UQVB_B8 : XINV
	PORT MAP (ZN0 => UQVN_N6, A0 => OE);
UQVB_B9 : XBIDI1
	PORT MAP (Z0 => UQVN_N5, XB0 => XB1, A0 => A1, OE => UQVN_N6);
UQVB_B10 : XDFF1
	PORT MAP (Q0 => Q0, D0 => UQVN_N7, CLK => CLK);
UQVB_B11 : XINV
	PORT MAP (ZN0 => UQVN_N8, A0 => OE);
UQVB_B12 : XBIDI1
	PORT MAP (Z0 => UQVN_N7, XB0 => XB0, A0 => A0, OE => UQVN_N8);
END lattice_arch;
-- VHDL netlist for BIID38
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIID38 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        CLK : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        Q4 : OUT std_logic;
        Q5 : OUT std_logic;
        Q6 : OUT std_logic;
        Q7 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic;
        XB4 : INOUT std_logic;
        XB5 : INOUT std_logic;
        XB6 : INOUT std_logic;
        XB7 : INOUT std_logic
    );
END BIID38;


ARCHITECTURE lattice_arch OF BIID38 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16 : std_logic;


  COMPONENT XDFF1
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDFF1 use  entity  lattice.XDFF1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDFF1
	PORT MAP (Q0 => Q7, D0 => UQVN_N1, CLK => CLK);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N2, A0 => OE);
UQVB_B3 : XBIDI1
	PORT MAP (Z0 => UQVN_N1, XB0 => XB7, A0 => A7, OE => UQVN_N2);
UQVB_B4 : XDFF1
	PORT MAP (Q0 => Q6, D0 => UQVN_N3, CLK => CLK);
UQVB_B5 : XINV
	PORT MAP (ZN0 => UQVN_N4, A0 => OE);
UQVB_B6 : XBIDI1
	PORT MAP (Z0 => UQVN_N3, XB0 => XB6, A0 => A6, OE => UQVN_N4);
UQVB_B7 : XDFF1
	PORT MAP (Q0 => Q5, D0 => UQVN_N5, CLK => CLK);
UQVB_B8 : XINV
	PORT MAP (ZN0 => UQVN_N6, A0 => OE);
UQVB_B9 : XBIDI1
	PORT MAP (Z0 => UQVN_N5, XB0 => XB5, A0 => A5, OE => UQVN_N6);
UQVB_B10 : XDFF1
	PORT MAP (Q0 => Q4, D0 => UQVN_N7, CLK => CLK);
UQVB_B11 : XINV
	PORT MAP (ZN0 => UQVN_N8, A0 => OE);
UQVB_B12 : XBIDI1
	PORT MAP (Z0 => UQVN_N7, XB0 => XB4, A0 => A4, OE => UQVN_N8);
UQVB_B13 : XDFF1
	PORT MAP (Q0 => Q0, D0 => UQVN_N9, CLK => CLK);
UQVB_B14 : XINV
	PORT MAP (ZN0 => UQVN_N10, A0 => OE);
UQVB_B15 : XBIDI1
	PORT MAP (Z0 => UQVN_N9, XB0 => XB0, A0 => A0, OE => UQVN_N10);
UQVB_B16 : XDFF1
	PORT MAP (Q0 => Q1, D0 => UQVN_N11, CLK => CLK);
UQVB_B17 : XINV
	PORT MAP (ZN0 => UQVN_N12, A0 => OE);
UQVB_B18 : XBIDI1
	PORT MAP (Z0 => UQVN_N11, XB0 => XB1, A0 => A1, OE => UQVN_N12);
UQVB_B19 : XDFF1
	PORT MAP (Q0 => Q3, D0 => UQVN_N13, CLK => CLK);
UQVB_B20 : XINV
	PORT MAP (ZN0 => UQVN_N14, A0 => OE);
UQVB_B21 : XBIDI1
	PORT MAP (Z0 => UQVN_N13, XB0 => XB3, A0 => A3, OE => UQVN_N14);
UQVB_B22 : XDFF1
	PORT MAP (Q0 => Q2, D0 => UQVN_N15, CLK => CLK);
UQVB_B23 : XINV
	PORT MAP (ZN0 => UQVN_N16, A0 => OE);
UQVB_B24 : XBIDI1
	PORT MAP (Z0 => UQVN_N15, XB0 => XB2, A0 => A2, OE => UQVN_N16);
END lattice_arch;
-- VHDL netlist for BIID41
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIID41 IS 
    PORT (
        A0 : IN std_logic;
        CLK : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
END BIID41;


ARCHITECTURE lattice_arch OF BIID41 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3 : std_logic;


  COMPONENT XDFF1
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDFF1 use  entity  lattice.XDFF1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDFF1
	PORT MAP (Q0 => Q0, D0 => UQVN_N2, CLK => CLK);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => A0);
UQVB_B3 : XINV
	PORT MAP (ZN0 => UQVN_N3, A0 => OE);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => UQVN_N2, XB0 => XB0, A0 => UQVN_N1, OE => UQVN_N3);
END lattice_arch;
-- VHDL netlist for BIID44
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIID44 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        CLK : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic
    );
END BIID44;


ARCHITECTURE lattice_arch OF BIID44 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12 : std_logic;


  COMPONENT XDFF1
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDFF1 use  entity  lattice.XDFF1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDFF1
	PORT MAP (Q0 => Q3, D0 => UQVN_N2, CLK => CLK);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => A3);
UQVB_B3 : XINV
	PORT MAP (ZN0 => UQVN_N3, A0 => OE);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => UQVN_N2, XB0 => XB3, A0 => UQVN_N1, OE => UQVN_N3);
UQVB_B5 : XDFF1
	PORT MAP (Q0 => Q2, D0 => UQVN_N5, CLK => CLK);
UQVB_B6 : XINV
	PORT MAP (ZN0 => UQVN_N4, A0 => A2);
UQVB_B7 : XINV
	PORT MAP (ZN0 => UQVN_N6, A0 => OE);
UQVB_B8 : XBIDI1
	PORT MAP (Z0 => UQVN_N5, XB0 => XB2, A0 => UQVN_N4, OE => UQVN_N6);
UQVB_B9 : XDFF1
	PORT MAP (Q0 => Q1, D0 => UQVN_N8, CLK => CLK);
UQVB_B10 : XINV
	PORT MAP (ZN0 => UQVN_N7, A0 => A1);
UQVB_B11 : XINV
	PORT MAP (ZN0 => UQVN_N9, A0 => OE);
UQVB_B12 : XBIDI1
	PORT MAP (Z0 => UQVN_N8, XB0 => XB1, A0 => UQVN_N7, OE => UQVN_N9);
UQVB_B13 : XDFF1
	PORT MAP (Q0 => Q0, D0 => UQVN_N11, CLK => CLK);
UQVB_B14 : XINV
	PORT MAP (ZN0 => UQVN_N10, A0 => A0);
UQVB_B15 : XINV
	PORT MAP (ZN0 => UQVN_N12, A0 => OE);
UQVB_B16 : XBIDI1
	PORT MAP (Z0 => UQVN_N11, XB0 => XB0, A0 => UQVN_N10, OE => UQVN_N12);
END lattice_arch;
-- VHDL netlist for BIID48
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIID48 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        CLK : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        Q4 : OUT std_logic;
        Q5 : OUT std_logic;
        Q6 : OUT std_logic;
        Q7 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic;
        XB4 : INOUT std_logic;
        XB5 : INOUT std_logic;
        XB6 : INOUT std_logic;
        XB7 : INOUT std_logic
    );
END BIID48;


ARCHITECTURE lattice_arch OF BIID48 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, UQVN_N23, UQVN_N24 : std_logic;


  COMPONENT XDFF1
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDFF1 use  entity  lattice.XDFF1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDFF1
	PORT MAP (Q0 => Q7, D0 => UQVN_N2, CLK => CLK);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => A7);
UQVB_B3 : XINV
	PORT MAP (ZN0 => UQVN_N3, A0 => OE);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => UQVN_N2, XB0 => XB7, A0 => UQVN_N1, OE => UQVN_N3);
UQVB_B5 : XDFF1
	PORT MAP (Q0 => Q6, D0 => UQVN_N5, CLK => CLK);
UQVB_B6 : XINV
	PORT MAP (ZN0 => UQVN_N4, A0 => A6);
UQVB_B7 : XINV
	PORT MAP (ZN0 => UQVN_N6, A0 => OE);
UQVB_B8 : XBIDI1
	PORT MAP (Z0 => UQVN_N5, XB0 => XB6, A0 => UQVN_N4, OE => UQVN_N6);
UQVB_B9 : XDFF1
	PORT MAP (Q0 => Q5, D0 => UQVN_N8, CLK => CLK);
UQVB_B10 : XINV
	PORT MAP (ZN0 => UQVN_N7, A0 => A5);
UQVB_B11 : XINV
	PORT MAP (ZN0 => UQVN_N9, A0 => OE);
UQVB_B12 : XBIDI1
	PORT MAP (Z0 => UQVN_N8, XB0 => XB5, A0 => UQVN_N7, OE => UQVN_N9);
UQVB_B13 : XDFF1
	PORT MAP (Q0 => Q4, D0 => UQVN_N11, CLK => CLK);
UQVB_B14 : XINV
	PORT MAP (ZN0 => UQVN_N10, A0 => A4);
UQVB_B15 : XINV
	PORT MAP (ZN0 => UQVN_N12, A0 => OE);
UQVB_B16 : XBIDI1
	PORT MAP (Z0 => UQVN_N11, XB0 => XB4, A0 => UQVN_N10, OE => UQVN_N12);
UQVB_B17 : XDFF1
	PORT MAP (Q0 => Q0, D0 => UQVN_N14, CLK => CLK);
UQVB_B18 : XINV
	PORT MAP (ZN0 => UQVN_N13, A0 => A0);
UQVB_B19 : XINV
	PORT MAP (ZN0 => UQVN_N15, A0 => OE);
UQVB_B20 : XBIDI1
	PORT MAP (Z0 => UQVN_N14, XB0 => XB0, A0 => UQVN_N13, OE => UQVN_N15);
UQVB_B21 : XDFF1
	PORT MAP (Q0 => Q1, D0 => UQVN_N17, CLK => CLK);
UQVB_B22 : XINV
	PORT MAP (ZN0 => UQVN_N16, A0 => A1);
UQVB_B23 : XINV
	PORT MAP (ZN0 => UQVN_N18, A0 => OE);
UQVB_B24 : XBIDI1
	PORT MAP (Z0 => UQVN_N17, XB0 => XB1, A0 => UQVN_N16, OE => UQVN_N18);
UQVB_B25 : XDFF1
	PORT MAP (Q0 => Q3, D0 => UQVN_N20, CLK => CLK);
UQVB_B26 : XINV
	PORT MAP (ZN0 => UQVN_N19, A0 => A3);
UQVB_B27 : XINV
	PORT MAP (ZN0 => UQVN_N21, A0 => OE);
UQVB_B28 : XBIDI1
	PORT MAP (Z0 => UQVN_N20, XB0 => XB3, A0 => UQVN_N19, OE => UQVN_N21);
UQVB_B29 : XDFF1
	PORT MAP (Q0 => Q2, D0 => UQVN_N23, CLK => CLK);
UQVB_B30 : XINV
	PORT MAP (ZN0 => UQVN_N22, A0 => A2);
UQVB_B31 : XINV
	PORT MAP (ZN0 => UQVN_N24, A0 => OE);
UQVB_B32 : XBIDI1
	PORT MAP (Z0 => UQVN_N23, XB0 => XB2, A0 => UQVN_N22, OE => UQVN_N24);
END lattice_arch;
-- VHDL netlist for BIID51
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIID51 IS 
    PORT (
        A0 : IN std_logic;
        CLK : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
END BIID51;


ARCHITECTURE lattice_arch OF BIID51 IS
SIGNAL  UQVN_N1, UQVN_N2 : std_logic;


  COMPONENT XDFF1
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDFF1 use  entity  lattice.XDFF1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDFF1
	PORT MAP (Q0 => Q0, D0 => UQVN_N2, CLK => UQVN_N1);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => CLK);
UQVB_B3 : XBIDI1
	PORT MAP (Z0 => UQVN_N2, XB0 => XB0, A0 => A0, OE => OE);
END lattice_arch;
-- VHDL netlist for BIID54
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIID54 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        CLK : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic
    );
END BIID54;


ARCHITECTURE lattice_arch OF BIID54 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8 : std_logic;


  COMPONENT XDFF1
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDFF1 use  entity  lattice.XDFF1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDFF1
	PORT MAP (Q0 => Q3, D0 => UQVN_N2, CLK => UQVN_N1);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => CLK);
UQVB_B3 : XBIDI1
	PORT MAP (Z0 => UQVN_N2, XB0 => XB3, A0 => A3, OE => OE);
UQVB_B4 : XDFF1
	PORT MAP (Q0 => Q2, D0 => UQVN_N4, CLK => UQVN_N3);
UQVB_B5 : XINV
	PORT MAP (ZN0 => UQVN_N3, A0 => CLK);
UQVB_B6 : XBIDI1
	PORT MAP (Z0 => UQVN_N4, XB0 => XB2, A0 => A2, OE => OE);
UQVB_B7 : XDFF1
	PORT MAP (Q0 => Q1, D0 => UQVN_N6, CLK => UQVN_N5);
UQVB_B8 : XINV
	PORT MAP (ZN0 => UQVN_N5, A0 => CLK);
UQVB_B9 : XBIDI1
	PORT MAP (Z0 => UQVN_N6, XB0 => XB1, A0 => A1, OE => OE);
UQVB_B10 : XDFF1
	PORT MAP (Q0 => Q0, D0 => UQVN_N8, CLK => UQVN_N7);
UQVB_B11 : XINV
	PORT MAP (ZN0 => UQVN_N7, A0 => CLK);
UQVB_B12 : XBIDI1
	PORT MAP (Z0 => UQVN_N8, XB0 => XB0, A0 => A0, OE => OE);
END lattice_arch;
-- VHDL netlist for BIID58
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIID58 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        CLK : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        Q4 : OUT std_logic;
        Q5 : OUT std_logic;
        Q6 : OUT std_logic;
        Q7 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic;
        XB4 : INOUT std_logic;
        XB5 : INOUT std_logic;
        XB6 : INOUT std_logic;
        XB7 : INOUT std_logic
    );
END BIID58;


ARCHITECTURE lattice_arch OF BIID58 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16 : std_logic;


  COMPONENT XDFF1
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDFF1 use  entity  lattice.XDFF1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDFF1
	PORT MAP (Q0 => Q7, D0 => UQVN_N2, CLK => UQVN_N1);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => CLK);
UQVB_B3 : XBIDI1
	PORT MAP (Z0 => UQVN_N2, XB0 => XB7, A0 => A7, OE => OE);
UQVB_B4 : XDFF1
	PORT MAP (Q0 => Q6, D0 => UQVN_N4, CLK => UQVN_N3);
UQVB_B5 : XINV
	PORT MAP (ZN0 => UQVN_N3, A0 => CLK);
UQVB_B6 : XBIDI1
	PORT MAP (Z0 => UQVN_N4, XB0 => XB6, A0 => A6, OE => OE);
UQVB_B7 : XDFF1
	PORT MAP (Q0 => Q5, D0 => UQVN_N6, CLK => UQVN_N5);
UQVB_B8 : XINV
	PORT MAP (ZN0 => UQVN_N5, A0 => CLK);
UQVB_B9 : XBIDI1
	PORT MAP (Z0 => UQVN_N6, XB0 => XB5, A0 => A5, OE => OE);
UQVB_B10 : XDFF1
	PORT MAP (Q0 => Q4, D0 => UQVN_N8, CLK => UQVN_N7);
UQVB_B11 : XINV
	PORT MAP (ZN0 => UQVN_N7, A0 => CLK);
UQVB_B12 : XBIDI1
	PORT MAP (Z0 => UQVN_N8, XB0 => XB4, A0 => A4, OE => OE);
UQVB_B13 : XDFF1
	PORT MAP (Q0 => Q0, D0 => UQVN_N10, CLK => UQVN_N9);
UQVB_B14 : XINV
	PORT MAP (ZN0 => UQVN_N9, A0 => CLK);
UQVB_B15 : XBIDI1
	PORT MAP (Z0 => UQVN_N10, XB0 => XB0, A0 => A0, OE => OE);
UQVB_B16 : XDFF1
	PORT MAP (Q0 => Q1, D0 => UQVN_N12, CLK => UQVN_N11);
UQVB_B17 : XINV
	PORT MAP (ZN0 => UQVN_N11, A0 => CLK);
UQVB_B18 : XBIDI1
	PORT MAP (Z0 => UQVN_N12, XB0 => XB1, A0 => A1, OE => OE);
UQVB_B19 : XDFF1
	PORT MAP (Q0 => Q3, D0 => UQVN_N14, CLK => UQVN_N13);
UQVB_B20 : XINV
	PORT MAP (ZN0 => UQVN_N13, A0 => CLK);
UQVB_B21 : XBIDI1
	PORT MAP (Z0 => UQVN_N14, XB0 => XB3, A0 => A3, OE => OE);
UQVB_B22 : XDFF1
	PORT MAP (Q0 => Q2, D0 => UQVN_N16, CLK => UQVN_N15);
UQVB_B23 : XINV
	PORT MAP (ZN0 => UQVN_N15, A0 => CLK);
UQVB_B24 : XBIDI1
	PORT MAP (Z0 => UQVN_N16, XB0 => XB2, A0 => A2, OE => OE);
END lattice_arch;
-- VHDL netlist for BIID61
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIID61 IS 
    PORT (
        A0 : IN std_logic;
        CLK : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
END BIID61;


ARCHITECTURE lattice_arch OF BIID61 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3 : std_logic;


  COMPONENT XDFF1
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDFF1 use  entity  lattice.XDFF1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDFF1
	PORT MAP (Q0 => Q0, D0 => UQVN_N3, CLK => UQVN_N2);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => A0);
UQVB_B3 : XINV
	PORT MAP (ZN0 => UQVN_N2, A0 => CLK);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => UQVN_N3, XB0 => XB0, A0 => UQVN_N1, OE => OE);
END lattice_arch;
-- VHDL netlist for BIID64
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIID64 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        CLK : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic
    );
END BIID64;


ARCHITECTURE lattice_arch OF BIID64 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12 : std_logic;


  COMPONENT XDFF1
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDFF1 use  entity  lattice.XDFF1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDFF1
	PORT MAP (Q0 => Q3, D0 => UQVN_N3, CLK => UQVN_N2);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => A3);
UQVB_B3 : XINV
	PORT MAP (ZN0 => UQVN_N2, A0 => CLK);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => UQVN_N3, XB0 => XB3, A0 => UQVN_N1, OE => OE);
UQVB_B5 : XDFF1
	PORT MAP (Q0 => Q2, D0 => UQVN_N6, CLK => UQVN_N5);
UQVB_B6 : XINV
	PORT MAP (ZN0 => UQVN_N4, A0 => A2);
UQVB_B7 : XINV
	PORT MAP (ZN0 => UQVN_N5, A0 => CLK);
UQVB_B8 : XBIDI1
	PORT MAP (Z0 => UQVN_N6, XB0 => XB2, A0 => UQVN_N4, OE => OE);
UQVB_B9 : XDFF1
	PORT MAP (Q0 => Q1, D0 => UQVN_N9, CLK => UQVN_N8);
UQVB_B10 : XINV
	PORT MAP (ZN0 => UQVN_N7, A0 => A1);
UQVB_B11 : XINV
	PORT MAP (ZN0 => UQVN_N8, A0 => CLK);
UQVB_B12 : XBIDI1
	PORT MAP (Z0 => UQVN_N9, XB0 => XB1, A0 => UQVN_N7, OE => OE);
UQVB_B13 : XDFF1
	PORT MAP (Q0 => Q0, D0 => UQVN_N12, CLK => UQVN_N11);
UQVB_B14 : XINV
	PORT MAP (ZN0 => UQVN_N10, A0 => A0);
UQVB_B15 : XINV
	PORT MAP (ZN0 => UQVN_N11, A0 => CLK);
UQVB_B16 : XBIDI1
	PORT MAP (Z0 => UQVN_N12, XB0 => XB0, A0 => UQVN_N10, OE => OE);
END lattice_arch;
-- VHDL netlist for BIID68
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIID68 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        CLK : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        Q4 : OUT std_logic;
        Q5 : OUT std_logic;
        Q6 : OUT std_logic;
        Q7 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic;
        XB4 : INOUT std_logic;
        XB5 : INOUT std_logic;
        XB6 : INOUT std_logic;
        XB7 : INOUT std_logic
    );
END BIID68;


ARCHITECTURE lattice_arch OF BIID68 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, UQVN_N23, UQVN_N24 : std_logic;


  COMPONENT XDFF1
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDFF1 use  entity  lattice.XDFF1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDFF1
	PORT MAP (Q0 => Q7, D0 => UQVN_N3, CLK => UQVN_N2);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => A7);
UQVB_B3 : XINV
	PORT MAP (ZN0 => UQVN_N2, A0 => CLK);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => UQVN_N3, XB0 => XB7, A0 => UQVN_N1, OE => OE);
UQVB_B5 : XDFF1
	PORT MAP (Q0 => Q6, D0 => UQVN_N6, CLK => UQVN_N5);
UQVB_B6 : XINV
	PORT MAP (ZN0 => UQVN_N4, A0 => A6);
UQVB_B7 : XINV
	PORT MAP (ZN0 => UQVN_N5, A0 => CLK);
UQVB_B8 : XBIDI1
	PORT MAP (Z0 => UQVN_N6, XB0 => XB6, A0 => UQVN_N4, OE => OE);
UQVB_B9 : XDFF1
	PORT MAP (Q0 => Q5, D0 => UQVN_N9, CLK => UQVN_N8);
UQVB_B10 : XINV
	PORT MAP (ZN0 => UQVN_N7, A0 => A5);
UQVB_B11 : XINV
	PORT MAP (ZN0 => UQVN_N8, A0 => CLK);
UQVB_B12 : XBIDI1
	PORT MAP (Z0 => UQVN_N9, XB0 => XB5, A0 => UQVN_N7, OE => OE);
UQVB_B13 : XDFF1
	PORT MAP (Q0 => Q4, D0 => UQVN_N12, CLK => UQVN_N11);
UQVB_B14 : XINV
	PORT MAP (ZN0 => UQVN_N10, A0 => A4);
UQVB_B15 : XINV
	PORT MAP (ZN0 => UQVN_N11, A0 => CLK);
UQVB_B16 : XBIDI1
	PORT MAP (Z0 => UQVN_N12, XB0 => XB4, A0 => UQVN_N10, OE => OE);
UQVB_B17 : XDFF1
	PORT MAP (Q0 => Q0, D0 => UQVN_N15, CLK => UQVN_N14);
UQVB_B18 : XINV
	PORT MAP (ZN0 => UQVN_N13, A0 => A0);
UQVB_B19 : XINV
	PORT MAP (ZN0 => UQVN_N14, A0 => CLK);
UQVB_B20 : XBIDI1
	PORT MAP (Z0 => UQVN_N15, XB0 => XB0, A0 => UQVN_N13, OE => OE);
UQVB_B21 : XDFF1
	PORT MAP (Q0 => Q1, D0 => UQVN_N18, CLK => UQVN_N17);
UQVB_B22 : XINV
	PORT MAP (ZN0 => UQVN_N16, A0 => A1);
UQVB_B23 : XINV
	PORT MAP (ZN0 => UQVN_N17, A0 => CLK);
UQVB_B24 : XBIDI1
	PORT MAP (Z0 => UQVN_N18, XB0 => XB1, A0 => UQVN_N16, OE => OE);
UQVB_B25 : XDFF1
	PORT MAP (Q0 => Q3, D0 => UQVN_N21, CLK => UQVN_N20);
UQVB_B26 : XINV
	PORT MAP (ZN0 => UQVN_N19, A0 => A3);
UQVB_B27 : XINV
	PORT MAP (ZN0 => UQVN_N20, A0 => CLK);
UQVB_B28 : XBIDI1
	PORT MAP (Z0 => UQVN_N21, XB0 => XB3, A0 => UQVN_N19, OE => OE);
UQVB_B29 : XDFF1
	PORT MAP (Q0 => Q2, D0 => UQVN_N24, CLK => UQVN_N23);
UQVB_B30 : XINV
	PORT MAP (ZN0 => UQVN_N22, A0 => A2);
UQVB_B31 : XINV
	PORT MAP (ZN0 => UQVN_N23, A0 => CLK);
UQVB_B32 : XBIDI1
	PORT MAP (Z0 => UQVN_N24, XB0 => XB2, A0 => UQVN_N22, OE => OE);
END lattice_arch;
-- VHDL netlist for BIID71
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIID71 IS 
    PORT (
        A0 : IN std_logic;
        CLK : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
END BIID71;


ARCHITECTURE lattice_arch OF BIID71 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3 : std_logic;


  COMPONENT XDFF1
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDFF1 use  entity  lattice.XDFF1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDFF1
	PORT MAP (Q0 => Q0, D0 => UQVN_N2, CLK => UQVN_N1);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N3, A0 => OE);
UQVB_B3 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => CLK);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => UQVN_N2, XB0 => XB0, A0 => A0, OE => UQVN_N3);
END lattice_arch;
-- VHDL netlist for BIID74
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIID74 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        CLK : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic
    );
END BIID74;


ARCHITECTURE lattice_arch OF BIID74 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12 : std_logic;


  COMPONENT XDFF1
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDFF1 use  entity  lattice.XDFF1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDFF1
	PORT MAP (Q0 => Q3, D0 => UQVN_N2, CLK => UQVN_N1);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N3, A0 => OE);
UQVB_B3 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => CLK);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => UQVN_N2, XB0 => XB3, A0 => A3, OE => UQVN_N3);
UQVB_B5 : XDFF1
	PORT MAP (Q0 => Q2, D0 => UQVN_N5, CLK => UQVN_N4);
UQVB_B6 : XINV
	PORT MAP (ZN0 => UQVN_N6, A0 => OE);
UQVB_B7 : XINV
	PORT MAP (ZN0 => UQVN_N4, A0 => CLK);
UQVB_B8 : XBIDI1
	PORT MAP (Z0 => UQVN_N5, XB0 => XB2, A0 => A2, OE => UQVN_N6);
UQVB_B9 : XDFF1
	PORT MAP (Q0 => Q1, D0 => UQVN_N8, CLK => UQVN_N7);
UQVB_B10 : XINV
	PORT MAP (ZN0 => UQVN_N9, A0 => OE);
UQVB_B11 : XINV
	PORT MAP (ZN0 => UQVN_N7, A0 => CLK);
UQVB_B12 : XBIDI1
	PORT MAP (Z0 => UQVN_N8, XB0 => XB1, A0 => A1, OE => UQVN_N9);
UQVB_B13 : XDFF1
	PORT MAP (Q0 => Q0, D0 => UQVN_N11, CLK => UQVN_N10);
UQVB_B14 : XINV
	PORT MAP (ZN0 => UQVN_N12, A0 => OE);
UQVB_B15 : XINV
	PORT MAP (ZN0 => UQVN_N10, A0 => CLK);
UQVB_B16 : XBIDI1
	PORT MAP (Z0 => UQVN_N11, XB0 => XB0, A0 => A0, OE => UQVN_N12);
END lattice_arch;
-- VHDL netlist for BIID78
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIID78 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        CLK : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        Q4 : OUT std_logic;
        Q5 : OUT std_logic;
        Q6 : OUT std_logic;
        Q7 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic;
        XB4 : INOUT std_logic;
        XB5 : INOUT std_logic;
        XB6 : INOUT std_logic;
        XB7 : INOUT std_logic
    );
END BIID78;


ARCHITECTURE lattice_arch OF BIID78 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, UQVN_N23, UQVN_N24 : std_logic;


  COMPONENT XDFF1
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDFF1 use  entity  lattice.XDFF1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDFF1
	PORT MAP (Q0 => Q7, D0 => UQVN_N2, CLK => UQVN_N1);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N3, A0 => OE);
UQVB_B3 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => CLK);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => UQVN_N2, XB0 => XB7, A0 => A7, OE => UQVN_N3);
UQVB_B5 : XDFF1
	PORT MAP (Q0 => Q6, D0 => UQVN_N5, CLK => UQVN_N4);
UQVB_B6 : XINV
	PORT MAP (ZN0 => UQVN_N6, A0 => OE);
UQVB_B7 : XINV
	PORT MAP (ZN0 => UQVN_N4, A0 => CLK);
UQVB_B8 : XBIDI1
	PORT MAP (Z0 => UQVN_N5, XB0 => XB6, A0 => A6, OE => UQVN_N6);
UQVB_B9 : XDFF1
	PORT MAP (Q0 => Q5, D0 => UQVN_N8, CLK => UQVN_N7);
UQVB_B10 : XINV
	PORT MAP (ZN0 => UQVN_N9, A0 => OE);
UQVB_B11 : XINV
	PORT MAP (ZN0 => UQVN_N7, A0 => CLK);
UQVB_B12 : XBIDI1
	PORT MAP (Z0 => UQVN_N8, XB0 => XB5, A0 => A5, OE => UQVN_N9);
UQVB_B13 : XDFF1
	PORT MAP (Q0 => Q4, D0 => UQVN_N11, CLK => UQVN_N10);
UQVB_B14 : XINV
	PORT MAP (ZN0 => UQVN_N12, A0 => OE);
UQVB_B15 : XINV
	PORT MAP (ZN0 => UQVN_N10, A0 => CLK);
UQVB_B16 : XBIDI1
	PORT MAP (Z0 => UQVN_N11, XB0 => XB4, A0 => A4, OE => UQVN_N12);
UQVB_B17 : XDFF1
	PORT MAP (Q0 => Q0, D0 => UQVN_N14, CLK => UQVN_N13);
UQVB_B18 : XINV
	PORT MAP (ZN0 => UQVN_N15, A0 => OE);
UQVB_B19 : XINV
	PORT MAP (ZN0 => UQVN_N13, A0 => CLK);
UQVB_B20 : XBIDI1
	PORT MAP (Z0 => UQVN_N14, XB0 => XB0, A0 => A0, OE => UQVN_N15);
UQVB_B21 : XDFF1
	PORT MAP (Q0 => Q1, D0 => UQVN_N17, CLK => UQVN_N16);
UQVB_B22 : XINV
	PORT MAP (ZN0 => UQVN_N18, A0 => OE);
UQVB_B23 : XINV
	PORT MAP (ZN0 => UQVN_N16, A0 => CLK);
UQVB_B24 : XBIDI1
	PORT MAP (Z0 => UQVN_N17, XB0 => XB1, A0 => A1, OE => UQVN_N18);
UQVB_B25 : XDFF1
	PORT MAP (Q0 => Q3, D0 => UQVN_N20, CLK => UQVN_N19);
UQVB_B26 : XINV
	PORT MAP (ZN0 => UQVN_N21, A0 => OE);
UQVB_B27 : XINV
	PORT MAP (ZN0 => UQVN_N19, A0 => CLK);
UQVB_B28 : XBIDI1
	PORT MAP (Z0 => UQVN_N20, XB0 => XB3, A0 => A3, OE => UQVN_N21);
UQVB_B29 : XDFF1
	PORT MAP (Q0 => Q2, D0 => UQVN_N23, CLK => UQVN_N22);
UQVB_B30 : XINV
	PORT MAP (ZN0 => UQVN_N24, A0 => OE);
UQVB_B31 : XINV
	PORT MAP (ZN0 => UQVN_N22, A0 => CLK);
UQVB_B32 : XBIDI1
	PORT MAP (Z0 => UQVN_N23, XB0 => XB2, A0 => A2, OE => UQVN_N24);
END lattice_arch;
-- VHDL netlist for BIID81
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIID81 IS 
    PORT (
        A0 : IN std_logic;
        CLK : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
END BIID81;


ARCHITECTURE lattice_arch OF BIID81 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4 : std_logic;


  COMPONENT XDFF1
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDFF1 use  entity  lattice.XDFF1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDFF1
	PORT MAP (Q0 => Q0, D0 => UQVN_N3, CLK => UQVN_N2);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => A0);
UQVB_B3 : XINV
	PORT MAP (ZN0 => UQVN_N2, A0 => CLK);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => UQVN_N3, XB0 => XB0, A0 => UQVN_N1, OE => UQVN_N4);
UQVB_B5 : XINV
	PORT MAP (ZN0 => UQVN_N4, A0 => OE);
END lattice_arch;
-- VHDL netlist for BIID84
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIID84 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        CLK : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic
    );
END BIID84;


ARCHITECTURE lattice_arch OF BIID84 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16 : std_logic;


  COMPONENT XDFF1
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDFF1 use  entity  lattice.XDFF1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDFF1
	PORT MAP (Q0 => Q3, D0 => UQVN_N3, CLK => UQVN_N2);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => A3);
UQVB_B3 : XINV
	PORT MAP (ZN0 => UQVN_N2, A0 => CLK);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => UQVN_N3, XB0 => XB3, A0 => UQVN_N1, OE => UQVN_N4);
UQVB_B5 : XINV
	PORT MAP (ZN0 => UQVN_N4, A0 => OE);
UQVB_B6 : XDFF1
	PORT MAP (Q0 => Q2, D0 => UQVN_N7, CLK => UQVN_N6);
UQVB_B7 : XINV
	PORT MAP (ZN0 => UQVN_N5, A0 => A2);
UQVB_B8 : XINV
	PORT MAP (ZN0 => UQVN_N6, A0 => CLK);
UQVB_B9 : XBIDI1
	PORT MAP (Z0 => UQVN_N7, XB0 => XB2, A0 => UQVN_N5, OE => UQVN_N8);
UQVB_B10 : XINV
	PORT MAP (ZN0 => UQVN_N8, A0 => OE);
UQVB_B11 : XDFF1
	PORT MAP (Q0 => Q1, D0 => UQVN_N11, CLK => UQVN_N10);
UQVB_B12 : XINV
	PORT MAP (ZN0 => UQVN_N9, A0 => A1);
UQVB_B13 : XINV
	PORT MAP (ZN0 => UQVN_N10, A0 => CLK);
UQVB_B14 : XBIDI1
	PORT MAP (Z0 => UQVN_N11, XB0 => XB1, A0 => UQVN_N9, OE => UQVN_N12);
UQVB_B15 : XINV
	PORT MAP (ZN0 => UQVN_N12, A0 => OE);
UQVB_B16 : XDFF1
	PORT MAP (Q0 => Q0, D0 => UQVN_N15, CLK => UQVN_N14);
UQVB_B17 : XINV
	PORT MAP (ZN0 => UQVN_N13, A0 => A0);
UQVB_B18 : XINV
	PORT MAP (ZN0 => UQVN_N14, A0 => CLK);
UQVB_B19 : XBIDI1
	PORT MAP (Z0 => UQVN_N15, XB0 => XB0, A0 => UQVN_N13, OE => UQVN_N16);
UQVB_B20 : XINV
	PORT MAP (ZN0 => UQVN_N16, A0 => OE);
END lattice_arch;
-- VHDL netlist for BIID88
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIID88 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        CLK : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        Q4 : OUT std_logic;
        Q5 : OUT std_logic;
        Q6 : OUT std_logic;
        Q7 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic;
        XB4 : INOUT std_logic;
        XB5 : INOUT std_logic;
        XB6 : INOUT std_logic;
        XB7 : INOUT std_logic
    );
END BIID88;


ARCHITECTURE lattice_arch OF BIID88 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, UQVN_N23, UQVN_N24,
	 UQVN_N25, UQVN_N26, UQVN_N27, UQVN_N28,
	 UQVN_N29, UQVN_N30, UQVN_N31, UQVN_N32 : std_logic;


  COMPONENT XDFF1
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDFF1 use  entity  lattice.XDFF1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDFF1
	PORT MAP (Q0 => Q7, D0 => UQVN_N3, CLK => UQVN_N2);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => A7);
UQVB_B3 : XINV
	PORT MAP (ZN0 => UQVN_N2, A0 => CLK);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => UQVN_N3, XB0 => XB7, A0 => UQVN_N1, OE => UQVN_N4);
UQVB_B5 : XINV
	PORT MAP (ZN0 => UQVN_N4, A0 => OE);
UQVB_B6 : XDFF1
	PORT MAP (Q0 => Q6, D0 => UQVN_N7, CLK => UQVN_N6);
UQVB_B7 : XINV
	PORT MAP (ZN0 => UQVN_N5, A0 => A6);
UQVB_B8 : XINV
	PORT MAP (ZN0 => UQVN_N6, A0 => CLK);
UQVB_B9 : XBIDI1
	PORT MAP (Z0 => UQVN_N7, XB0 => XB6, A0 => UQVN_N5, OE => UQVN_N8);
UQVB_B10 : XINV
	PORT MAP (ZN0 => UQVN_N8, A0 => OE);
UQVB_B11 : XDFF1
	PORT MAP (Q0 => Q5, D0 => UQVN_N11, CLK => UQVN_N10);
UQVB_B12 : XINV
	PORT MAP (ZN0 => UQVN_N9, A0 => A5);
UQVB_B13 : XINV
	PORT MAP (ZN0 => UQVN_N10, A0 => CLK);
UQVB_B14 : XBIDI1
	PORT MAP (Z0 => UQVN_N11, XB0 => XB5, A0 => UQVN_N9, OE => UQVN_N12);
UQVB_B15 : XINV
	PORT MAP (ZN0 => UQVN_N12, A0 => OE);
UQVB_B16 : XDFF1
	PORT MAP (Q0 => Q4, D0 => UQVN_N15, CLK => UQVN_N14);
UQVB_B17 : XINV
	PORT MAP (ZN0 => UQVN_N13, A0 => A4);
UQVB_B18 : XINV
	PORT MAP (ZN0 => UQVN_N14, A0 => CLK);
UQVB_B19 : XBIDI1
	PORT MAP (Z0 => UQVN_N15, XB0 => XB4, A0 => UQVN_N13, OE => UQVN_N16);
UQVB_B20 : XINV
	PORT MAP (ZN0 => UQVN_N16, A0 => OE);
UQVB_B21 : XDFF1
	PORT MAP (Q0 => Q0, D0 => UQVN_N19, CLK => UQVN_N18);
UQVB_B22 : XINV
	PORT MAP (ZN0 => UQVN_N17, A0 => A0);
UQVB_B23 : XINV
	PORT MAP (ZN0 => UQVN_N18, A0 => CLK);
UQVB_B24 : XBIDI1
	PORT MAP (Z0 => UQVN_N19, XB0 => XB0, A0 => UQVN_N17, OE => UQVN_N20);
UQVB_B25 : XINV
	PORT MAP (ZN0 => UQVN_N20, A0 => OE);
UQVB_B26 : XDFF1
	PORT MAP (Q0 => Q1, D0 => UQVN_N23, CLK => UQVN_N22);
UQVB_B27 : XINV
	PORT MAP (ZN0 => UQVN_N21, A0 => A1);
UQVB_B28 : XINV
	PORT MAP (ZN0 => UQVN_N22, A0 => CLK);
UQVB_B29 : XBIDI1
	PORT MAP (Z0 => UQVN_N23, XB0 => XB1, A0 => UQVN_N21, OE => UQVN_N24);
UQVB_B30 : XINV
	PORT MAP (ZN0 => UQVN_N24, A0 => OE);
UQVB_B31 : XDFF1
	PORT MAP (Q0 => Q3, D0 => UQVN_N27, CLK => UQVN_N26);
UQVB_B32 : XINV
	PORT MAP (ZN0 => UQVN_N25, A0 => A3);
UQVB_B33 : XINV
	PORT MAP (ZN0 => UQVN_N26, A0 => CLK);
UQVB_B34 : XBIDI1
	PORT MAP (Z0 => UQVN_N27, XB0 => XB3, A0 => UQVN_N25, OE => UQVN_N28);
UQVB_B35 : XINV
	PORT MAP (ZN0 => UQVN_N28, A0 => OE);
UQVB_B36 : XDFF1
	PORT MAP (Q0 => Q2, D0 => UQVN_N31, CLK => UQVN_N30);
UQVB_B37 : XINV
	PORT MAP (ZN0 => UQVN_N29, A0 => A2);
UQVB_B38 : XINV
	PORT MAP (ZN0 => UQVN_N30, A0 => CLK);
UQVB_B39 : XBIDI1
	PORT MAP (Z0 => UQVN_N31, XB0 => XB2, A0 => UQVN_N29, OE => UQVN_N32);
UQVB_B40 : XINV
	PORT MAP (ZN0 => UQVN_N32, A0 => OE);
END lattice_arch;
-- VHDL netlist for BIIL11
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIIL11 IS 
    PORT (
        A0 : IN std_logic;
        G : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
END BIIL11;


ARCHITECTURE lattice_arch OF BIIL11 IS
SIGNAL  UQVN_N1 : std_logic;


  COMPONENT XDL1
    PORT (
        D0 : IN std_logic;
        G : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDL1 use  entity  lattice.XDL1(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDL1
	PORT MAP (Q0 => Q0, D0 => UQVN_N1, G => G);
UQVB_B2 : XBIDI1
	PORT MAP (Z0 => UQVN_N1, XB0 => XB0, A0 => A0, OE => OE);
END lattice_arch;
-- VHDL netlist for BIIL14
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIIL14 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        G : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic
    );
END BIIL14;


ARCHITECTURE lattice_arch OF BIIL14 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4 : std_logic;


  COMPONENT XDL1
    PORT (
        D0 : IN std_logic;
        G : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDL1 use  entity  lattice.XDL1(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDL1
	PORT MAP (Q0 => Q3, D0 => UQVN_N1, G => G);
UQVB_B2 : XBIDI1
	PORT MAP (Z0 => UQVN_N1, XB0 => XB3, A0 => A3, OE => OE);
UQVB_B3 : XDL1
	PORT MAP (Q0 => Q2, D0 => UQVN_N2, G => G);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => UQVN_N2, XB0 => XB2, A0 => A2, OE => OE);
UQVB_B5 : XDL1
	PORT MAP (Q0 => Q1, D0 => UQVN_N3, G => G);
UQVB_B6 : XBIDI1
	PORT MAP (Z0 => UQVN_N3, XB0 => XB1, A0 => A1, OE => OE);
UQVB_B7 : XDL1
	PORT MAP (Q0 => Q0, D0 => UQVN_N4, G => G);
UQVB_B8 : XBIDI1
	PORT MAP (Z0 => UQVN_N4, XB0 => XB0, A0 => A0, OE => OE);
END lattice_arch;
-- VHDL netlist for BIIL18
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIIL18 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        G : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        Q4 : OUT std_logic;
        Q5 : OUT std_logic;
        Q6 : OUT std_logic;
        Q7 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic;
        XB4 : INOUT std_logic;
        XB5 : INOUT std_logic;
        XB6 : INOUT std_logic;
        XB7 : INOUT std_logic
    );
END BIIL18;


ARCHITECTURE lattice_arch OF BIIL18 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8 : std_logic;


  COMPONENT XDL1
    PORT (
        D0 : IN std_logic;
        G : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDL1 use  entity  lattice.XDL1(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDL1
	PORT MAP (Q0 => Q7, D0 => UQVN_N1, G => G);
UQVB_B2 : XBIDI1
	PORT MAP (Z0 => UQVN_N1, XB0 => XB7, A0 => A7, OE => OE);
UQVB_B3 : XDL1
	PORT MAP (Q0 => Q6, D0 => UQVN_N2, G => G);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => UQVN_N2, XB0 => XB6, A0 => A6, OE => OE);
UQVB_B5 : XDL1
	PORT MAP (Q0 => Q5, D0 => UQVN_N3, G => G);
UQVB_B6 : XBIDI1
	PORT MAP (Z0 => UQVN_N3, XB0 => XB5, A0 => A5, OE => OE);
UQVB_B7 : XDL1
	PORT MAP (Q0 => Q4, D0 => UQVN_N4, G => G);
UQVB_B8 : XBIDI1
	PORT MAP (Z0 => UQVN_N4, XB0 => XB4, A0 => A4, OE => OE);
UQVB_B9 : XDL1
	PORT MAP (Q0 => Q0, D0 => UQVN_N5, G => G);
UQVB_B10 : XBIDI1
	PORT MAP (Z0 => UQVN_N5, XB0 => XB0, A0 => A0, OE => OE);
UQVB_B11 : XDL1
	PORT MAP (Q0 => Q1, D0 => UQVN_N6, G => G);
UQVB_B12 : XBIDI1
	PORT MAP (Z0 => UQVN_N6, XB0 => XB1, A0 => A1, OE => OE);
UQVB_B13 : XDL1
	PORT MAP (Q0 => Q3, D0 => UQVN_N7, G => G);
UQVB_B14 : XBIDI1
	PORT MAP (Z0 => UQVN_N7, XB0 => XB3, A0 => A3, OE => OE);
UQVB_B15 : XDL1
	PORT MAP (Q0 => Q2, D0 => UQVN_N8, G => G);
UQVB_B16 : XBIDI1
	PORT MAP (Z0 => UQVN_N8, XB0 => XB2, A0 => A2, OE => OE);
END lattice_arch;
-- VHDL netlist for BIIL21
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIIL21 IS 
    PORT (
        A0 : IN std_logic;
        G : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
END BIIL21;


ARCHITECTURE lattice_arch OF BIIL21 IS
SIGNAL  UQVN_N1, UQVN_N2 : std_logic;


  COMPONENT XDL1
    PORT (
        D0 : IN std_logic;
        G : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDL1 use  entity  lattice.XDL1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDL1
	PORT MAP (Q0 => Q0, D0 => UQVN_N2, G => G);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => A0);
UQVB_B3 : XBIDI1
	PORT MAP (Z0 => UQVN_N2, XB0 => XB0, A0 => UQVN_N1, OE => OE);
END lattice_arch;
-- VHDL netlist for BIIL24
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIIL24 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        G : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic
    );
END BIIL24;


ARCHITECTURE lattice_arch OF BIIL24 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8 : std_logic;


  COMPONENT XDL1
    PORT (
        D0 : IN std_logic;
        G : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDL1 use  entity  lattice.XDL1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDL1
	PORT MAP (Q0 => Q3, D0 => UQVN_N2, G => G);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => A3);
UQVB_B3 : XBIDI1
	PORT MAP (Z0 => UQVN_N2, XB0 => XB3, A0 => UQVN_N1, OE => OE);
UQVB_B4 : XDL1
	PORT MAP (Q0 => Q2, D0 => UQVN_N4, G => G);
UQVB_B5 : XINV
	PORT MAP (ZN0 => UQVN_N3, A0 => A2);
UQVB_B6 : XBIDI1
	PORT MAP (Z0 => UQVN_N4, XB0 => XB2, A0 => UQVN_N3, OE => OE);
UQVB_B7 : XDL1
	PORT MAP (Q0 => Q1, D0 => UQVN_N6, G => G);
UQVB_B8 : XINV
	PORT MAP (ZN0 => UQVN_N5, A0 => A1);
UQVB_B9 : XBIDI1
	PORT MAP (Z0 => UQVN_N6, XB0 => XB1, A0 => UQVN_N5, OE => OE);
UQVB_B10 : XDL1
	PORT MAP (Q0 => Q0, D0 => UQVN_N8, G => G);
UQVB_B11 : XINV
	PORT MAP (ZN0 => UQVN_N7, A0 => A0);
UQVB_B12 : XBIDI1
	PORT MAP (Z0 => UQVN_N8, XB0 => XB0, A0 => UQVN_N7, OE => OE);
END lattice_arch;
-- VHDL netlist for BIIL28
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIIL28 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        G : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        Q4 : OUT std_logic;
        Q5 : OUT std_logic;
        Q6 : OUT std_logic;
        Q7 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic;
        XB4 : INOUT std_logic;
        XB5 : INOUT std_logic;
        XB6 : INOUT std_logic;
        XB7 : INOUT std_logic
    );
END BIIL28;


ARCHITECTURE lattice_arch OF BIIL28 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16 : std_logic;


  COMPONENT XDL1
    PORT (
        D0 : IN std_logic;
        G : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDL1 use  entity  lattice.XDL1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDL1
	PORT MAP (Q0 => Q7, D0 => UQVN_N2, G => G);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => A7);
UQVB_B3 : XBIDI1
	PORT MAP (Z0 => UQVN_N2, XB0 => XB7, A0 => UQVN_N1, OE => OE);
UQVB_B4 : XDL1
	PORT MAP (Q0 => Q6, D0 => UQVN_N4, G => G);
UQVB_B5 : XINV
	PORT MAP (ZN0 => UQVN_N3, A0 => A6);
UQVB_B6 : XBIDI1
	PORT MAP (Z0 => UQVN_N4, XB0 => XB6, A0 => UQVN_N3, OE => OE);
UQVB_B7 : XDL1
	PORT MAP (Q0 => Q5, D0 => UQVN_N6, G => G);
UQVB_B8 : XINV
	PORT MAP (ZN0 => UQVN_N5, A0 => A5);
UQVB_B9 : XBIDI1
	PORT MAP (Z0 => UQVN_N6, XB0 => XB5, A0 => UQVN_N5, OE => OE);
UQVB_B10 : XDL1
	PORT MAP (Q0 => Q4, D0 => UQVN_N8, G => G);
UQVB_B11 : XINV
	PORT MAP (ZN0 => UQVN_N7, A0 => A4);
UQVB_B12 : XBIDI1
	PORT MAP (Z0 => UQVN_N8, XB0 => XB4, A0 => UQVN_N7, OE => OE);
UQVB_B13 : XDL1
	PORT MAP (Q0 => Q0, D0 => UQVN_N10, G => G);
UQVB_B14 : XINV
	PORT MAP (ZN0 => UQVN_N9, A0 => A0);
UQVB_B15 : XBIDI1
	PORT MAP (Z0 => UQVN_N10, XB0 => XB0, A0 => UQVN_N9, OE => OE);
UQVB_B16 : XDL1
	PORT MAP (Q0 => Q1, D0 => UQVN_N12, G => G);
UQVB_B17 : XINV
	PORT MAP (ZN0 => UQVN_N11, A0 => A1);
UQVB_B18 : XBIDI1
	PORT MAP (Z0 => UQVN_N12, XB0 => XB1, A0 => UQVN_N11, OE => OE);
UQVB_B19 : XDL1
	PORT MAP (Q0 => Q3, D0 => UQVN_N14, G => G);
UQVB_B20 : XINV
	PORT MAP (ZN0 => UQVN_N13, A0 => A3);
UQVB_B21 : XBIDI1
	PORT MAP (Z0 => UQVN_N14, XB0 => XB3, A0 => UQVN_N13, OE => OE);
UQVB_B22 : XDL1
	PORT MAP (Q0 => Q2, D0 => UQVN_N16, G => G);
UQVB_B23 : XINV
	PORT MAP (ZN0 => UQVN_N15, A0 => A2);
UQVB_B24 : XBIDI1
	PORT MAP (Z0 => UQVN_N16, XB0 => XB2, A0 => UQVN_N15, OE => OE);
END lattice_arch;
-- VHDL netlist for BIIL31
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIIL31 IS 
    PORT (
        A0 : IN std_logic;
        G : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
END BIIL31;


ARCHITECTURE lattice_arch OF BIIL31 IS
SIGNAL  UQVN_N1, UQVN_N2 : std_logic;


  COMPONENT XDL1
    PORT (
        D0 : IN std_logic;
        G : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDL1 use  entity  lattice.XDL1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDL1
	PORT MAP (Q0 => Q0, D0 => UQVN_N1, G => G);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N2, A0 => OE);
UQVB_B3 : XBIDI1
	PORT MAP (Z0 => UQVN_N1, XB0 => XB0, A0 => A0, OE => UQVN_N2);
END lattice_arch;
-- VHDL netlist for BIIL34
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIIL34 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        G : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic
    );
END BIIL34;


ARCHITECTURE lattice_arch OF BIIL34 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8 : std_logic;


  COMPONENT XDL1
    PORT (
        D0 : IN std_logic;
        G : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDL1 use  entity  lattice.XDL1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDL1
	PORT MAP (Q0 => Q3, D0 => UQVN_N1, G => G);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N2, A0 => OE);
UQVB_B3 : XBIDI1
	PORT MAP (Z0 => UQVN_N1, XB0 => XB3, A0 => A3, OE => UQVN_N2);
UQVB_B4 : XDL1
	PORT MAP (Q0 => Q2, D0 => UQVN_N3, G => G);
UQVB_B5 : XINV
	PORT MAP (ZN0 => UQVN_N4, A0 => OE);
UQVB_B6 : XBIDI1
	PORT MAP (Z0 => UQVN_N3, XB0 => XB2, A0 => A2, OE => UQVN_N4);
UQVB_B7 : XDL1
	PORT MAP (Q0 => Q1, D0 => UQVN_N5, G => G);
UQVB_B8 : XINV
	PORT MAP (ZN0 => UQVN_N6, A0 => OE);
UQVB_B9 : XBIDI1
	PORT MAP (Z0 => UQVN_N5, XB0 => XB1, A0 => A1, OE => UQVN_N6);
UQVB_B10 : XDL1
	PORT MAP (Q0 => Q0, D0 => UQVN_N7, G => G);
UQVB_B11 : XINV
	PORT MAP (ZN0 => UQVN_N8, A0 => OE);
UQVB_B12 : XBIDI1
	PORT MAP (Z0 => UQVN_N7, XB0 => XB0, A0 => A0, OE => UQVN_N8);
END lattice_arch;
-- VHDL netlist for BIIL38
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIIL38 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        G : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        Q4 : OUT std_logic;
        Q5 : OUT std_logic;
        Q6 : OUT std_logic;
        Q7 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic;
        XB4 : INOUT std_logic;
        XB5 : INOUT std_logic;
        XB6 : INOUT std_logic;
        XB7 : INOUT std_logic
    );
END BIIL38;


ARCHITECTURE lattice_arch OF BIIL38 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16 : std_logic;


  COMPONENT XDL1
    PORT (
        D0 : IN std_logic;
        G : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDL1 use  entity  lattice.XDL1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDL1
	PORT MAP (Q0 => Q7, D0 => UQVN_N1, G => G);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N2, A0 => OE);
UQVB_B3 : XBIDI1
	PORT MAP (Z0 => UQVN_N1, XB0 => XB7, A0 => A7, OE => UQVN_N2);
UQVB_B4 : XDL1
	PORT MAP (Q0 => Q6, D0 => UQVN_N3, G => G);
UQVB_B5 : XINV
	PORT MAP (ZN0 => UQVN_N4, A0 => OE);
UQVB_B6 : XBIDI1
	PORT MAP (Z0 => UQVN_N3, XB0 => XB6, A0 => A6, OE => UQVN_N4);
UQVB_B7 : XDL1
	PORT MAP (Q0 => Q5, D0 => UQVN_N5, G => G);
UQVB_B8 : XINV
	PORT MAP (ZN0 => UQVN_N6, A0 => OE);
UQVB_B9 : XBIDI1
	PORT MAP (Z0 => UQVN_N5, XB0 => XB5, A0 => A5, OE => UQVN_N6);
UQVB_B10 : XDL1
	PORT MAP (Q0 => Q4, D0 => UQVN_N7, G => G);
UQVB_B11 : XINV
	PORT MAP (ZN0 => UQVN_N8, A0 => OE);
UQVB_B12 : XBIDI1
	PORT MAP (Z0 => UQVN_N7, XB0 => XB4, A0 => A4, OE => UQVN_N8);
UQVB_B13 : XDL1
	PORT MAP (Q0 => Q0, D0 => UQVN_N9, G => G);
UQVB_B14 : XINV
	PORT MAP (ZN0 => UQVN_N10, A0 => OE);
UQVB_B15 : XBIDI1
	PORT MAP (Z0 => UQVN_N9, XB0 => XB0, A0 => A0, OE => UQVN_N10);
UQVB_B16 : XDL1
	PORT MAP (Q0 => Q1, D0 => UQVN_N11, G => G);
UQVB_B17 : XINV
	PORT MAP (ZN0 => UQVN_N12, A0 => OE);
UQVB_B18 : XBIDI1
	PORT MAP (Z0 => UQVN_N11, XB0 => XB1, A0 => A1, OE => UQVN_N12);
UQVB_B19 : XDL1
	PORT MAP (Q0 => Q3, D0 => UQVN_N13, G => G);
UQVB_B20 : XINV
	PORT MAP (ZN0 => UQVN_N14, A0 => OE);
UQVB_B21 : XBIDI1
	PORT MAP (Z0 => UQVN_N13, XB0 => XB3, A0 => A3, OE => UQVN_N14);
UQVB_B22 : XDL1
	PORT MAP (Q0 => Q2, D0 => UQVN_N15, G => G);
UQVB_B23 : XINV
	PORT MAP (ZN0 => UQVN_N16, A0 => OE);
UQVB_B24 : XBIDI1
	PORT MAP (Z0 => UQVN_N15, XB0 => XB2, A0 => A2, OE => UQVN_N16);
END lattice_arch;
-- VHDL netlist for BIIL41
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIIL41 IS 
    PORT (
        A0 : IN std_logic;
        G : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
END BIIL41;


ARCHITECTURE lattice_arch OF BIIL41 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3 : std_logic;


  COMPONENT XDL1
    PORT (
        D0 : IN std_logic;
        G : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDL1 use  entity  lattice.XDL1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDL1
	PORT MAP (Q0 => Q0, D0 => UQVN_N2, G => G);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => A0);
UQVB_B3 : XINV
	PORT MAP (ZN0 => UQVN_N3, A0 => OE);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => UQVN_N2, XB0 => XB0, A0 => UQVN_N1, OE => UQVN_N3);
END lattice_arch;
-- VHDL netlist for BIIL44
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIIL44 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        G : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic
    );
END BIIL44;


ARCHITECTURE lattice_arch OF BIIL44 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12 : std_logic;


  COMPONENT XDL1
    PORT (
        D0 : IN std_logic;
        G : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDL1 use  entity  lattice.XDL1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDL1
	PORT MAP (Q0 => Q3, D0 => UQVN_N2, G => G);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => A3);
UQVB_B3 : XINV
	PORT MAP (ZN0 => UQVN_N3, A0 => OE);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => UQVN_N2, XB0 => XB3, A0 => UQVN_N1, OE => UQVN_N3);
UQVB_B5 : XDL1
	PORT MAP (Q0 => Q2, D0 => UQVN_N5, G => G);
UQVB_B6 : XINV
	PORT MAP (ZN0 => UQVN_N4, A0 => A2);
UQVB_B7 : XINV
	PORT MAP (ZN0 => UQVN_N6, A0 => OE);
UQVB_B8 : XBIDI1
	PORT MAP (Z0 => UQVN_N5, XB0 => XB2, A0 => UQVN_N4, OE => UQVN_N6);
UQVB_B9 : XDL1
	PORT MAP (Q0 => Q1, D0 => UQVN_N8, G => G);
UQVB_B10 : XINV
	PORT MAP (ZN0 => UQVN_N7, A0 => A1);
UQVB_B11 : XINV
	PORT MAP (ZN0 => UQVN_N9, A0 => OE);
UQVB_B12 : XBIDI1
	PORT MAP (Z0 => UQVN_N8, XB0 => XB1, A0 => UQVN_N7, OE => UQVN_N9);
UQVB_B13 : XDL1
	PORT MAP (Q0 => Q0, D0 => UQVN_N11, G => G);
UQVB_B14 : XINV
	PORT MAP (ZN0 => UQVN_N10, A0 => A0);
UQVB_B15 : XINV
	PORT MAP (ZN0 => UQVN_N12, A0 => OE);
UQVB_B16 : XBIDI1
	PORT MAP (Z0 => UQVN_N11, XB0 => XB0, A0 => UQVN_N10, OE => UQVN_N12);
END lattice_arch;
-- VHDL netlist for BIIL48
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIIL48 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        G : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        Q4 : OUT std_logic;
        Q5 : OUT std_logic;
        Q6 : OUT std_logic;
        Q7 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic;
        XB4 : INOUT std_logic;
        XB5 : INOUT std_logic;
        XB6 : INOUT std_logic;
        XB7 : INOUT std_logic
    );
END BIIL48;


ARCHITECTURE lattice_arch OF BIIL48 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, UQVN_N23, UQVN_N24 : std_logic;


  COMPONENT XDL1
    PORT (
        D0 : IN std_logic;
        G : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDL1 use  entity  lattice.XDL1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDL1
	PORT MAP (Q0 => Q7, D0 => UQVN_N2, G => G);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => A7);
UQVB_B3 : XINV
	PORT MAP (ZN0 => UQVN_N3, A0 => OE);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => UQVN_N2, XB0 => XB7, A0 => UQVN_N1, OE => UQVN_N3);
UQVB_B5 : XDL1
	PORT MAP (Q0 => Q6, D0 => UQVN_N5, G => G);
UQVB_B6 : XINV
	PORT MAP (ZN0 => UQVN_N4, A0 => A6);
UQVB_B7 : XINV
	PORT MAP (ZN0 => UQVN_N6, A0 => OE);
UQVB_B8 : XBIDI1
	PORT MAP (Z0 => UQVN_N5, XB0 => XB6, A0 => UQVN_N4, OE => UQVN_N6);
UQVB_B9 : XDL1
	PORT MAP (Q0 => Q5, D0 => UQVN_N8, G => G);
UQVB_B10 : XINV
	PORT MAP (ZN0 => UQVN_N7, A0 => A5);
UQVB_B11 : XINV
	PORT MAP (ZN0 => UQVN_N9, A0 => OE);
UQVB_B12 : XBIDI1
	PORT MAP (Z0 => UQVN_N8, XB0 => XB5, A0 => UQVN_N7, OE => UQVN_N9);
UQVB_B13 : XDL1
	PORT MAP (Q0 => Q4, D0 => UQVN_N11, G => G);
UQVB_B14 : XINV
	PORT MAP (ZN0 => UQVN_N10, A0 => A4);
UQVB_B15 : XINV
	PORT MAP (ZN0 => UQVN_N12, A0 => OE);
UQVB_B16 : XBIDI1
	PORT MAP (Z0 => UQVN_N11, XB0 => XB4, A0 => UQVN_N10, OE => UQVN_N12);
UQVB_B17 : XDL1
	PORT MAP (Q0 => Q0, D0 => UQVN_N14, G => G);
UQVB_B18 : XINV
	PORT MAP (ZN0 => UQVN_N13, A0 => A0);
UQVB_B19 : XINV
	PORT MAP (ZN0 => UQVN_N15, A0 => OE);
UQVB_B20 : XBIDI1
	PORT MAP (Z0 => UQVN_N14, XB0 => XB0, A0 => UQVN_N13, OE => UQVN_N15);
UQVB_B21 : XDL1
	PORT MAP (Q0 => Q1, D0 => UQVN_N17, G => G);
UQVB_B22 : XINV
	PORT MAP (ZN0 => UQVN_N16, A0 => A1);
UQVB_B23 : XINV
	PORT MAP (ZN0 => UQVN_N18, A0 => OE);
UQVB_B24 : XBIDI1
	PORT MAP (Z0 => UQVN_N17, XB0 => XB1, A0 => UQVN_N16, OE => UQVN_N18);
UQVB_B25 : XDL1
	PORT MAP (Q0 => Q3, D0 => UQVN_N20, G => G);
UQVB_B26 : XINV
	PORT MAP (ZN0 => UQVN_N19, A0 => A3);
UQVB_B27 : XINV
	PORT MAP (ZN0 => UQVN_N21, A0 => OE);
UQVB_B28 : XBIDI1
	PORT MAP (Z0 => UQVN_N20, XB0 => XB3, A0 => UQVN_N19, OE => UQVN_N21);
UQVB_B29 : XDL1
	PORT MAP (Q0 => Q2, D0 => UQVN_N23, G => G);
UQVB_B30 : XINV
	PORT MAP (ZN0 => UQVN_N22, A0 => A2);
UQVB_B31 : XINV
	PORT MAP (ZN0 => UQVN_N24, A0 => OE);
UQVB_B32 : XBIDI1
	PORT MAP (Z0 => UQVN_N23, XB0 => XB2, A0 => UQVN_N22, OE => UQVN_N24);
END lattice_arch;
-- VHDL netlist for BIIL51
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIIL51 IS 
    PORT (
        A0 : IN std_logic;
        G : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
END BIIL51;


ARCHITECTURE lattice_arch OF BIIL51 IS
SIGNAL  UQVN_N1, UQVN_N2 : std_logic;


  COMPONENT XDL1
    PORT (
        D0 : IN std_logic;
        G : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDL1 use  entity  lattice.XDL1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDL1
	PORT MAP (Q0 => Q0, D0 => UQVN_N2, G => UQVN_N1);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => G);
UQVB_B3 : XBIDI1
	PORT MAP (Z0 => UQVN_N2, XB0 => XB0, A0 => A0, OE => OE);
END lattice_arch;
-- VHDL netlist for BIIL54
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIIL54 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        G : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic
    );
END BIIL54;


ARCHITECTURE lattice_arch OF BIIL54 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8 : std_logic;


  COMPONENT XDL1
    PORT (
        D0 : IN std_logic;
        G : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDL1 use  entity  lattice.XDL1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDL1
	PORT MAP (Q0 => Q3, D0 => UQVN_N2, G => UQVN_N1);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => G);
UQVB_B3 : XBIDI1
	PORT MAP (Z0 => UQVN_N2, XB0 => XB3, A0 => A3, OE => OE);
UQVB_B4 : XDL1
	PORT MAP (Q0 => Q2, D0 => UQVN_N4, G => UQVN_N3);
UQVB_B5 : XINV
	PORT MAP (ZN0 => UQVN_N3, A0 => G);
UQVB_B6 : XBIDI1
	PORT MAP (Z0 => UQVN_N4, XB0 => XB2, A0 => A2, OE => OE);
UQVB_B7 : XDL1
	PORT MAP (Q0 => Q1, D0 => UQVN_N6, G => UQVN_N5);
UQVB_B8 : XINV
	PORT MAP (ZN0 => UQVN_N5, A0 => G);
UQVB_B9 : XBIDI1
	PORT MAP (Z0 => UQVN_N6, XB0 => XB1, A0 => A1, OE => OE);
UQVB_B10 : XDL1
	PORT MAP (Q0 => Q0, D0 => UQVN_N8, G => UQVN_N7);
UQVB_B11 : XINV
	PORT MAP (ZN0 => UQVN_N7, A0 => G);
UQVB_B12 : XBIDI1
	PORT MAP (Z0 => UQVN_N8, XB0 => XB0, A0 => A0, OE => OE);
END lattice_arch;
-- VHDL netlist for BIIL58
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIIL58 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        G : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        Q4 : OUT std_logic;
        Q5 : OUT std_logic;
        Q6 : OUT std_logic;
        Q7 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic;
        XB4 : INOUT std_logic;
        XB5 : INOUT std_logic;
        XB6 : INOUT std_logic;
        XB7 : INOUT std_logic
    );
END BIIL58;


ARCHITECTURE lattice_arch OF BIIL58 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16 : std_logic;


  COMPONENT XDL1
    PORT (
        D0 : IN std_logic;
        G : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDL1 use  entity  lattice.XDL1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDL1
	PORT MAP (Q0 => Q7, D0 => UQVN_N2, G => UQVN_N1);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => G);
UQVB_B3 : XBIDI1
	PORT MAP (Z0 => UQVN_N2, XB0 => XB7, A0 => A7, OE => OE);
UQVB_B4 : XDL1
	PORT MAP (Q0 => Q6, D0 => UQVN_N4, G => UQVN_N3);
UQVB_B5 : XINV
	PORT MAP (ZN0 => UQVN_N3, A0 => G);
UQVB_B6 : XBIDI1
	PORT MAP (Z0 => UQVN_N4, XB0 => XB6, A0 => A6, OE => OE);
UQVB_B7 : XDL1
	PORT MAP (Q0 => Q5, D0 => UQVN_N6, G => UQVN_N5);
UQVB_B8 : XINV
	PORT MAP (ZN0 => UQVN_N5, A0 => G);
UQVB_B9 : XBIDI1
	PORT MAP (Z0 => UQVN_N6, XB0 => XB5, A0 => A5, OE => OE);
UQVB_B10 : XDL1
	PORT MAP (Q0 => Q4, D0 => UQVN_N8, G => UQVN_N7);
UQVB_B11 : XINV
	PORT MAP (ZN0 => UQVN_N7, A0 => G);
UQVB_B12 : XBIDI1
	PORT MAP (Z0 => UQVN_N8, XB0 => XB4, A0 => A4, OE => OE);
UQVB_B13 : XDL1
	PORT MAP (Q0 => Q0, D0 => UQVN_N10, G => UQVN_N9);
UQVB_B14 : XINV
	PORT MAP (ZN0 => UQVN_N9, A0 => G);
UQVB_B15 : XBIDI1
	PORT MAP (Z0 => UQVN_N10, XB0 => XB0, A0 => A0, OE => OE);
UQVB_B16 : XDL1
	PORT MAP (Q0 => Q1, D0 => UQVN_N12, G => UQVN_N11);
UQVB_B17 : XINV
	PORT MAP (ZN0 => UQVN_N11, A0 => G);
UQVB_B18 : XBIDI1
	PORT MAP (Z0 => UQVN_N12, XB0 => XB1, A0 => A1, OE => OE);
UQVB_B19 : XDL1
	PORT MAP (Q0 => Q3, D0 => UQVN_N14, G => UQVN_N13);
UQVB_B20 : XINV
	PORT MAP (ZN0 => UQVN_N13, A0 => G);
UQVB_B21 : XBIDI1
	PORT MAP (Z0 => UQVN_N14, XB0 => XB3, A0 => A3, OE => OE);
UQVB_B22 : XDL1
	PORT MAP (Q0 => Q2, D0 => UQVN_N16, G => UQVN_N15);
UQVB_B23 : XINV
	PORT MAP (ZN0 => UQVN_N15, A0 => G);
UQVB_B24 : XBIDI1
	PORT MAP (Z0 => UQVN_N16, XB0 => XB2, A0 => A2, OE => OE);
END lattice_arch;
-- VHDL netlist for BIIL61
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIIL61 IS 
    PORT (
        A0 : IN std_logic;
        G : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
END BIIL61;


ARCHITECTURE lattice_arch OF BIIL61 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3 : std_logic;


  COMPONENT XDL1
    PORT (
        D0 : IN std_logic;
        G : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDL1 use  entity  lattice.XDL1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDL1
	PORT MAP (Q0 => Q0, D0 => UQVN_N3, G => UQVN_N2);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => A0);
UQVB_B3 : XINV
	PORT MAP (ZN0 => UQVN_N2, A0 => G);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => UQVN_N3, XB0 => XB0, A0 => UQVN_N1, OE => OE);
END lattice_arch;
-- VHDL netlist for BIIL64
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIIL64 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        G : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic
    );
END BIIL64;


ARCHITECTURE lattice_arch OF BIIL64 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12 : std_logic;


  COMPONENT XDL1
    PORT (
        D0 : IN std_logic;
        G : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDL1 use  entity  lattice.XDL1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDL1
	PORT MAP (Q0 => Q3, D0 => UQVN_N3, G => UQVN_N2);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => A3);
UQVB_B3 : XINV
	PORT MAP (ZN0 => UQVN_N2, A0 => G);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => UQVN_N3, XB0 => XB3, A0 => UQVN_N1, OE => OE);
UQVB_B5 : XDL1
	PORT MAP (Q0 => Q2, D0 => UQVN_N6, G => UQVN_N5);
UQVB_B6 : XINV
	PORT MAP (ZN0 => UQVN_N4, A0 => A2);
UQVB_B7 : XINV
	PORT MAP (ZN0 => UQVN_N5, A0 => G);
UQVB_B8 : XBIDI1
	PORT MAP (Z0 => UQVN_N6, XB0 => XB2, A0 => UQVN_N4, OE => OE);
UQVB_B9 : XDL1
	PORT MAP (Q0 => Q1, D0 => UQVN_N9, G => UQVN_N8);
UQVB_B10 : XINV
	PORT MAP (ZN0 => UQVN_N7, A0 => A1);
UQVB_B11 : XINV
	PORT MAP (ZN0 => UQVN_N8, A0 => G);
UQVB_B12 : XBIDI1
	PORT MAP (Z0 => UQVN_N9, XB0 => XB1, A0 => UQVN_N7, OE => OE);
UQVB_B13 : XDL1
	PORT MAP (Q0 => Q0, D0 => UQVN_N12, G => UQVN_N11);
UQVB_B14 : XINV
	PORT MAP (ZN0 => UQVN_N10, A0 => A0);
UQVB_B15 : XINV
	PORT MAP (ZN0 => UQVN_N11, A0 => G);
UQVB_B16 : XBIDI1
	PORT MAP (Z0 => UQVN_N12, XB0 => XB0, A0 => UQVN_N10, OE => OE);
END lattice_arch;
-- VHDL netlist for BIIL68
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIIL68 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        G : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        Q4 : OUT std_logic;
        Q5 : OUT std_logic;
        Q6 : OUT std_logic;
        Q7 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic;
        XB4 : INOUT std_logic;
        XB5 : INOUT std_logic;
        XB6 : INOUT std_logic;
        XB7 : INOUT std_logic
    );
END BIIL68;


ARCHITECTURE lattice_arch OF BIIL68 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, UQVN_N23, UQVN_N24 : std_logic;


  COMPONENT XDL1
    PORT (
        D0 : IN std_logic;
        G : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDL1 use  entity  lattice.XDL1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDL1
	PORT MAP (Q0 => Q7, D0 => UQVN_N3, G => UQVN_N2);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => A7);
UQVB_B3 : XINV
	PORT MAP (ZN0 => UQVN_N2, A0 => G);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => UQVN_N3, XB0 => XB7, A0 => UQVN_N1, OE => OE);
UQVB_B5 : XDL1
	PORT MAP (Q0 => Q6, D0 => UQVN_N6, G => UQVN_N5);
UQVB_B6 : XINV
	PORT MAP (ZN0 => UQVN_N4, A0 => A6);
UQVB_B7 : XINV
	PORT MAP (ZN0 => UQVN_N5, A0 => G);
UQVB_B8 : XBIDI1
	PORT MAP (Z0 => UQVN_N6, XB0 => XB6, A0 => UQVN_N4, OE => OE);
UQVB_B9 : XDL1
	PORT MAP (Q0 => Q5, D0 => UQVN_N9, G => UQVN_N8);
UQVB_B10 : XINV
	PORT MAP (ZN0 => UQVN_N7, A0 => A5);
UQVB_B11 : XINV
	PORT MAP (ZN0 => UQVN_N8, A0 => G);
UQVB_B12 : XBIDI1
	PORT MAP (Z0 => UQVN_N9, XB0 => XB5, A0 => UQVN_N7, OE => OE);
UQVB_B13 : XDL1
	PORT MAP (Q0 => Q4, D0 => UQVN_N12, G => UQVN_N11);
UQVB_B14 : XINV
	PORT MAP (ZN0 => UQVN_N10, A0 => A4);
UQVB_B15 : XINV
	PORT MAP (ZN0 => UQVN_N11, A0 => G);
UQVB_B16 : XBIDI1
	PORT MAP (Z0 => UQVN_N12, XB0 => XB4, A0 => UQVN_N10, OE => OE);
UQVB_B17 : XDL1
	PORT MAP (Q0 => Q0, D0 => UQVN_N15, G => UQVN_N14);
UQVB_B18 : XINV
	PORT MAP (ZN0 => UQVN_N13, A0 => A0);
UQVB_B19 : XINV
	PORT MAP (ZN0 => UQVN_N14, A0 => G);
UQVB_B20 : XBIDI1
	PORT MAP (Z0 => UQVN_N15, XB0 => XB0, A0 => UQVN_N13, OE => OE);
UQVB_B21 : XDL1
	PORT MAP (Q0 => Q1, D0 => UQVN_N18, G => UQVN_N17);
UQVB_B22 : XINV
	PORT MAP (ZN0 => UQVN_N16, A0 => A1);
UQVB_B23 : XINV
	PORT MAP (ZN0 => UQVN_N17, A0 => G);
UQVB_B24 : XBIDI1
	PORT MAP (Z0 => UQVN_N18, XB0 => XB1, A0 => UQVN_N16, OE => OE);
UQVB_B25 : XDL1
	PORT MAP (Q0 => Q3, D0 => UQVN_N21, G => UQVN_N20);
UQVB_B26 : XINV
	PORT MAP (ZN0 => UQVN_N19, A0 => A3);
UQVB_B27 : XINV
	PORT MAP (ZN0 => UQVN_N20, A0 => G);
UQVB_B28 : XBIDI1
	PORT MAP (Z0 => UQVN_N21, XB0 => XB3, A0 => UQVN_N19, OE => OE);
UQVB_B29 : XDL1
	PORT MAP (Q0 => Q2, D0 => UQVN_N24, G => UQVN_N23);
UQVB_B30 : XINV
	PORT MAP (ZN0 => UQVN_N22, A0 => A2);
UQVB_B31 : XINV
	PORT MAP (ZN0 => UQVN_N23, A0 => G);
UQVB_B32 : XBIDI1
	PORT MAP (Z0 => UQVN_N24, XB0 => XB2, A0 => UQVN_N22, OE => OE);
END lattice_arch;
-- VHDL netlist for BIIL71
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIIL71 IS 
    PORT (
        A0 : IN std_logic;
        G : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
END BIIL71;


ARCHITECTURE lattice_arch OF BIIL71 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3 : std_logic;


  COMPONENT XDL1
    PORT (
        D0 : IN std_logic;
        G : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDL1 use  entity  lattice.XDL1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDL1
	PORT MAP (Q0 => Q0, D0 => UQVN_N2, G => UQVN_N1);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N3, A0 => OE);
UQVB_B3 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => G);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => UQVN_N2, XB0 => XB0, A0 => A0, OE => UQVN_N3);
END lattice_arch;
-- VHDL netlist for BIIL74
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIIL74 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        G : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic
    );
END BIIL74;


ARCHITECTURE lattice_arch OF BIIL74 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12 : std_logic;


  COMPONENT XDL1
    PORT (
        D0 : IN std_logic;
        G : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDL1 use  entity  lattice.XDL1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDL1
	PORT MAP (Q0 => Q3, D0 => UQVN_N2, G => UQVN_N1);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N3, A0 => OE);
UQVB_B3 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => G);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => UQVN_N2, XB0 => XB3, A0 => A3, OE => UQVN_N3);
UQVB_B5 : XDL1
	PORT MAP (Q0 => Q2, D0 => UQVN_N5, G => UQVN_N4);
UQVB_B6 : XINV
	PORT MAP (ZN0 => UQVN_N6, A0 => OE);
UQVB_B7 : XINV
	PORT MAP (ZN0 => UQVN_N4, A0 => G);
UQVB_B8 : XBIDI1
	PORT MAP (Z0 => UQVN_N5, XB0 => XB2, A0 => A2, OE => UQVN_N6);
UQVB_B9 : XDL1
	PORT MAP (Q0 => Q1, D0 => UQVN_N8, G => UQVN_N7);
UQVB_B10 : XINV
	PORT MAP (ZN0 => UQVN_N9, A0 => OE);
UQVB_B11 : XINV
	PORT MAP (ZN0 => UQVN_N7, A0 => G);
UQVB_B12 : XBIDI1
	PORT MAP (Z0 => UQVN_N8, XB0 => XB1, A0 => A1, OE => UQVN_N9);
UQVB_B13 : XDL1
	PORT MAP (Q0 => Q0, D0 => UQVN_N11, G => UQVN_N10);
UQVB_B14 : XINV
	PORT MAP (ZN0 => UQVN_N12, A0 => OE);
UQVB_B15 : XINV
	PORT MAP (ZN0 => UQVN_N10, A0 => G);
UQVB_B16 : XBIDI1
	PORT MAP (Z0 => UQVN_N11, XB0 => XB0, A0 => A0, OE => UQVN_N12);
END lattice_arch;
-- VHDL netlist for BIIL78
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIIL78 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        G : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        Q4 : OUT std_logic;
        Q5 : OUT std_logic;
        Q6 : OUT std_logic;
        Q7 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic;
        XB4 : INOUT std_logic;
        XB5 : INOUT std_logic;
        XB6 : INOUT std_logic;
        XB7 : INOUT std_logic
    );
END BIIL78;


ARCHITECTURE lattice_arch OF BIIL78 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, UQVN_N23, UQVN_N24 : std_logic;


  COMPONENT XDL1
    PORT (
        D0 : IN std_logic;
        G : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDL1 use  entity  lattice.XDL1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDL1
	PORT MAP (Q0 => Q7, D0 => UQVN_N2, G => UQVN_N1);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N3, A0 => OE);
UQVB_B3 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => G);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => UQVN_N2, XB0 => XB7, A0 => A7, OE => UQVN_N3);
UQVB_B5 : XDL1
	PORT MAP (Q0 => Q6, D0 => UQVN_N5, G => UQVN_N4);
UQVB_B6 : XINV
	PORT MAP (ZN0 => UQVN_N6, A0 => OE);
UQVB_B7 : XINV
	PORT MAP (ZN0 => UQVN_N4, A0 => G);
UQVB_B8 : XBIDI1
	PORT MAP (Z0 => UQVN_N5, XB0 => XB6, A0 => A6, OE => UQVN_N6);
UQVB_B9 : XDL1
	PORT MAP (Q0 => Q5, D0 => UQVN_N8, G => UQVN_N7);
UQVB_B10 : XINV
	PORT MAP (ZN0 => UQVN_N9, A0 => OE);
UQVB_B11 : XINV
	PORT MAP (ZN0 => UQVN_N7, A0 => G);
UQVB_B12 : XBIDI1
	PORT MAP (Z0 => UQVN_N8, XB0 => XB5, A0 => A5, OE => UQVN_N9);
UQVB_B13 : XDL1
	PORT MAP (Q0 => Q4, D0 => UQVN_N11, G => UQVN_N10);
UQVB_B14 : XINV
	PORT MAP (ZN0 => UQVN_N12, A0 => OE);
UQVB_B15 : XINV
	PORT MAP (ZN0 => UQVN_N10, A0 => G);
UQVB_B16 : XBIDI1
	PORT MAP (Z0 => UQVN_N11, XB0 => XB4, A0 => A4, OE => UQVN_N12);
UQVB_B17 : XDL1
	PORT MAP (Q0 => Q0, D0 => UQVN_N14, G => UQVN_N13);
UQVB_B18 : XINV
	PORT MAP (ZN0 => UQVN_N15, A0 => OE);
UQVB_B19 : XINV
	PORT MAP (ZN0 => UQVN_N13, A0 => G);
UQVB_B20 : XBIDI1
	PORT MAP (Z0 => UQVN_N14, XB0 => XB0, A0 => A0, OE => UQVN_N15);
UQVB_B21 : XDL1
	PORT MAP (Q0 => Q1, D0 => UQVN_N17, G => UQVN_N16);
UQVB_B22 : XINV
	PORT MAP (ZN0 => UQVN_N18, A0 => OE);
UQVB_B23 : XINV
	PORT MAP (ZN0 => UQVN_N16, A0 => G);
UQVB_B24 : XBIDI1
	PORT MAP (Z0 => UQVN_N17, XB0 => XB1, A0 => A1, OE => UQVN_N18);
UQVB_B25 : XDL1
	PORT MAP (Q0 => Q3, D0 => UQVN_N20, G => UQVN_N19);
UQVB_B26 : XINV
	PORT MAP (ZN0 => UQVN_N21, A0 => OE);
UQVB_B27 : XINV
	PORT MAP (ZN0 => UQVN_N19, A0 => G);
UQVB_B28 : XBIDI1
	PORT MAP (Z0 => UQVN_N20, XB0 => XB3, A0 => A3, OE => UQVN_N21);
UQVB_B29 : XDL1
	PORT MAP (Q0 => Q2, D0 => UQVN_N23, G => UQVN_N22);
UQVB_B30 : XINV
	PORT MAP (ZN0 => UQVN_N24, A0 => OE);
UQVB_B31 : XINV
	PORT MAP (ZN0 => UQVN_N22, A0 => G);
UQVB_B32 : XBIDI1
	PORT MAP (Z0 => UQVN_N23, XB0 => XB2, A0 => A2, OE => UQVN_N24);
END lattice_arch;
-- VHDL netlist for BIIL81
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIIL81 IS 
    PORT (
        A0 : IN std_logic;
        G : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
END BIIL81;


ARCHITECTURE lattice_arch OF BIIL81 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4 : std_logic;


  COMPONENT XDL1
    PORT (
        D0 : IN std_logic;
        G : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDL1 use  entity  lattice.XDL1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDL1
	PORT MAP (Q0 => Q0, D0 => UQVN_N3, G => UQVN_N2);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => A0);
UQVB_B3 : XINV
	PORT MAP (ZN0 => UQVN_N2, A0 => G);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => UQVN_N3, XB0 => XB0, A0 => UQVN_N1, OE => UQVN_N4);
UQVB_B5 : XINV
	PORT MAP (ZN0 => UQVN_N4, A0 => OE);
END lattice_arch;
-- VHDL netlist for BIIL84
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIIL84 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        G : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic
    );
END BIIL84;


ARCHITECTURE lattice_arch OF BIIL84 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16 : std_logic;


  COMPONENT XDL1
    PORT (
        D0 : IN std_logic;
        G : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDL1 use  entity  lattice.XDL1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDL1
	PORT MAP (Q0 => Q3, D0 => UQVN_N3, G => UQVN_N2);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => A3);
UQVB_B3 : XINV
	PORT MAP (ZN0 => UQVN_N2, A0 => G);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => UQVN_N3, XB0 => XB3, A0 => UQVN_N1, OE => UQVN_N4);
UQVB_B5 : XINV
	PORT MAP (ZN0 => UQVN_N4, A0 => OE);
UQVB_B6 : XDL1
	PORT MAP (Q0 => Q2, D0 => UQVN_N7, G => UQVN_N6);
UQVB_B7 : XINV
	PORT MAP (ZN0 => UQVN_N5, A0 => A2);
UQVB_B8 : XINV
	PORT MAP (ZN0 => UQVN_N6, A0 => G);
UQVB_B9 : XBIDI1
	PORT MAP (Z0 => UQVN_N7, XB0 => XB2, A0 => UQVN_N5, OE => UQVN_N8);
UQVB_B10 : XINV
	PORT MAP (ZN0 => UQVN_N8, A0 => OE);
UQVB_B11 : XDL1
	PORT MAP (Q0 => Q1, D0 => UQVN_N11, G => UQVN_N10);
UQVB_B12 : XINV
	PORT MAP (ZN0 => UQVN_N9, A0 => A1);
UQVB_B13 : XINV
	PORT MAP (ZN0 => UQVN_N10, A0 => G);
UQVB_B14 : XBIDI1
	PORT MAP (Z0 => UQVN_N11, XB0 => XB1, A0 => UQVN_N9, OE => UQVN_N12);
UQVB_B15 : XINV
	PORT MAP (ZN0 => UQVN_N12, A0 => OE);
UQVB_B16 : XDL1
	PORT MAP (Q0 => Q0, D0 => UQVN_N15, G => UQVN_N14);
UQVB_B17 : XINV
	PORT MAP (ZN0 => UQVN_N13, A0 => A0);
UQVB_B18 : XINV
	PORT MAP (ZN0 => UQVN_N14, A0 => G);
UQVB_B19 : XBIDI1
	PORT MAP (Z0 => UQVN_N15, XB0 => XB0, A0 => UQVN_N13, OE => UQVN_N16);
UQVB_B20 : XINV
	PORT MAP (ZN0 => UQVN_N16, A0 => OE);
END lattice_arch;
-- VHDL netlist for BIIL88
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIIL88 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        G : IN std_logic;
        OE : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        Q4 : OUT std_logic;
        Q5 : OUT std_logic;
        Q6 : OUT std_logic;
        Q7 : OUT std_logic;
        XB0 : INOUT std_logic;
        XB1 : INOUT std_logic;
        XB2 : INOUT std_logic;
        XB3 : INOUT std_logic;
        XB4 : INOUT std_logic;
        XB5 : INOUT std_logic;
        XB6 : INOUT std_logic;
        XB7 : INOUT std_logic
    );
END BIIL88;


ARCHITECTURE lattice_arch OF BIIL88 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, UQVN_N23, UQVN_N24,
	 UQVN_N25, UQVN_N26, UQVN_N27, UQVN_N28,
	 UQVN_N29, UQVN_N30, UQVN_N31, UQVN_N32 : std_logic;


  COMPONENT XDL1
    PORT (
        D0 : IN std_logic;
        G : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: XDL1 use  entity  lattice.XDL1(lattice_arch);


  COMPONENT XINV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: XINV use  entity  lattice.XINV(lattice_arch);


  COMPONENT XBIDI1
    PORT (
        A0 : IN std_logic;
        OE : IN std_logic;
        Z0 : OUT std_logic;
        XB0 : INOUT std_logic
    );
  END COMPONENT;

for all: XBIDI1 use  entity  lattice.XBIDI1(lattice_arch);


BEGIN

UQVB_B1 : XDL1
	PORT MAP (Q0 => Q7, D0 => UQVN_N3, G => UQVN_N2);
UQVB_B2 : XINV
	PORT MAP (ZN0 => UQVN_N1, A0 => A7);
UQVB_B3 : XINV
	PORT MAP (ZN0 => UQVN_N2, A0 => G);
UQVB_B4 : XBIDI1
	PORT MAP (Z0 => UQVN_N3, XB0 => XB7, A0 => UQVN_N1, OE => UQVN_N4);
UQVB_B5 : XINV
	PORT MAP (ZN0 => UQVN_N4, A0 => OE);
UQVB_B6 : XDL1
	PORT MAP (Q0 => Q6, D0 => UQVN_N7, G => UQVN_N6);
UQVB_B7 : XINV
	PORT MAP (ZN0 => UQVN_N5, A0 => A6);
UQVB_B8 : XINV
	PORT MAP (ZN0 => UQVN_N6, A0 => G);
UQVB_B9 : XBIDI1
	PORT MAP (Z0 => UQVN_N7, XB0 => XB6, A0 => UQVN_N5, OE => UQVN_N8);
UQVB_B10 : XINV
	PORT MAP (ZN0 => UQVN_N8, A0 => OE);
UQVB_B11 : XDL1
	PORT MAP (Q0 => Q5, D0 => UQVN_N11, G => UQVN_N10);
UQVB_B12 : XINV
	PORT MAP (ZN0 => UQVN_N9, A0 => A5);
UQVB_B13 : XINV
	PORT MAP (ZN0 => UQVN_N10, A0 => G);
UQVB_B14 : XBIDI1
	PORT MAP (Z0 => UQVN_N11, XB0 => XB5, A0 => UQVN_N9, OE => UQVN_N12);
UQVB_B15 : XINV
	PORT MAP (ZN0 => UQVN_N12, A0 => OE);
UQVB_B16 : XDL1
	PORT MAP (Q0 => Q4, D0 => UQVN_N15, G => UQVN_N14);
UQVB_B17 : XINV
	PORT MAP (ZN0 => UQVN_N13, A0 => A4);
UQVB_B18 : XINV
	PORT MAP (ZN0 => UQVN_N14, A0 => G);
UQVB_B19 : XBIDI1
	PORT MAP (Z0 => UQVN_N15, XB0 => XB4, A0 => UQVN_N13, OE => UQVN_N16);
UQVB_B20 : XINV
	PORT MAP (ZN0 => UQVN_N16, A0 => OE);
UQVB_B21 : XDL1
	PORT MAP (Q0 => Q0, D0 => UQVN_N19, G => UQVN_N18);
UQVB_B22 : XINV
	PORT MAP (ZN0 => UQVN_N17, A0 => A0);
UQVB_B23 : XINV
	PORT MAP (ZN0 => UQVN_N18, A0 => G);
UQVB_B24 : XBIDI1
	PORT MAP (Z0 => UQVN_N19, XB0 => XB0, A0 => UQVN_N17, OE => UQVN_N20);
UQVB_B25 : XINV
	PORT MAP (ZN0 => UQVN_N20, A0 => OE);
UQVB_B26 : XDL1
	PORT MAP (Q0 => Q1, D0 => UQVN_N23, G => UQVN_N22);
UQVB_B27 : XINV
	PORT MAP (ZN0 => UQVN_N21, A0 => A1);
UQVB_B28 : XINV
	PORT MAP (ZN0 => UQVN_N22, A0 => G);
UQVB_B29 : XBIDI1
	PORT MAP (Z0 => UQVN_N23, XB0 => XB1, A0 => UQVN_N21, OE => UQVN_N24);
UQVB_B30 : XINV
	PORT MAP (ZN0 => UQVN_N24, A0 => OE);
UQVB_B31 : XDL1
	PORT MAP (Q0 => Q3, D0 => UQVN_N27, G => UQVN_N26);
UQVB_B32 : XINV
	PORT MAP (ZN0 => UQVN_N25, A0 => A3);
UQVB_B33 : XINV
	PORT MAP (ZN0 => UQVN_N26, A0 => G);
UQVB_B34 : XBIDI1
	PORT MAP (Z0 => UQVN_N27, XB0 => XB3, A0 => UQVN_N25, OE => UQVN_N28);
UQVB_B35 : XINV
	PORT MAP (ZN0 => UQVN_N28, A0 => OE);
UQVB_B36 : XDL1
	PORT MAP (Q0 => Q2, D0 => UQVN_N31, G => UQVN_N30);
UQVB_B37 : XINV
	PORT MAP (ZN0 => UQVN_N29, A0 => A2);
UQVB_B38 : XINV
	PORT MAP (ZN0 => UQVN_N30, A0 => G);
UQVB_B39 : XBIDI1
	PORT MAP (Z0 => UQVN_N31, XB0 => XB2, A0 => UQVN_N29, OE => UQVN_N32);
UQVB_B40 : XINV
	PORT MAP (ZN0 => UQVN_N32, A0 => OE);
END lattice_arch;
-- VHDL netlist for BIN27
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY BIN27 IS 
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        EN : IN std_logic;
        Z0 : OUT std_logic;
        Z1 : OUT std_logic;
        Z2 : OUT std_logic;
        Z3 : OUT std_logic;
        Z4 : OUT std_logic;
        Z5 : OUT std_logic;
        Z6 : OUT std_logic
    );
END BIN27;


ARCHITECTURE lattice_arch OF BIN27 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, UQVN_N23, UQVN_N24,
	 UQVN_N25, UQVN_N26, UQVN_N27, UQVN_N28,
	 UQVN_N29, UQVN_N30, UQVN_N31, UQVN_N32,
	 UQVN_N33, UQVN_N34, UQVN_N35, UQVN_N36,
	 UQVN_N37, UQVN_N38 : std_logic;


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT OR6
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR6 use  entity  lattice.OR6(lattice_arch);


  COMPONENT OR5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR5 use  entity  lattice.OR5(lattice_arch);


  COMPONENT OR4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR4 use  entity  lattice.OR4(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


BEGIN

UQVB_B1 : INV
	PORT MAP (ZN0 => UQVN_N35, A0 => A0);
UQVB_B2 : INV
	PORT MAP (ZN0 => UQVN_N36, A0 => A1);
UQVB_B3 : INV
	PORT MAP (ZN0 => UQVN_N37, A0 => A2);
UQVB_B4 : AND3
	PORT MAP (Z0 => UQVN_N1, A0 => EN, A1 => A1, A2 => UQVN_N35);
UQVB_B5 : INV
	PORT MAP (ZN0 => UQVN_N38, A0 => A3);
UQVB_B6 : AND3
	PORT MAP (Z0 => UQVN_N14, A0 => EN, A1 => A3, A2 => UQVN_N37);
UQVB_B7 : AND4
	PORT MAP (Z0 => UQVN_N4, A0 => EN, A1 => UQVN_N38, A2 => A2, 
	A3 => A0);
UQVB_B8 : AND3
	PORT MAP (Z0 => UQVN_N3, A0 => EN, A1 => A2, A2 => A1);
UQVB_B9 : AND3
	PORT MAP (Z0 => UQVN_N2, A0 => EN, A1 => UQVN_N38, A2 => A1);
UQVB_B10 : AND4
	PORT MAP (Z0 => UQVN_N5, A0 => EN, A1 => A3, A2 => UQVN_N37, 
	A3 => UQVN_N36);
UQVB_B11 : AND4
	PORT MAP (Z0 => UQVN_N6, A0 => EN, A1 => UQVN_N37, A2 => UQVN_N36, 
	A3 => UQVN_N35);
UQVB_B12 : OR6
	PORT MAP (Z0 => Z0, A0 => UQVN_N1, A1 => UQVN_N2, A2 => UQVN_N3, 
	A3 => UQVN_N4, A4 => UQVN_N5, A5 => UQVN_N6);
UQVB_B13 : AND3
	PORT MAP (Z0 => UQVN_N9, A0 => EN, A1 => UQVN_N38, A2 => UQVN_N37);
UQVB_B14 : AND4
	PORT MAP (Z0 => UQVN_N8, A0 => EN, A1 => UQVN_N38, A2 => A1, 
	A3 => A0);
UQVB_B15 : AND4
	PORT MAP (Z0 => UQVN_N7, A0 => EN, A1 => A3, A2 => UQVN_N36, 
	A3 => A0);
UQVB_B16 : AND4
	PORT MAP (Z0 => UQVN_N10, A0 => EN, A1 => UQVN_N38, A2 => UQVN_N36, 
	A3 => UQVN_N35);
UQVB_B17 : AND4
	PORT MAP (Z0 => UQVN_N11, A0 => EN, A1 => A3, A2 => UQVN_N37, 
	A3 => UQVN_N35);
UQVB_B18 : OR5
	PORT MAP (Z0 => Z1, A0 => UQVN_N9, A1 => UQVN_N8, A2 => UQVN_N7, 
	A3 => UQVN_N10, A4 => UQVN_N11);
UQVB_B19 : AND3
	PORT MAP (Z0 => UQVN_N13, A0 => EN, A1 => UQVN_N36, A2 => A0);
UQVB_B20 : AND3
	PORT MAP (Z0 => UQVN_N12, A0 => EN, A1 => UQVN_N38, A2 => A2);
UQVB_B21 : AND3
	PORT MAP (Z0 => UQVN_N16, A0 => EN, A1 => UQVN_N38, A2 => A0);
UQVB_B22 : AND3
	PORT MAP (Z0 => UQVN_N15, A0 => EN, A1 => UQVN_N38, A2 => UQVN_N36);
UQVB_B23 : OR5
	PORT MAP (Z0 => Z2, A0 => UQVN_N14, A1 => UQVN_N13, A2 => UQVN_N12, 
	A3 => UQVN_N15, A4 => UQVN_N16);
UQVB_B24 : AND3
	PORT MAP (Z0 => UQVN_N19, A0 => EN, A1 => A3, A2 => UQVN_N36);
UQVB_B25 : AND4
	PORT MAP (Z0 => UQVN_N18, A0 => EN, A1 => A2, A2 => UQVN_N36, 
	A3 => A0);
UQVB_B26 : AND4
	PORT MAP (Z0 => UQVN_N17, A0 => EN, A1 => A2, A2 => A1, 
	A3 => UQVN_N35);
UQVB_B27 : AND4
	PORT MAP (Z0 => UQVN_N20, A0 => EN, A1 => UQVN_N37, A2 => A1, 
	A3 => A0);
UQVB_B28 : AND4
	PORT MAP (Z0 => UQVN_N21, A0 => EN, A1 => UQVN_N38, A2 => UQVN_N37, 
	A3 => UQVN_N35);
UQVB_B29 : OR5
	PORT MAP (Z0 => Z3, A0 => UQVN_N19, A1 => UQVN_N18, A2 => UQVN_N17, 
	A3 => UQVN_N20, A4 => UQVN_N21);
UQVB_B30 : AND3
	PORT MAP (Z0 => UQVN_N24, A0 => EN, A1 => A1, A2 => UQVN_N35);
UQVB_B31 : AND3
	PORT MAP (Z0 => UQVN_N23, A0 => EN, A1 => A3, A2 => A2);
UQVB_B32 : AND3
	PORT MAP (Z0 => UQVN_N22, A0 => EN, A1 => A3, A2 => A1);
UQVB_B33 : AND4
	PORT MAP (Z0 => UQVN_N25, A0 => EN, A1 => UQVN_N37, A2 => UQVN_N36, 
	A3 => UQVN_N35);
UQVB_B34 : OR4
	PORT MAP (Z0 => Z4, A0 => UQVN_N24, A1 => UQVN_N23, A2 => UQVN_N22, 
	A3 => UQVN_N25);
UQVB_B35 : AND3
	PORT MAP (Z0 => UQVN_N28, A0 => EN, A1 => A3, A2 => UQVN_N37);
UQVB_B36 : AND3
	PORT MAP (Z0 => UQVN_N27, A0 => EN, A1 => A3, A2 => A1);
UQVB_B37 : AND4
	PORT MAP (Z0 => UQVN_N26, A0 => EN, A1 => UQVN_N38, A2 => A2, 
	A3 => UQVN_N36);
UQVB_B38 : AND4
	PORT MAP (Z0 => UQVN_N29, A0 => EN, A1 => A2, A2 => A1, 
	A3 => UQVN_N35);
UQVB_B39 : AND4
	PORT MAP (Z0 => UQVN_N30, A0 => EN, A1 => UQVN_N37, A2 => UQVN_N36, 
	A3 => UQVN_N35);
UQVB_B40 : OR5
	PORT MAP (Z0 => Z5, A0 => UQVN_N28, A1 => UQVN_N27, A2 => UQVN_N26, 
	A3 => UQVN_N29, A4 => UQVN_N30);
UQVB_B41 : AND3
	PORT MAP (Z0 => UQVN_N33, A0 => EN, A1 => A1, A2 => UQVN_N35);
UQVB_B42 : AND2
	PORT MAP (Z0 => UQVN_N32, A0 => EN, A1 => A3);
UQVB_B43 : AND3
	PORT MAP (Z0 => UQVN_N31, A0 => EN, A1 => A2, A2 => UQVN_N36);
UQVB_B44 : AND4
	PORT MAP (Z0 => UQVN_N34, A0 => EN, A1 => UQVN_N37, A2 => A1, 
	A3 => A0);
UQVB_B45 : OR4
	PORT MAP (Z0 => Z6, A0 => UQVN_N33, A1 => UQVN_N32, A2 => UQVN_N31, 
	A3 => UQVN_N34);
END lattice_arch;
-- VHDL netlist for CBD11
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBD11 IS 
    PORT (
        CAI : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBD11;


ARCHITECTURE lattice_arch OF CBD11 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3 : std_logic;


  COMPONENT FD21
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD21 use  entity  lattice.FD21(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


BEGIN

UQVB_B1 : FD21
	PORT MAP (Q0 => UQVN_N1, D0 => UQVN_N3, CLK => CLK, CD => CD);
UQVB_B2 : INV
	PORT MAP (ZN0 => UQVN_N2, A0 => UQVN_N1);
UQVB_B3 : AND2
	PORT MAP (Z0 => CAO, A0 => UQVN_N2, A1 => CAI);
UQVB_B4 : BUF
	PORT MAP (Z0 => Q0, A0 => UQVN_N1);
UQVB_B5 : LXOR2
	PORT MAP (Z0 => UQVN_N3, A0 => UQVN_N1, A1 => CAI);
END lattice_arch;
-- VHDL netlist for CBD12
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBD12 IS 
    PORT (
        CAI : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBD12;


ARCHITECTURE lattice_arch OF CBD12 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, QI0,
	 QI1, UQVN_N4, UQVN_N5 : std_logic;


  COMPONENT FD21
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD21 use  entity  lattice.FD21(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


BEGIN

UQVB_B1 : FD21
	PORT MAP (Q0 => QI0, D0 => UQVN_N2, CLK => CLK, CD => CD);
UQVB_B2 : FD21
	PORT MAP (Q0 => QI1, D0 => UQVN_N3, CLK => CLK, CD => CD);
UQVB_B3 : INV
	PORT MAP (ZN0 => UQVN_N4, A0 => QI0);
UQVB_B4 : INV
	PORT MAP (ZN0 => UQVN_N5, A0 => QI1);
UQVB_B5 : AND3
	PORT MAP (Z0 => CAO, A0 => UQVN_N4, A1 => UQVN_N5, A2 => CAI);
UQVB_B6 : AND2
	PORT MAP (Z0 => UQVN_N1, A0 => UQVN_N4, A1 => CAI);
UQVB_B7 : BUF
	PORT MAP (Z0 => Q1, A0 => QI1);
UQVB_B8 : BUF
	PORT MAP (Z0 => Q0, A0 => QI0);
UQVB_B9 : LXOR2
	PORT MAP (Z0 => UQVN_N2, A0 => QI0, A1 => CAI);
UQVB_B10 : LXOR2
	PORT MAP (Z0 => UQVN_N3, A0 => QI1, A1 => UQVN_N1);
END lattice_arch;
-- VHDL netlist for CBD14
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBD14 IS 
    PORT (
        CAI : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBD14;


ARCHITECTURE lattice_arch OF CBD14 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, QI0,
	 QI1, QI2, QI3, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11 : std_logic;


  COMPONENT FD21
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD21 use  entity  lattice.FD21(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT AND5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND5 use  entity  lattice.AND5(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


BEGIN

UQVB_B1 : FD21
	PORT MAP (Q0 => QI0, D0 => UQVN_N4, CLK => CLK, CD => CD);
UQVB_B2 : FD21
	PORT MAP (Q0 => QI1, D0 => UQVN_N5, CLK => CLK, CD => CD);
UQVB_B3 : INV
	PORT MAP (ZN0 => UQVN_N8, A0 => QI0);
UQVB_B4 : INV
	PORT MAP (ZN0 => UQVN_N9, A0 => QI1);
UQVB_B5 : INV
	PORT MAP (ZN0 => UQVN_N10, A0 => QI2);
UQVB_B6 : INV
	PORT MAP (ZN0 => UQVN_N11, A0 => QI3);
UQVB_B7 : AND2
	PORT MAP (Z0 => UQVN_N1, A0 => UQVN_N8, A1 => CAI);
UQVB_B8 : AND3
	PORT MAP (Z0 => UQVN_N2, A0 => UQVN_N8, A1 => UQVN_N9, A2 => CAI);
UQVB_B9 : AND4
	PORT MAP (Z0 => UQVN_N3, A0 => UQVN_N8, A1 => UQVN_N9, A2 => UQVN_N10, 
	A3 => CAI);
UQVB_B10 : AND5
	PORT MAP (Z0 => CAO, A0 => UQVN_N8, A1 => UQVN_N9, A2 => UQVN_N10, 
	A3 => UQVN_N11, A4 => CAI);
UQVB_B11 : BUF
	PORT MAP (Z0 => Q3, A0 => QI3);
UQVB_B12 : BUF
	PORT MAP (Z0 => Q2, A0 => QI2);
UQVB_B13 : BUF
	PORT MAP (Z0 => Q1, A0 => QI1);
UQVB_B14 : BUF
	PORT MAP (Z0 => Q0, A0 => QI0);
UQVB_B15 : FD21
	PORT MAP (Q0 => QI2, D0 => UQVN_N6, CLK => CLK, CD => CD);
UQVB_B16 : FD21
	PORT MAP (Q0 => QI3, D0 => UQVN_N7, CLK => CLK, CD => CD);
UQVB_B17 : LXOR2
	PORT MAP (Z0 => UQVN_N4, A0 => QI0, A1 => CAI);
UQVB_B18 : LXOR2
	PORT MAP (Z0 => UQVN_N5, A0 => QI1, A1 => UQVN_N1);
UQVB_B19 : LXOR2
	PORT MAP (Z0 => UQVN_N6, A0 => QI2, A1 => UQVN_N2);
UQVB_B20 : LXOR2
	PORT MAP (Z0 => UQVN_N7, A0 => QI3, A1 => UQVN_N3);
END lattice_arch;
-- VHDL netlist for CBD18
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBD18 IS 
    PORT (
        CAI : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        Q4 : OUT std_logic;
        Q5 : OUT std_logic;
        Q6 : OUT std_logic;
        Q7 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBD18;


ARCHITECTURE lattice_arch OF CBD18 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, QI0,
	 QI1, QI2, QI3, QI4,
	 QI5, QI6, QI7, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, UQVN_N23 : std_logic;


  COMPONENT FD21
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD21 use  entity  lattice.FD21(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT AND5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND5 use  entity  lattice.AND5(lattice_arch);


  COMPONENT AND6
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND6 use  entity  lattice.AND6(lattice_arch);


  COMPONENT AND7
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND7 use  entity  lattice.AND7(lattice_arch);


  COMPONENT AND8
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND8 use  entity  lattice.AND8(lattice_arch);


  COMPONENT AND9
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND9 use  entity  lattice.AND9(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


BEGIN

UQVB_B1 : FD21
	PORT MAP (Q0 => QI0, D0 => UQVN_N8, CLK => CLK, CD => CD);
UQVB_B2 : FD21
	PORT MAP (Q0 => QI1, D0 => UQVN_N9, CLK => CLK, CD => CD);
UQVB_B3 : INV
	PORT MAP (ZN0 => UQVN_N16, A0 => QI0);
UQVB_B4 : INV
	PORT MAP (ZN0 => UQVN_N17, A0 => QI1);
UQVB_B5 : INV
	PORT MAP (ZN0 => UQVN_N18, A0 => QI2);
UQVB_B6 : INV
	PORT MAP (ZN0 => UQVN_N19, A0 => QI3);
UQVB_B7 : INV
	PORT MAP (ZN0 => UQVN_N20, A0 => QI4);
UQVB_B8 : INV
	PORT MAP (ZN0 => UQVN_N21, A0 => QI5);
UQVB_B9 : INV
	PORT MAP (ZN0 => UQVN_N22, A0 => QI6);
UQVB_B10 : INV
	PORT MAP (ZN0 => UQVN_N23, A0 => QI7);
UQVB_B11 : AND2
	PORT MAP (Z0 => UQVN_N1, A0 => UQVN_N16, A1 => CAI);
UQVB_B12 : AND3
	PORT MAP (Z0 => UQVN_N2, A0 => UQVN_N16, A1 => UQVN_N17, A2 => CAI);
UQVB_B13 : AND4
	PORT MAP (Z0 => UQVN_N3, A0 => UQVN_N16, A1 => UQVN_N17, A2 => UQVN_N18, 
	A3 => CAI);
UQVB_B14 : AND5
	PORT MAP (Z0 => UQVN_N4, A0 => UQVN_N16, A1 => UQVN_N17, A2 => UQVN_N18, 
	A3 => UQVN_N19, A4 => CAI);
UQVB_B15 : AND6
	PORT MAP (Z0 => UQVN_N5, A0 => UQVN_N16, A1 => UQVN_N17, A2 => UQVN_N18, 
	A3 => UQVN_N19, A4 => UQVN_N20, A5 => CAI);
UQVB_B16 : AND7
	PORT MAP (Z0 => UQVN_N6, A0 => UQVN_N16, A1 => UQVN_N17, A2 => UQVN_N18, 
	A3 => UQVN_N19, A4 => UQVN_N20, A5 => UQVN_N21, A6 => CAI);
UQVB_B17 : AND8
	PORT MAP (Z0 => UQVN_N7, A0 => UQVN_N16, A1 => UQVN_N17, A2 => UQVN_N18, 
	A3 => UQVN_N19, A4 => UQVN_N20, A5 => UQVN_N21, A6 => UQVN_N22, 
	A7 => CAI);
UQVB_B18 : AND9
	PORT MAP (Z0 => CAO, A0 => UQVN_N16, A1 => UQVN_N17, A2 => UQVN_N18, 
	A3 => UQVN_N19, A4 => UQVN_N20, A5 => UQVN_N21, A6 => UQVN_N22, 
	A7 => UQVN_N23, A8 => CAI);
UQVB_B19 : BUF
	PORT MAP (Z0 => Q7, A0 => QI7);
UQVB_B20 : BUF
	PORT MAP (Z0 => Q0, A0 => QI0);
UQVB_B21 : BUF
	PORT MAP (Z0 => Q6, A0 => QI6);
UQVB_B22 : BUF
	PORT MAP (Z0 => Q1, A0 => QI1);
UQVB_B23 : BUF
	PORT MAP (Z0 => Q5, A0 => QI5);
UQVB_B24 : BUF
	PORT MAP (Z0 => Q2, A0 => QI2);
UQVB_B25 : BUF
	PORT MAP (Z0 => Q4, A0 => QI4);
UQVB_B26 : BUF
	PORT MAP (Z0 => Q3, A0 => QI3);
UQVB_B27 : FD21
	PORT MAP (Q0 => QI2, D0 => UQVN_N10, CLK => CLK, CD => CD);
UQVB_B28 : FD21
	PORT MAP (Q0 => QI3, D0 => UQVN_N11, CLK => CLK, CD => CD);
UQVB_B29 : LXOR2
	PORT MAP (Z0 => UQVN_N8, A0 => QI0, A1 => CAI);
UQVB_B30 : LXOR2
	PORT MAP (Z0 => UQVN_N9, A0 => QI1, A1 => UQVN_N1);
UQVB_B31 : LXOR2
	PORT MAP (Z0 => UQVN_N10, A0 => QI2, A1 => UQVN_N2);
UQVB_B32 : LXOR2
	PORT MAP (Z0 => UQVN_N11, A0 => QI3, A1 => UQVN_N3);
UQVB_B33 : LXOR2
	PORT MAP (Z0 => UQVN_N12, A0 => QI4, A1 => UQVN_N4);
UQVB_B34 : FD21
	PORT MAP (Q0 => QI4, D0 => UQVN_N12, CLK => CLK, CD => CD);
UQVB_B35 : LXOR2
	PORT MAP (Z0 => UQVN_N13, A0 => QI5, A1 => UQVN_N5);
UQVB_B36 : FD21
	PORT MAP (Q0 => QI5, D0 => UQVN_N13, CLK => CLK, CD => CD);
UQVB_B37 : FD21
	PORT MAP (Q0 => QI6, D0 => UQVN_N14, CLK => CLK, CD => CD);
UQVB_B38 : LXOR2
	PORT MAP (Z0 => UQVN_N14, A0 => QI6, A1 => UQVN_N6);
UQVB_B39 : LXOR2
	PORT MAP (Z0 => UQVN_N15, A0 => QI7, A1 => UQVN_N7);
UQVB_B40 : FD21
	PORT MAP (Q0 => QI7, D0 => UQVN_N15, CLK => CLK, CD => CD);
END lattice_arch;
-- VHDL netlist for CBD21
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBD21 IS 
    PORT (
        CAI : IN std_logic;
        CLK : IN std_logic;
        EN : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBD21;


ARCHITECTURE lattice_arch OF CBD21 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4 : std_logic;


  COMPONENT FD21
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD21 use  entity  lattice.FD21(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


BEGIN

UQVB_B1 : FD21
	PORT MAP (Q0 => UQVN_N1, D0 => UQVN_N3, CLK => CLK, CD => CD);
UQVB_B2 : INV
	PORT MAP (ZN0 => UQVN_N4, A0 => UQVN_N1);
UQVB_B3 : AND3
	PORT MAP (Z0 => CAO, A0 => UQVN_N4, A1 => CAI, A2 => EN);
UQVB_B4 : AND2
	PORT MAP (Z0 => UQVN_N2, A0 => CAI, A1 => EN);
UQVB_B5 : BUF
	PORT MAP (Z0 => Q0, A0 => UQVN_N1);
UQVB_B6 : LXOR2
	PORT MAP (Z0 => UQVN_N3, A0 => UQVN_N1, A1 => UQVN_N2);
END lattice_arch;
-- VHDL netlist for CBD22
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBD22 IS 
    PORT (
        CAI : IN std_logic;
        CLK : IN std_logic;
        EN : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBD22;


ARCHITECTURE lattice_arch OF CBD22 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 QI0, QI1, UQVN_N5, UQVN_N6 : std_logic;


  COMPONENT FD21
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD21 use  entity  lattice.FD21(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


BEGIN

UQVB_B1 : FD21
	PORT MAP (Q0 => QI0, D0 => UQVN_N3, CLK => CLK, CD => CD);
UQVB_B2 : FD21
	PORT MAP (Q0 => QI1, D0 => UQVN_N4, CLK => CLK, CD => CD);
UQVB_B3 : INV
	PORT MAP (ZN0 => UQVN_N5, A0 => QI0);
UQVB_B4 : INV
	PORT MAP (ZN0 => UQVN_N6, A0 => QI1);
UQVB_B5 : AND4
	PORT MAP (Z0 => CAO, A0 => UQVN_N5, A1 => UQVN_N6, A2 => CAI, 
	A3 => EN);
UQVB_B6 : AND2
	PORT MAP (Z0 => UQVN_N1, A0 => CAI, A1 => EN);
UQVB_B7 : AND3
	PORT MAP (Z0 => UQVN_N2, A0 => UQVN_N5, A1 => CAI, A2 => EN);
UQVB_B8 : BUF
	PORT MAP (Z0 => Q1, A0 => QI1);
UQVB_B9 : BUF
	PORT MAP (Z0 => Q0, A0 => QI0);
UQVB_B10 : LXOR2
	PORT MAP (Z0 => UQVN_N3, A0 => QI0, A1 => UQVN_N1);
UQVB_B11 : LXOR2
	PORT MAP (Z0 => UQVN_N4, A0 => QI1, A1 => UQVN_N2);
END lattice_arch;
-- VHDL netlist for CBD24
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBD24 IS 
    PORT (
        CAI : IN std_logic;
        CLK : IN std_logic;
        EN : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBD24;


ARCHITECTURE lattice_arch OF CBD24 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 QI0, QI1, QI2, QI3,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12 : std_logic;


  COMPONENT FD21
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD21 use  entity  lattice.FD21(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT AND5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND5 use  entity  lattice.AND5(lattice_arch);


  COMPONENT AND6
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND6 use  entity  lattice.AND6(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


BEGIN

UQVB_B1 : FD21
	PORT MAP (Q0 => QI0, D0 => UQVN_N5, CLK => CLK, CD => CD);
UQVB_B2 : FD21
	PORT MAP (Q0 => QI1, D0 => UQVN_N6, CLK => CLK, CD => CD);
UQVB_B3 : INV
	PORT MAP (ZN0 => UQVN_N9, A0 => QI0);
UQVB_B4 : INV
	PORT MAP (ZN0 => UQVN_N10, A0 => QI1);
UQVB_B5 : INV
	PORT MAP (ZN0 => UQVN_N11, A0 => QI2);
UQVB_B6 : INV
	PORT MAP (ZN0 => UQVN_N12, A0 => QI3);
UQVB_B7 : AND2
	PORT MAP (Z0 => UQVN_N1, A0 => CAI, A1 => EN);
UQVB_B8 : AND3
	PORT MAP (Z0 => UQVN_N2, A0 => UQVN_N9, A1 => CAI, A2 => EN);
UQVB_B9 : AND4
	PORT MAP (Z0 => UQVN_N3, A0 => UQVN_N9, A1 => UQVN_N10, A2 => CAI, 
	A3 => EN);
UQVB_B10 : AND5
	PORT MAP (Z0 => UQVN_N4, A0 => UQVN_N9, A1 => UQVN_N10, A2 => UQVN_N11, 
	A3 => CAI, A4 => EN);
UQVB_B11 : AND6
	PORT MAP (Z0 => CAO, A0 => UQVN_N9, A1 => UQVN_N10, A2 => UQVN_N11, 
	A3 => UQVN_N12, A4 => CAI, A5 => EN);
UQVB_B12 : BUF
	PORT MAP (Z0 => Q3, A0 => QI3);
UQVB_B13 : BUF
	PORT MAP (Z0 => Q2, A0 => QI2);
UQVB_B14 : BUF
	PORT MAP (Z0 => Q1, A0 => QI1);
UQVB_B15 : BUF
	PORT MAP (Z0 => Q0, A0 => QI0);
UQVB_B16 : FD21
	PORT MAP (Q0 => QI2, D0 => UQVN_N7, CLK => CLK, CD => CD);
UQVB_B17 : FD21
	PORT MAP (Q0 => QI3, D0 => UQVN_N8, CLK => CLK, CD => CD);
UQVB_B18 : LXOR2
	PORT MAP (Z0 => UQVN_N5, A0 => QI0, A1 => UQVN_N1);
UQVB_B19 : LXOR2
	PORT MAP (Z0 => UQVN_N6, A0 => QI1, A1 => UQVN_N2);
UQVB_B20 : LXOR2
	PORT MAP (Z0 => UQVN_N7, A0 => QI2, A1 => UQVN_N3);
UQVB_B21 : LXOR2
	PORT MAP (Z0 => UQVN_N8, A0 => QI3, A1 => UQVN_N4);
END lattice_arch;
-- VHDL netlist for CBD28
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBD28 IS 
    PORT (
        CAI : IN std_logic;
        CLK : IN std_logic;
        EN : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        Q4 : OUT std_logic;
        Q5 : OUT std_logic;
        Q6 : OUT std_logic;
        Q7 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBD28;


ARCHITECTURE lattice_arch OF CBD28 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 QI0, QI1, QI2, QI3,
	 QI4, QI5, QI6, QI7,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, UQVN_N23, UQVN_N24 : std_logic;


  COMPONENT FD21
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD21 use  entity  lattice.FD21(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT AND5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND5 use  entity  lattice.AND5(lattice_arch);


  COMPONENT AND6
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND6 use  entity  lattice.AND6(lattice_arch);


  COMPONENT AND7
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND7 use  entity  lattice.AND7(lattice_arch);


  COMPONENT AND8
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND8 use  entity  lattice.AND8(lattice_arch);


  COMPONENT AND9
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND9 use  entity  lattice.AND9(lattice_arch);


  COMPONENT AND10
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        A9 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND10 use  entity  lattice.AND10(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


BEGIN

UQVB_B1 : FD21
	PORT MAP (Q0 => QI0, D0 => UQVN_N9, CLK => CLK, CD => CD);
UQVB_B2 : FD21
	PORT MAP (Q0 => QI1, D0 => UQVN_N10, CLK => CLK, CD => CD);
UQVB_B3 : INV
	PORT MAP (ZN0 => UQVN_N17, A0 => QI0);
UQVB_B4 : INV
	PORT MAP (ZN0 => UQVN_N18, A0 => QI1);
UQVB_B5 : INV
	PORT MAP (ZN0 => UQVN_N19, A0 => QI2);
UQVB_B6 : INV
	PORT MAP (ZN0 => UQVN_N20, A0 => QI3);
UQVB_B7 : INV
	PORT MAP (ZN0 => UQVN_N21, A0 => QI4);
UQVB_B8 : INV
	PORT MAP (ZN0 => UQVN_N22, A0 => QI5);
UQVB_B9 : INV
	PORT MAP (ZN0 => UQVN_N23, A0 => QI6);
UQVB_B10 : INV
	PORT MAP (ZN0 => UQVN_N24, A0 => QI7);
UQVB_B11 : AND2
	PORT MAP (Z0 => UQVN_N1, A0 => CAI, A1 => EN);
UQVB_B12 : AND3
	PORT MAP (Z0 => UQVN_N2, A0 => UQVN_N17, A1 => CAI, A2 => EN);
UQVB_B13 : AND4
	PORT MAP (Z0 => UQVN_N3, A0 => UQVN_N17, A1 => UQVN_N18, A2 => CAI, 
	A3 => EN);
UQVB_B14 : AND5
	PORT MAP (Z0 => UQVN_N4, A0 => UQVN_N17, A1 => UQVN_N18, A2 => UQVN_N19, 
	A3 => CAI, A4 => EN);
UQVB_B15 : AND6
	PORT MAP (Z0 => UQVN_N5, A0 => UQVN_N17, A1 => UQVN_N18, A2 => UQVN_N19, 
	A3 => UQVN_N20, A4 => CAI, A5 => EN);
UQVB_B16 : AND7
	PORT MAP (Z0 => UQVN_N6, A0 => UQVN_N17, A1 => UQVN_N18, A2 => UQVN_N19, 
	A3 => UQVN_N20, A4 => UQVN_N21, A5 => CAI, A6 => EN);
UQVB_B17 : AND8
	PORT MAP (Z0 => UQVN_N7, A0 => UQVN_N17, A1 => UQVN_N18, A2 => UQVN_N19, 
	A3 => UQVN_N20, A4 => UQVN_N21, A5 => UQVN_N22, A6 => CAI, 
	A7 => EN);
UQVB_B18 : AND9
	PORT MAP (Z0 => UQVN_N8, A0 => UQVN_N17, A1 => UQVN_N18, A2 => UQVN_N19, 
	A3 => UQVN_N20, A4 => UQVN_N21, A5 => UQVN_N22, A6 => UQVN_N23, 
	A7 => CAI, A8 => EN);
UQVB_B19 : AND10
	PORT MAP (Z0 => CAO, A0 => UQVN_N17, A1 => UQVN_N18, A2 => UQVN_N19, 
	A3 => UQVN_N20, A4 => UQVN_N21, A5 => UQVN_N22, A6 => UQVN_N23, 
	A7 => UQVN_N24, A8 => CAI, A9 => EN);
UQVB_B20 : BUF
	PORT MAP (Z0 => Q7, A0 => QI7);
UQVB_B21 : BUF
	PORT MAP (Z0 => Q6, A0 => QI6);
UQVB_B22 : BUF
	PORT MAP (Z0 => Q5, A0 => QI5);
UQVB_B23 : BUF
	PORT MAP (Z0 => Q4, A0 => QI4);
UQVB_B24 : BUF
	PORT MAP (Z0 => Q3, A0 => QI3);
UQVB_B25 : BUF
	PORT MAP (Z0 => Q2, A0 => QI2);
UQVB_B26 : BUF
	PORT MAP (Z0 => Q1, A0 => QI1);
UQVB_B27 : BUF
	PORT MAP (Z0 => Q0, A0 => QI0);
UQVB_B28 : FD21
	PORT MAP (Q0 => QI2, D0 => UQVN_N11, CLK => CLK, CD => CD);
UQVB_B29 : FD21
	PORT MAP (Q0 => QI3, D0 => UQVN_N12, CLK => CLK, CD => CD);
UQVB_B30 : LXOR2
	PORT MAP (Z0 => UQVN_N9, A0 => QI0, A1 => UQVN_N1);
UQVB_B31 : LXOR2
	PORT MAP (Z0 => UQVN_N10, A0 => QI1, A1 => UQVN_N2);
UQVB_B32 : LXOR2
	PORT MAP (Z0 => UQVN_N11, A0 => QI2, A1 => UQVN_N3);
UQVB_B33 : LXOR2
	PORT MAP (Z0 => UQVN_N12, A0 => QI3, A1 => UQVN_N4);
UQVB_B34 : LXOR2
	PORT MAP (Z0 => UQVN_N13, A0 => QI4, A1 => UQVN_N5);
UQVB_B35 : FD21
	PORT MAP (Q0 => QI4, D0 => UQVN_N13, CLK => CLK, CD => CD);
UQVB_B36 : LXOR2
	PORT MAP (Z0 => UQVN_N14, A0 => QI5, A1 => UQVN_N6);
UQVB_B37 : FD21
	PORT MAP (Q0 => QI5, D0 => UQVN_N14, CLK => CLK, CD => CD);
UQVB_B38 : FD21
	PORT MAP (Q0 => QI6, D0 => UQVN_N15, CLK => CLK, CD => CD);
UQVB_B39 : LXOR2
	PORT MAP (Z0 => UQVN_N15, A0 => QI6, A1 => UQVN_N7);
UQVB_B40 : LXOR2
	PORT MAP (Z0 => UQVN_N16, A0 => QI7, A1 => UQVN_N8);
UQVB_B41 : FD21
	PORT MAP (Q0 => QI7, D0 => UQVN_N16, CLK => CLK, CD => CD);
END lattice_arch;
-- VHDL netlist for CBD31
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBD31 IS 
    PORT (
        D0 : IN std_logic;
        CAI : IN std_logic;
        CLK : IN std_logic;
        PS : IN std_logic;
        LD : IN std_logic;
        EN : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBD31;


ARCHITECTURE lattice_arch OF CBD31 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9 : std_logic;


  COMPONENT FD21
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD21 use  entity  lattice.FD21(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


  COMPONENT OR3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR3 use  entity  lattice.OR3(lattice_arch);


BEGIN

UQVB_B1 : FD21
	PORT MAP (Q0 => UQVN_N3, D0 => UQVN_N9, CLK => CLK, CD => CD);
UQVB_B2 : AND3
	PORT MAP (Z0 => UQVN_N1, A0 => UQVN_N3, A1 => UQVN_N7, A2 => UQVN_N8);
UQVB_B3 : AND2
	PORT MAP (Z0 => UQVN_N4, A0 => D0, A1 => LD);
UQVB_B4 : AND3
	PORT MAP (Z0 => UQVN_N5, A0 => UQVN_N7, A1 => CAI, A2 => EN);
UQVB_B5 : INV
	PORT MAP (ZN0 => UQVN_N2, A0 => UQVN_N3);
UQVB_B6 : AND3
	PORT MAP (Z0 => CAO, A0 => UQVN_N2, A1 => EN, A2 => CAI);
UQVB_B7 : INV
	PORT MAP (ZN0 => UQVN_N7, A0 => LD);
UQVB_B8 : BUF
	PORT MAP (Z0 => Q0, A0 => UQVN_N3);
UQVB_B9 : LXOR2
	PORT MAP (Z0 => UQVN_N9, A0 => UQVN_N1, A1 => UQVN_N6);
UQVB_B10 : OR3
	PORT MAP (Z0 => UQVN_N6, A0 => UQVN_N4, A1 => UQVN_N5, A2 => PS);
UQVB_B11 : INV
	PORT MAP (ZN0 => UQVN_N8, A0 => PS);
END lattice_arch;
-- VHDL netlist for CBD32
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBD32 IS 
    PORT (
        D0 : IN std_logic;
        D1 : IN std_logic;
        CAI : IN std_logic;
        CLK : IN std_logic;
        PS : IN std_logic;
        LD : IN std_logic;
        EN : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBD32;


ARCHITECTURE lattice_arch OF CBD32 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 QI0, QI1, UQVN_N13, UQVN_N14 : std_logic;


  COMPONENT FD21
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD21 use  entity  lattice.FD21(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT OR3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR3 use  entity  lattice.OR3(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


BEGIN

UQVB_B1 : FD21
	PORT MAP (Q0 => QI0, D0 => UQVN_N11, CLK => CLK, CD => CD);
UQVB_B2 : FD21
	PORT MAP (Q0 => QI1, D0 => UQVN_N12, CLK => CLK, CD => CD);
UQVB_B3 : AND3
	PORT MAP (Z0 => UQVN_N1, A0 => QI0, A1 => UQVN_N9, A2 => UQVN_N10);
UQVB_B4 : AND2
	PORT MAP (Z0 => UQVN_N3, A0 => D0, A1 => LD);
UQVB_B5 : AND3
	PORT MAP (Z0 => UQVN_N4, A0 => UQVN_N9, A1 => CAI, A2 => EN);
UQVB_B6 : AND2
	PORT MAP (Z0 => UQVN_N6, A0 => D1, A1 => LD);
UQVB_B7 : AND4
	PORT MAP (Z0 => UQVN_N2, A0 => UQVN_N13, A1 => CAI, A2 => UQVN_N9, 
	A3 => EN);
UQVB_B8 : OR3
	PORT MAP (Z0 => UQVN_N8, A0 => UQVN_N6, A1 => UQVN_N2, A2 => PS);
UQVB_B9 : AND3
	PORT MAP (Z0 => UQVN_N7, A0 => QI1, A1 => UQVN_N9, A2 => UQVN_N10);
UQVB_B10 : INV
	PORT MAP (ZN0 => UQVN_N13, A0 => QI0);
UQVB_B11 : INV
	PORT MAP (ZN0 => UQVN_N14, A0 => QI1);
UQVB_B12 : AND4
	PORT MAP (Z0 => CAO, A0 => UQVN_N13, A1 => UQVN_N14, A2 => EN, 
	A3 => CAI);
UQVB_B13 : INV
	PORT MAP (ZN0 => UQVN_N9, A0 => LD);
UQVB_B14 : BUF
	PORT MAP (Z0 => Q1, A0 => QI1);
UQVB_B15 : BUF
	PORT MAP (Z0 => Q0, A0 => QI0);
UQVB_B16 : LXOR2
	PORT MAP (Z0 => UQVN_N11, A0 => UQVN_N1, A1 => UQVN_N5);
UQVB_B17 : OR3
	PORT MAP (Z0 => UQVN_N5, A0 => UQVN_N3, A1 => UQVN_N4, A2 => PS);
UQVB_B18 : LXOR2
	PORT MAP (Z0 => UQVN_N12, A0 => UQVN_N7, A1 => UQVN_N8);
UQVB_B19 : INV
	PORT MAP (ZN0 => UQVN_N10, A0 => PS);
END lattice_arch;
-- VHDL netlist for CBD34
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBD34 IS 
    PORT (
        D0 : IN std_logic;
        D1 : IN std_logic;
        D2 : IN std_logic;
        D3 : IN std_logic;
        CAI : IN std_logic;
        CLK : IN std_logic;
        PS : IN std_logic;
        LD : IN std_logic;
        EN : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBD34;


ARCHITECTURE lattice_arch OF CBD34 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, QI0, QI1,
	 QI2, QI3, UQVN_N23, UQVN_N24,
	 UQVN_N25, UQVN_N26 : std_logic;


  COMPONENT FD21
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD21 use  entity  lattice.FD21(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT OR3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR3 use  entity  lattice.OR3(lattice_arch);


  COMPONENT AND5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND5 use  entity  lattice.AND5(lattice_arch);


  COMPONENT AND6
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND6 use  entity  lattice.AND6(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


BEGIN

UQVB_B1 : FD21
	PORT MAP (Q0 => QI0, D0 => UQVN_N19, CLK => CLK, CD => CD);
UQVB_B2 : FD21
	PORT MAP (Q0 => QI1, D0 => UQVN_N20, CLK => CLK, CD => CD);
UQVB_B3 : AND3
	PORT MAP (Z0 => UQVN_N1, A0 => QI0, A1 => UQVN_N17, A2 => UQVN_N18);
UQVB_B4 : AND2
	PORT MAP (Z0 => UQVN_N3, A0 => D0, A1 => LD);
UQVB_B5 : AND3
	PORT MAP (Z0 => UQVN_N4, A0 => UQVN_N17, A1 => CAI, A2 => EN);
UQVB_B6 : AND2
	PORT MAP (Z0 => UQVN_N6, A0 => D1, A1 => LD);
UQVB_B7 : AND3
	PORT MAP (Z0 => UQVN_N10, A0 => QI2, A1 => UQVN_N17, A2 => UQVN_N18);
UQVB_B8 : AND2
	PORT MAP (Z0 => UQVN_N9, A0 => D2, A1 => LD);
UQVB_B9 : AND3
	PORT MAP (Z0 => UQVN_N14, A0 => QI3, A1 => UQVN_N17, A2 => UQVN_N18);
UQVB_B10 : AND2
	PORT MAP (Z0 => UQVN_N13, A0 => D3, A1 => LD);
UQVB_B11 : AND4
	PORT MAP (Z0 => UQVN_N2, A0 => UQVN_N23, A1 => CAI, A2 => UQVN_N17, 
	A3 => EN);
UQVB_B12 : OR3
	PORT MAP (Z0 => UQVN_N8, A0 => UQVN_N6, A1 => UQVN_N2, A2 => PS);
UQVB_B13 : OR3
	PORT MAP (Z0 => UQVN_N11, A0 => UQVN_N9, A1 => UQVN_N12, A2 => PS);
UQVB_B14 : OR3
	PORT MAP (Z0 => UQVN_N15, A0 => UQVN_N13, A1 => UQVN_N16, A2 => PS);
UQVB_B15 : AND5
	PORT MAP (Z0 => UQVN_N12, A0 => UQVN_N23, A1 => UQVN_N24, A2 => UQVN_N17, 
	A3 => CAI, A4 => EN);
UQVB_B16 : AND6
	PORT MAP (Z0 => UQVN_N16, A0 => UQVN_N23, A1 => UQVN_N24, A2 => UQVN_N25, 
	A3 => UQVN_N17, A4 => CAI, A5 => EN);
UQVB_B17 : AND3
	PORT MAP (Z0 => UQVN_N7, A0 => QI1, A1 => UQVN_N17, A2 => UQVN_N18);
UQVB_B18 : INV
	PORT MAP (ZN0 => UQVN_N23, A0 => QI0);
UQVB_B19 : INV
	PORT MAP (ZN0 => UQVN_N24, A0 => QI1);
UQVB_B20 : INV
	PORT MAP (ZN0 => UQVN_N25, A0 => QI2);
UQVB_B21 : INV
	PORT MAP (ZN0 => UQVN_N26, A0 => QI3);
UQVB_B22 : AND6
	PORT MAP (Z0 => CAO, A0 => UQVN_N23, A1 => UQVN_N24, A2 => UQVN_N25, 
	A3 => UQVN_N26, A4 => EN, A5 => CAI);
UQVB_B23 : INV
	PORT MAP (ZN0 => UQVN_N18, A0 => PS);
UQVB_B24 : BUF
	PORT MAP (Z0 => Q3, A0 => QI3);
UQVB_B25 : BUF
	PORT MAP (Z0 => Q2, A0 => QI2);
UQVB_B26 : BUF
	PORT MAP (Z0 => Q1, A0 => QI1);
UQVB_B27 : BUF
	PORT MAP (Z0 => Q0, A0 => QI0);
UQVB_B28 : FD21
	PORT MAP (Q0 => QI2, D0 => UQVN_N21, CLK => CLK, CD => CD);
UQVB_B29 : FD21
	PORT MAP (Q0 => QI3, D0 => UQVN_N22, CLK => CLK, CD => CD);
UQVB_B30 : LXOR2
	PORT MAP (Z0 => UQVN_N19, A0 => UQVN_N1, A1 => UQVN_N5);
UQVB_B31 : OR3
	PORT MAP (Z0 => UQVN_N5, A0 => UQVN_N3, A1 => UQVN_N4, A2 => PS);
UQVB_B32 : LXOR2
	PORT MAP (Z0 => UQVN_N20, A0 => UQVN_N7, A1 => UQVN_N8);
UQVB_B33 : INV
	PORT MAP (ZN0 => UQVN_N17, A0 => LD);
UQVB_B34 : LXOR2
	PORT MAP (Z0 => UQVN_N21, A0 => UQVN_N10, A1 => UQVN_N11);
UQVB_B35 : LXOR2
	PORT MAP (Z0 => UQVN_N22, A0 => UQVN_N14, A1 => UQVN_N15);
END lattice_arch;
-- VHDL netlist for CBD38
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBD38 IS 
    PORT (
        D0 : IN std_logic;
        D1 : IN std_logic;
        D2 : IN std_logic;
        D3 : IN std_logic;
        D4 : IN std_logic;
        D5 : IN std_logic;
        D6 : IN std_logic;
        D7 : IN std_logic;
        CAI : IN std_logic;
        CLK : IN std_logic;
        PS : IN std_logic;
        LD : IN std_logic;
        EN : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        Q4 : OUT std_logic;
        Q5 : OUT std_logic;
        Q6 : OUT std_logic;
        Q7 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBD38;


ARCHITECTURE lattice_arch OF CBD38 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, UQVN_N23, UQVN_N24,
	 UQVN_N25, UQVN_N26, UQVN_N27, UQVN_N28,
	 UQVN_N29, UQVN_N30, UQVN_N31, UQVN_N32,
	 UQVN_N33, UQVN_N34, UQVN_N35, UQVN_N36,
	 UQVN_N37, UQVN_N38, UQVN_N39, UQVN_N40,
	 UQVN_N41, UQVN_N42, UQVN_N43, UQVN_N44,
	 QI0, QI1, QI2, QI3,
	 QI4, QI5, QI6, QI7,
	 UQVN_N45, UQVN_N46, UQVN_N47, UQVN_N48,
	 UQVN_N49, UQVN_N50, UQVN_N51, UQVN_N52 : std_logic;


  COMPONENT FD21
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD21 use  entity  lattice.FD21(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT OR3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR3 use  entity  lattice.OR3(lattice_arch);


  COMPONENT AND5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND5 use  entity  lattice.AND5(lattice_arch);


  COMPONENT AND6
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND6 use  entity  lattice.AND6(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT AND10
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        A9 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND10 use  entity  lattice.AND10(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


  COMPONENT AND7
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND7 use  entity  lattice.AND7(lattice_arch);


  COMPONENT AND8
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND8 use  entity  lattice.AND8(lattice_arch);


  COMPONENT AND9
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND9 use  entity  lattice.AND9(lattice_arch);


BEGIN

UQVB_B1 : FD21
	PORT MAP (Q0 => QI0, D0 => UQVN_N19, CLK => CLK, CD => CD);
UQVB_B2 : FD21
	PORT MAP (Q0 => QI1, D0 => UQVN_N20, CLK => CLK, CD => CD);
UQVB_B3 : AND3
	PORT MAP (Z0 => UQVN_N1, A0 => QI0, A1 => UQVN_N17, A2 => UQVN_N18);
UQVB_B4 : AND2
	PORT MAP (Z0 => UQVN_N3, A0 => D0, A1 => LD);
UQVB_B5 : AND3
	PORT MAP (Z0 => UQVN_N4, A0 => UQVN_N17, A1 => CAI, A2 => EN);
UQVB_B6 : AND2
	PORT MAP (Z0 => UQVN_N6, A0 => D1, A1 => LD);
UQVB_B7 : AND3
	PORT MAP (Z0 => UQVN_N10, A0 => QI2, A1 => UQVN_N17, A2 => UQVN_N18);
UQVB_B8 : AND2
	PORT MAP (Z0 => UQVN_N9, A0 => D2, A1 => LD);
UQVB_B9 : AND3
	PORT MAP (Z0 => UQVN_N14, A0 => QI3, A1 => UQVN_N17, A2 => UQVN_N18);
UQVB_B10 : AND2
	PORT MAP (Z0 => UQVN_N13, A0 => D3, A1 => LD);
UQVB_B11 : AND4
	PORT MAP (Z0 => UQVN_N2, A0 => UQVN_N45, A1 => CAI, A2 => UQVN_N17, 
	A3 => EN);
UQVB_B12 : OR3
	PORT MAP (Z0 => UQVN_N8, A0 => UQVN_N6, A1 => UQVN_N2, A2 => PS);
UQVB_B13 : OR3
	PORT MAP (Z0 => UQVN_N11, A0 => UQVN_N9, A1 => UQVN_N12, A2 => PS);
UQVB_B14 : OR3
	PORT MAP (Z0 => UQVN_N15, A0 => UQVN_N13, A1 => UQVN_N16, A2 => PS);
UQVB_B15 : AND5
	PORT MAP (Z0 => UQVN_N12, A0 => UQVN_N45, A1 => UQVN_N46, A2 => UQVN_N17, 
	A3 => CAI, A4 => EN);
UQVB_B16 : AND6
	PORT MAP (Z0 => UQVN_N16, A0 => UQVN_N45, A1 => UQVN_N46, A2 => UQVN_N47, 
	A3 => UQVN_N17, A4 => CAI, A5 => EN);
UQVB_B17 : AND3
	PORT MAP (Z0 => UQVN_N7, A0 => QI1, A1 => UQVN_N17, A2 => UQVN_N18);
UQVB_B18 : INV
	PORT MAP (ZN0 => UQVN_N45, A0 => QI0);
UQVB_B19 : INV
	PORT MAP (ZN0 => UQVN_N46, A0 => QI1);
UQVB_B20 : INV
	PORT MAP (ZN0 => UQVN_N47, A0 => QI2);
UQVB_B21 : INV
	PORT MAP (ZN0 => UQVN_N48, A0 => QI3);
UQVB_B22 : AND10
	PORT MAP (Z0 => CAO, A0 => UQVN_N45, A1 => UQVN_N46, A2 => UQVN_N47, 
	A3 => UQVN_N48, A4 => UQVN_N49, A5 => UQVN_N50, A6 => UQVN_N51, 
	A7 => UQVN_N52, A8 => CAI, A9 => EN);
UQVB_B23 : INV
	PORT MAP (ZN0 => UQVN_N18, A0 => PS);
UQVB_B24 : BUF
	PORT MAP (Z0 => Q7, A0 => QI7);
UQVB_B25 : BUF
	PORT MAP (Z0 => Q6, A0 => QI6);
UQVB_B26 : BUF
	PORT MAP (Z0 => Q5, A0 => QI5);
UQVB_B27 : BUF
	PORT MAP (Z0 => Q4, A0 => QI4);
UQVB_B28 : BUF
	PORT MAP (Z0 => Q3, A0 => QI3);
UQVB_B29 : BUF
	PORT MAP (Z0 => Q2, A0 => QI2);
UQVB_B30 : BUF
	PORT MAP (Z0 => Q1, A0 => QI1);
UQVB_B31 : BUF
	PORT MAP (Z0 => Q0, A0 => QI0);
UQVB_B32 : FD21
	PORT MAP (Q0 => QI2, D0 => UQVN_N21, CLK => CLK, CD => CD);
UQVB_B33 : FD21
	PORT MAP (Q0 => QI3, D0 => UQVN_N22, CLK => CLK, CD => CD);
UQVB_B34 : LXOR2
	PORT MAP (Z0 => UQVN_N19, A0 => UQVN_N1, A1 => UQVN_N5);
UQVB_B35 : OR3
	PORT MAP (Z0 => UQVN_N5, A0 => UQVN_N3, A1 => UQVN_N4, A2 => PS);
UQVB_B36 : LXOR2
	PORT MAP (Z0 => UQVN_N20, A0 => UQVN_N7, A1 => UQVN_N8);
UQVB_B37 : INV
	PORT MAP (ZN0 => UQVN_N17, A0 => LD);
UQVB_B38 : LXOR2
	PORT MAP (Z0 => UQVN_N21, A0 => UQVN_N10, A1 => UQVN_N11);
UQVB_B39 : LXOR2
	PORT MAP (Z0 => UQVN_N22, A0 => UQVN_N14, A1 => UQVN_N15);
UQVB_B40 : AND3
	PORT MAP (Z0 => UQVN_N27, A0 => QI4, A1 => UQVN_N25, A2 => UQVN_N37);
UQVB_B41 : AND2
	PORT MAP (Z0 => UQVN_N28, A0 => D4, A1 => LD);
UQVB_B42 : AND3
	PORT MAP (Z0 => UQVN_N31, A0 => QI5, A1 => UQVN_N25, A2 => UQVN_N37);
UQVB_B43 : AND2
	PORT MAP (Z0 => UQVN_N32, A0 => D5, A1 => LD);
UQVB_B44 : AND3
	PORT MAP (Z0 => UQVN_N35, A0 => QI6, A1 => UQVN_N25, A2 => UQVN_N37);
UQVB_B45 : AND2
	PORT MAP (Z0 => UQVN_N34, A0 => D6, A1 => LD);
UQVB_B46 : AND3
	PORT MAP (Z0 => UQVN_N39, A0 => QI7, A1 => UQVN_N25, A2 => UQVN_N37);
UQVB_B47 : AND2
	PORT MAP (Z0 => UQVN_N40, A0 => D7, A1 => LD);
UQVB_B48 : AND7
	PORT MAP (Z0 => UQVN_N29, A0 => UQVN_N45, A1 => UQVN_N46, A2 => UQVN_N47, 
	A3 => UQVN_N48, A4 => UQVN_N25, A5 => CAI, A6 => EN);
UQVB_B49 : OR3
	PORT MAP (Z0 => UQVN_N26, A0 => UQVN_N28, A1 => UQVN_N29, A2 => PS);
UQVB_B50 : OR3
	PORT MAP (Z0 => UQVN_N30, A0 => UQVN_N32, A1 => UQVN_N33, A2 => PS);
UQVB_B51 : AND8
	PORT MAP (Z0 => UQVN_N33, A0 => UQVN_N45, A1 => UQVN_N46, A2 => UQVN_N47, 
	A3 => UQVN_N48, A4 => UQVN_N49, A5 => UQVN_N25, A6 => CAI, 
	A7 => EN);
UQVB_B52 : OR3
	PORT MAP (Z0 => UQVN_N36, A0 => UQVN_N34, A1 => UQVN_N23, A2 => PS);
UQVB_B53 : AND9
	PORT MAP (Z0 => UQVN_N23, A0 => UQVN_N45, A1 => UQVN_N46, A2 => UQVN_N47, 
	A3 => UQVN_N48, A4 => UQVN_N49, A5 => UQVN_N50, A6 => UQVN_N25, 
	A7 => CAI, A8 => EN);
UQVB_B54 : AND10
	PORT MAP (Z0 => UQVN_N24, A0 => UQVN_N45, A1 => UQVN_N46, A2 => UQVN_N47, 
	A3 => UQVN_N48, A4 => UQVN_N49, A5 => UQVN_N50, A6 => UQVN_N51, 
	A7 => UQVN_N25, A8 => CAI, A9 => EN);
UQVB_B55 : OR3
	PORT MAP (Z0 => UQVN_N38, A0 => UQVN_N40, A1 => UQVN_N24, A2 => PS);
UQVB_B56 : INV
	PORT MAP (ZN0 => UQVN_N49, A0 => QI4);
UQVB_B57 : INV
	PORT MAP (ZN0 => UQVN_N50, A0 => QI5);
UQVB_B58 : INV
	PORT MAP (ZN0 => UQVN_N51, A0 => QI6);
UQVB_B59 : INV
	PORT MAP (ZN0 => UQVN_N52, A0 => QI7);
UQVB_B60 : INV
	PORT MAP (ZN0 => UQVN_N37, A0 => PS);
UQVB_B61 : INV
	PORT MAP (ZN0 => UQVN_N25, A0 => LD);
UQVB_B62 : LXOR2
	PORT MAP (Z0 => UQVN_N41, A0 => UQVN_N27, A1 => UQVN_N26);
UQVB_B63 : FD21
	PORT MAP (Q0 => QI4, D0 => UQVN_N41, CLK => CLK, CD => CD);
UQVB_B64 : LXOR2
	PORT MAP (Z0 => UQVN_N42, A0 => UQVN_N31, A1 => UQVN_N30);
UQVB_B65 : FD21
	PORT MAP (Q0 => QI5, D0 => UQVN_N42, CLK => CLK, CD => CD);
UQVB_B66 : FD21
	PORT MAP (Q0 => QI6, D0 => UQVN_N43, CLK => CLK, CD => CD);
UQVB_B67 : LXOR2
	PORT MAP (Z0 => UQVN_N43, A0 => UQVN_N35, A1 => UQVN_N36);
UQVB_B68 : LXOR2
	PORT MAP (Z0 => UQVN_N44, A0 => UQVN_N39, A1 => UQVN_N38);
UQVB_B69 : FD21
	PORT MAP (Q0 => QI7, D0 => UQVN_N44, CLK => CLK, CD => CD);
END lattice_arch;
-- VHDL netlist for CBD41
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBD41 IS 
    PORT (
        D0 : IN std_logic;
        CAI : IN std_logic;
        CLK : IN std_logic;
        PS : IN std_logic;
        LD : IN std_logic;
        EN : IN std_logic;
        CS : IN std_logic;
        Q0 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBD41;


ARCHITECTURE lattice_arch OF CBD41 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10 : std_logic;


  COMPONENT FD11
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD11 use  entity  lattice.FD11(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


  COMPONENT OR3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR3 use  entity  lattice.OR3(lattice_arch);


BEGIN

UQVB_B1 : FD11
	PORT MAP (Q0 => UQVN_N5, D0 => UQVN_N10, CLK => CLK);
UQVB_B2 : INV
	PORT MAP (ZN0 => UQVN_N4, A0 => UQVN_N5);
UQVB_B3 : AND3
	PORT MAP (Z0 => CAO, A0 => UQVN_N4, A1 => CAI, A2 => EN);
UQVB_B4 : AND4
	PORT MAP (Z0 => UQVN_N1, A0 => UQVN_N5, A1 => UQVN_N7, A2 => UQVN_N9, 
	A3 => UQVN_N8);
UQVB_B5 : AND3
	PORT MAP (Z0 => UQVN_N2, A0 => D0, A1 => LD, A2 => UQVN_N9);
UQVB_B6 : AND4
	PORT MAP (Z0 => UQVN_N3, A0 => UQVN_N7, A1 => CAI, A2 => EN, 
	A3 => UQVN_N9);
UQVB_B7 : INV
	PORT MAP (ZN0 => UQVN_N9, A0 => CS);
UQVB_B8 : INV
	PORT MAP (ZN0 => UQVN_N7, A0 => LD);
UQVB_B9 : BUF
	PORT MAP (Z0 => Q0, A0 => UQVN_N5);
UQVB_B10 : LXOR2
	PORT MAP (Z0 => UQVN_N10, A0 => UQVN_N1, A1 => UQVN_N6);
UQVB_B11 : OR3
	PORT MAP (Z0 => UQVN_N6, A0 => UQVN_N2, A1 => UQVN_N3, A2 => PS);
UQVB_B12 : INV
	PORT MAP (ZN0 => UQVN_N8, A0 => PS);
END lattice_arch;
-- VHDL netlist for CBD42
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBD42 IS 
    PORT (
        D0 : IN std_logic;
        D1 : IN std_logic;
        CAI : IN std_logic;
        CLK : IN std_logic;
        PS : IN std_logic;
        LD : IN std_logic;
        EN : IN std_logic;
        CS : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBD42;


ARCHITECTURE lattice_arch OF CBD42 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, QI0, QI1, UQVN_N14,
	 UQVN_N15 : std_logic;


  COMPONENT FD11
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD11 use  entity  lattice.FD11(lattice_arch);


  COMPONENT OR3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR3 use  entity  lattice.OR3(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND5 use  entity  lattice.AND5(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


BEGIN

UQVB_B1 : FD11
	PORT MAP (Q0 => QI0, D0 => UQVN_N12, CLK => CLK);
UQVB_B2 : FD11
	PORT MAP (Q0 => QI1, D0 => UQVN_N13, CLK => CLK);
UQVB_B3 : OR3
	PORT MAP (Z0 => UQVN_N8, A0 => UQVN_N6, A1 => UQVN_N4, A2 => PS);
UQVB_B4 : INV
	PORT MAP (ZN0 => UQVN_N14, A0 => QI0);
UQVB_B5 : INV
	PORT MAP (ZN0 => UQVN_N15, A0 => QI1);
UQVB_B6 : AND4
	PORT MAP (Z0 => CAO, A0 => UQVN_N14, A1 => UQVN_N15, A2 => CAI, 
	A3 => EN);
UQVB_B7 : AND4
	PORT MAP (Z0 => UQVN_N1, A0 => QI0, A1 => UQVN_N9, A2 => UQVN_N11, 
	A3 => UQVN_N10);
UQVB_B8 : AND3
	PORT MAP (Z0 => UQVN_N5, A0 => D0, A1 => LD, A2 => UQVN_N11);
UQVB_B9 : AND4
	PORT MAP (Z0 => UQVN_N2, A0 => UQVN_N9, A1 => CAI, A2 => EN, 
	A3 => UQVN_N11);
UQVB_B10 : AND4
	PORT MAP (Z0 => UQVN_N3, A0 => QI1, A1 => UQVN_N9, A2 => UQVN_N11, 
	A3 => UQVN_N10);
UQVB_B11 : AND3
	PORT MAP (Z0 => UQVN_N6, A0 => D1, A1 => LD, A2 => UQVN_N11);
UQVB_B12 : AND5
	PORT MAP (Z0 => UQVN_N4, A0 => UQVN_N14, A1 => CAI, A2 => UQVN_N9, 
	A3 => EN, A4 => UQVN_N11);
UQVB_B13 : INV
	PORT MAP (ZN0 => UQVN_N11, A0 => CS);
UQVB_B14 : BUF
	PORT MAP (Z0 => Q1, A0 => QI1);
UQVB_B15 : BUF
	PORT MAP (Z0 => Q0, A0 => QI0);
UQVB_B16 : LXOR2
	PORT MAP (Z0 => UQVN_N12, A0 => UQVN_N1, A1 => UQVN_N7);
UQVB_B17 : OR3
	PORT MAP (Z0 => UQVN_N7, A0 => UQVN_N5, A1 => UQVN_N2, A2 => PS);
UQVB_B18 : LXOR2
	PORT MAP (Z0 => UQVN_N13, A0 => UQVN_N3, A1 => UQVN_N8);
UQVB_B19 : INV
	PORT MAP (ZN0 => UQVN_N9, A0 => LD);
UQVB_B20 : INV
	PORT MAP (ZN0 => UQVN_N10, A0 => PS);
END lattice_arch;
-- VHDL netlist for CBD44
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBD44 IS 
    PORT (
        D0 : IN std_logic;
        D1 : IN std_logic;
        D2 : IN std_logic;
        D3 : IN std_logic;
        CAI : IN std_logic;
        CLK : IN std_logic;
        PS : IN std_logic;
        LD : IN std_logic;
        EN : IN std_logic;
        CS : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBD44;


ARCHITECTURE lattice_arch OF CBD44 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, UQVN_N23, QI0,
	 QI1, QI2, QI3, UQVN_N24,
	 UQVN_N25, UQVN_N26, UQVN_N27 : std_logic;


  COMPONENT FD11
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD11 use  entity  lattice.FD11(lattice_arch);


  COMPONENT OR3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR3 use  entity  lattice.OR3(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND5 use  entity  lattice.AND5(lattice_arch);


  COMPONENT AND6
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND6 use  entity  lattice.AND6(lattice_arch);


  COMPONENT AND7
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND7 use  entity  lattice.AND7(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


BEGIN

UQVB_B1 : FD11
	PORT MAP (Q0 => QI0, D0 => UQVN_N20, CLK => CLK);
UQVB_B2 : FD11
	PORT MAP (Q0 => QI1, D0 => UQVN_N21, CLK => CLK);
UQVB_B3 : OR3
	PORT MAP (Z0 => UQVN_N10, A0 => UQVN_N6, A1 => UQVN_N4, A2 => PS);
UQVB_B4 : OR3
	PORT MAP (Z0 => UQVN_N12, A0 => UQVN_N7, A1 => UQVN_N13, A2 => PS);
UQVB_B5 : OR3
	PORT MAP (Z0 => UQVN_N15, A0 => UQVN_N8, A1 => UQVN_N16, A2 => PS);
UQVB_B6 : INV
	PORT MAP (ZN0 => UQVN_N24, A0 => QI0);
UQVB_B7 : INV
	PORT MAP (ZN0 => UQVN_N25, A0 => QI1);
UQVB_B8 : INV
	PORT MAP (ZN0 => UQVN_N26, A0 => QI2);
UQVB_B9 : INV
	PORT MAP (ZN0 => UQVN_N27, A0 => QI3);
UQVB_B10 : AND4
	PORT MAP (Z0 => UQVN_N1, A0 => QI0, A1 => UQVN_N17, A2 => UQVN_N19, 
	A3 => UQVN_N18);
UQVB_B11 : AND3
	PORT MAP (Z0 => UQVN_N5, A0 => D0, A1 => LD, A2 => UQVN_N19);
UQVB_B12 : AND4
	PORT MAP (Z0 => UQVN_N2, A0 => UQVN_N17, A1 => CAI, A2 => EN, 
	A3 => UQVN_N19);
UQVB_B13 : AND4
	PORT MAP (Z0 => UQVN_N3, A0 => QI1, A1 => UQVN_N17, A2 => UQVN_N19, 
	A3 => UQVN_N18);
UQVB_B14 : AND3
	PORT MAP (Z0 => UQVN_N6, A0 => D1, A1 => LD, A2 => UQVN_N19);
UQVB_B15 : AND5
	PORT MAP (Z0 => UQVN_N4, A0 => UQVN_N24, A1 => CAI, A2 => UQVN_N17, 
	A3 => EN, A4 => UQVN_N19);
UQVB_B16 : AND3
	PORT MAP (Z0 => UQVN_N7, A0 => D2, A1 => LD, A2 => UQVN_N19);
UQVB_B17 : AND4
	PORT MAP (Z0 => UQVN_N11, A0 => QI2, A1 => UQVN_N17, A2 => UQVN_N18, 
	A3 => UQVN_N19);
UQVB_B18 : AND6
	PORT MAP (Z0 => UQVN_N13, A0 => UQVN_N24, A1 => UQVN_N25, A2 => UQVN_N17, 
	A3 => CAI, A4 => EN, A5 => UQVN_N19);
UQVB_B19 : AND4
	PORT MAP (Z0 => UQVN_N14, A0 => QI3, A1 => UQVN_N17, A2 => UQVN_N18, 
	A3 => UQVN_N19);
UQVB_B20 : AND3
	PORT MAP (Z0 => UQVN_N8, A0 => D3, A1 => LD, A2 => UQVN_N19);
UQVB_B21 : AND7
	PORT MAP (Z0 => UQVN_N16, A0 => UQVN_N24, A1 => UQVN_N25, A2 => UQVN_N26, 
	A3 => UQVN_N17, A4 => CAI, A5 => EN, A6 => UQVN_N19);
UQVB_B22 : AND6
	PORT MAP (Z0 => CAO, A0 => UQVN_N24, A1 => UQVN_N25, A2 => UQVN_N26, 
	A3 => UQVN_N27, A4 => CAI, A5 => EN);
UQVB_B23 : INV
	PORT MAP (ZN0 => UQVN_N19, A0 => CS);
UQVB_B24 : INV
	PORT MAP (ZN0 => UQVN_N18, A0 => PS);
UQVB_B25 : BUF
	PORT MAP (Z0 => Q3, A0 => QI3);
UQVB_B26 : BUF
	PORT MAP (Z0 => Q2, A0 => QI2);
UQVB_B27 : BUF
	PORT MAP (Z0 => Q1, A0 => QI1);
UQVB_B28 : BUF
	PORT MAP (Z0 => Q0, A0 => QI0);
UQVB_B29 : FD11
	PORT MAP (Q0 => QI2, D0 => UQVN_N22, CLK => CLK);
UQVB_B30 : FD11
	PORT MAP (Q0 => QI3, D0 => UQVN_N23, CLK => CLK);
UQVB_B31 : LXOR2
	PORT MAP (Z0 => UQVN_N20, A0 => UQVN_N1, A1 => UQVN_N9);
UQVB_B32 : OR3
	PORT MAP (Z0 => UQVN_N9, A0 => UQVN_N5, A1 => UQVN_N2, A2 => PS);
UQVB_B33 : LXOR2
	PORT MAP (Z0 => UQVN_N21, A0 => UQVN_N3, A1 => UQVN_N10);
UQVB_B34 : INV
	PORT MAP (ZN0 => UQVN_N17, A0 => LD);
UQVB_B35 : LXOR2
	PORT MAP (Z0 => UQVN_N22, A0 => UQVN_N11, A1 => UQVN_N12);
UQVB_B36 : LXOR2
	PORT MAP (Z0 => UQVN_N23, A0 => UQVN_N14, A1 => UQVN_N15);
END lattice_arch;
-- VHDL netlist for CBD48
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBD48 IS 
    PORT (
        D0 : IN std_logic;
        D1 : IN std_logic;
        D2 : IN std_logic;
        D3 : IN std_logic;
        D4 : IN std_logic;
        D5 : IN std_logic;
        D6 : IN std_logic;
        D7 : IN std_logic;
        CAI : IN std_logic;
        CLK : IN std_logic;
        PS : IN std_logic;
        LD : IN std_logic;
        EN : IN std_logic;
        CS : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        Q4 : OUT std_logic;
        Q5 : OUT std_logic;
        Q6 : OUT std_logic;
        Q7 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBD48;


ARCHITECTURE lattice_arch OF CBD48 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, UQVN_N23, UQVN_N24,
	 UQVN_N25, UQVN_N26, UQVN_N27, UQVN_N28,
	 UQVN_N29, UQVN_N30, UQVN_N31, UQVN_N32,
	 UQVN_N33, UQVN_N34, UQVN_N35, UQVN_N36,
	 UQVN_N37, UQVN_N38, UQVN_N39, UQVN_N40,
	 UQVN_N41, UQVN_N42, UQVN_N43, UQVN_N44,
	 UQVN_N45, UQVN_N46, QI0, QI1,
	 QI2, QI3, QI4, QI5,
	 QI6, QI7, UQVN_N47, UQVN_N48,
	 UQVN_N49, UQVN_N50, UQVN_N51, UQVN_N52,
	 UQVN_N53, UQVN_N54 : std_logic;


  COMPONENT FD11
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD11 use  entity  lattice.FD11(lattice_arch);


  COMPONENT OR3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR3 use  entity  lattice.OR3(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND5 use  entity  lattice.AND5(lattice_arch);


  COMPONENT AND6
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND6 use  entity  lattice.AND6(lattice_arch);


  COMPONENT AND7
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND7 use  entity  lattice.AND7(lattice_arch);


  COMPONENT AND10
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        A9 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND10 use  entity  lattice.AND10(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


  COMPONENT AND11
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        A9 : IN std_logic;
        A10 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND11 use  entity  lattice.AND11(lattice_arch);


  COMPONENT AND9
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND9 use  entity  lattice.AND9(lattice_arch);


  COMPONENT AND8
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND8 use  entity  lattice.AND8(lattice_arch);


BEGIN

UQVB_B1 : FD11
	PORT MAP (Q0 => QI0, D0 => UQVN_N20, CLK => CLK);
UQVB_B2 : FD11
	PORT MAP (Q0 => QI1, D0 => UQVN_N21, CLK => CLK);
UQVB_B3 : OR3
	PORT MAP (Z0 => UQVN_N10, A0 => UQVN_N6, A1 => UQVN_N4, A2 => PS);
UQVB_B4 : OR3
	PORT MAP (Z0 => UQVN_N12, A0 => UQVN_N7, A1 => UQVN_N13, A2 => PS);
UQVB_B5 : OR3
	PORT MAP (Z0 => UQVN_N15, A0 => UQVN_N8, A1 => UQVN_N16, A2 => PS);
UQVB_B6 : INV
	PORT MAP (ZN0 => UQVN_N47, A0 => QI0);
UQVB_B7 : INV
	PORT MAP (ZN0 => UQVN_N48, A0 => QI1);
UQVB_B8 : INV
	PORT MAP (ZN0 => UQVN_N49, A0 => QI2);
UQVB_B9 : INV
	PORT MAP (ZN0 => UQVN_N50, A0 => QI3);
UQVB_B10 : AND4
	PORT MAP (Z0 => UQVN_N1, A0 => QI0, A1 => UQVN_N17, A2 => UQVN_N19, 
	A3 => UQVN_N18);
UQVB_B11 : AND3
	PORT MAP (Z0 => UQVN_N5, A0 => D0, A1 => LD, A2 => UQVN_N19);
UQVB_B12 : AND4
	PORT MAP (Z0 => UQVN_N2, A0 => UQVN_N17, A1 => CAI, A2 => EN, 
	A3 => UQVN_N19);
UQVB_B13 : AND4
	PORT MAP (Z0 => UQVN_N3, A0 => QI1, A1 => UQVN_N17, A2 => UQVN_N19, 
	A3 => UQVN_N18);
UQVB_B14 : AND3
	PORT MAP (Z0 => UQVN_N6, A0 => D1, A1 => LD, A2 => UQVN_N19);
UQVB_B15 : AND5
	PORT MAP (Z0 => UQVN_N4, A0 => UQVN_N47, A1 => CAI, A2 => UQVN_N17, 
	A3 => EN, A4 => UQVN_N19);
UQVB_B16 : AND3
	PORT MAP (Z0 => UQVN_N7, A0 => D2, A1 => LD, A2 => UQVN_N19);
UQVB_B17 : AND4
	PORT MAP (Z0 => UQVN_N11, A0 => QI2, A1 => UQVN_N17, A2 => UQVN_N18, 
	A3 => UQVN_N19);
UQVB_B18 : AND6
	PORT MAP (Z0 => UQVN_N13, A0 => UQVN_N47, A1 => UQVN_N48, A2 => UQVN_N17, 
	A3 => CAI, A4 => EN, A5 => UQVN_N19);
UQVB_B19 : AND4
	PORT MAP (Z0 => UQVN_N14, A0 => QI3, A1 => UQVN_N17, A2 => UQVN_N18, 
	A3 => UQVN_N19);
UQVB_B20 : AND3
	PORT MAP (Z0 => UQVN_N8, A0 => D3, A1 => LD, A2 => UQVN_N19);
UQVB_B21 : AND7
	PORT MAP (Z0 => UQVN_N16, A0 => UQVN_N47, A1 => UQVN_N48, A2 => UQVN_N49, 
	A3 => UQVN_N17, A4 => CAI, A5 => EN, A6 => UQVN_N19);
UQVB_B22 : INV
	PORT MAP (ZN0 => UQVN_N19, A0 => CS);
UQVB_B23 : INV
	PORT MAP (ZN0 => UQVN_N18, A0 => PS);
UQVB_B24 : AND10
	PORT MAP (Z0 => CAO, A0 => UQVN_N47, A1 => UQVN_N48, A2 => UQVN_N49, 
	A3 => UQVN_N50, A4 => UQVN_N51, A5 => UQVN_N52, A6 => UQVN_N53, 
	A7 => UQVN_N54, A8 => CAI, A9 => EN);
UQVB_B25 : BUF
	PORT MAP (Z0 => Q7, A0 => QI7);
UQVB_B26 : BUF
	PORT MAP (Z0 => Q6, A0 => QI6);
UQVB_B27 : BUF
	PORT MAP (Z0 => Q5, A0 => QI5);
UQVB_B28 : BUF
	PORT MAP (Z0 => Q4, A0 => QI4);
UQVB_B29 : BUF
	PORT MAP (Z0 => Q3, A0 => QI3);
UQVB_B30 : BUF
	PORT MAP (Z0 => Q2, A0 => QI2);
UQVB_B31 : BUF
	PORT MAP (Z0 => Q1, A0 => QI1);
UQVB_B32 : BUF
	PORT MAP (Z0 => Q0, A0 => QI0);
UQVB_B33 : FD11
	PORT MAP (Q0 => QI2, D0 => UQVN_N22, CLK => CLK);
UQVB_B34 : FD11
	PORT MAP (Q0 => QI3, D0 => UQVN_N23, CLK => CLK);
UQVB_B35 : LXOR2
	PORT MAP (Z0 => UQVN_N20, A0 => UQVN_N1, A1 => UQVN_N9);
UQVB_B36 : OR3
	PORT MAP (Z0 => UQVN_N9, A0 => UQVN_N5, A1 => UQVN_N2, A2 => PS);
UQVB_B37 : LXOR2
	PORT MAP (Z0 => UQVN_N21, A0 => UQVN_N3, A1 => UQVN_N10);
UQVB_B38 : INV
	PORT MAP (ZN0 => UQVN_N17, A0 => LD);
UQVB_B39 : LXOR2
	PORT MAP (Z0 => UQVN_N22, A0 => UQVN_N11, A1 => UQVN_N12);
UQVB_B40 : LXOR2
	PORT MAP (Z0 => UQVN_N23, A0 => UQVN_N14, A1 => UQVN_N15);
UQVB_B41 : OR3
	PORT MAP (Z0 => UQVN_N28, A0 => UQVN_N30, A1 => UQVN_N31, A2 => PS);
UQVB_B42 : OR3
	PORT MAP (Z0 => UQVN_N32, A0 => UQVN_N34, A1 => UQVN_N35, A2 => PS);
UQVB_B43 : OR3
	PORT MAP (Z0 => UQVN_N38, A0 => UQVN_N36, A1 => UQVN_N24, A2 => PS);
UQVB_B44 : OR3
	PORT MAP (Z0 => UQVN_N41, A0 => UQVN_N26, A1 => UQVN_N25, A2 => PS);
UQVB_B45 : INV
	PORT MAP (ZN0 => UQVN_N51, A0 => QI4);
UQVB_B46 : INV
	PORT MAP (ZN0 => UQVN_N52, A0 => QI5);
UQVB_B47 : INV
	PORT MAP (ZN0 => UQVN_N53, A0 => QI6);
UQVB_B48 : INV
	PORT MAP (ZN0 => UQVN_N54, A0 => QI7);
UQVB_B49 : AND4
	PORT MAP (Z0 => UQVN_N29, A0 => QI4, A1 => UQVN_N27, A2 => UQVN_N39, 
	A3 => UQVN_N40);
UQVB_B50 : AND3
	PORT MAP (Z0 => UQVN_N30, A0 => D4, A1 => LD, A2 => UQVN_N40);
UQVB_B51 : AND4
	PORT MAP (Z0 => UQVN_N33, A0 => QI5, A1 => UQVN_N27, A2 => UQVN_N39, 
	A3 => UQVN_N40);
UQVB_B52 : AND3
	PORT MAP (Z0 => UQVN_N34, A0 => D5, A1 => LD, A2 => UQVN_N40);
UQVB_B53 : AND4
	PORT MAP (Z0 => UQVN_N37, A0 => QI6, A1 => UQVN_N27, A2 => UQVN_N39, 
	A3 => UQVN_N40);
UQVB_B54 : AND3
	PORT MAP (Z0 => UQVN_N36, A0 => D6, A1 => LD, A2 => UQVN_N40);
UQVB_B55 : AND4
	PORT MAP (Z0 => UQVN_N42, A0 => QI7, A1 => UQVN_N27, A2 => UQVN_N39, 
	A3 => UQVN_N40);
UQVB_B56 : AND3
	PORT MAP (Z0 => UQVN_N26, A0 => D7, A1 => LD, A2 => UQVN_N40);
UQVB_B57 : AND11
	PORT MAP (Z0 => UQVN_N25, A0 => UQVN_N47, A1 => UQVN_N48, A2 => UQVN_N49, 
	A3 => UQVN_N50, A4 => UQVN_N51, A5 => UQVN_N52, A6 => UQVN_N53, 
	A7 => UQVN_N27, A8 => CAI, A9 => EN, A10 => UQVN_N40);
UQVB_B58 : AND10
	PORT MAP (Z0 => UQVN_N24, A0 => UQVN_N47, A1 => UQVN_N48, A2 => UQVN_N49, 
	A3 => UQVN_N50, A4 => UQVN_N51, A5 => UQVN_N52, A6 => UQVN_N27, 
	A7 => CAI, A8 => EN, A9 => UQVN_N40);
UQVB_B59 : AND9
	PORT MAP (Z0 => UQVN_N35, A0 => UQVN_N47, A1 => UQVN_N48, A2 => UQVN_N49, 
	A3 => UQVN_N50, A4 => UQVN_N51, A5 => UQVN_N27, A6 => CAI, 
	A7 => EN, A8 => UQVN_N40);
UQVB_B60 : AND8
	PORT MAP (Z0 => UQVN_N31, A0 => UQVN_N47, A1 => UQVN_N48, A2 => UQVN_N49, 
	A3 => UQVN_N50, A4 => UQVN_N27, A5 => CAI, A6 => EN, 
	A7 => UQVN_N40);
UQVB_B61 : INV
	PORT MAP (ZN0 => UQVN_N40, A0 => CS);
UQVB_B62 : INV
	PORT MAP (ZN0 => UQVN_N39, A0 => PS);
UQVB_B63 : INV
	PORT MAP (ZN0 => UQVN_N27, A0 => LD);
UQVB_B64 : LXOR2
	PORT MAP (Z0 => UQVN_N43, A0 => UQVN_N29, A1 => UQVN_N28);
UQVB_B65 : FD11
	PORT MAP (Q0 => QI4, D0 => UQVN_N43, CLK => CLK);
UQVB_B66 : LXOR2
	PORT MAP (Z0 => UQVN_N44, A0 => UQVN_N33, A1 => UQVN_N32);
UQVB_B67 : FD11
	PORT MAP (Q0 => QI5, D0 => UQVN_N44, CLK => CLK);
UQVB_B68 : FD11
	PORT MAP (Q0 => QI6, D0 => UQVN_N45, CLK => CLK);
UQVB_B69 : LXOR2
	PORT MAP (Z0 => UQVN_N45, A0 => UQVN_N37, A1 => UQVN_N38);
UQVB_B70 : LXOR2
	PORT MAP (Z0 => UQVN_N46, A0 => UQVN_N42, A1 => UQVN_N41);
UQVB_B71 : FD11
	PORT MAP (Q0 => QI7, D0 => UQVN_N46, CLK => CLK);
END lattice_arch;
-- VHDL netlist for CBD516
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBD516 IS 
    PORT (
        CLK : IN std_logic;
        EN : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        Q4 : OUT std_logic;
        Q5 : OUT std_logic;
        Q6 : OUT std_logic;
        Q7 : OUT std_logic;
        Q8 : OUT std_logic;
        Q9 : OUT std_logic;
        Q10 : OUT std_logic;
        Q11 : OUT std_logic;
        Q12 : OUT std_logic;
        Q13 : OUT std_logic;
        Q14 : OUT std_logic;
        Q15 : OUT std_logic
    );
END CBD516;


ARCHITECTURE lattice_arch OF CBD516 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, UQVN_N23, UQVN_N24,
	 UQVN_N25, UQVN_N26, UQVN_N27, UQVN_N28,
	 UQVN_N29, UQVN_N30, UQVN_N31, UQVN_N32,
	 UQVN_N33, UQVN_N34, QI0, QI1,
	 QI10, QI11, QI12, QI13,
	 QI14, QI15, QI2, QI3,
	 QI4, QI5, QI6, QI7,
	 QI8, QI9, UQVN_N35, UQVN_N36,
	 UQVN_N37, UQVN_N38, UQVN_N39, UQVN_N40,
	 UQVN_N41, UQVN_N42, UQVN_N43, UQVN_N44,
	 UQVN_N45, UQVN_N46, UQVN_N47, UQVN_N48,
	 UQVN_N49 : std_logic;


  COMPONENT FD21
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD21 use  entity  lattice.FD21(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND5 use  entity  lattice.AND5(lattice_arch);


  COMPONENT AND6
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND6 use  entity  lattice.AND6(lattice_arch);


  COMPONENT AND7
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND7 use  entity  lattice.AND7(lattice_arch);


  COMPONENT AND8
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND8 use  entity  lattice.AND8(lattice_arch);


  COMPONENT AND9
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND9 use  entity  lattice.AND9(lattice_arch);


  COMPONENT AND10
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        A9 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND10 use  entity  lattice.AND10(lattice_arch);


  COMPONENT AND11
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        A9 : IN std_logic;
        A10 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND11 use  entity  lattice.AND11(lattice_arch);


  COMPONENT AND12
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        A9 : IN std_logic;
        A10 : IN std_logic;
        A11 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND12 use  entity  lattice.AND12(lattice_arch);


  COMPONENT AND16
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        A9 : IN std_logic;
        A10 : IN std_logic;
        A11 : IN std_logic;
        A12 : IN std_logic;
        A13 : IN std_logic;
        A14 : IN std_logic;
        A15 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND16 use  entity  lattice.AND16(lattice_arch);


BEGIN

UQVB_B1 : FD21
	PORT MAP (Q0 => QI0, D0 => UQVN_N1, CLK => CLK, CD => CD);
UQVB_B2 : AND4
	PORT MAP (Z0 => UQVN_N7, A0 => UQVN_N35, A1 => UQVN_N36, A2 => UQVN_N42, 
	A3 => EN);
UQVB_B3 : INV
	PORT MAP (ZN0 => UQVN_N35, A0 => QI0);
UQVB_B4 : INV
	PORT MAP (ZN0 => UQVN_N36, A0 => QI1);
UQVB_B5 : INV
	PORT MAP (ZN0 => UQVN_N42, A0 => QI2);
UQVB_B6 : INV
	PORT MAP (ZN0 => UQVN_N43, A0 => QI3);
UQVB_B7 : LXOR2
	PORT MAP (Z0 => UQVN_N1, A0 => QI0, A1 => EN);
UQVB_B8 : LXOR2
	PORT MAP (Z0 => UQVN_N2, A0 => QI1, A1 => UQVN_N5);
UQVB_B9 : LXOR2
	PORT MAP (Z0 => UQVN_N3, A0 => QI2, A1 => UQVN_N6);
UQVB_B10 : FD21
	PORT MAP (Q0 => QI1, D0 => UQVN_N2, CLK => CLK, CD => CD);
UQVB_B11 : LXOR2
	PORT MAP (Z0 => UQVN_N4, A0 => QI3, A1 => UQVN_N7);
UQVB_B12 : BUF
	PORT MAP (Z0 => Q15, A0 => QI15);
UQVB_B13 : BUF
	PORT MAP (Z0 => Q14, A0 => QI14);
UQVB_B14 : BUF
	PORT MAP (Z0 => Q13, A0 => QI13);
UQVB_B15 : BUF
	PORT MAP (Z0 => Q12, A0 => QI12);
UQVB_B16 : BUF
	PORT MAP (Z0 => Q11, A0 => QI11);
UQVB_B17 : BUF
	PORT MAP (Z0 => Q10, A0 => QI10);
UQVB_B18 : BUF
	PORT MAP (Z0 => Q9, A0 => QI9);
UQVB_B19 : BUF
	PORT MAP (Z0 => Q8, A0 => QI8);
UQVB_B20 : BUF
	PORT MAP (Z0 => Q7, A0 => QI7);
UQVB_B21 : BUF
	PORT MAP (Z0 => Q6, A0 => QI6);
UQVB_B22 : BUF
	PORT MAP (Z0 => Q5, A0 => QI5);
UQVB_B23 : BUF
	PORT MAP (Z0 => Q4, A0 => QI4);
UQVB_B24 : BUF
	PORT MAP (Z0 => Q3, A0 => QI3);
UQVB_B25 : BUF
	PORT MAP (Z0 => Q2, A0 => QI2);
UQVB_B26 : BUF
	PORT MAP (Z0 => Q1, A0 => QI1);
UQVB_B27 : BUF
	PORT MAP (Z0 => Q0, A0 => QI0);
UQVB_B28 : FD21
	PORT MAP (Q0 => QI2, D0 => UQVN_N3, CLK => CLK, CD => CD);
UQVB_B29 : FD21
	PORT MAP (Q0 => QI3, D0 => UQVN_N4, CLK => CLK, CD => CD);
UQVB_B30 : AND2
	PORT MAP (Z0 => UQVN_N5, A0 => UQVN_N35, A1 => EN);
UQVB_B31 : AND3
	PORT MAP (Z0 => UQVN_N6, A0 => UQVN_N35, A1 => UQVN_N36, A2 => EN);
UQVB_B32 : FD21
	PORT MAP (Q0 => QI5, D0 => UQVN_N8, CLK => CLK, CD => CD);
UQVB_B33 : FD21
	PORT MAP (Q0 => QI6, D0 => UQVN_N10, CLK => CLK, CD => CD);
UQVB_B34 : FD21
	PORT MAP (Q0 => QI4, D0 => UQVN_N9, CLK => CLK, CD => CD);
UQVB_B35 : LXOR2
	PORT MAP (Z0 => UQVN_N15, A0 => QI7, A1 => UQVN_N13);
UQVB_B36 : LXOR2
	PORT MAP (Z0 => UQVN_N10, A0 => QI6, A1 => UQVN_N12);
UQVB_B37 : LXOR2
	PORT MAP (Z0 => UQVN_N8, A0 => QI5, A1 => UQVN_N11);
UQVB_B38 : LXOR2
	PORT MAP (Z0 => UQVN_N9, A0 => QI4, A1 => UQVN_N14);
UQVB_B39 : AND5
	PORT MAP (Z0 => UQVN_N14, A0 => UQVN_N35, A1 => UQVN_N36, A2 => UQVN_N42, 
	A3 => UQVN_N43, A4 => EN);
UQVB_B40 : FD21
	PORT MAP (Q0 => QI7, D0 => UQVN_N15, CLK => CLK, CD => CD);
UQVB_B41 : AND6
	PORT MAP (Z0 => UQVN_N11, A0 => UQVN_N35, A1 => UQVN_N36, A2 => UQVN_N42, 
	A3 => UQVN_N43, A4 => UQVN_N44, A5 => EN);
UQVB_B42 : AND7
	PORT MAP (Z0 => UQVN_N12, A0 => UQVN_N35, A1 => UQVN_N36, A2 => UQVN_N42, 
	A3 => UQVN_N43, A4 => UQVN_N44, A5 => UQVN_N45, A6 => EN);
UQVB_B43 : AND8
	PORT MAP (Z0 => UQVN_N13, A0 => UQVN_N35, A1 => UQVN_N36, A2 => UQVN_N42, 
	A3 => UQVN_N43, A4 => UQVN_N44, A5 => UQVN_N45, A6 => UQVN_N46, 
	A7 => EN);
UQVB_B44 : INV
	PORT MAP (ZN0 => UQVN_N44, A0 => QI4);
UQVB_B45 : INV
	PORT MAP (ZN0 => UQVN_N45, A0 => QI5);
UQVB_B46 : INV
	PORT MAP (ZN0 => UQVN_N46, A0 => QI6);
UQVB_B47 : INV
	PORT MAP (ZN0 => UQVN_N47, A0 => QI7);
UQVB_B48 : FD21
	PORT MAP (Q0 => QI8, D0 => UQVN_N21, CLK => CLK, CD => CD);
UQVB_B49 : FD21
	PORT MAP (Q0 => QI10, D0 => UQVN_N20, CLK => CLK, CD => CD);
UQVB_B50 : FD21
	PORT MAP (Q0 => QI9, D0 => UQVN_N22, CLK => CLK, CD => CD);
UQVB_B51 : FD21
	PORT MAP (Q0 => QI11, D0 => UQVN_N23, CLK => CLK, CD => CD);
UQVB_B52 : LXOR2
	PORT MAP (Z0 => UQVN_N21, A0 => QI8, A1 => UQVN_N16);
UQVB_B53 : LXOR2
	PORT MAP (Z0 => UQVN_N22, A0 => QI9, A1 => UQVN_N19);
UQVB_B54 : AND9
	PORT MAP (Z0 => UQVN_N16, A0 => UQVN_N35, A1 => UQVN_N36, A2 => UQVN_N42, 
	A3 => UQVN_N43, A4 => UQVN_N44, A5 => UQVN_N45, A6 => UQVN_N46, 
	A7 => UQVN_N47, A8 => EN);
UQVB_B55 : LXOR2
	PORT MAP (Z0 => UQVN_N20, A0 => QI10, A1 => UQVN_N18);
UQVB_B56 : AND10
	PORT MAP (Z0 => UQVN_N19, A0 => UQVN_N35, A1 => UQVN_N36, A2 => UQVN_N42, 
	A3 => UQVN_N43, A4 => UQVN_N44, A5 => UQVN_N45, A6 => UQVN_N46, 
	A7 => UQVN_N47, A8 => UQVN_N48, A9 => EN);
UQVB_B57 : AND11
	PORT MAP (Z0 => UQVN_N18, A0 => UQVN_N35, A1 => UQVN_N36, A2 => UQVN_N42, 
	A3 => UQVN_N43, A4 => UQVN_N44, A5 => UQVN_N45, A6 => UQVN_N46, 
	A7 => UQVN_N47, A8 => UQVN_N48, A9 => UQVN_N49, A10 => EN);
UQVB_B58 : LXOR2
	PORT MAP (Z0 => UQVN_N23, A0 => QI11, A1 => UQVN_N17);
UQVB_B59 : AND12
	PORT MAP (Z0 => UQVN_N17, A0 => UQVN_N35, A1 => UQVN_N36, A2 => UQVN_N42, 
	A3 => UQVN_N43, A4 => UQVN_N44, A5 => UQVN_N45, A6 => UQVN_N46, 
	A7 => UQVN_N47, A8 => UQVN_N48, A9 => UQVN_N49, A10 => UQVN_N37, 
	A11 => EN);
UQVB_B60 : INV
	PORT MAP (ZN0 => UQVN_N48, A0 => QI8);
UQVB_B61 : INV
	PORT MAP (ZN0 => UQVN_N49, A0 => QI9);
UQVB_B62 : INV
	PORT MAP (ZN0 => UQVN_N37, A0 => QI10);
UQVB_B63 : INV
	PORT MAP (ZN0 => UQVN_N38, A0 => QI11);
UQVB_B64 : INV
	PORT MAP (ZN0 => UQVN_N41, A0 => QI14);
UQVB_B65 : LXOR2
	PORT MAP (Z0 => UQVN_N26, A0 => QI14, A1 => UQVN_N25);
UQVB_B66 : FD21
	PORT MAP (Q0 => QI15, D0 => UQVN_N32, CLK => CLK, CD => CD);
UQVB_B67 : FD21
	PORT MAP (Q0 => QI13, D0 => UQVN_N28, CLK => CLK, CD => CD);
UQVB_B68 : FD21
	PORT MAP (Q0 => QI12, D0 => UQVN_N29, CLK => CLK, CD => CD);
UQVB_B69 : LXOR2
	PORT MAP (Z0 => UQVN_N28, A0 => QI13, A1 => UQVN_N30);
UQVB_B70 : LXOR2
	PORT MAP (Z0 => UQVN_N29, A0 => QI12, A1 => UQVN_N27);
UQVB_B71 : FD21
	PORT MAP (Q0 => QI14, D0 => UQVN_N26, CLK => CLK, CD => CD);
UQVB_B72 : LXOR2
	PORT MAP (Z0 => UQVN_N32, A0 => QI15, A1 => UQVN_N24);
UQVB_B73 : AND12
	PORT MAP (Z0 => UQVN_N31, A0 => UQVN_N35, A1 => UQVN_N36, A2 => UQVN_N42, 
	A3 => UQVN_N43, A4 => UQVN_N44, A5 => UQVN_N45, A6 => UQVN_N46, 
	A7 => UQVN_N47, A8 => UQVN_N48, A9 => UQVN_N49, A10 => UQVN_N37, 
	A11 => UQVN_N38);
UQVB_B74 : AND2
	PORT MAP (Z0 => UQVN_N27, A0 => UQVN_N31, A1 => EN);
UQVB_B75 : AND12
	PORT MAP (Z0 => UQVN_N33, A0 => UQVN_N35, A1 => UQVN_N36, A2 => UQVN_N42, 
	A3 => UQVN_N43, A4 => UQVN_N44, A5 => UQVN_N45, A6 => UQVN_N46, 
	A7 => UQVN_N47, A8 => UQVN_N48, A9 => UQVN_N49, A10 => UQVN_N37, 
	A11 => UQVN_N38);
UQVB_B76 : AND3
	PORT MAP (Z0 => UQVN_N30, A0 => UQVN_N33, A1 => UQVN_N39, A2 => EN);
UQVB_B77 : AND12
	PORT MAP (Z0 => UQVN_N34, A0 => UQVN_N35, A1 => UQVN_N36, A2 => UQVN_N42, 
	A3 => UQVN_N43, A4 => UQVN_N44, A5 => UQVN_N45, A6 => UQVN_N46, 
	A7 => UQVN_N47, A8 => UQVN_N48, A9 => UQVN_N49, A10 => UQVN_N37, 
	A11 => UQVN_N38);
UQVB_B78 : AND4
	PORT MAP (Z0 => UQVN_N25, A0 => UQVN_N34, A1 => UQVN_N39, A2 => UQVN_N40, 
	A3 => EN);
UQVB_B79 : AND16
	PORT MAP (Z0 => UQVN_N24, A0 => UQVN_N35, A1 => UQVN_N36, A2 => UQVN_N42, 
	A3 => UQVN_N43, A4 => UQVN_N44, A5 => UQVN_N45, A6 => UQVN_N46, 
	A7 => UQVN_N47, A8 => UQVN_N48, A9 => UQVN_N49, A10 => UQVN_N37, 
	A11 => UQVN_N38, A12 => UQVN_N39, A13 => UQVN_N40, A14 => UQVN_N41, 
	A15 => EN);
UQVB_B80 : INV
	PORT MAP (ZN0 => UQVN_N39, A0 => QI12);
UQVB_B81 : INV
	PORT MAP (ZN0 => UQVN_N40, A0 => QI13);
END lattice_arch;
-- VHDL netlist for CBD616
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBD616 IS 
    PORT (
        CLK : IN std_logic;
        EN : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        Q4 : OUT std_logic;
        Q5 : OUT std_logic;
        Q6 : OUT std_logic;
        Q7 : OUT std_logic;
        Q8 : OUT std_logic;
        Q9 : OUT std_logic;
        Q10 : OUT std_logic;
        Q11 : OUT std_logic;
        Q12 : OUT std_logic;
        Q13 : OUT std_logic;
        Q14 : OUT std_logic;
        Q15 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBD616;


ARCHITECTURE lattice_arch OF CBD616 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, UQVN_N23, UQVN_N24,
	 UQVN_N25, UQVN_N26, UQVN_N27, UQVN_N28,
	 UQVN_N29, UQVN_N30, UQVN_N31, UQVN_N32,
	 UQVN_N33, UQVN_N34, UQVN_N35, QI0,
	 QI1, QI10, QI11, QI12,
	 QI13, QI14, QI15, QI2,
	 QI3, QI4, QI5, QI6,
	 QI7, QI8, QI9, UQVN_N36,
	 UQVN_N37, UQVN_N38, UQVN_N39, UQVN_N40,
	 UQVN_N41, UQVN_N42, UQVN_N43, UQVN_N44,
	 UQVN_N45, UQVN_N46, UQVN_N47, UQVN_N48,
	 UQVN_N49, UQVN_N50, UQVN_N51 : std_logic;


  COMPONENT FD21
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD21 use  entity  lattice.FD21(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


  COMPONENT AND16
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        A9 : IN std_logic;
        A10 : IN std_logic;
        A11 : IN std_logic;
        A12 : IN std_logic;
        A13 : IN std_logic;
        A14 : IN std_logic;
        A15 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND16 use  entity  lattice.AND16(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND5 use  entity  lattice.AND5(lattice_arch);


  COMPONENT AND6
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND6 use  entity  lattice.AND6(lattice_arch);


  COMPONENT AND7
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND7 use  entity  lattice.AND7(lattice_arch);


  COMPONENT AND8
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND8 use  entity  lattice.AND8(lattice_arch);


  COMPONENT AND9
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND9 use  entity  lattice.AND9(lattice_arch);


  COMPONENT AND10
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        A9 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND10 use  entity  lattice.AND10(lattice_arch);


  COMPONENT AND11
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        A9 : IN std_logic;
        A10 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND11 use  entity  lattice.AND11(lattice_arch);


  COMPONENT AND12
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        A9 : IN std_logic;
        A10 : IN std_logic;
        A11 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND12 use  entity  lattice.AND12(lattice_arch);


BEGIN

UQVB_B1 : FD21
	PORT MAP (Q0 => QI0, D0 => UQVN_N2, CLK => CLK, CD => CD);
UQVB_B2 : AND4
	PORT MAP (Z0 => UQVN_N8, A0 => UQVN_N36, A1 => UQVN_N37, A2 => UQVN_N44, 
	A3 => EN);
UQVB_B3 : INV
	PORT MAP (ZN0 => UQVN_N36, A0 => QI0);
UQVB_B4 : INV
	PORT MAP (ZN0 => UQVN_N37, A0 => QI1);
UQVB_B5 : INV
	PORT MAP (ZN0 => UQVN_N44, A0 => QI2);
UQVB_B6 : INV
	PORT MAP (ZN0 => UQVN_N45, A0 => QI3);
UQVB_B7 : AND2
	PORT MAP (Z0 => CAO, A0 => UQVN_N1, A1 => EN);
UQVB_B8 : LXOR2
	PORT MAP (Z0 => UQVN_N2, A0 => QI0, A1 => EN);
UQVB_B9 : AND16
	PORT MAP (Z0 => UQVN_N1, A0 => UQVN_N36, A1 => UQVN_N37, A2 => UQVN_N44, 
	A3 => UQVN_N45, A4 => UQVN_N46, A5 => UQVN_N47, A6 => UQVN_N48, 
	A7 => UQVN_N49, A8 => UQVN_N50, A9 => UQVN_N51, A10 => UQVN_N38, 
	A11 => UQVN_N39, A12 => UQVN_N40, A13 => UQVN_N41, A14 => UQVN_N42, 
	A15 => UQVN_N43);
UQVB_B10 : LXOR2
	PORT MAP (Z0 => UQVN_N3, A0 => QI1, A1 => UQVN_N6);
UQVB_B11 : LXOR2
	PORT MAP (Z0 => UQVN_N4, A0 => QI2, A1 => UQVN_N7);
UQVB_B12 : FD21
	PORT MAP (Q0 => QI1, D0 => UQVN_N3, CLK => CLK, CD => CD);
UQVB_B13 : LXOR2
	PORT MAP (Z0 => UQVN_N5, A0 => QI3, A1 => UQVN_N8);
UQVB_B14 : BUF
	PORT MAP (Z0 => Q15, A0 => QI15);
UQVB_B15 : BUF
	PORT MAP (Z0 => Q14, A0 => QI14);
UQVB_B16 : BUF
	PORT MAP (Z0 => Q13, A0 => QI13);
UQVB_B17 : BUF
	PORT MAP (Z0 => Q12, A0 => QI12);
UQVB_B18 : BUF
	PORT MAP (Z0 => Q11, A0 => QI11);
UQVB_B19 : BUF
	PORT MAP (Z0 => Q10, A0 => QI10);
UQVB_B20 : BUF
	PORT MAP (Z0 => Q9, A0 => QI9);
UQVB_B21 : BUF
	PORT MAP (Z0 => Q8, A0 => QI8);
UQVB_B22 : BUF
	PORT MAP (Z0 => Q7, A0 => QI7);
UQVB_B23 : BUF
	PORT MAP (Z0 => Q6, A0 => QI6);
UQVB_B24 : BUF
	PORT MAP (Z0 => Q5, A0 => QI5);
UQVB_B25 : BUF
	PORT MAP (Z0 => Q4, A0 => QI4);
UQVB_B26 : BUF
	PORT MAP (Z0 => Q3, A0 => QI3);
UQVB_B27 : BUF
	PORT MAP (Z0 => Q2, A0 => QI2);
UQVB_B28 : BUF
	PORT MAP (Z0 => Q1, A0 => QI1);
UQVB_B29 : BUF
	PORT MAP (Z0 => Q0, A0 => QI0);
UQVB_B30 : FD21
	PORT MAP (Q0 => QI2, D0 => UQVN_N4, CLK => CLK, CD => CD);
UQVB_B31 : FD21
	PORT MAP (Q0 => QI3, D0 => UQVN_N5, CLK => CLK, CD => CD);
UQVB_B32 : AND2
	PORT MAP (Z0 => UQVN_N6, A0 => UQVN_N36, A1 => EN);
UQVB_B33 : AND3
	PORT MAP (Z0 => UQVN_N7, A0 => UQVN_N36, A1 => UQVN_N37, A2 => EN);
UQVB_B34 : FD21
	PORT MAP (Q0 => QI5, D0 => UQVN_N9, CLK => CLK, CD => CD);
UQVB_B35 : FD21
	PORT MAP (Q0 => QI6, D0 => UQVN_N11, CLK => CLK, CD => CD);
UQVB_B36 : FD21
	PORT MAP (Q0 => QI4, D0 => UQVN_N10, CLK => CLK, CD => CD);
UQVB_B37 : LXOR2
	PORT MAP (Z0 => UQVN_N16, A0 => QI7, A1 => UQVN_N14);
UQVB_B38 : LXOR2
	PORT MAP (Z0 => UQVN_N11, A0 => QI6, A1 => UQVN_N13);
UQVB_B39 : LXOR2
	PORT MAP (Z0 => UQVN_N9, A0 => QI5, A1 => UQVN_N12);
UQVB_B40 : LXOR2
	PORT MAP (Z0 => UQVN_N10, A0 => QI4, A1 => UQVN_N15);
UQVB_B41 : AND5
	PORT MAP (Z0 => UQVN_N15, A0 => UQVN_N36, A1 => UQVN_N37, A2 => UQVN_N44, 
	A3 => UQVN_N45, A4 => EN);
UQVB_B42 : FD21
	PORT MAP (Q0 => QI7, D0 => UQVN_N16, CLK => CLK, CD => CD);
UQVB_B43 : AND6
	PORT MAP (Z0 => UQVN_N12, A0 => UQVN_N36, A1 => UQVN_N37, A2 => UQVN_N44, 
	A3 => UQVN_N45, A4 => UQVN_N46, A5 => EN);
UQVB_B44 : AND7
	PORT MAP (Z0 => UQVN_N13, A0 => UQVN_N36, A1 => UQVN_N37, A2 => UQVN_N44, 
	A3 => UQVN_N45, A4 => UQVN_N46, A5 => UQVN_N47, A6 => EN);
UQVB_B45 : AND8
	PORT MAP (Z0 => UQVN_N14, A0 => UQVN_N36, A1 => UQVN_N37, A2 => UQVN_N44, 
	A3 => UQVN_N45, A4 => UQVN_N46, A5 => UQVN_N47, A6 => UQVN_N48, 
	A7 => EN);
UQVB_B46 : INV
	PORT MAP (ZN0 => UQVN_N46, A0 => QI4);
UQVB_B47 : INV
	PORT MAP (ZN0 => UQVN_N47, A0 => QI5);
UQVB_B48 : INV
	PORT MAP (ZN0 => UQVN_N48, A0 => QI6);
UQVB_B49 : INV
	PORT MAP (ZN0 => UQVN_N49, A0 => QI7);
UQVB_B50 : FD21
	PORT MAP (Q0 => QI8, D0 => UQVN_N22, CLK => CLK, CD => CD);
UQVB_B51 : FD21
	PORT MAP (Q0 => QI10, D0 => UQVN_N21, CLK => CLK, CD => CD);
UQVB_B52 : FD21
	PORT MAP (Q0 => QI9, D0 => UQVN_N23, CLK => CLK, CD => CD);
UQVB_B53 : FD21
	PORT MAP (Q0 => QI11, D0 => UQVN_N24, CLK => CLK, CD => CD);
UQVB_B54 : LXOR2
	PORT MAP (Z0 => UQVN_N22, A0 => QI8, A1 => UQVN_N17);
UQVB_B55 : LXOR2
	PORT MAP (Z0 => UQVN_N23, A0 => QI9, A1 => UQVN_N20);
UQVB_B56 : AND9
	PORT MAP (Z0 => UQVN_N17, A0 => UQVN_N36, A1 => UQVN_N37, A2 => UQVN_N44, 
	A3 => UQVN_N45, A4 => UQVN_N46, A5 => UQVN_N47, A6 => UQVN_N48, 
	A7 => UQVN_N49, A8 => EN);
UQVB_B57 : LXOR2
	PORT MAP (Z0 => UQVN_N21, A0 => QI10, A1 => UQVN_N19);
UQVB_B58 : AND10
	PORT MAP (Z0 => UQVN_N20, A0 => UQVN_N36, A1 => UQVN_N37, A2 => UQVN_N44, 
	A3 => UQVN_N45, A4 => UQVN_N46, A5 => UQVN_N47, A6 => UQVN_N48, 
	A7 => UQVN_N49, A8 => UQVN_N50, A9 => EN);
UQVB_B59 : AND11
	PORT MAP (Z0 => UQVN_N19, A0 => UQVN_N36, A1 => UQVN_N37, A2 => UQVN_N44, 
	A3 => UQVN_N45, A4 => UQVN_N46, A5 => UQVN_N47, A6 => UQVN_N48, 
	A7 => UQVN_N49, A8 => UQVN_N50, A9 => UQVN_N51, A10 => EN);
UQVB_B60 : LXOR2
	PORT MAP (Z0 => UQVN_N24, A0 => QI11, A1 => UQVN_N18);
UQVB_B61 : AND12
	PORT MAP (Z0 => UQVN_N18, A0 => UQVN_N36, A1 => UQVN_N37, A2 => UQVN_N44, 
	A3 => UQVN_N45, A4 => UQVN_N46, A5 => UQVN_N47, A6 => UQVN_N48, 
	A7 => UQVN_N49, A8 => UQVN_N50, A9 => UQVN_N51, A10 => UQVN_N38, 
	A11 => EN);
UQVB_B62 : INV
	PORT MAP (ZN0 => UQVN_N50, A0 => QI8);
UQVB_B63 : INV
	PORT MAP (ZN0 => UQVN_N51, A0 => QI9);
UQVB_B64 : INV
	PORT MAP (ZN0 => UQVN_N38, A0 => QI10);
UQVB_B65 : INV
	PORT MAP (ZN0 => UQVN_N39, A0 => QI11);
UQVB_B66 : INV
	PORT MAP (ZN0 => UQVN_N42, A0 => QI14);
UQVB_B67 : LXOR2
	PORT MAP (Z0 => UQVN_N27, A0 => QI14, A1 => UQVN_N26);
UQVB_B68 : INV
	PORT MAP (ZN0 => UQVN_N43, A0 => QI15);
UQVB_B69 : FD21
	PORT MAP (Q0 => QI15, D0 => UQVN_N33, CLK => CLK, CD => CD);
UQVB_B70 : FD21
	PORT MAP (Q0 => QI13, D0 => UQVN_N29, CLK => CLK, CD => CD);
UQVB_B71 : FD21
	PORT MAP (Q0 => QI12, D0 => UQVN_N30, CLK => CLK, CD => CD);
UQVB_B72 : LXOR2
	PORT MAP (Z0 => UQVN_N29, A0 => QI13, A1 => UQVN_N31);
UQVB_B73 : LXOR2
	PORT MAP (Z0 => UQVN_N30, A0 => QI12, A1 => UQVN_N28);
UQVB_B74 : FD21
	PORT MAP (Q0 => QI14, D0 => UQVN_N27, CLK => CLK, CD => CD);
UQVB_B75 : LXOR2
	PORT MAP (Z0 => UQVN_N33, A0 => QI15, A1 => UQVN_N25);
UQVB_B76 : AND12
	PORT MAP (Z0 => UQVN_N32, A0 => UQVN_N36, A1 => UQVN_N37, A2 => UQVN_N44, 
	A3 => UQVN_N45, A4 => UQVN_N46, A5 => UQVN_N47, A6 => UQVN_N48, 
	A7 => UQVN_N49, A8 => UQVN_N50, A9 => UQVN_N51, A10 => UQVN_N38, 
	A11 => UQVN_N39);
UQVB_B77 : AND2
	PORT MAP (Z0 => UQVN_N28, A0 => UQVN_N32, A1 => EN);
UQVB_B78 : AND12
	PORT MAP (Z0 => UQVN_N34, A0 => UQVN_N36, A1 => UQVN_N37, A2 => UQVN_N44, 
	A3 => UQVN_N45, A4 => UQVN_N46, A5 => UQVN_N47, A6 => UQVN_N48, 
	A7 => UQVN_N49, A8 => UQVN_N50, A9 => UQVN_N51, A10 => UQVN_N38, 
	A11 => UQVN_N39);
UQVB_B79 : AND3
	PORT MAP (Z0 => UQVN_N31, A0 => UQVN_N34, A1 => UQVN_N40, A2 => EN);
UQVB_B80 : AND12
	PORT MAP (Z0 => UQVN_N35, A0 => UQVN_N36, A1 => UQVN_N37, A2 => UQVN_N44, 
	A3 => UQVN_N45, A4 => UQVN_N46, A5 => UQVN_N47, A6 => UQVN_N48, 
	A7 => UQVN_N49, A8 => UQVN_N50, A9 => UQVN_N51, A10 => UQVN_N38, 
	A11 => UQVN_N39);
UQVB_B81 : AND4
	PORT MAP (Z0 => UQVN_N26, A0 => UQVN_N35, A1 => UQVN_N40, A2 => UQVN_N41, 
	A3 => EN);
UQVB_B82 : AND16
	PORT MAP (Z0 => UQVN_N25, A0 => UQVN_N36, A1 => UQVN_N37, A2 => UQVN_N44, 
	A3 => UQVN_N45, A4 => UQVN_N46, A5 => UQVN_N47, A6 => UQVN_N48, 
	A7 => UQVN_N49, A8 => UQVN_N50, A9 => UQVN_N51, A10 => UQVN_N38, 
	A11 => UQVN_N39, A12 => UQVN_N40, A13 => UQVN_N41, A14 => UQVN_N42, 
	A15 => EN);
UQVB_B83 : INV
	PORT MAP (ZN0 => UQVN_N40, A0 => QI12);
UQVB_B84 : INV
	PORT MAP (ZN0 => UQVN_N41, A0 => QI13);
END lattice_arch;
-- VHDL netlist for CBU11
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBU11 IS 
    PORT (
        CAI : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBU11;


ARCHITECTURE lattice_arch OF CBU11 IS
SIGNAL  UQVN_N1, UQVN_N2 : std_logic;


  COMPONENT FD21
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD21 use  entity  lattice.FD21(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


BEGIN

UQVB_B1 : FD21
	PORT MAP (Q0 => UQVN_N1, D0 => UQVN_N2, CLK => CLK, CD => CD);
UQVB_B2 : AND2
	PORT MAP (Z0 => CAO, A0 => UQVN_N1, A1 => CAI);
UQVB_B3 : BUF
	PORT MAP (Z0 => Q0, A0 => UQVN_N1);
UQVB_B4 : LXOR2
	PORT MAP (Z0 => UQVN_N2, A0 => UQVN_N1, A1 => CAI);
END lattice_arch;
-- VHDL netlist for CBU12
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBU12 IS 
    PORT (
        CAI : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBU12;


ARCHITECTURE lattice_arch OF CBU12 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, QI0,
	 QI1 : std_logic;


  COMPONENT FD21
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD21 use  entity  lattice.FD21(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


BEGIN

UQVB_B1 : FD21
	PORT MAP (Q0 => QI0, D0 => UQVN_N2, CLK => CLK, CD => CD);
UQVB_B2 : FD21
	PORT MAP (Q0 => QI1, D0 => UQVN_N3, CLK => CLK, CD => CD);
UQVB_B3 : AND3
	PORT MAP (Z0 => CAO, A0 => QI0, A1 => QI1, A2 => CAI);
UQVB_B4 : AND2
	PORT MAP (Z0 => UQVN_N1, A0 => QI0, A1 => CAI);
UQVB_B5 : BUF
	PORT MAP (Z0 => Q1, A0 => QI1);
UQVB_B6 : BUF
	PORT MAP (Z0 => Q0, A0 => QI0);
UQVB_B7 : LXOR2
	PORT MAP (Z0 => UQVN_N2, A0 => QI0, A1 => CAI);
UQVB_B8 : LXOR2
	PORT MAP (Z0 => UQVN_N3, A0 => QI1, A1 => UQVN_N1);
END lattice_arch;
-- VHDL netlist for CBU14
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBU14 IS 
    PORT (
        CAI : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBU14;


ARCHITECTURE lattice_arch OF CBU14 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, QI0,
	 QI1, QI2, QI3 : std_logic;


  COMPONENT FD21
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD21 use  entity  lattice.FD21(lattice_arch);


  COMPONENT AND5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND5 use  entity  lattice.AND5(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


BEGIN

UQVB_B1 : FD21
	PORT MAP (Q0 => QI0, D0 => UQVN_N4, CLK => CLK, CD => CD);
UQVB_B2 : FD21
	PORT MAP (Q0 => QI1, D0 => UQVN_N5, CLK => CLK, CD => CD);
UQVB_B3 : AND5
	PORT MAP (Z0 => CAO, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => CAI);
UQVB_B4 : AND2
	PORT MAP (Z0 => UQVN_N1, A0 => QI0, A1 => CAI);
UQVB_B5 : AND3
	PORT MAP (Z0 => UQVN_N2, A0 => QI0, A1 => QI1, A2 => CAI);
UQVB_B6 : AND4
	PORT MAP (Z0 => UQVN_N3, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => CAI);
UQVB_B7 : BUF
	PORT MAP (Z0 => Q3, A0 => QI3);
UQVB_B8 : BUF
	PORT MAP (Z0 => Q2, A0 => QI2);
UQVB_B9 : BUF
	PORT MAP (Z0 => Q1, A0 => QI1);
UQVB_B10 : BUF
	PORT MAP (Z0 => Q0, A0 => QI0);
UQVB_B11 : FD21
	PORT MAP (Q0 => QI2, D0 => UQVN_N6, CLK => CLK, CD => CD);
UQVB_B12 : FD21
	PORT MAP (Q0 => QI3, D0 => UQVN_N7, CLK => CLK, CD => CD);
UQVB_B13 : LXOR2
	PORT MAP (Z0 => UQVN_N4, A0 => QI0, A1 => CAI);
UQVB_B14 : LXOR2
	PORT MAP (Z0 => UQVN_N5, A0 => QI1, A1 => UQVN_N1);
UQVB_B15 : LXOR2
	PORT MAP (Z0 => UQVN_N6, A0 => QI2, A1 => UQVN_N2);
UQVB_B16 : LXOR2
	PORT MAP (Z0 => UQVN_N7, A0 => QI3, A1 => UQVN_N3);
END lattice_arch;
-- VHDL netlist for CBU18
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBU18 IS 
    PORT (
        CAI : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        Q4 : OUT std_logic;
        Q5 : OUT std_logic;
        Q6 : OUT std_logic;
        Q7 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBU18;


ARCHITECTURE lattice_arch OF CBU18 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, QI0,
	 QI1, QI2, QI3, QI4,
	 QI5, QI6, QI7 : std_logic;


  COMPONENT FD21
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD21 use  entity  lattice.FD21(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT AND5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND5 use  entity  lattice.AND5(lattice_arch);


  COMPONENT AND6
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND6 use  entity  lattice.AND6(lattice_arch);


  COMPONENT AND7
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND7 use  entity  lattice.AND7(lattice_arch);


  COMPONENT AND8
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND8 use  entity  lattice.AND8(lattice_arch);


  COMPONENT AND9
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND9 use  entity  lattice.AND9(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


BEGIN

UQVB_B1 : FD21
	PORT MAP (Q0 => QI0, D0 => UQVN_N8, CLK => CLK, CD => CD);
UQVB_B2 : FD21
	PORT MAP (Q0 => QI1, D0 => UQVN_N9, CLK => CLK, CD => CD);
UQVB_B3 : AND2
	PORT MAP (Z0 => UQVN_N1, A0 => QI0, A1 => CAI);
UQVB_B4 : AND3
	PORT MAP (Z0 => UQVN_N2, A0 => QI0, A1 => QI1, A2 => CAI);
UQVB_B5 : AND4
	PORT MAP (Z0 => UQVN_N3, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => CAI);
UQVB_B6 : AND5
	PORT MAP (Z0 => UQVN_N4, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => CAI);
UQVB_B7 : AND6
	PORT MAP (Z0 => UQVN_N5, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => QI4, A5 => CAI);
UQVB_B8 : AND7
	PORT MAP (Z0 => UQVN_N6, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => QI4, A5 => QI5, A6 => CAI);
UQVB_B9 : AND8
	PORT MAP (Z0 => UQVN_N7, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => QI4, A5 => QI5, A6 => QI6, 
	A7 => CAI);
UQVB_B10 : AND9
	PORT MAP (Z0 => CAO, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => QI4, A5 => QI5, A6 => QI6, 
	A7 => QI7, A8 => CAI);
UQVB_B11 : BUF
	PORT MAP (Z0 => Q0, A0 => QI0);
UQVB_B12 : BUF
	PORT MAP (Z0 => Q7, A0 => QI7);
UQVB_B13 : BUF
	PORT MAP (Z0 => Q6, A0 => QI6);
UQVB_B14 : BUF
	PORT MAP (Z0 => Q4, A0 => QI4);
UQVB_B15 : BUF
	PORT MAP (Z0 => Q5, A0 => QI5);
UQVB_B16 : BUF
	PORT MAP (Z0 => Q3, A0 => QI3);
UQVB_B17 : BUF
	PORT MAP (Z0 => Q1, A0 => QI1);
UQVB_B18 : BUF
	PORT MAP (Z0 => Q2, A0 => QI2);
UQVB_B19 : FD21
	PORT MAP (Q0 => QI2, D0 => UQVN_N10, CLK => CLK, CD => CD);
UQVB_B20 : FD21
	PORT MAP (Q0 => QI3, D0 => UQVN_N11, CLK => CLK, CD => CD);
UQVB_B21 : LXOR2
	PORT MAP (Z0 => UQVN_N8, A0 => QI0, A1 => CAI);
UQVB_B22 : LXOR2
	PORT MAP (Z0 => UQVN_N9, A0 => QI1, A1 => UQVN_N1);
UQVB_B23 : LXOR2
	PORT MAP (Z0 => UQVN_N10, A0 => QI2, A1 => UQVN_N2);
UQVB_B24 : LXOR2
	PORT MAP (Z0 => UQVN_N11, A0 => QI3, A1 => UQVN_N3);
UQVB_B25 : LXOR2
	PORT MAP (Z0 => UQVN_N12, A0 => QI4, A1 => UQVN_N4);
UQVB_B26 : FD21
	PORT MAP (Q0 => QI4, D0 => UQVN_N12, CLK => CLK, CD => CD);
UQVB_B27 : LXOR2
	PORT MAP (Z0 => UQVN_N13, A0 => QI5, A1 => UQVN_N5);
UQVB_B28 : FD21
	PORT MAP (Q0 => QI5, D0 => UQVN_N13, CLK => CLK, CD => CD);
UQVB_B29 : FD21
	PORT MAP (Q0 => QI6, D0 => UQVN_N14, CLK => CLK, CD => CD);
UQVB_B30 : LXOR2
	PORT MAP (Z0 => UQVN_N14, A0 => QI6, A1 => UQVN_N6);
UQVB_B31 : LXOR2
	PORT MAP (Z0 => UQVN_N15, A0 => QI7, A1 => UQVN_N7);
UQVB_B32 : FD21
	PORT MAP (Q0 => QI7, D0 => UQVN_N15, CLK => CLK, CD => CD);
END lattice_arch;
-- VHDL netlist for CBU21
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBU21 IS 
    PORT (
        CAI : IN std_logic;
        CLK : IN std_logic;
        EN : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBU21;


ARCHITECTURE lattice_arch OF CBU21 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3 : std_logic;


  COMPONENT FD21
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD21 use  entity  lattice.FD21(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


BEGIN

UQVB_B1 : FD21
	PORT MAP (Q0 => UQVN_N2, D0 => UQVN_N3, CLK => CLK, CD => CD);
UQVB_B2 : AND2
	PORT MAP (Z0 => UQVN_N1, A0 => CAI, A1 => EN);
UQVB_B3 : AND3
	PORT MAP (Z0 => CAO, A0 => UQVN_N2, A1 => CAI, A2 => EN);
UQVB_B4 : BUF
	PORT MAP (Z0 => Q0, A0 => UQVN_N2);
UQVB_B5 : LXOR2
	PORT MAP (Z0 => UQVN_N3, A0 => UQVN_N2, A1 => UQVN_N1);
END lattice_arch;
-- VHDL netlist for CBU22
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBU22 IS 
    PORT (
        CAI : IN std_logic;
        CLK : IN std_logic;
        EN : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBU22;


ARCHITECTURE lattice_arch OF CBU22 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 QI0, QI1 : std_logic;


  COMPONENT FD21
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD21 use  entity  lattice.FD21(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


BEGIN

UQVB_B1 : FD21
	PORT MAP (Q0 => QI0, D0 => UQVN_N3, CLK => CLK, CD => CD);
UQVB_B2 : FD21
	PORT MAP (Q0 => QI1, D0 => UQVN_N4, CLK => CLK, CD => CD);
UQVB_B3 : AND2
	PORT MAP (Z0 => UQVN_N1, A0 => CAI, A1 => EN);
UQVB_B4 : AND3
	PORT MAP (Z0 => UQVN_N2, A0 => QI0, A1 => CAI, A2 => EN);
UQVB_B5 : AND4
	PORT MAP (Z0 => CAO, A0 => QI0, A1 => QI1, A2 => CAI, 
	A3 => EN);
UQVB_B6 : BUF
	PORT MAP (Z0 => Q1, A0 => QI1);
UQVB_B7 : BUF
	PORT MAP (Z0 => Q0, A0 => QI0);
UQVB_B8 : LXOR2
	PORT MAP (Z0 => UQVN_N3, A0 => QI0, A1 => UQVN_N1);
UQVB_B9 : LXOR2
	PORT MAP (Z0 => UQVN_N4, A0 => QI1, A1 => UQVN_N2);
END lattice_arch;
-- VHDL netlist for CBU24
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBU24 IS 
    PORT (
        CAI : IN std_logic;
        CLK : IN std_logic;
        EN : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBU24;


ARCHITECTURE lattice_arch OF CBU24 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 QI0, QI1, QI2, QI3 : std_logic;


  COMPONENT FD21
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD21 use  entity  lattice.FD21(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT AND5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND5 use  entity  lattice.AND5(lattice_arch);


  COMPONENT AND6
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND6 use  entity  lattice.AND6(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


BEGIN

UQVB_B1 : FD21
	PORT MAP (Q0 => QI0, D0 => UQVN_N5, CLK => CLK, CD => CD);
UQVB_B2 : FD21
	PORT MAP (Q0 => QI1, D0 => UQVN_N6, CLK => CLK, CD => CD);
UQVB_B3 : AND2
	PORT MAP (Z0 => UQVN_N1, A0 => CAI, A1 => EN);
UQVB_B4 : AND3
	PORT MAP (Z0 => UQVN_N2, A0 => QI0, A1 => CAI, A2 => EN);
UQVB_B5 : AND4
	PORT MAP (Z0 => UQVN_N3, A0 => QI0, A1 => QI1, A2 => CAI, 
	A3 => EN);
UQVB_B6 : AND5
	PORT MAP (Z0 => UQVN_N4, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => CAI, A4 => EN);
UQVB_B7 : AND6
	PORT MAP (Z0 => CAO, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => CAI, A5 => EN);
UQVB_B8 : BUF
	PORT MAP (Z0 => Q3, A0 => QI3);
UQVB_B9 : BUF
	PORT MAP (Z0 => Q1, A0 => QI1);
UQVB_B10 : BUF
	PORT MAP (Z0 => Q0, A0 => QI0);
UQVB_B11 : BUF
	PORT MAP (Z0 => Q2, A0 => QI2);
UQVB_B12 : FD21
	PORT MAP (Q0 => QI2, D0 => UQVN_N7, CLK => CLK, CD => CD);
UQVB_B13 : FD21
	PORT MAP (Q0 => QI3, D0 => UQVN_N8, CLK => CLK, CD => CD);
UQVB_B14 : LXOR2
	PORT MAP (Z0 => UQVN_N5, A0 => QI0, A1 => UQVN_N1);
UQVB_B15 : LXOR2
	PORT MAP (Z0 => UQVN_N6, A0 => QI1, A1 => UQVN_N2);
UQVB_B16 : LXOR2
	PORT MAP (Z0 => UQVN_N7, A0 => QI2, A1 => UQVN_N3);
UQVB_B17 : LXOR2
	PORT MAP (Z0 => UQVN_N8, A0 => QI3, A1 => UQVN_N4);
END lattice_arch;
-- VHDL netlist for CBU28
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBU28 IS 
    PORT (
        CAI : IN std_logic;
        CLK : IN std_logic;
        EN : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        Q4 : OUT std_logic;
        Q5 : OUT std_logic;
        Q6 : OUT std_logic;
        Q7 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBU28;


ARCHITECTURE lattice_arch OF CBU28 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 QI0, QI1, QI2, QI3,
	 QI4, QI5, QI6, QI7 : std_logic;


  COMPONENT FD21
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD21 use  entity  lattice.FD21(lattice_arch);


  COMPONENT AND10
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        A9 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND10 use  entity  lattice.AND10(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT AND5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND5 use  entity  lattice.AND5(lattice_arch);


  COMPONENT AND6
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND6 use  entity  lattice.AND6(lattice_arch);


  COMPONENT AND7
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND7 use  entity  lattice.AND7(lattice_arch);


  COMPONENT AND8
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND8 use  entity  lattice.AND8(lattice_arch);


  COMPONENT AND9
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND9 use  entity  lattice.AND9(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


BEGIN

UQVB_B1 : FD21
	PORT MAP (Q0 => QI0, D0 => UQVN_N9, CLK => CLK, CD => CD);
UQVB_B2 : FD21
	PORT MAP (Q0 => QI1, D0 => UQVN_N10, CLK => CLK, CD => CD);
UQVB_B3 : AND10
	PORT MAP (Z0 => CAO, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => QI4, A5 => QI5, A6 => QI6, 
	A7 => QI7, A8 => CAI, A9 => EN);
UQVB_B4 : AND2
	PORT MAP (Z0 => UQVN_N1, A0 => CAI, A1 => EN);
UQVB_B5 : AND3
	PORT MAP (Z0 => UQVN_N2, A0 => QI0, A1 => CAI, A2 => EN);
UQVB_B6 : AND4
	PORT MAP (Z0 => UQVN_N3, A0 => QI0, A1 => QI1, A2 => CAI, 
	A3 => EN);
UQVB_B7 : AND5
	PORT MAP (Z0 => UQVN_N4, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => CAI, A4 => EN);
UQVB_B8 : AND6
	PORT MAP (Z0 => UQVN_N5, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => CAI, A5 => EN);
UQVB_B9 : AND7
	PORT MAP (Z0 => UQVN_N6, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => QI4, A5 => CAI, A6 => EN);
UQVB_B10 : AND8
	PORT MAP (Z0 => UQVN_N7, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => QI4, A5 => QI5, A6 => CAI, 
	A7 => EN);
UQVB_B11 : AND9
	PORT MAP (Z0 => UQVN_N8, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => QI4, A5 => QI5, A6 => QI6, 
	A7 => CAI, A8 => EN);
UQVB_B12 : BUF
	PORT MAP (Z0 => Q7, A0 => QI7);
UQVB_B13 : BUF
	PORT MAP (Z0 => Q6, A0 => QI6);
UQVB_B14 : BUF
	PORT MAP (Z0 => Q0, A0 => QI0);
UQVB_B15 : BUF
	PORT MAP (Z0 => Q1, A0 => QI1);
UQVB_B16 : BUF
	PORT MAP (Z0 => Q5, A0 => QI5);
UQVB_B17 : BUF
	PORT MAP (Z0 => Q2, A0 => QI2);
UQVB_B18 : BUF
	PORT MAP (Z0 => Q4, A0 => QI4);
UQVB_B19 : BUF
	PORT MAP (Z0 => Q3, A0 => QI3);
UQVB_B20 : FD21
	PORT MAP (Q0 => QI2, D0 => UQVN_N11, CLK => CLK, CD => CD);
UQVB_B21 : FD21
	PORT MAP (Q0 => QI3, D0 => UQVN_N12, CLK => CLK, CD => CD);
UQVB_B22 : LXOR2
	PORT MAP (Z0 => UQVN_N9, A0 => QI0, A1 => UQVN_N1);
UQVB_B23 : LXOR2
	PORT MAP (Z0 => UQVN_N10, A0 => QI1, A1 => UQVN_N2);
UQVB_B24 : LXOR2
	PORT MAP (Z0 => UQVN_N11, A0 => QI2, A1 => UQVN_N3);
UQVB_B25 : LXOR2
	PORT MAP (Z0 => UQVN_N12, A0 => QI3, A1 => UQVN_N4);
UQVB_B26 : LXOR2
	PORT MAP (Z0 => UQVN_N13, A0 => QI4, A1 => UQVN_N5);
UQVB_B27 : FD21
	PORT MAP (Q0 => QI4, D0 => UQVN_N13, CLK => CLK, CD => CD);
UQVB_B28 : LXOR2
	PORT MAP (Z0 => UQVN_N14, A0 => QI5, A1 => UQVN_N6);
UQVB_B29 : FD21
	PORT MAP (Q0 => QI5, D0 => UQVN_N14, CLK => CLK, CD => CD);
UQVB_B30 : FD21
	PORT MAP (Q0 => QI6, D0 => UQVN_N15, CLK => CLK, CD => CD);
UQVB_B31 : LXOR2
	PORT MAP (Z0 => UQVN_N15, A0 => QI6, A1 => UQVN_N7);
UQVB_B32 : LXOR2
	PORT MAP (Z0 => UQVN_N16, A0 => QI7, A1 => UQVN_N8);
UQVB_B33 : FD21
	PORT MAP (Q0 => QI7, D0 => UQVN_N16, CLK => CLK, CD => CD);
END lattice_arch;
-- VHDL netlist for CBU31
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBU31 IS 
    PORT (
        D0 : IN std_logic;
        CAI : IN std_logic;
        CLK : IN std_logic;
        PS : IN std_logic;
        LD : IN std_logic;
        EN : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBU31;


ARCHITECTURE lattice_arch OF CBU31 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8 : std_logic;


  COMPONENT FD21
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD21 use  entity  lattice.FD21(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


  COMPONENT OR3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR3 use  entity  lattice.OR3(lattice_arch);


BEGIN

UQVB_B1 : FD21
	PORT MAP (Q0 => UQVN_N7, D0 => UQVN_N8, CLK => CLK, CD => CD);
UQVB_B2 : AND3
	PORT MAP (Z0 => UQVN_N1, A0 => UQVN_N7, A1 => UQVN_N5, A2 => UQVN_N6);
UQVB_B3 : AND2
	PORT MAP (Z0 => UQVN_N2, A0 => D0, A1 => LD);
UQVB_B4 : AND3
	PORT MAP (Z0 => UQVN_N3, A0 => UQVN_N5, A1 => CAI, A2 => EN);
UQVB_B5 : AND3
	PORT MAP (Z0 => CAO, A0 => UQVN_N7, A1 => CAI, A2 => EN);
UQVB_B6 : INV
	PORT MAP (ZN0 => UQVN_N5, A0 => LD);
UQVB_B7 : BUF
	PORT MAP (Z0 => Q0, A0 => UQVN_N7);
UQVB_B8 : LXOR2
	PORT MAP (Z0 => UQVN_N8, A0 => UQVN_N1, A1 => UQVN_N4);
UQVB_B9 : OR3
	PORT MAP (Z0 => UQVN_N4, A0 => UQVN_N2, A1 => UQVN_N3, A2 => PS);
UQVB_B10 : INV
	PORT MAP (ZN0 => UQVN_N6, A0 => PS);
END lattice_arch;
-- VHDL netlist for CBU32
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBU32 IS 
    PORT (
        D0 : IN std_logic;
        D1 : IN std_logic;
        CAI : IN std_logic;
        CLK : IN std_logic;
        PS : IN std_logic;
        LD : IN std_logic;
        EN : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBU32;


ARCHITECTURE lattice_arch OF CBU32 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 QI0, QI1 : std_logic;


  COMPONENT FD21
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD21 use  entity  lattice.FD21(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT OR3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR3 use  entity  lattice.OR3(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


BEGIN

UQVB_B1 : FD21
	PORT MAP (Q0 => QI0, D0 => UQVN_N11, CLK => CLK, CD => CD);
UQVB_B2 : FD21
	PORT MAP (Q0 => QI1, D0 => UQVN_N12, CLK => CLK, CD => CD);
UQVB_B3 : AND3
	PORT MAP (Z0 => UQVN_N1, A0 => QI0, A1 => UQVN_N9, A2 => UQVN_N10);
UQVB_B4 : AND2
	PORT MAP (Z0 => UQVN_N3, A0 => D0, A1 => LD);
UQVB_B5 : AND3
	PORT MAP (Z0 => UQVN_N4, A0 => UQVN_N9, A1 => CAI, A2 => EN);
UQVB_B6 : AND2
	PORT MAP (Z0 => UQVN_N6, A0 => D1, A1 => LD);
UQVB_B7 : AND4
	PORT MAP (Z0 => UQVN_N2, A0 => QI0, A1 => CAI, A2 => UQVN_N9, 
	A3 => EN);
UQVB_B8 : OR3
	PORT MAP (Z0 => UQVN_N8, A0 => UQVN_N6, A1 => UQVN_N2, A2 => PS);
UQVB_B9 : AND3
	PORT MAP (Z0 => UQVN_N7, A0 => QI1, A1 => UQVN_N9, A2 => UQVN_N10);
UQVB_B10 : AND4
	PORT MAP (Z0 => CAO, A0 => QI0, A1 => QI1, A2 => CAI, 
	A3 => EN);
UQVB_B11 : INV
	PORT MAP (ZN0 => UQVN_N10, A0 => PS);
UQVB_B12 : BUF
	PORT MAP (Z0 => Q1, A0 => QI1);
UQVB_B13 : BUF
	PORT MAP (Z0 => Q0, A0 => QI0);
UQVB_B14 : LXOR2
	PORT MAP (Z0 => UQVN_N11, A0 => UQVN_N1, A1 => UQVN_N5);
UQVB_B15 : OR3
	PORT MAP (Z0 => UQVN_N5, A0 => UQVN_N3, A1 => UQVN_N4, A2 => PS);
UQVB_B16 : LXOR2
	PORT MAP (Z0 => UQVN_N12, A0 => UQVN_N7, A1 => UQVN_N8);
UQVB_B17 : INV
	PORT MAP (ZN0 => UQVN_N9, A0 => LD);
END lattice_arch;
-- VHDL netlist for CBU34
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBU34 IS 
    PORT (
        D0 : IN std_logic;
        D1 : IN std_logic;
        D2 : IN std_logic;
        D3 : IN std_logic;
        CAI : IN std_logic;
        CLK : IN std_logic;
        PS : IN std_logic;
        LD : IN std_logic;
        EN : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBU34;


ARCHITECTURE lattice_arch OF CBU34 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, QI0, QI1,
	 QI2, QI3 : std_logic;


  COMPONENT FD21
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD21 use  entity  lattice.FD21(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT OR3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR3 use  entity  lattice.OR3(lattice_arch);


  COMPONENT AND5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND5 use  entity  lattice.AND5(lattice_arch);


  COMPONENT AND6
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND6 use  entity  lattice.AND6(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


BEGIN

UQVB_B1 : FD21
	PORT MAP (Q0 => QI0, D0 => UQVN_N19, CLK => CLK, CD => CD);
UQVB_B2 : FD21
	PORT MAP (Q0 => QI1, D0 => UQVN_N20, CLK => CLK, CD => CD);
UQVB_B3 : AND3
	PORT MAP (Z0 => UQVN_N1, A0 => QI0, A1 => UQVN_N17, A2 => UQVN_N18);
UQVB_B4 : AND2
	PORT MAP (Z0 => UQVN_N3, A0 => D0, A1 => LD);
UQVB_B5 : AND3
	PORT MAP (Z0 => UQVN_N4, A0 => UQVN_N17, A1 => CAI, A2 => EN);
UQVB_B6 : AND2
	PORT MAP (Z0 => UQVN_N6, A0 => D1, A1 => LD);
UQVB_B7 : AND3
	PORT MAP (Z0 => UQVN_N10, A0 => QI2, A1 => UQVN_N17, A2 => UQVN_N18);
UQVB_B8 : AND2
	PORT MAP (Z0 => UQVN_N9, A0 => D2, A1 => LD);
UQVB_B9 : AND3
	PORT MAP (Z0 => UQVN_N14, A0 => QI3, A1 => UQVN_N17, A2 => UQVN_N18);
UQVB_B10 : AND2
	PORT MAP (Z0 => UQVN_N13, A0 => D3, A1 => LD);
UQVB_B11 : AND4
	PORT MAP (Z0 => UQVN_N2, A0 => QI0, A1 => CAI, A2 => UQVN_N17, 
	A3 => EN);
UQVB_B12 : OR3
	PORT MAP (Z0 => UQVN_N8, A0 => UQVN_N6, A1 => UQVN_N2, A2 => PS);
UQVB_B13 : OR3
	PORT MAP (Z0 => UQVN_N11, A0 => UQVN_N9, A1 => UQVN_N12, A2 => PS);
UQVB_B14 : OR3
	PORT MAP (Z0 => UQVN_N15, A0 => UQVN_N13, A1 => UQVN_N16, A2 => PS);
UQVB_B15 : AND5
	PORT MAP (Z0 => UQVN_N12, A0 => QI0, A1 => QI1, A2 => UQVN_N17, 
	A3 => CAI, A4 => EN);
UQVB_B16 : AND6
	PORT MAP (Z0 => UQVN_N16, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => UQVN_N17, A4 => CAI, A5 => EN);
UQVB_B17 : AND3
	PORT MAP (Z0 => UQVN_N7, A0 => QI1, A1 => UQVN_N17, A2 => UQVN_N18);
UQVB_B18 : AND6
	PORT MAP (Z0 => CAO, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => CAI, A5 => EN);
UQVB_B19 : INV
	PORT MAP (ZN0 => UQVN_N18, A0 => PS);
UQVB_B20 : BUF
	PORT MAP (Z0 => Q3, A0 => QI3);
UQVB_B21 : BUF
	PORT MAP (Z0 => Q2, A0 => QI2);
UQVB_B22 : BUF
	PORT MAP (Z0 => Q1, A0 => QI1);
UQVB_B23 : BUF
	PORT MAP (Z0 => Q0, A0 => QI0);
UQVB_B24 : FD21
	PORT MAP (Q0 => QI2, D0 => UQVN_N21, CLK => CLK, CD => CD);
UQVB_B25 : FD21
	PORT MAP (Q0 => QI3, D0 => UQVN_N22, CLK => CLK, CD => CD);
UQVB_B26 : LXOR2
	PORT MAP (Z0 => UQVN_N19, A0 => UQVN_N1, A1 => UQVN_N5);
UQVB_B27 : OR3
	PORT MAP (Z0 => UQVN_N5, A0 => UQVN_N3, A1 => UQVN_N4, A2 => PS);
UQVB_B28 : LXOR2
	PORT MAP (Z0 => UQVN_N20, A0 => UQVN_N7, A1 => UQVN_N8);
UQVB_B29 : INV
	PORT MAP (ZN0 => UQVN_N17, A0 => LD);
UQVB_B30 : LXOR2
	PORT MAP (Z0 => UQVN_N21, A0 => UQVN_N10, A1 => UQVN_N11);
UQVB_B31 : LXOR2
	PORT MAP (Z0 => UQVN_N22, A0 => UQVN_N14, A1 => UQVN_N15);
END lattice_arch;
-- VHDL netlist for CBU38
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBU38 IS 
    PORT (
        D0 : IN std_logic;
        D1 : IN std_logic;
        D2 : IN std_logic;
        D3 : IN std_logic;
        D4 : IN std_logic;
        D5 : IN std_logic;
        D6 : IN std_logic;
        D7 : IN std_logic;
        CAI : IN std_logic;
        CLK : IN std_logic;
        PS : IN std_logic;
        LD : IN std_logic;
        EN : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        Q4 : OUT std_logic;
        Q5 : OUT std_logic;
        Q6 : OUT std_logic;
        Q7 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBU38;


ARCHITECTURE lattice_arch OF CBU38 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, UQVN_N23, UQVN_N24,
	 UQVN_N25, UQVN_N26, UQVN_N27, UQVN_N28,
	 UQVN_N29, UQVN_N30, UQVN_N31, UQVN_N32,
	 UQVN_N33, UQVN_N34, UQVN_N35, UQVN_N36,
	 UQVN_N37, UQVN_N38, UQVN_N39, UQVN_N40,
	 UQVN_N41, UQVN_N42, UQVN_N43, UQVN_N44,
	 QI0, QI1, QI2, QI3,
	 QI4, QI5, QI6, QI7 : std_logic;


  COMPONENT FD21
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD21 use  entity  lattice.FD21(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT OR3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR3 use  entity  lattice.OR3(lattice_arch);


  COMPONENT AND5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND5 use  entity  lattice.AND5(lattice_arch);


  COMPONENT AND6
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND6 use  entity  lattice.AND6(lattice_arch);


  COMPONENT AND10
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        A9 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND10 use  entity  lattice.AND10(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


  COMPONENT AND7
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND7 use  entity  lattice.AND7(lattice_arch);


  COMPONENT AND8
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND8 use  entity  lattice.AND8(lattice_arch);


  COMPONENT AND9
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND9 use  entity  lattice.AND9(lattice_arch);


BEGIN

UQVB_B1 : FD21
	PORT MAP (Q0 => QI0, D0 => UQVN_N19, CLK => CLK, CD => CD);
UQVB_B2 : FD21
	PORT MAP (Q0 => QI1, D0 => UQVN_N20, CLK => CLK, CD => CD);
UQVB_B3 : AND3
	PORT MAP (Z0 => UQVN_N1, A0 => QI0, A1 => UQVN_N17, A2 => UQVN_N18);
UQVB_B4 : AND2
	PORT MAP (Z0 => UQVN_N3, A0 => D0, A1 => LD);
UQVB_B5 : AND3
	PORT MAP (Z0 => UQVN_N4, A0 => UQVN_N17, A1 => CAI, A2 => EN);
UQVB_B6 : AND2
	PORT MAP (Z0 => UQVN_N6, A0 => D1, A1 => LD);
UQVB_B7 : AND3
	PORT MAP (Z0 => UQVN_N10, A0 => QI2, A1 => UQVN_N17, A2 => UQVN_N18);
UQVB_B8 : AND2
	PORT MAP (Z0 => UQVN_N9, A0 => D2, A1 => LD);
UQVB_B9 : AND3
	PORT MAP (Z0 => UQVN_N14, A0 => QI3, A1 => UQVN_N17, A2 => UQVN_N18);
UQVB_B10 : AND2
	PORT MAP (Z0 => UQVN_N13, A0 => D3, A1 => LD);
UQVB_B11 : AND4
	PORT MAP (Z0 => UQVN_N2, A0 => QI0, A1 => CAI, A2 => UQVN_N17, 
	A3 => EN);
UQVB_B12 : OR3
	PORT MAP (Z0 => UQVN_N8, A0 => UQVN_N6, A1 => UQVN_N2, A2 => PS);
UQVB_B13 : OR3
	PORT MAP (Z0 => UQVN_N11, A0 => UQVN_N9, A1 => UQVN_N12, A2 => PS);
UQVB_B14 : OR3
	PORT MAP (Z0 => UQVN_N15, A0 => UQVN_N13, A1 => UQVN_N16, A2 => PS);
UQVB_B15 : AND5
	PORT MAP (Z0 => UQVN_N12, A0 => QI0, A1 => QI1, A2 => UQVN_N17, 
	A3 => CAI, A4 => EN);
UQVB_B16 : AND6
	PORT MAP (Z0 => UQVN_N16, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => UQVN_N17, A4 => CAI, A5 => EN);
UQVB_B17 : AND3
	PORT MAP (Z0 => UQVN_N7, A0 => QI1, A1 => UQVN_N17, A2 => UQVN_N18);
UQVB_B18 : AND10
	PORT MAP (Z0 => CAO, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => QI4, A5 => QI5, A6 => QI6, 
	A7 => QI7, A8 => CAI, A9 => EN);
UQVB_B19 : INV
	PORT MAP (ZN0 => UQVN_N18, A0 => PS);
UQVB_B20 : BUF
	PORT MAP (Z0 => Q7, A0 => QI7);
UQVB_B21 : BUF
	PORT MAP (Z0 => Q6, A0 => QI6);
UQVB_B22 : BUF
	PORT MAP (Z0 => Q5, A0 => QI5);
UQVB_B23 : BUF
	PORT MAP (Z0 => Q4, A0 => QI4);
UQVB_B24 : BUF
	PORT MAP (Z0 => Q3, A0 => QI3);
UQVB_B25 : BUF
	PORT MAP (Z0 => Q2, A0 => QI2);
UQVB_B26 : BUF
	PORT MAP (Z0 => Q1, A0 => QI1);
UQVB_B27 : BUF
	PORT MAP (Z0 => Q0, A0 => QI0);
UQVB_B28 : FD21
	PORT MAP (Q0 => QI2, D0 => UQVN_N21, CLK => CLK, CD => CD);
UQVB_B29 : FD21
	PORT MAP (Q0 => QI3, D0 => UQVN_N22, CLK => CLK, CD => CD);
UQVB_B30 : LXOR2
	PORT MAP (Z0 => UQVN_N19, A0 => UQVN_N1, A1 => UQVN_N5);
UQVB_B31 : OR3
	PORT MAP (Z0 => UQVN_N5, A0 => UQVN_N3, A1 => UQVN_N4, A2 => PS);
UQVB_B32 : LXOR2
	PORT MAP (Z0 => UQVN_N20, A0 => UQVN_N7, A1 => UQVN_N8);
UQVB_B33 : INV
	PORT MAP (ZN0 => UQVN_N17, A0 => LD);
UQVB_B34 : LXOR2
	PORT MAP (Z0 => UQVN_N21, A0 => UQVN_N10, A1 => UQVN_N11);
UQVB_B35 : LXOR2
	PORT MAP (Z0 => UQVN_N22, A0 => UQVN_N14, A1 => UQVN_N15);
UQVB_B36 : AND10
	PORT MAP (Z0 => UQVN_N25, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => QI4, A5 => QI5, A6 => QI6, 
	A7 => UQVN_N34, A8 => CAI, A9 => EN);
UQVB_B37 : INV
	PORT MAP (ZN0 => UQVN_N34, A0 => LD);
UQVB_B38 : INV
	PORT MAP (ZN0 => UQVN_N24, A0 => PS);
UQVB_B39 : AND3
	PORT MAP (Z0 => UQVN_N33, A0 => QI4, A1 => UQVN_N34, A2 => UQVN_N24);
UQVB_B40 : AND3
	PORT MAP (Z0 => UQVN_N30, A0 => QI5, A1 => UQVN_N34, A2 => UQVN_N24);
UQVB_B41 : AND3
	PORT MAP (Z0 => UQVN_N44, A0 => QI6, A1 => UQVN_N34, A2 => UQVN_N24);
UQVB_B42 : AND3
	PORT MAP (Z0 => UQVN_N27, A0 => QI7, A1 => UQVN_N34, A2 => UQVN_N24);
UQVB_B43 : AND7
	PORT MAP (Z0 => UQVN_N43, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => UQVN_N34, A5 => CAI, A6 => EN);
UQVB_B44 : AND8
	PORT MAP (Z0 => UQVN_N41, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => QI4, A5 => UQVN_N34, A6 => CAI, 
	A7 => EN);
UQVB_B45 : AND2
	PORT MAP (Z0 => UQVN_N26, A0 => D5, A1 => LD);
UQVB_B46 : AND2
	PORT MAP (Z0 => UQVN_N32, A0 => D4, A1 => LD);
UQVB_B47 : FD21
	PORT MAP (Q0 => QI7, D0 => UQVN_N28, CLK => CLK, CD => CD);
UQVB_B48 : FD21
	PORT MAP (Q0 => QI6, D0 => UQVN_N38, CLK => CLK, CD => CD);
UQVB_B49 : FD21
	PORT MAP (Q0 => QI5, D0 => UQVN_N31, CLK => CLK, CD => CD);
UQVB_B50 : FD21
	PORT MAP (Q0 => QI4, D0 => UQVN_N35, CLK => CLK, CD => CD);
UQVB_B51 : AND2
	PORT MAP (Z0 => UQVN_N23, A0 => D6, A1 => LD);
UQVB_B52 : LXOR2
	PORT MAP (Z0 => UQVN_N28, A0 => UQVN_N27, A1 => UQVN_N36);
UQVB_B53 : OR3
	PORT MAP (Z0 => UQVN_N36, A0 => UQVN_N29, A1 => UQVN_N25, A2 => PS);
UQVB_B54 : AND2
	PORT MAP (Z0 => UQVN_N29, A0 => D7, A1 => LD);
UQVB_B55 : LXOR2
	PORT MAP (Z0 => UQVN_N38, A0 => UQVN_N44, A1 => UQVN_N37);
UQVB_B56 : OR3
	PORT MAP (Z0 => UQVN_N37, A0 => UQVN_N23, A1 => UQVN_N39, A2 => PS);
UQVB_B57 : LXOR2
	PORT MAP (Z0 => UQVN_N31, A0 => UQVN_N30, A1 => UQVN_N40);
UQVB_B58 : OR3
	PORT MAP (Z0 => UQVN_N40, A0 => UQVN_N26, A1 => UQVN_N41, A2 => PS);
UQVB_B59 : LXOR2
	PORT MAP (Z0 => UQVN_N35, A0 => UQVN_N33, A1 => UQVN_N42);
UQVB_B60 : OR3
	PORT MAP (Z0 => UQVN_N42, A0 => UQVN_N32, A1 => UQVN_N43, A2 => PS);
UQVB_B61 : AND9
	PORT MAP (Z0 => UQVN_N39, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => QI4, A5 => QI5, A6 => UQVN_N34, 
	A7 => CAI, A8 => EN);
END lattice_arch;
-- VHDL netlist for CBU41
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBU41 IS 
    PORT (
        D0 : IN std_logic;
        CAI : IN std_logic;
        CLK : IN std_logic;
        PS : IN std_logic;
        LD : IN std_logic;
        EN : IN std_logic;
        CS : IN std_logic;
        Q0 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBU41;


ARCHITECTURE lattice_arch OF CBU41 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9 : std_logic;


  COMPONENT FD11
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD11 use  entity  lattice.FD11(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


  COMPONENT OR3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR3 use  entity  lattice.OR3(lattice_arch);


BEGIN

UQVB_B1 : FD11
	PORT MAP (Q0 => UQVN_N2, D0 => UQVN_N9, CLK => CLK);
UQVB_B2 : AND3
	PORT MAP (Z0 => CAO, A0 => UQVN_N2, A1 => CAI, A2 => EN);
UQVB_B3 : INV
	PORT MAP (ZN0 => UQVN_N6, A0 => LD);
UQVB_B4 : INV
	PORT MAP (ZN0 => UQVN_N7, A0 => CS);
UQVB_B5 : BUF
	PORT MAP (Z0 => Q0, A0 => UQVN_N2);
UQVB_B6 : AND3
	PORT MAP (Z0 => UQVN_N3, A0 => D0, A1 => LD, A2 => UQVN_N7);
UQVB_B7 : AND4
	PORT MAP (Z0 => UQVN_N4, A0 => UQVN_N6, A1 => CAI, A2 => EN, 
	A3 => UQVN_N7);
UQVB_B8 : LXOR2
	PORT MAP (Z0 => UQVN_N9, A0 => UQVN_N1, A1 => UQVN_N5);
UQVB_B9 : OR3
	PORT MAP (Z0 => UQVN_N5, A0 => UQVN_N3, A1 => UQVN_N4, A2 => PS);
UQVB_B10 : AND4
	PORT MAP (Z0 => UQVN_N1, A0 => UQVN_N2, A1 => UQVN_N6, A2 => UQVN_N7, 
	A3 => UQVN_N8);
UQVB_B11 : INV
	PORT MAP (ZN0 => UQVN_N8, A0 => PS);
END lattice_arch;
-- VHDL netlist for CBU42
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBU42 IS 
    PORT (
        D0 : IN std_logic;
        D1 : IN std_logic;
        CAI : IN std_logic;
        CLK : IN std_logic;
        PS : IN std_logic;
        LD : IN std_logic;
        EN : IN std_logic;
        CS : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBU42;


ARCHITECTURE lattice_arch OF CBU42 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, QI0, QI1 : std_logic;


  COMPONENT FD11
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD11 use  entity  lattice.FD11(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


  COMPONENT OR3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR3 use  entity  lattice.OR3(lattice_arch);


  COMPONENT AND5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND5 use  entity  lattice.AND5(lattice_arch);


BEGIN

UQVB_B1 : FD11
	PORT MAP (Q0 => QI0, D0 => UQVN_N12, CLK => CLK);
UQVB_B2 : FD11
	PORT MAP (Q0 => QI1, D0 => UQVN_N13, CLK => CLK);
UQVB_B3 : AND4
	PORT MAP (Z0 => CAO, A0 => QI0, A1 => QI1, A2 => CAI, 
	A3 => EN);
UQVB_B4 : INV
	PORT MAP (ZN0 => UQVN_N10, A0 => CS);
UQVB_B5 : INV
	PORT MAP (ZN0 => UQVN_N11, A0 => PS);
UQVB_B6 : BUF
	PORT MAP (Z0 => Q1, A0 => QI1);
UQVB_B7 : BUF
	PORT MAP (Z0 => Q0, A0 => QI0);
UQVB_B8 : AND3
	PORT MAP (Z0 => UQVN_N2, A0 => D0, A1 => LD, A2 => UQVN_N10);
UQVB_B9 : AND4
	PORT MAP (Z0 => UQVN_N3, A0 => UQVN_N9, A1 => CAI, A2 => EN, 
	A3 => UQVN_N10);
UQVB_B10 : LXOR2
	PORT MAP (Z0 => UQVN_N12, A0 => UQVN_N1, A1 => UQVN_N4);
UQVB_B11 : OR3
	PORT MAP (Z0 => UQVN_N4, A0 => UQVN_N2, A1 => UQVN_N3, A2 => PS);
UQVB_B12 : AND4
	PORT MAP (Z0 => UQVN_N1, A0 => QI0, A1 => UQVN_N9, A2 => UQVN_N10, 
	A3 => UQVN_N11);
UQVB_B13 : AND4
	PORT MAP (Z0 => UQVN_N7, A0 => QI1, A1 => UQVN_N9, A2 => UQVN_N10, 
	A3 => UQVN_N11);
UQVB_B14 : LXOR2
	PORT MAP (Z0 => UQVN_N13, A0 => UQVN_N7, A1 => UQVN_N8);
UQVB_B15 : AND3
	PORT MAP (Z0 => UQVN_N5, A0 => D1, A1 => LD, A2 => UQVN_N10);
UQVB_B16 : INV
	PORT MAP (ZN0 => UQVN_N9, A0 => LD);
UQVB_B17 : AND5
	PORT MAP (Z0 => UQVN_N6, A0 => QI0, A1 => CAI, A2 => UQVN_N9, 
	A3 => EN, A4 => UQVN_N10);
UQVB_B18 : OR3
	PORT MAP (Z0 => UQVN_N8, A0 => UQVN_N5, A1 => UQVN_N6, A2 => PS);
END lattice_arch;
-- VHDL netlist for CBU44
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBU44 IS 
    PORT (
        D0 : IN std_logic;
        D1 : IN std_logic;
        D2 : IN std_logic;
        D3 : IN std_logic;
        CAI : IN std_logic;
        CLK : IN std_logic;
        PS : IN std_logic;
        LD : IN std_logic;
        EN : IN std_logic;
        CS : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBU44;


ARCHITECTURE lattice_arch OF CBU44 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, UQVN_N23, QI0,
	 QI1, QI2, QI3 : std_logic;


  COMPONENT FD11
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD11 use  entity  lattice.FD11(lattice_arch);


  COMPONENT AND6
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND6 use  entity  lattice.AND6(lattice_arch);


  COMPONENT OR3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR3 use  entity  lattice.OR3(lattice_arch);


  COMPONENT AND7
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND7 use  entity  lattice.AND7(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


  COMPONENT AND5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND5 use  entity  lattice.AND5(lattice_arch);


BEGIN

UQVB_B1 : FD11
	PORT MAP (Q0 => QI0, D0 => UQVN_N20, CLK => CLK);
UQVB_B2 : FD11
	PORT MAP (Q0 => QI1, D0 => UQVN_N21, CLK => CLK);
UQVB_B3 : AND6
	PORT MAP (Z0 => UQVN_N2, A0 => QI0, A1 => QI1, A2 => CAI, 
	A3 => UQVN_N17, A4 => EN, A5 => UQVN_N18);
UQVB_B4 : OR3
	PORT MAP (Z0 => UQVN_N15, A0 => UQVN_N13, A1 => UQVN_N16, A2 => PS);
UQVB_B5 : AND7
	PORT MAP (Z0 => UQVN_N16, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => UQVN_N17, A4 => CAI, A5 => EN, A6 => UQVN_N18);
UQVB_B6 : AND6
	PORT MAP (Z0 => CAO, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => CAI, A5 => EN);
UQVB_B7 : INV
	PORT MAP (ZN0 => UQVN_N18, A0 => CS);
UQVB_B8 : INV
	PORT MAP (ZN0 => UQVN_N19, A0 => PS);
UQVB_B9 : BUF
	PORT MAP (Z0 => Q3, A0 => QI3);
UQVB_B10 : BUF
	PORT MAP (Z0 => Q0, A0 => QI0);
UQVB_B11 : BUF
	PORT MAP (Z0 => Q2, A0 => QI2);
UQVB_B12 : BUF
	PORT MAP (Z0 => Q1, A0 => QI1);
UQVB_B13 : FD11
	PORT MAP (Q0 => QI2, D0 => UQVN_N22, CLK => CLK);
UQVB_B14 : FD11
	PORT MAP (Q0 => QI3, D0 => UQVN_N23, CLK => CLK);
UQVB_B15 : AND3
	PORT MAP (Z0 => UQVN_N3, A0 => D0, A1 => LD, A2 => UQVN_N18);
UQVB_B16 : AND4
	PORT MAP (Z0 => UQVN_N4, A0 => UQVN_N17, A1 => CAI, A2 => EN, 
	A3 => UQVN_N18);
UQVB_B17 : LXOR2
	PORT MAP (Z0 => UQVN_N20, A0 => UQVN_N1, A1 => UQVN_N5);
UQVB_B18 : OR3
	PORT MAP (Z0 => UQVN_N5, A0 => UQVN_N3, A1 => UQVN_N4, A2 => PS);
UQVB_B19 : AND4
	PORT MAP (Z0 => UQVN_N1, A0 => QI0, A1 => UQVN_N17, A2 => UQVN_N18, 
	A3 => UQVN_N19);
UQVB_B20 : AND4
	PORT MAP (Z0 => UQVN_N8, A0 => QI1, A1 => UQVN_N17, A2 => UQVN_N18, 
	A3 => UQVN_N19);
UQVB_B21 : LXOR2
	PORT MAP (Z0 => UQVN_N21, A0 => UQVN_N8, A1 => UQVN_N9);
UQVB_B22 : AND3
	PORT MAP (Z0 => UQVN_N6, A0 => D1, A1 => LD, A2 => UQVN_N18);
UQVB_B23 : INV
	PORT MAP (ZN0 => UQVN_N17, A0 => LD);
UQVB_B24 : AND3
	PORT MAP (Z0 => UQVN_N10, A0 => D2, A1 => LD, A2 => UQVN_N18);
UQVB_B25 : LXOR2
	PORT MAP (Z0 => UQVN_N22, A0 => UQVN_N11, A1 => UQVN_N12);
UQVB_B26 : AND4
	PORT MAP (Z0 => UQVN_N11, A0 => QI2, A1 => UQVN_N17, A2 => UQVN_N18, 
	A3 => UQVN_N19);
UQVB_B27 : LXOR2
	PORT MAP (Z0 => UQVN_N23, A0 => UQVN_N14, A1 => UQVN_N15);
UQVB_B28 : AND3
	PORT MAP (Z0 => UQVN_N13, A0 => D3, A1 => LD, A2 => UQVN_N18);
UQVB_B29 : AND4
	PORT MAP (Z0 => UQVN_N14, A0 => QI3, A1 => UQVN_N17, A2 => UQVN_N18, 
	A3 => UQVN_N19);
UQVB_B30 : AND5
	PORT MAP (Z0 => UQVN_N7, A0 => QI0, A1 => CAI, A2 => UQVN_N17, 
	A3 => EN, A4 => UQVN_N18);
UQVB_B31 : OR3
	PORT MAP (Z0 => UQVN_N9, A0 => UQVN_N6, A1 => UQVN_N7, A2 => PS);
UQVB_B32 : OR3
	PORT MAP (Z0 => UQVN_N12, A0 => UQVN_N10, A1 => UQVN_N2, A2 => PS);
END lattice_arch;
-- VHDL netlist for CBU48
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBU48 IS 
    PORT (
        D0 : IN std_logic;
        D1 : IN std_logic;
        D2 : IN std_logic;
        D3 : IN std_logic;
        D4 : IN std_logic;
        D5 : IN std_logic;
        D6 : IN std_logic;
        D7 : IN std_logic;
        CAI : IN std_logic;
        CLK : IN std_logic;
        PS : IN std_logic;
        LD : IN std_logic;
        EN : IN std_logic;
        CS : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        Q4 : OUT std_logic;
        Q5 : OUT std_logic;
        Q6 : OUT std_logic;
        Q7 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBU48;


ARCHITECTURE lattice_arch OF CBU48 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, UQVN_N23, UQVN_N24,
	 UQVN_N25, UQVN_N26, UQVN_N27, UQVN_N28,
	 UQVN_N29, UQVN_N30, UQVN_N31, UQVN_N32,
	 UQVN_N33, UQVN_N34, UQVN_N35, UQVN_N36,
	 UQVN_N37, UQVN_N38, UQVN_N39, UQVN_N40,
	 UQVN_N41, UQVN_N42, UQVN_N43, UQVN_N44,
	 UQVN_N45, UQVN_N46, QI0, QI1,
	 QI2, QI3, QI4, QI5,
	 QI6, QI7 : std_logic;


  COMPONENT FD11
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD11 use  entity  lattice.FD11(lattice_arch);


  COMPONENT AND6
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND6 use  entity  lattice.AND6(lattice_arch);


  COMPONENT OR3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: OR3 use  entity  lattice.OR3(lattice_arch);


  COMPONENT AND7
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND7 use  entity  lattice.AND7(lattice_arch);


  COMPONENT AND10
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        A9 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND10 use  entity  lattice.AND10(lattice_arch);


  COMPONENT INV
    PORT (
        A0 : IN std_logic;
        ZN0 : OUT std_logic
    );
  END COMPONENT;

for all: INV use  entity  lattice.INV(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


  COMPONENT AND5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND5 use  entity  lattice.AND5(lattice_arch);


  COMPONENT AND8
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND8 use  entity  lattice.AND8(lattice_arch);


  COMPONENT AND9
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND9 use  entity  lattice.AND9(lattice_arch);


  COMPONENT AND11
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        A9 : IN std_logic;
        A10 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND11 use  entity  lattice.AND11(lattice_arch);


BEGIN

UQVB_B1 : FD11
	PORT MAP (Q0 => QI0, D0 => UQVN_N20, CLK => CLK);
UQVB_B2 : FD11
	PORT MAP (Q0 => QI1, D0 => UQVN_N21, CLK => CLK);
UQVB_B3 : AND6
	PORT MAP (Z0 => UQVN_N2, A0 => QI0, A1 => QI1, A2 => CAI, 
	A3 => UQVN_N17, A4 => EN, A5 => UQVN_N18);
UQVB_B4 : OR3
	PORT MAP (Z0 => UQVN_N15, A0 => UQVN_N13, A1 => UQVN_N16, A2 => PS);
UQVB_B5 : AND7
	PORT MAP (Z0 => UQVN_N16, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => UQVN_N17, A4 => CAI, A5 => EN, A6 => UQVN_N18);
UQVB_B6 : AND10
	PORT MAP (Z0 => CAO, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => QI4, A5 => QI5, A6 => QI6, 
	A7 => QI7, A8 => CAI, A9 => EN);
UQVB_B7 : INV
	PORT MAP (ZN0 => UQVN_N18, A0 => CS);
UQVB_B8 : INV
	PORT MAP (ZN0 => UQVN_N19, A0 => PS);
UQVB_B9 : BUF
	PORT MAP (Z0 => Q7, A0 => QI7);
UQVB_B10 : BUF
	PORT MAP (Z0 => Q6, A0 => QI6);
UQVB_B11 : BUF
	PORT MAP (Z0 => Q5, A0 => QI5);
UQVB_B12 : BUF
	PORT MAP (Z0 => Q4, A0 => QI4);
UQVB_B13 : BUF
	PORT MAP (Z0 => Q3, A0 => QI3);
UQVB_B14 : BUF
	PORT MAP (Z0 => Q2, A0 => QI2);
UQVB_B15 : BUF
	PORT MAP (Z0 => Q1, A0 => QI1);
UQVB_B16 : BUF
	PORT MAP (Z0 => Q0, A0 => QI0);
UQVB_B17 : FD11
	PORT MAP (Q0 => QI2, D0 => UQVN_N22, CLK => CLK);
UQVB_B18 : FD11
	PORT MAP (Q0 => QI3, D0 => UQVN_N23, CLK => CLK);
UQVB_B19 : AND3
	PORT MAP (Z0 => UQVN_N3, A0 => D0, A1 => LD, A2 => UQVN_N18);
UQVB_B20 : AND4
	PORT MAP (Z0 => UQVN_N4, A0 => UQVN_N17, A1 => CAI, A2 => EN, 
	A3 => UQVN_N18);
UQVB_B21 : LXOR2
	PORT MAP (Z0 => UQVN_N20, A0 => UQVN_N1, A1 => UQVN_N5);
UQVB_B22 : OR3
	PORT MAP (Z0 => UQVN_N5, A0 => UQVN_N3, A1 => UQVN_N4, A2 => PS);
UQVB_B23 : AND4
	PORT MAP (Z0 => UQVN_N1, A0 => QI0, A1 => UQVN_N17, A2 => UQVN_N18, 
	A3 => UQVN_N19);
UQVB_B24 : AND4
	PORT MAP (Z0 => UQVN_N8, A0 => QI1, A1 => UQVN_N17, A2 => UQVN_N18, 
	A3 => UQVN_N19);
UQVB_B25 : LXOR2
	PORT MAP (Z0 => UQVN_N21, A0 => UQVN_N8, A1 => UQVN_N9);
UQVB_B26 : AND3
	PORT MAP (Z0 => UQVN_N6, A0 => D1, A1 => LD, A2 => UQVN_N18);
UQVB_B27 : INV
	PORT MAP (ZN0 => UQVN_N17, A0 => LD);
UQVB_B28 : AND3
	PORT MAP (Z0 => UQVN_N10, A0 => D2, A1 => LD, A2 => UQVN_N18);
UQVB_B29 : LXOR2
	PORT MAP (Z0 => UQVN_N22, A0 => UQVN_N11, A1 => UQVN_N12);
UQVB_B30 : AND4
	PORT MAP (Z0 => UQVN_N11, A0 => QI2, A1 => UQVN_N17, A2 => UQVN_N18, 
	A3 => UQVN_N19);
UQVB_B31 : LXOR2
	PORT MAP (Z0 => UQVN_N23, A0 => UQVN_N14, A1 => UQVN_N15);
UQVB_B32 : AND3
	PORT MAP (Z0 => UQVN_N13, A0 => D3, A1 => LD, A2 => UQVN_N18);
UQVB_B33 : AND4
	PORT MAP (Z0 => UQVN_N14, A0 => QI3, A1 => UQVN_N17, A2 => UQVN_N18, 
	A3 => UQVN_N19);
UQVB_B34 : AND5
	PORT MAP (Z0 => UQVN_N7, A0 => QI0, A1 => CAI, A2 => UQVN_N17, 
	A3 => EN, A4 => UQVN_N18);
UQVB_B35 : OR3
	PORT MAP (Z0 => UQVN_N9, A0 => UQVN_N6, A1 => UQVN_N7, A2 => PS);
UQVB_B36 : OR3
	PORT MAP (Z0 => UQVN_N12, A0 => UQVN_N10, A1 => UQVN_N2, A2 => PS);
UQVB_B37 : AND8
	PORT MAP (Z0 => UQVN_N29, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => UQVN_N25, A5 => CAI, A6 => EN, 
	A7 => UQVN_N38);
UQVB_B38 : AND9
	PORT MAP (Z0 => UQVN_N33, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => QI4, A5 => UQVN_N25, A6 => CAI, 
	A7 => EN, A8 => UQVN_N38);
UQVB_B39 : AND10
	PORT MAP (Z0 => UQVN_N34, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => QI4, A5 => QI5, A6 => UQVN_N25, 
	A7 => CAI, A8 => EN, A9 => UQVN_N38);
UQVB_B40 : AND11
	PORT MAP (Z0 => UQVN_N24, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => QI4, A5 => QI5, A6 => QI6, 
	A7 => UQVN_N25, A8 => CAI, A9 => EN, A10 => UQVN_N38);
UQVB_B41 : OR3
	PORT MAP (Z0 => UQVN_N40, A0 => UQVN_N42, A1 => UQVN_N24, A2 => PS);
UQVB_B42 : OR3
	PORT MAP (Z0 => UQVN_N26, A0 => UQVN_N28, A1 => UQVN_N29, A2 => PS);
UQVB_B43 : INV
	PORT MAP (ZN0 => UQVN_N38, A0 => CS);
UQVB_B44 : INV
	PORT MAP (ZN0 => UQVN_N25, A0 => LD);
UQVB_B45 : LXOR2
	PORT MAP (Z0 => UQVN_N43, A0 => UQVN_N27, A1 => UQVN_N26);
UQVB_B46 : FD11
	PORT MAP (Q0 => QI4, D0 => UQVN_N43, CLK => CLK);
UQVB_B47 : AND3
	PORT MAP (Z0 => UQVN_N28, A0 => D4, A1 => LD, A2 => UQVN_N38);
UQVB_B48 : AND4
	PORT MAP (Z0 => UQVN_N27, A0 => QI4, A1 => UQVN_N25, A2 => UQVN_N38, 
	A3 => UQVN_N39);
UQVB_B49 : LXOR2
	PORT MAP (Z0 => UQVN_N44, A0 => UQVN_N31, A1 => UQVN_N30);
UQVB_B50 : FD11
	PORT MAP (Q0 => QI5, D0 => UQVN_N44, CLK => CLK);
UQVB_B51 : OR3
	PORT MAP (Z0 => UQVN_N30, A0 => UQVN_N32, A1 => UQVN_N33, A2 => PS);
UQVB_B52 : AND3
	PORT MAP (Z0 => UQVN_N32, A0 => D5, A1 => LD, A2 => UQVN_N38);
UQVB_B53 : AND4
	PORT MAP (Z0 => UQVN_N31, A0 => QI5, A1 => UQVN_N25, A2 => UQVN_N38, 
	A3 => UQVN_N39);
UQVB_B54 : AND3
	PORT MAP (Z0 => UQVN_N35, A0 => D6, A1 => LD, A2 => UQVN_N38);
UQVB_B55 : OR3
	PORT MAP (Z0 => UQVN_N37, A0 => UQVN_N35, A1 => UQVN_N34, A2 => PS);
UQVB_B56 : FD11
	PORT MAP (Q0 => QI6, D0 => UQVN_N45, CLK => CLK);
UQVB_B57 : LXOR2
	PORT MAP (Z0 => UQVN_N45, A0 => UQVN_N36, A1 => UQVN_N37);
UQVB_B58 : AND4
	PORT MAP (Z0 => UQVN_N36, A0 => QI6, A1 => UQVN_N25, A2 => UQVN_N38, 
	A3 => UQVN_N39);
UQVB_B59 : LXOR2
	PORT MAP (Z0 => UQVN_N46, A0 => UQVN_N41, A1 => UQVN_N40);
UQVB_B60 : FD11
	PORT MAP (Q0 => QI7, D0 => UQVN_N46, CLK => CLK);
UQVB_B61 : AND3
	PORT MAP (Z0 => UQVN_N42, A0 => D7, A1 => LD, A2 => UQVN_N38);
UQVB_B62 : AND4
	PORT MAP (Z0 => UQVN_N41, A0 => QI7, A1 => UQVN_N25, A2 => UQVN_N38, 
	A3 => UQVN_N39);
UQVB_B63 : INV
	PORT MAP (ZN0 => UQVN_N39, A0 => PS);
END lattice_arch;
-- VHDL netlist for CBU516
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBU516 IS 
    PORT (
        CLK : IN std_logic;
        EN : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        Q4 : OUT std_logic;
        Q5 : OUT std_logic;
        Q6 : OUT std_logic;
        Q7 : OUT std_logic;
        Q8 : OUT std_logic;
        Q9 : OUT std_logic;
        Q10 : OUT std_logic;
        Q11 : OUT std_logic;
        Q12 : OUT std_logic;
        Q13 : OUT std_logic;
        Q14 : OUT std_logic;
        Q15 : OUT std_logic
    );
END CBU516;


ARCHITECTURE lattice_arch OF CBU516 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, UQVN_N23, UQVN_N24,
	 UQVN_N25, UQVN_N26, UQVN_N27, UQVN_N28,
	 UQVN_N29, UQVN_N30, UQVN_N31, UQVN_N32,
	 UQVN_N33, UQVN_N34, QI0, QI1,
	 QI10, QI11, QI12, QI13,
	 QI14, QI15, QI2, QI3,
	 QI4, QI5, QI6, QI7,
	 QI8, QI9 : std_logic;


  COMPONENT FD21
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD21 use  entity  lattice.FD21(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND5 use  entity  lattice.AND5(lattice_arch);


  COMPONENT AND6
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND6 use  entity  lattice.AND6(lattice_arch);


  COMPONENT AND7
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND7 use  entity  lattice.AND7(lattice_arch);


  COMPONENT AND8
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND8 use  entity  lattice.AND8(lattice_arch);


  COMPONENT AND9
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND9 use  entity  lattice.AND9(lattice_arch);


  COMPONENT AND10
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        A9 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND10 use  entity  lattice.AND10(lattice_arch);


  COMPONENT AND11
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        A9 : IN std_logic;
        A10 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND11 use  entity  lattice.AND11(lattice_arch);


  COMPONENT AND12
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        A9 : IN std_logic;
        A10 : IN std_logic;
        A11 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND12 use  entity  lattice.AND12(lattice_arch);


  COMPONENT AND16
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        A9 : IN std_logic;
        A10 : IN std_logic;
        A11 : IN std_logic;
        A12 : IN std_logic;
        A13 : IN std_logic;
        A14 : IN std_logic;
        A15 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND16 use  entity  lattice.AND16(lattice_arch);


BEGIN

UQVB_B1 : FD21
	PORT MAP (Q0 => QI0, D0 => UQVN_N1, CLK => CLK, CD => CD);
UQVB_B2 : AND4
	PORT MAP (Z0 => UQVN_N7, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => EN);
UQVB_B3 : LXOR2
	PORT MAP (Z0 => UQVN_N1, A0 => QI0, A1 => EN);
UQVB_B4 : LXOR2
	PORT MAP (Z0 => UQVN_N2, A0 => QI1, A1 => UQVN_N5);
UQVB_B5 : LXOR2
	PORT MAP (Z0 => UQVN_N3, A0 => QI2, A1 => UQVN_N6);
UQVB_B6 : BUF
	PORT MAP (Z0 => Q15, A0 => QI15);
UQVB_B7 : BUF
	PORT MAP (Z0 => Q14, A0 => QI14);
UQVB_B8 : BUF
	PORT MAP (Z0 => Q13, A0 => QI13);
UQVB_B9 : BUF
	PORT MAP (Z0 => Q12, A0 => QI12);
UQVB_B10 : BUF
	PORT MAP (Z0 => Q11, A0 => QI11);
UQVB_B11 : BUF
	PORT MAP (Z0 => Q10, A0 => QI10);
UQVB_B12 : BUF
	PORT MAP (Z0 => Q9, A0 => QI9);
UQVB_B13 : BUF
	PORT MAP (Z0 => Q8, A0 => QI8);
UQVB_B14 : FD21
	PORT MAP (Q0 => QI1, D0 => UQVN_N2, CLK => CLK, CD => CD);
UQVB_B15 : BUF
	PORT MAP (Z0 => Q7, A0 => QI7);
UQVB_B16 : BUF
	PORT MAP (Z0 => Q6, A0 => QI6);
UQVB_B17 : BUF
	PORT MAP (Z0 => Q5, A0 => QI5);
UQVB_B18 : BUF
	PORT MAP (Z0 => Q4, A0 => QI4);
UQVB_B19 : BUF
	PORT MAP (Z0 => Q3, A0 => QI3);
UQVB_B20 : BUF
	PORT MAP (Z0 => Q2, A0 => QI2);
UQVB_B21 : BUF
	PORT MAP (Z0 => Q1, A0 => QI1);
UQVB_B22 : BUF
	PORT MAP (Z0 => Q0, A0 => QI0);
UQVB_B23 : LXOR2
	PORT MAP (Z0 => UQVN_N4, A0 => QI3, A1 => UQVN_N7);
UQVB_B24 : FD21
	PORT MAP (Q0 => QI2, D0 => UQVN_N3, CLK => CLK, CD => CD);
UQVB_B25 : FD21
	PORT MAP (Q0 => QI3, D0 => UQVN_N4, CLK => CLK, CD => CD);
UQVB_B26 : AND2
	PORT MAP (Z0 => UQVN_N5, A0 => QI0, A1 => EN);
UQVB_B27 : AND3
	PORT MAP (Z0 => UQVN_N6, A0 => QI0, A1 => QI1, A2 => EN);
UQVB_B28 : FD21
	PORT MAP (Q0 => QI5, D0 => UQVN_N8, CLK => CLK, CD => CD);
UQVB_B29 : FD21
	PORT MAP (Q0 => QI6, D0 => UQVN_N10, CLK => CLK, CD => CD);
UQVB_B30 : FD21
	PORT MAP (Q0 => QI4, D0 => UQVN_N9, CLK => CLK, CD => CD);
UQVB_B31 : LXOR2
	PORT MAP (Z0 => UQVN_N15, A0 => QI7, A1 => UQVN_N13);
UQVB_B32 : LXOR2
	PORT MAP (Z0 => UQVN_N10, A0 => QI6, A1 => UQVN_N12);
UQVB_B33 : LXOR2
	PORT MAP (Z0 => UQVN_N8, A0 => QI5, A1 => UQVN_N11);
UQVB_B34 : LXOR2
	PORT MAP (Z0 => UQVN_N9, A0 => QI4, A1 => UQVN_N14);
UQVB_B35 : AND5
	PORT MAP (Z0 => UQVN_N14, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => EN);
UQVB_B36 : FD21
	PORT MAP (Q0 => QI7, D0 => UQVN_N15, CLK => CLK, CD => CD);
UQVB_B37 : AND6
	PORT MAP (Z0 => UQVN_N11, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => QI4, A5 => EN);
UQVB_B38 : AND7
	PORT MAP (Z0 => UQVN_N12, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => QI4, A5 => QI5, A6 => EN);
UQVB_B39 : AND8
	PORT MAP (Z0 => UQVN_N13, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => QI4, A5 => QI5, A6 => QI6, 
	A7 => EN);
UQVB_B40 : FD21
	PORT MAP (Q0 => QI8, D0 => UQVN_N21, CLK => CLK, CD => CD);
UQVB_B41 : FD21
	PORT MAP (Q0 => QI10, D0 => UQVN_N20, CLK => CLK, CD => CD);
UQVB_B42 : FD21
	PORT MAP (Q0 => QI9, D0 => UQVN_N22, CLK => CLK, CD => CD);
UQVB_B43 : FD21
	PORT MAP (Q0 => QI11, D0 => UQVN_N23, CLK => CLK, CD => CD);
UQVB_B44 : LXOR2
	PORT MAP (Z0 => UQVN_N21, A0 => QI8, A1 => UQVN_N16);
UQVB_B45 : LXOR2
	PORT MAP (Z0 => UQVN_N22, A0 => QI9, A1 => UQVN_N19);
UQVB_B46 : AND9
	PORT MAP (Z0 => UQVN_N16, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => QI4, A5 => QI5, A6 => QI6, 
	A7 => QI7, A8 => EN);
UQVB_B47 : LXOR2
	PORT MAP (Z0 => UQVN_N20, A0 => QI10, A1 => UQVN_N18);
UQVB_B48 : AND10
	PORT MAP (Z0 => UQVN_N19, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => QI4, A5 => QI5, A6 => QI6, 
	A7 => QI7, A8 => QI8, A9 => EN);
UQVB_B49 : AND11
	PORT MAP (Z0 => UQVN_N18, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => QI4, A5 => QI5, A6 => QI6, 
	A7 => QI7, A8 => QI8, A9 => QI9, A10 => EN);
UQVB_B50 : LXOR2
	PORT MAP (Z0 => UQVN_N23, A0 => QI11, A1 => UQVN_N17);
UQVB_B51 : AND12
	PORT MAP (Z0 => UQVN_N17, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => QI4, A5 => QI5, A6 => QI6, 
	A7 => QI7, A8 => QI8, A9 => QI9, A10 => QI10, 
	A11 => EN);
UQVB_B52 : LXOR2
	PORT MAP (Z0 => UQVN_N26, A0 => QI14, A1 => UQVN_N25);
UQVB_B53 : FD21
	PORT MAP (Q0 => QI15, D0 => UQVN_N32, CLK => CLK, CD => CD);
UQVB_B54 : FD21
	PORT MAP (Q0 => QI13, D0 => UQVN_N28, CLK => CLK, CD => CD);
UQVB_B55 : FD21
	PORT MAP (Q0 => QI12, D0 => UQVN_N29, CLK => CLK, CD => CD);
UQVB_B56 : LXOR2
	PORT MAP (Z0 => UQVN_N28, A0 => QI13, A1 => UQVN_N30);
UQVB_B57 : LXOR2
	PORT MAP (Z0 => UQVN_N29, A0 => QI12, A1 => UQVN_N27);
UQVB_B58 : FD21
	PORT MAP (Q0 => QI14, D0 => UQVN_N26, CLK => CLK, CD => CD);
UQVB_B59 : LXOR2
	PORT MAP (Z0 => UQVN_N32, A0 => QI15, A1 => UQVN_N24);
UQVB_B60 : AND12
	PORT MAP (Z0 => UQVN_N31, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => QI4, A5 => QI5, A6 => QI6, 
	A7 => QI7, A8 => QI8, A9 => QI9, A10 => QI10, 
	A11 => QI11);
UQVB_B61 : AND2
	PORT MAP (Z0 => UQVN_N27, A0 => UQVN_N31, A1 => EN);
UQVB_B62 : AND12
	PORT MAP (Z0 => UQVN_N33, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => QI4, A5 => QI5, A6 => QI6, 
	A7 => QI7, A8 => QI8, A9 => QI9, A10 => QI10, 
	A11 => QI11);
UQVB_B63 : AND3
	PORT MAP (Z0 => UQVN_N30, A0 => UQVN_N33, A1 => QI12, A2 => EN);
UQVB_B64 : AND12
	PORT MAP (Z0 => UQVN_N34, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => QI4, A5 => QI5, A6 => QI6, 
	A7 => QI7, A8 => QI8, A9 => QI9, A10 => QI10, 
	A11 => QI11);
UQVB_B65 : AND4
	PORT MAP (Z0 => UQVN_N25, A0 => UQVN_N34, A1 => QI12, A2 => QI13, 
	A3 => EN);
UQVB_B66 : AND16
	PORT MAP (Z0 => UQVN_N24, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => QI4, A5 => QI5, A6 => QI6, 
	A7 => QI7, A8 => QI8, A9 => QI9, A10 => QI10, 
	A11 => QI11, A12 => QI12, A13 => QI13, A14 => QI14, 
	A15 => EN);
END lattice_arch;
-- VHDL netlist for CBU616
-- Date: 15.5.95 13.45.13

LIBRARY IEEE;
library lattice;
use lattice.vhd_pkg.all;
USE IEEE.std_logic_1164.all;
USE work.all;

ENTITY CBU616 IS 
    PORT (
        CLK : IN std_logic;
        EN : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic;
        Q1 : OUT std_logic;
        Q2 : OUT std_logic;
        Q3 : OUT std_logic;
        Q4 : OUT std_logic;
        Q5 : OUT std_logic;
        Q6 : OUT std_logic;
        Q7 : OUT std_logic;
        Q8 : OUT std_logic;
        Q9 : OUT std_logic;
        Q10 : OUT std_logic;
        Q11 : OUT std_logic;
        Q12 : OUT std_logic;
        Q13 : OUT std_logic;
        Q14 : OUT std_logic;
        Q15 : OUT std_logic;
        CAO : OUT std_logic
    );
END CBU616;


ARCHITECTURE lattice_arch OF CBU616 IS
SIGNAL  UQVN_N1, UQVN_N2, UQVN_N3, UQVN_N4,
	 UQVN_N5, UQVN_N6, UQVN_N7, UQVN_N8,
	 UQVN_N9, UQVN_N10, UQVN_N11, UQVN_N12,
	 UQVN_N13, UQVN_N14, UQVN_N15, UQVN_N16,
	 UQVN_N17, UQVN_N18, UQVN_N19, UQVN_N20,
	 UQVN_N21, UQVN_N22, UQVN_N23, UQVN_N24,
	 UQVN_N25, UQVN_N26, UQVN_N27, UQVN_N28,
	 UQVN_N29, UQVN_N30, UQVN_N31, UQVN_N32,
	 UQVN_N33, UQVN_N34, UQVN_N35, QI0,
	 QI1, QI10, QI11, QI12,
	 QI13, QI14, QI15, QI2,
	 QI3, QI4, QI5, QI6,
	 QI7, QI8, QI9 : std_logic;


  COMPONENT FD21
    PORT (
        D0 : IN std_logic;
        CLK : IN std_logic;
        CD : IN std_logic;
        Q0 : OUT std_logic
    );
  END COMPONENT;

for all: FD21 use  entity  lattice.FD21(lattice_arch);


  COMPONENT AND4
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND4 use  entity  lattice.AND4(lattice_arch);


  COMPONENT AND16
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        A9 : IN std_logic;
        A10 : IN std_logic;
        A11 : IN std_logic;
        A12 : IN std_logic;
        A13 : IN std_logic;
        A14 : IN std_logic;
        A15 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND16 use  entity  lattice.AND16(lattice_arch);


  COMPONENT AND2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND2 use  entity  lattice.AND2(lattice_arch);


  COMPONENT LXOR2
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: LXOR2 use  entity  lattice.LXOR2(lattice_arch);


  COMPONENT BUF
    PORT (
        A0 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: BUF use  entity  lattice.BUF(lattice_arch);


  COMPONENT AND3
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND3 use  entity  lattice.AND3(lattice_arch);


  COMPONENT AND5
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND5 use  entity  lattice.AND5(lattice_arch);


  COMPONENT AND6
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND6 use  entity  lattice.AND6(lattice_arch);


  COMPONENT AND7
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND7 use  entity  lattice.AND7(lattice_arch);


  COMPONENT AND8
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND8 use  entity  lattice.AND8(lattice_arch);


  COMPONENT AND9
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND9 use  entity  lattice.AND9(lattice_arch);


  COMPONENT AND10
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        A9 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND10 use  entity  lattice.AND10(lattice_arch);


  COMPONENT AND11
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        A9 : IN std_logic;
        A10 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND11 use  entity  lattice.AND11(lattice_arch);


  COMPONENT AND12
    PORT (
        A0 : IN std_logic;
        A1 : IN std_logic;
        A2 : IN std_logic;
        A3 : IN std_logic;
        A4 : IN std_logic;
        A5 : IN std_logic;
        A6 : IN std_logic;
        A7 : IN std_logic;
        A8 : IN std_logic;
        A9 : IN std_logic;
        A10 : IN std_logic;
        A11 : IN std_logic;
        Z0 : OUT std_logic
    );
  END COMPONENT;

for all: AND12 use  entity  lattice.AND12(lattice_arch);


BEGIN

UQVB_B1 : FD21
	PORT MAP (Q0 => QI0, D0 => UQVN_N2, CLK => CLK, CD => CD);
UQVB_B2 : AND4
	PORT MAP (Z0 => UQVN_N8, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => EN);
UQVB_B3 : AND16
	PORT MAP (Z0 => UQVN_N1, A0 => QI0, A1 => QI1, A2 => QI2, 
	A3 => QI3, A4 => QI4, A5 => QI5, A6 => QI6, 
	A7 => QI7, A8 => QI8, A9 => QI9, A10 => QI10, 
	A11 => QI11, A12 => QI12, A13 => QI13, A14 => QI14, 
	A15 => QI15);
UQVB_B4 : AND2
	PORT MAP (Z0 => CAO, A0 => UQVN_N1, A1 => EN);
UQVB_B5 : LXOR2
	PORT MAP (Z0 => UQVN_N2, A0 => QI0, A1 => EN);
UQVB_B6 : LXOR2
	PORT MAP (Z0 => UQVN_N3, A0 => QI1, A1 => UQVN_N6);
UQVB_B7 : LXOR2
	PORT MAP (Z0 => UQVN_N4, A0 => QI2, A1 => UQVN_N7);
UQVB_B8 : BUF
	PORT MAP (Z0 => Q15, A0 => QI15);
UQVB_B9 : BUF
	PORT MAP (Z0 => Q14, A0 => QI14);
UQVB_B10 : BUF
	PORT MAP (Z0 => Q13, A0 => QI13);
UQVB_B11 : BUF
	PORT MAP (Z0 => Q12, A0 => QI12);
UQVB_B12 : BUF
	PORT MAP (Z0 => Q11, A0 => QI11);
UQVB_B13 : BUF
	PORT MAP (Z0 => Q10, A0 => QI10);
UQVB_B14 : BUF
	PORT MAP (Z0 => Q9, A0 => QI9);
UQVB_B15 : BUF
	PORT MAP (Z0 => Q8, A0 => QI8);
UQVB_B16 : FD21
	PORT MAP (Q0 => QI1, D0 => UQVN_N3, CLK => CLK, CD => CD);
UQVB_B17 : BUF
	PORT MAP (Z0 => Q7, A0 => QI7);
UQVB_B18 : BUF
	PORT MAP (Z0 => Q6, A0 => QI6);
UQVB_B19 : BUF
	PORT MAP (Z0 => Q5, A0 => QI5);
UQVB_B20 : BUF
	PORT MAP (Z0 => Q4, A0 => QI4);
UQVB_B21 : BUF
	PORT MAP (Z0 => Q3, A0 => QI3);
UQVB_B22 : BUF
	PORT MAP (Z0 => Q2, A0 => QI2);
UQVB_B23 : BUF
	PORT MAP (Z0 => Q1, A0 => QI1);
UQVB_B24 : BUF
	PORT MAP (Z0 => Q0, A0 => QI0);
UQVB_B25 : LXOR2
	PORT MAP (Z0 => UQVN_N5, A0 => QI3, A1 => UQVN_N8);
UQVB_B26 : FD21
	PORT MAP (Q0 => QI2, D0 => UQVN_N4, CLK => CLK, CD => CD);
UQVB_B27 : FD21
	PORT MAP (Q0 => QI3, D0 => UQVN_N5, CLK => CLK, CD => CD);
UQVB_B28 : AND2
	PORT MAP (Z0 => UQVN_N6, A0 => QI0, A1 => EN);
UQVB_B29 : AND3
	PORT MAP (Z0 => UQVN_N7, A0 => QI0, A1 => QI1, A2 => EN);
UQVB_B30 : FD21
	PORT MAP (Q0 => QI5, D0 => UQVN_N9, CLK => CLK, CD => CD);
UQVB_B31 : FD21
	PORT MAP (Q0 => QI6, D0 => UQVN_N11, CLK 